/*
 * For dealing with sums that are meant to be ports.
 * The following may be recognized as ports:
 *     sum(x in X, r([...,]* x))
 *     sum(x in X, r([...,]* x) . <expr>)
 * The r([...,]* x) has to be encapsulated to make it a port.
 */

#include <stdio.h>
#include "psf_prototype.h"
#include "tiltype.h"
#include "tilutil.h"
#include "psf_malloc.h"
#include "process.h"
#include "eqm.h"
#include "sumport.h"
#include "headtail.h"
#include "eqm_local.h"

/*
 * Test sets on the possibility to check if an atom with a
 * variable as its last argument is element of the set.
 */
static int **set_cond = NULL;
static int nr_atoms;

static int s_term_condition_test(st, akey)
struct s_term *st;
int akey;
{
    /*
     * If atom akey can be found in the set, and not all the
     * arguments of atom akey are variables, 0 is returned.
     * Otherwise 1 is returned, which indicates that it is
     * decidable that atom akey is elemnt of the set.
     */
    int i, j;
    struct module *mod;
    
    switch(st->fun) {
    case UNI:
    case INT:
    case DIF:
	for (j = 0; j < st->a; j ++) {
	    if (st->u_tag[j]) {
		if (!s_term_condition_test(st->arr[j].s_t, akey))
		    return(0);
	    } else if (st->arr[j].ae_t->ind.table == SOR)
		continue; /* atoms */
	    else { /* SET */
		mod = get_til_module();
		if (!s_term_condition_test(
		    &mod->set[st->arr[j].ae_t->ind.key].construct.set_term,
		    akey))
		    return(0);
	    }
	}
	return(1);
    case ENU:
	for (j = 0; j < st->a; j ++) {
	    if (st->arr[j].ae_t->ind.key != akey)
		continue;
	    for (i = st->arr[j].ae_t->a - 1; i >= 0; i --) {
		if (st->arr[j].ae_t->ae_list[i].ind.table != VAR) {
		    return(0);
		}
	    }
	}
	return(1);
    }
    return(0); /* But we are never here. */
}

static void set_condition_test()
{
    struct module *mod;
    struct set_tuple *s;
    int i, j;

    mod = get_til_module();
    if (set_cond != NULL) {
	for (i = 1; i <= nr_atoms; i ++)
	    PSF_FREE(set_cond[i]);
	PSF_FREE(set_cond);
    }
    nr_atoms = mod->entries_table[ATM];
    set_cond = PSF_NMALLOC(int *, nr_atoms + 1);
    for (i = 1; i <= nr_atoms; i ++) {
	set_cond[i] = PSF_NMALLOC(int, mod->entries_table[SET] + 1);
	for (j = 1, s = &mod->set[1]; j <= mod->entries_table[SET]; j ++, s ++)
	    {
	    if (mod->atm[i].sor_indlist.a == 0 || s->u_tag == 0) {
		set_cond[i][j] = 0;
		continue;
	    }
	    set_cond[i][j] = s_term_condition_test(&s->construct.set_term, i);
	    if (set_cond[i][j] == -1)
		set_cond[i][j] = mod->atm[i].sor_indlist.a;
	}
    }
/*
    for (i = 1; i <= nr_atoms; i ++) {
	fprintf(stderr, "atom: %d ", i);
	for (j = 1; j <= mod->entries_table[SET]; j ++)
	    fprintf(stderr, " %d", set_cond[i][j]);
	fprintf(stderr, "\n");
    }
*/
}

/*
 * Test communications on the possibility to act on a sumport.
 */
static int **com_cond = NULL;
static int nr_coms;

static int var_appears_in(aet, key)
struct ae_term *aet;
keytype key;
{
    int i;

    if (aet->ind.table == VAR) {
	if (aet->ind.key == key)
	    return(1);
	else
	    return(0);
    }
    for (i = 0; i < aet->a; i ++) {
	if (var_appears_in(&aet->ae_list[i], key))
	    return(1);
    }
    return(0);
}

static void com_condition_test()
{
    struct module *mod;
    struct com_tuple *c;
    int i, j, k, l;
    int nr_partners;

    mod = get_til_module();
    if (com_cond != NULL) {
	for (i = 1; i <= nr_coms; i++)
	    PSF_FREE(com_cond[i]);
	PSF_FREE(com_cond);
    }
    nr_coms = mod->entries_table[COM];
    com_cond = PSF_NMALLOC(int *, nr_coms + 1);
    for (i = 1, c = &mod->com[1]; i <= nr_coms; i ++, c ++) {
	nr_partners = 2; /* in future, get it from c->... */
	com_cond[i] = PSF_NMALLOC(int, nr_partners);
	com_cond[i][0] = com_cond[i][1] = 0;
	for (j = nr_partners - 1; j >= 0; j --) {
	    for (k = c->aet[j].a - 1; k >= 0; k --) {
		if (c->aet[j].ae_list[k].ind.table != VAR)
		    break;
		for (l = nr_partners - 1; l >= 0; l --) {
		    if (l == j)
			continue;
		    if (var_appears_in(&c->aet[l],
			c->aet[j].ae_list[k].ind.key))
			break;
		}
		if (l < 0)
		    break;
	    }
	    com_cond[i][j] = c->aet[j].a - 1 - k;
	}
    }
/*
    for (i = 1; i <= nr_coms; i ++) {
	fprintf(stderr, "com: %d ", i);
	for (j = 0; j < nr_partners; j ++)
	    fprintf(stderr, " %d", com_cond[i][j]);
	fprintf(stderr, "\n");
    }
*/
}

void init_sumport()
{
    set_condition_test();
    com_condition_test();
}

/*
 * The portvar must be of type setvar.
 */
static int vartypes_match(setvar, portarg)
keytype setvar;
indextype *portarg;
{
    struct module *mod;
    indextype *setind, *portind;

    mod = get_til_module();
    setind = &mod->var[setvar].ind;
    if (portarg->table == FUN)
	portind = &mod->fun[portarg->key].return_list.indlist[0];
    else
	portind = &mod->var[portarg->key].ind;
    if (portind->table == setind->table &&
	portind->key == setind->key)
	return(1);
    while (portind->table == SET) {
	portind = &mod->set[portind->key].ind;
	if (portind->table == setind->table &&
	    portind->key == setind->key)
	    return(1);
    }
    return(0);
}

/*
 * Find out if the atom of the port is in the set.
 */
static int sumport_in_set(aet, st)
struct ae_term *aet;
struct s_term *st;
{
    int j;
    int member;
    struct module *mod;
    int i;

    for (j = 0; j < st->a; j ++) {
	if (st->u_tag[j])
	    member = sumport_in_set(aet, st->arr[j].s_t);
	else if (st->arr[j].ae_t->ind.table == SOR)
	    member = 1; /* atoms */
	else if (st->arr[j].ae_t->ind.table == SET) {
	    mod = get_til_module();
	    member = sumport_in_set(aet,
		&mod->set[st->arr[j].ae_t->ind.key].construct.set_term);
	} else {
	    if (st->arr[j].ae_t->ind.key == aet->ind.key) {
		member = 1;
		for (i = aet->a - 1; i >= 0; i --) {
		    if (! (member = vartypes_match(st->arr[j].ae_t->
			ae_list[i].ind.key, &aet->ae_list[i].ind))) {
			member = 0;
			break;
		    }
		}
	    } else
		member = 0;
	}
	switch(st->fun) {
	case UNI:
	    if (member)
		return(1);
	    break;
	case INT:
	    if (!member)
		return(0);
	    break;
	case DIF:
	    if (j) {
		if (member)
		    return(0);
		else
		    member = 1;
	    } else {
		if (!member)
		    return(0);
	    }
	    break;
	case ENU:
	    if (member)
		return(1);
	    break;
	}
    }
    return(member);
}

/*
 * Test if an atom can be matched in the set.
 */
int sumport_member_of_set(aet, key)
struct ae_term *aet;
keytype key;
{
    struct module *mod;

    if (set_cond[aet->ind.key][key]) {
	mod = get_til_module();
	return(sumport_in_set(aet, &mod->set[key].construct.set_term));
    } else
	return(-1);
}

/*
 * Find out if the atom of the port is encapsulated or hidden,
 * so that it cannot communicate.
 */
int sumport_encaps_or_hide(p, top)
struct process *p;
struct process *top;
{
    struct set_list *sl;
    struct ae_term *aet;

    aet = p->h_t->ae_t;
    for (sl = p->set; sl != top->set; sl = sl->next) {
	if (!set_cond[aet->ind.key][sl->key])
	    return(-1); /* We cannot check it. */
	if (sumport_in_set(aet, sl->set))
	    return(1); /* No communication. */
    }
    return(0);
}

/*
 * Find out if atom of possible port is of stype.
 */
static struct set_list *set_flag;

int sumport_in_set_list(aet, sl, psl, stype)
struct ae_term *aet;
struct set_list *sl;
struct set_list *psl;
int stype;
{
    while (sl != psl) {
	if (sl->set == NULL ||
	    (set_cond[aet->ind.key][sl->key] &&
		sumport_in_set(aet, sl->set))) {
	    if (sl->stype == stype) {
		/* set flag for decide_sumport */
		set_flag = sl;
		return(1);
	    } else
		return(0);
	} else {
	    if (set_cond[aet->ind.key][sl->key] == 0)
		return(-1); /* We cannot check it. */
	}
	sl = sl->next;
    }
    return(0);
}

static int sumvars_in_aet(sv, nsv, aet)
keytype *sv;
int nsv;
struct ae_term *aet;
{
    int i, j;
    int vars_seen;

    vars_seen = 0;
    for (i = nsv - 1; i >= 0; i --) {
	for (j = aet->a - 1; j >= 0; j --) {
	    if (aet->ae_list[j].ind.table == VAR) {
		if (aet->ae_list[j].ind.key == sv[i]) {
		    vars_seen ++;
		}
	    } else if (var_appears_in(&aet->ae_list[j], sv[i])) {
		return(0);
	    }
	}
    }
    return(vars_seen == nsv);
}

/*
 * Decide whether the sum can be a port, and if so, set
 * p->flag to PORT_PROCESS and let p->h_t->aet_t point to
 * the atom of the port.
 * Until p->com_flag is set, it is NOT a port.
 */
void decide_sumport(p)
struct process *p;
{
    struct process_expr *expr;
    keytype *sumvar;
    int nr_sumvar;
    int max_sumvar;
    int a;
    int loop;

    expr = p->h_t->tail->expr;
    max_sumvar = 4;
    sumvar = PSF_NMALLOC(keytype, max_sumvar);
    nr_sumvar = 0;
    sumvar[nr_sumvar ++] = expr->proc_expr.pe1.ind.key;
    expr = expr->proc_expr.pe1.pe;
    for (loop = 1; loop; ) {
	switch(expr->fun) {
	case SEQ:
	    expr = &expr->proc_expr.pe3.pe[0];
	    break;
	case SUM:
	    if (nr_sumvar == max_sumvar) {
		max_sumvar *= 2;
		sumvar = PSF_REALLOC(sumvar, keytype, max_sumvar);
	    }
	    sumvar[nr_sumvar ++] = expr->proc_expr.pe1.ind.key;
	    expr = expr->proc_expr.pe1.pe;
	    break;
	case AET:
	    if (expr->proc_expr.pe2.ind.table == ATM) {
		if (sumvars_in_aet(sumvar, nr_sumvar, &expr->proc_expr.pe2) &&
		    sumport_in_set_list(&expr->proc_expr.pe2, p->set, NULL,
		    ENC) > 0) {
		    p->flag |= PORT_PROCESS;
		    p->h_t->ae_t = &expr->proc_expr.pe2;
		    p->encaps_flag = set_flag;
		    p->sumvar = sumvar;
		    p->nr_sumvar = nr_sumvar;
		}
	    } else
		PSF_FREE(sumvar);
	    loop = 0;
	    break;
	default:
	    PSF_FREE(sumvar);
	    loop = 0;
	    break;
	}
    }
}

static int is_sumvar(key, sv, nsv)
keytype key;
keytype *sv;
int nsv;
{
    int i;

    for (i = 0; i < nsv; i ++) {
	if (sv[i] == key)
	    return(1);
    }
    return(0);
}

/*
 * Check whether can act as a communication-partner of nr_partner of
 * communication i.
 */
subst_t *check_sumport_com(i, nr_partner, paet, caet, subpartner, subprocess, sump)
int i;
int nr_partner;
struct ae_term *paet;
struct ae_term *caet;
subst_t *subpartner;
subst_t *subprocess;
struct process *sump;
{
    int a;
    int j;
    subst_t *sub, *rsub;
    struct ae_term *caeth, *paeth;
    eqm_t *eqm;
    subst_elem_t *se;

    if (com_cond[i][nr_partner]) {
	if (paet->ind.key == caet->ind.key) {
	    rsub = sub = get_sub();
	    sub->sb_elems = NULL;
	    eqm = get_eqm();
	    a = paet->a;
	    for (j = 0; j < a; j ++) {
		if (paet->ae_list[j].ind.table == VAR &&
		    is_sumvar(paet->ae_list[j].ind.key, sump->sumvar,
		    sump->nr_sumvar)) {
		    if (vartypes_match(caet->ae_list[j].ind.key,
			&paet->ae_list[j].ind)) {
			caeth = term_instantiate(&caet->ae_list[j], subpartner, eqm);
			if (caeth->ind.table == VAR)
			    continue;
			rsub = term_match_sub(&paet->ae_list[j], caeth, sub);
/*
    print_ae_term(caeth);
fprintf(stderr, " <-> ");
    print_ae_term(&paet->ae_list[j]);
fprintf(stderr, " %lu\n", rsub);
*/
			ae_term_free(caeth);
			continue;
		    } else {
			subst_free(sub);
			return(NULL);
		    }
		}
	
		caeth = term_instantiate(&caet->ae_list[j], subpartner, eqm);
		paeth = term_instantiate(&paet->ae_list[j], subprocess, eqm);
		rsub = term_match_sub(caeth, paeth, sub);
/*
    set_print_output_file(stderr);
    set_print_current_module(get_til_module());
    print_ae_term(caeth);
    for (se = rsub->sb_elems; se; se = se->next_se) {
	fprintf(stderr, "var %d: ", se->var.key);
	print_ae_term(term2ae_term(se->value));
	fprintf(stderr, "\n");
    }
    fprintf(stderr, "---\n");
*/
		if (caeth->ind.table != VAR)
		    /*
		     * term_instantiate does not copy a variable.
		     */
		    ae_term_free(caeth);
		ae_term_free(paeth);
		if (rsub == NULL) {
		    subst_free(sub);
		    break;
		}
		sub = rsub; /* added, but correct ? */
	    }
	    return(rsub);
	}
    }
    return(NULL);
}

/*
 * Mimick the receiving of the terms in sub on port p.
 */
struct process *create_sumport(p, sub)
struct process *p;
subst_t *sub;
{
    int r;
    struct process *h1, *h2;
    struct process_expr *pe;
    subst_elem_t *se, *sev;
    keytype *sumvar;
    int nr_sumvar;

/*
    set_print_output_file(stderr);
    set_print_current_module(get_til_module());
    for (se = sub->sb_elems; se; se = se->next_se) {
	fprintf(stderr, "var %d: ", se->var.key);
	print_ae_term(term2ae_term(se->value));
	fprintf(stderr, "\n");
    }
    fprintf(stderr, "---\n");
*/

    /* it's no longer a sumport */
    p->flag &= ~ PORT_PROCESS;
    p->h_t->ae_t = NULL;
    p->encaps_flag = NULL;
    p->com_flag = 0;

    h1 = p;
    pe = h1->h_t->head;
    sumvar = p->sumvar;
    nr_sumvar = p->nr_sumvar;
    p->sumvar = NULL;
    p->nr_sumvar = 0;
    while (nr_sumvar) {
	/* make a child */
	alloc_children(h1, 1);
	put_process_to_sleep(h1, 1);
	h2 = create_process(h1, pe->proc_expr.pe1.pe);
	add_process_to_table(h2);
	h1->child[0] = h2;

	/* add sub elem for sum variable */
	h2->h_t->sub = copy_add_sub_to_sub(h2->h_t->sub, NULL);
/*
	if (sub->sb_elems != NULL) {
*/
	if (sub->sb_elems->var.key == pe->proc_expr.pe1.ind.key) {
	    sev = sub->sb_elems;
	    sub->sb_elems = sev->next_se;
	} else {
	    for (se = sub->sb_elems; se->next_se->var.key !=
		pe->proc_expr.pe1.ind.key; se = se->next_se);
	    sev = se->next_se;
	    se->next_se = sev->next_se;
	}
	sev->next_se = h2->h_t->sub->sb_elems;
	h2->h_t->sub->sb_elems = sev;
/*
	}
*/
	h2->h_t->top = 1;

	/* delete sum process, if possible */
	if (h1->h_t->tail->tail == NULL &&
	    !(h1->h_t->tail->expr->fun == SEQ &&
		h1->h_t->tail->expr->proc_expr.pe3.a - 1 != h1->h_t->tail->nr)) {
	    struct process *parent;
	    int i;

	    parent = h1->parent;
	    for (i = 0; i < parent->nr_children; i ++)
		if (parent->child[i] == h1)
		    break;
	    parent->child[i] = h2;
	    h2->parent = parent;
	    h1->set = NULL;
	    delete_process_from_table(h1);
	    destroy_process(h1);
	}

	/* skip the SEQ (go to the next sum) */
	while (h2->h_t->tail->expr->fun == SEQ) {
	    /* from make_head_tail */
	    h2->h_t->tail->nr = 0;
	    add_tail(h2->h_t, &h2->h_t->tail->expr->proc_expr.pe3.pe[0]);
	}
	/* for next iteration */
	nr_sumvar --;
	pe = h2->h_t->tail->expr;
	h1 = h2;
    }
    PSF_FREE(sumvar);

    /* make the atom for receiving */
    r = make_head_tail(h1);

    /* go to the process with the atom, and return it */
    for(; h1->nr_children; h1 = h1->child[0]);
    return(h1);
}
