#include <stdio.h>
#include "psf_prototype.h"
#include "tiltype.h"
#include "eqm.h"
#include "process.h"
#include "statecontrol.h"
#include "sumport.h"
#include "eqm_local.h"
#include "headtail.h"
#include "alloccontrol.h"

static int aet_possible(aet)
    struct ae_term *aet;
{
    int i;

    if (aet->ind.table == VAR)
	return (1);
    for (i = 0; i < aet->a; i++)
	if (aet_possible(&aet->ae_list[i]))
	    return (1);
    return (0);
}

static int st_possible(st)
    struct s_term *st;
{
    int i;

    for (i = 0; i < st->a; i++) {
	if (st->u_tag[i])
	    return (1);
	else if (aet_possible(st->arr[i].ae_t))
	    return (1);
    }
    return (0);
}

static void make_tree(p, st, expr, operator, eqm)
    struct process *p;
    struct s_term *st;
    struct process_expr *expr;
    char operator;
    eqm_t *eqm;
{
    int i;
    struct process *h, *parent;
    struct ae_term *taet;

    alloc_children(p, st->a);
    put_process_to_sleep(p, st->a + 1);
    for (i = st->a - 1; i >= 0; i--) {
	h = create_process(p, expr->proc_expr.pe1.pe);
	add_process_to_table(h);
	p->child[i] = h;

	taet = term_reduce(eqm, st->arr[i].ae_t);
	h->h_t->sub = copy_add_to_sub(h->h_t->sub, &expr->
				      proc_expr.pe1.ind, taet, eqm);
	ae_term_free(taet);
	h->h_t->top = 1;
	if (operator == ALT)
	    h->flag = TEMP_PROCESS;
	make_head_tail(h);
    }
    p->sleeping--;
    if (!p->sleeping) {
	if ((parent = p->parent) != NULL) {
	    awaken_process(parent, p);
	    parent->flag |= DEADLOCK;
	    delete_process_from_table(p);
	    destroy_process(p);
	} else
	    p->flag |= DEADLOCK;
    } else if (operator != PAR)
	p->flag &= ~DEADLOCK;
}

int make_set_tree(p, set, operator, eqm)
    struct process *p;
    set_tuple *set;
    char operator;
    eqm_t *eqm;
{
    if (set->u_tag == 0) {
	return (1);
    }
    if (set->construct.set_term.fun != ENU) {
	return (1);
    }
    if (st_possible(&set->construct.set_term)) {
	return (1);
    }
    make_tree(p, &set->construct.set_term, p->h_t->tail->expr,
	      operator, eqm);
    return (0);
}

int make_sum_aet(p, aet, eqm)
    struct process *p;
    struct ae_term *aet;
    eqm_t *eqm;
{
    struct process *h;
    struct process_expr *expr;

    /* clear possible sumport flag */
    if (p->flag & PORT_PROCESS) {
	p->flag &= ~ PORT_PROCESS;
	p->h_t->ae_t = NULL;
    }

    alloc_children(p, 1);
    put_process_to_sleep(p, 2);

    expr = p->h_t->head;
    h = create_process(p, expr->proc_expr.pe1.pe);
    add_process_to_table(h);
    p->child[0] = h;

    h->h_t->sub = copy_add_to_sub(h->h_t->sub, &expr->
				  proc_expr.pe1.ind, aet, eqm);
    h->h_t->top = 1;
    make_head_tail(h);
    p->sleeping--;
    if (!p->sleeping) {   /* it's a deadlock */
	free_child(p->child);
	p->child = NULL;
	p->nr_children = 0;
	p->flag &= ~DEADLOCK;
	return (1);
    }
    return (0);
}
