#include <stdio.h>
#include <stdlib.h>
#include <X11/Intrinsic.h>
#include "psf_prototype.h"
#include "tiltype.h"
#include "tilutil.h"
#include "simutil.h"
#include "freetil.h"
#include "process.h"
#include "simulate.h"
#include "statecontrol.h"
#include "simoption.h"
#include "sumport.h"
#include "headtail.h"
#include "history.h"
#include "interface.h"
#include "heads.h"
#include "startprocess.h"
#include "choose.h"

static int state = STATE_INIT;
static int state_forced = -1;

static char error_buf[10240];

int start_process = -1;

static void init_per_spec()
{
    init_head_tail();
    init_sumport();
    make_start_process_list();
    interface_start_process(GetStartProcessList());
}

static void keep_history()
{
    if (Option_History) {
	if (!Option_Tracein) {
/*
	    if (history_save()) {
*/
/* tbsim trace
		if (trace_to_stdout()) {
		    printf(">save\n");
		    fflush(stdout);
	    }
*/
/*
	    }
*/
	}
    }
}

void state_control()
{
    int old_state = -1;
    int last_init;
    int suminlist = 0;
    int i;
    struct module *mod;
    struct ae_term *aet;

    init_per_spec();

    while (1) {

#ifdef	DEBUG
	if (old_state != state)
	    fprintf(stderr, "state = %d\n", state);
#endif

	switch (state) {
	case STATE_INIT:	/* 0 */
	    /* initialize for simulation */
	    old_state = -1;
	    state = STATE_CHOOSE_START;
	    break;
	case STATE_CHOOSE_START:	/* 1 */
	    /* choose start proces */
	    mod = get_til_module();
	    start_process = GetStartProcessChoice();
	    if (init_process_table(&mod->def[start_process].ae_t) == -1) {
		state = STATE_DEADLOCK;
	    } else {
		state = STATE_CHOOSE_INIT;
	    }
	    break;
	case STATE_SIMULATE:	/* 2 */
	    /* simulate, one step */
	    simulate();
	    if (!nr_processes_in_table()) {
		state = STATE_END;
	    } else
		state = STATE_CHOOSE_INIT;
	    break;
	case STATE_CHOOSE_INIT:/* 4 */
	    MakeHeadList(get_process_table());
	    if (ChooseListSize() == 0) {
		state = STATE_DEADLOCK;
		break;
	    }
	    state = STATE_CHOOSE;
	    break;
	case STATE_CHOOSE:
/* tbsim
	    keep_history();
*/
	    interface_choice(GetChooseList());
	    break;
	case STATE_END:	/* 7 */
	    if (old_state != state) {
/* tbsim
		old_state = state;
*/
		DestroyHeadList(); /* otherwise it appears in status */
/* tbsim
		keep_history();
*/
		interface_halt("end");
	    }
	    break;
	case STATE_RESET:	/* 8 */
	    /* RESET button is pressed */
	    destroy_process_table();
	    DestroyHeadList();
	    history_reset();
	    state = STATE_INIT;
	    start_process = -1;
	    /*
	     * print_count ();
	     */
	    break;
	case STATE_DEADLOCK:	/* 9 */
	    if (old_state != state) {
/* tbsim
		old_state = state;
*/
/* tbsim
		keep_history();
*/
		interface_halt("deadlock");
	    }
	    break;
	case STATE_HALT:
	    if (old_state != state) {
/* tbsim
		old_state = state;
*/
		interface_halt(error_buf);
	    }
	    break;
	case STATE_NOTHING:
	    /* do nothing */
	    break;
	case STATE_TRACEIN:
	    /* obsolete */
	    fprintf(stderr, "reached obsolete state STATE_TRACEIN\n");
	    break;
	case STATE_END_TRACEIN:
	    /* obsolete */
	    fprintf(stderr, "reached obsolete state STATE_END_TRACEIN\n");
	    break;
	case STATE_INPUT:
	    /* obsolete */
	    fprintf(stderr, "reached obsolete state STATE_INPUT\n");
	    break;
	default:
	    /*
	     * PANIC, I've lost the state, I where in. AH, I've found the exit
	     */
	    fprintf(stderr, "LOST CONTROL OF STATE\n");
	    exit(2);
	}
	if (state_forced != -1) {
	    state = state_forced;
	    state_forced = -1;
	}
    }
}

void force_state(ft)
    int ft;
{
    state_forced = ft;
}

int get_state()
{
    return(state);
}

void DECL_VARARGS_FUNC(force_error, char *, fmt)
{
    va_list args;

    VARARGS_start(args, fmt);
    vsprintf(error_buf, fmt, args);
    va_end(args);
    force_state(STATE_HALT);
}
