#include <stdio.h>
#include <string.h>
#include "psf_prototype.h"
#include "psf_malloc.h"

static char *buf = NULL;
static int max_buf = 2048;
static char *p;
static int listsize;
static int choice;

void StartProcessListReset()
{
    if (buf != NULL)
	PSF_FREE(buf);
    buf = PSF_NMALLOC(char, max_buf);
    p = buf;
    *p = '\0';
    listsize = 0;
}

void StartProcessListAdd(key, str)
int key;
char *str;
{
    if (strlen(buf) + strlen(str) + 10 >= max_buf) {
	max_buf *= 2;
	buf = PSF_REALLOC(buf, char, max_buf);
	p = buf + strlen(buf);
    }
    if (listsize)
	*p ++ = '#';
    sprintf(p, "%d %d %s", listsize, key, str);
    p += strlen(p);
    listsize ++;
}

char *GetStartProcessList()
{
    return(buf);
}

int StartProcessListSize()
{
    return(listsize);
}

void SetStartProcessChoice(i)
int i;
{
    choice = i;
}

int GetStartProcessChoice()
{
    return(choice);
}

