#include <stdio.h>
#include <string.h>
#include "psf_prototype.h"
#include "tiltype.h"
#include "prtilparts.h"
#include "fieldex.h"
#include "tilutil.h"
#include "msprint.h"
#include "simutil.h"
#include "psf_malloc.h"
#include "interface.h"

static char **definition_name;
static int nr_definitions;

static void make_definition_names()
{
    struct module *mod;
    int nr_def;
    int i;

    mod = get_til_module();
    nr_def = mod->entries_table[DEF];
    nr_definitions = nr_def;
    definition_name = PSF_NMALLOC(char *, nr_def + 1);
    for (i = 1; i <= nr_def; i++) {
	msprint_ae_term(&mod->def[i].ae_t);
	definition_name[i] = get_ms();
    }
}

char *get_definition_name(i)
    int i;
{
    return (definition_name[i]);
}

int get_nr_definitions()
{
    return (nr_definitions);
}

void init_simutil()
{
    if (get_til_module() == NULL)
	return;
    make_definition_names();
    send_action_info();
}

void free_simutil()
{
    int i, j;

    for (i = 1; i <= nr_definitions; i++)
	free(definition_name[i]);
    free(definition_name);
}

void send_action_info()
{
    char *buf;
    int max_buf;
    struct module *mod;
    int i;
    char *s;
    char *pbuf;

    max_buf = 10240;
    buf = PSF_NMALLOC(char, max_buf);
    *buf = '\0';
    mod = get_til_module();
    for (i = 1; i <= mod->entries_table[ATM]; i ++) {
	msprintf("%s", field_extract("n", mod->atm[i].ff, ATM, i));
	msprint_ind_list(mod->atm[i].sor_indlist.indlist,
	    mod->atm[i].sor_indlist.a);
	s = get_ms();
	if (strlen(buf) + strlen(s) + 1 >= max_buf) {
	    max_buf *= 2;
	    buf = PSF_REALLOC(buf, char, max_buf);
	}
	if (i == 1) {
	    pbuf = buf;
	} else {
	    pbuf = buf + strlen(buf);
	    *pbuf = '#';
	    pbuf ++;
	}
	sprintf(pbuf, "%d %s", i, s);
    }
    interface_action_info(buf);
    PSF_FREE(buf);
}
