#include <stdio.h>
#include "psf_prototype.h"
#include "tiltype.h"
#include "process.h"
#include "headtail.h"
#include "simulate.h"
#include "statecontrol.h"
#include "prio.h"
#include "sumport.h"
#include "simutil.h"
#include "heads.h"
#include "choose.h"

static unsigned int choice;

static void chosen_action(pp, cp)
    struct process **pp;
    struct communication **cp;
{
    choice = GetChoice();
    GetChosenHead(choice, pp, cp);
}

void simulate()
{
    struct process *p, *pl, *pr;
    struct communication *com;
    int ret_value;

    chosen_action(&p, &com);
    if (p != NULL) {
/* tbsim sum
	if (p->h_t->head->fun == SUM) {
	    set_item_to_choose(get_chosen_item());
	    popup_inputterm_sum(p);
	    force_state(STATE_INPUT);
	    return;
	}
*/
	p = remove_alternate_processes(p);
	if (p == NULL)
	    ret_value = 0;
	else
	    ret_value = next_head_tail(p);
    } else {
	if (com->p_left->flag & PORT_PROCESS)
	    com->p_left = create_sumport(com->p_left, com->sub);
	else if (com->p_right->flag & PORT_PROCESS)
	    com->p_right = create_sumport(com->p_right, com->sub);
	com->p_right->encaps_flag = com->p_right->hide_flag = NULL;
	com->p_left->encaps_flag = com->p_left->hide_flag = NULL;
	com->p_left->com_flag = com->p_right->com_flag = 0;
	pr = remove_alternate_processes(com->p_right);
	pl = remove_alternate_processes(com->p_left);
	if (pl == NULL)
	    ret_value = 0;
	else
	    ret_value = next_head_tail(pl);
	if (pr != NULL)
	    ret_value = next_head_tail(pr);
    }
    switch (ret_value) {
    case -1:			/* all processes have ended */

#ifdef	DEBUG
	fprintf(stderr, "NO MORE PROCESSES\n");
#endif

	break;
    case 0:			/* everything ok */
	break;
    case 1:			/* new processes are added */
	break;
    default:			/* not yet implemented functions */
/*
	fprintf(stderr, "UNIMPLEMENTED FUNCTION\n");
*/
	break;
    }
}
