#include <stdio.h>
#include <string.h>
#include "psf_prototype.h"
#include "tiltype.h"
#include "tilutil.h"
#include "simutil.h"
#include "eqm.h"
#include "msprint.h"
#include "headtail.h"
#include "process.h"
#include "alloccontrol.h"
#include "psf_malloc.h"
#include "prio.h"
#include "sumport.h"
#include "eqm_local.h"
#include "heads.h"
#include "startprocess.h"

static struct process *process_table = NULL;
static struct process *process_table_end;
static unsigned int nr_processes = 0;

static struct process_expr aet_expr = {AET};

int init_process_table(aet)
struct ae_term *aet;
{
    struct process *p;

    aet_expr.proc_expr.pe2 = *aet;
    p = create_process(NULL, &aet_expr);
    add_process_to_table(p);
    return (make_head_tail(p));
}

struct process *get_process_table()
{
    return (process_table);
}

static unsigned int process_id = 0;

struct process *create_process(parent, counter)
    struct process *parent;
    struct process_expr *counter;
{
    struct process *p;
    struct head_tail *h_t;
    struct tailheap *tail;

    p = alloc_process();
    p->id = process_id;
    process_id++;
    p->parent = parent;
    if (parent == NULL)
	p->flag = NORMAL_PROCESS;
    else
	p->flag = parent->flag & (~DEADLOCK);
    p->sleeping = 0;
    p->h_t = h_t = alloc_h_t();
    h_t->head = NULL;
    h_t->tail = tail = alloc_tail();
    tail->expr = counter;
    tail->nr = 0;
    tail->tail = NULL;
    h_t->string = NULL;
    p->child = NULL;
    p->nr_children = 0;
    if (parent == NULL) {
	p->set = NULL;
	h_t->sub = NULL;
    } else {
	p->set = parent->set;
	h_t->sub = parent->h_t->sub;
    }
    h_t->top = 0;
    h_t->ae_t = NULL;
    p->hide_flag = NULL;
    p->encaps_flag = NULL;
    p->com_flag = 0;
    p->next = NULL;
    p->prev = NULL;
    p->sumvar = NULL;
    p->nr_sumvar = 0;
    return (p);
}

void alloc_children(p, nr)
    struct process *p;
    unsigned int nr;
{
    if (p->child != NULL)
	fprintf(stderr, "child not freed\n");
    p->child = alloc_child(nr);
    p->nr_children = nr;
}

void destroy_process(p)
    struct process *p;
{
    struct head_tail *h_t;
    struct set_list *sl1, *sl2, *sparent;

    h_t = p->h_t;
    while (h_t->tail != NULL)
	delete_tail(h_t);
    if (h_t->string != NULL)
	free_string(h_t->string);
    if (h_t->top)
	subst_free(h_t->sub);
    if ((h_t->ae_t != NULL) && !(p->flag & PORT_PROCESS))
	ae_term_free(h_t->ae_t);
    else
	h_t->ae_t = NULL;
    free_h_t(h_t);
    if ((sl1 = p->set) != NULL) {
	if (p->parent == NULL)
	    sparent = NULL;
	else
	    sparent = p->parent->set;
	while (sl1 != sparent) {
	    sl2 = sl1;
	    sl1 = sl1->next;
	    free_set(sl2);
	}
    }
    if (p->child != NULL) {
	free_child(p->child);
	p->child = NULL;
    }
    if (p->sumvar != NULL) {
	PSF_FREE(p->sumvar);
	p->sumvar = NULL;
    }
    /*
     * Fill in the magic number. It makes debugging so much easier,
     * although it's a legal process-id. -- BOBO --
     */
    p->id = 8080;
    p->com_flag = 8080;
    p->nr_children = 8080;
    free_process(p);
}

void add_process_to_table(p)
    struct process *p;
{
    if (!nr_processes)
	process_table = p;
    else
	process_table_end->next = p;
    p->prev = process_table_end;
    process_table_end = p;
    nr_processes++;

    /* for history, so that new processes get an unused id */
    if (p->id >= process_id)
	process_id = p->id + 1;
}

void delete_process_from_table(p)
    struct process *p;
{
    struct process *hp;


    if (0) {
	hp = process_table;
	if (hp == p)
	    process_table = hp = p->next;
	else {
	    while (hp->next != p)
		hp = hp->next;
	    hp->next = p->next;
	} if
	    (process_table_end == p)
	    process_table_end = hp;
    }
    if (p->prev == NULL) {
	process_table = p->next;
	if (process_table != NULL)
	    process_table->prev = NULL;
    } else {
	p->prev->next = p->next;
    }
    if (p->next == NULL)
	process_table_end = p->prev;
    else
	p->next->prev = p->prev;
    nr_processes--;
}

unsigned int nr_processes_in_table()
{
    return (nr_processes);
}

static void dpt_rec(p)
    struct process *p;
{
    int i;

    for (i = 0; i < p->nr_children; i++)
	if (p->child[i] != NULL)
	    dpt_rec(p->child[i]);
    delete_process_from_table(p);
    destroy_process(p);
}

void destroy_process_table()
{
    struct process *p;

    if (0) {
	while (process_table != NULL) {
	    p = process_table;
	    process_table =
		process_table->next;
	    destroy_process(p);
	}
	process_table_end = NULL;
	nr_processes = 0;
    }
    if (process_table != NULL)
	dpt_rec(process_table);
    process_table = NULL;
    process_table_end = NULL;
    process_id = 0;
    if (nr_processes != 0)
	fprintf(stderr, "** %d\n", nr_processes);
}

void put_process_to_sleep(p, nr_children)
    struct process *p;
    unsigned int nr_children;
{
    p->sleeping = nr_children;
}

void awaken_process(p, child)
    struct process *p;
    struct process *child;
{
    struct process **h;

    p->sleeping--;
    if (!p->sleeping) {
	free_child(p->child);
	p->child = NULL;
	p->nr_children = 0;
    } else {
	h = &p->child[p->nr_children - 1];
	while (*h != child)
	    h--;
	*h = NULL;
    }
}

static char char_table[] = {
    AET, SKP, ALT, SEQ, PAR, SUM, MRG, ENC, HID, DLK, IF, INTR, DISR, PRIO,
    STAR, SHARP
};
static char *name_table[] = {
    "", "skip", "+", ".", "||", "sum",
    "merge", "encaps", "hide", "delta", "[...]->",
    "interrupt", "disrupt", "prio", "*", "#"
};

#ifdef DEBUG_MEMUSE
int count_p(p)
struct process *p;
{
    int i;
    int pcount, ccount;

    if (p == NULL)
	return(0);
    pcount = ccount = 0;
    for (i = 0; i < p->nr_children; i ++) {
	if (p->child[i] == NULL)
	    continue;
	pcount += count_p(p->child[i]);
	ccount ++;
    }
    if (p->sleeping != ccount) {
	fprintf(stderr, " %d: %d %d\n", p->id, p->sleeping, p->nr_children);
    }
    return(pcount + ccount);
}
#endif /* DEBUG_MEMUSE */
    
void print_process_status(display)
void (*display)PROTO_VARARGS(char *);
{
    struct process *p;
    struct communication *c;
    int i;

    display("   PID   PPID STATUS FLAGS  PRIO HEAD\n");
    for (p = process_table; p != NULL; p = p->next) {
	display("%6u", p->id);
	if (p->parent == NULL)
	    display("       ");
	else
	    display(" %6u", p->parent->id);
	if (!p->sleeping)
	    display("       ");
	else
	    display("  S%3d ", p->sleeping);
	display(" %c%c%c%c%c%c ",
			p->flag & DEADLOCK ? 'D' : ' ',
			p->flag & DISABLED_PROCESS ? 'I' : ' ',
			p->flag & PORT_PROCESS ? 'P' : ' ',
			p->encaps_flag != NULL ? 'E' : ' ',
			p->hide_flag != NULL ? 'H' : ' ',
			p->com_flag ? 'C' : ' ');
	if (p->flag & DEADLOCK) {
	    display("\n");
	    continue;
	}
	if (!p->sleeping) {
	    if (p->priority == MAX_PRIO)
		display("MAX ");
	    else if (p->priority == MIN_PRIO)
		display("MIN ");
	    else
		display("%3d ", p->priority);
	    if (p->h_t->head->fun == SKP)
		display(" %-16s", p->h_t->string);
	    else
		display(" %-16s", p->h_t->string);
	} else if (p->h_t->tail != NULL) {
	    display("    ");
	    for (i = 0; char_table[i] != p->h_t->tail->expr->fun; i ++);
	    display(" <%s>", name_table[i]);
	    if (p->h_t->tail->expr->fun == SHARP) {
		if (p->loop_count < 0)
		    display(" (%d", - p->loop_count);
		else if (p->loop_count == 0)
		    display(" ()");
		else
		    display(" %d)", p->loop_count);
	    }
	}
/*
display("  %ld", p->h_t->sub);
*/
	display("\n");
    }

    if ((c = GetCommList()) != NULL) {
	display("\n");
	display("   PID    PID FLAGS PRIO COMM\n");
	for (; c != NULL; c = c->next) {
	    display("%6u %6u   %c%c  ", c->p_left->id,
		c->p_right->id, c->encaps_flag != NULL ? 'E' : ' ',
		 c->hide_flag != NULL ? 'H' : ' ');
	    if (c->priority == MAX_PRIO)
		display("MAX ");
	    else if (c->priority == MIN_PRIO)
		display("MIN ");
	    else
		display("%3d ", c->priority);
	    display(" %s\n", c->string);
	}
    }
#ifdef DEBUG_MEMUSE
    fprintf(stderr, "#p: %d %d\n", nr_processes, count_p(process_table) + 1);
    fprintf(stderr, "                  new         old        free        left\n");
    print_alloc_count();
    print_sub_count();
#endif /* DEBUG_MEMUSE */
}

int make_start_process_list()
{
    int i;
    int nr;
    char *name;

    nr = get_nr_definitions();
    StartProcessListReset();
    for (i = 1; i <= nr; i++) {
	name = get_definition_name(i);
	if (name[strlen(name) - 1] != ')') {
	    StartProcessListAdd(i, name);
	}
    }
}

int find_start_process(s)
    char *s;
{
    int i;
    int nr;

    nr = get_nr_definitions();
    for (i = 1; i <= nr; i ++) {
	if (strcmp(s, get_definition_name(i)) == 0) {
	    return i;
	}
    }
    return -1;
}

void mark_process_tree(p, flag)
    struct process *p;
    int flag;
{
    int fun;
    int i;

    if (!p)
	return;

    if (p->h_t->tail != NULL) {
	fun = p->h_t->tail->expr->fun;
	if (fun == ALT || fun == SUM || fun == DISR || fun == INTR ||
	    fun == STAR || fun == SHARP)
	    return;
    }
    if (flag == NORMAL_PROCESS) {
	p->flag &= ~TEMP_PROCESS;
	p->flag &= NORMAL_PROCESS;
    } else
	p->flag = flag;
    for (i = 0; i < p->nr_children; i++)
	mark_process_tree(p->child[i], flag);
}

static int encaps_or_hide(p, top)
    struct process *p;
    struct process *top;
{
    int r;
    struct set_list *sl;

    if (p->flag & PORT_PROCESS) {
	if ((r = sumport_encaps_or_hide(p, top)) == -1)
	    return(1);
	else
	    return(r);
    }

    for (sl = p->set; sl != top->set; sl = sl->next) {
	if (sl == p->encaps_flag || sl == p->hide_flag)
	    return(1);
    }
    return(0);
}

int replace_var(sub, caet, paet, sumvar, nr_sumvar)
subst_t *sub;
struct ae_term *caet;
struct ae_term *paet;
keytype *sumvar;
int nr_sumvar;
{
    int a;
    subst_elem_t *e;
    int i, j;

    /* for all substitions in sub */
    for (e = sub->sb_elems; e; e = e->next_se) {
	/* replace this key with key of corresponding sum-variable */
	for (i = caet->a - 1; i >= 0; i --) {
	    if (paet->ae_list[i].ind.table == VAR) {
		/* we have a sum-variable */
		if (e->var.key == caet->ae_list[i].ind.key) {
		    /* it corresponds */
		    /* now check if allowed wrt sets (extra type-check) */
		    if (!check_set_sumvar(e, paet->ae_list[i].ind.key))
			return(0);
		    /* replace */
		    e->var.key = paet->ae_list[i].ind.key;
		    break;
		}
	    }
	}
    }
    return(1);
}
