/*
 * Determination of priorities on atoms (and communications).
 * Results in setting the priorities to:
 *    - a negative number, indicating that it has low priority and the absolute
 *    value of the number indicates which prio-operator has caused this.
 *    - 0, indicating that there is no priority.
 *    - a positive number, indicating that it has high priority.
 */

#include <stdio.h>
#include "psf_prototype.h"
#include "tiltype.h"
#include "process.h"
#include "headtail.h"
#include "tilutil.h"
#include "prio.h"
#include "sumport.h"

/*
 * Determines the priority of an atom according to the priority-list prio.
 *  0 for no priority
 *  x for priority x, where x is the number of the set in the list
 *    in which the atom was found (numbering from right to left)
 */
int priority_level(aet, prio, type)
struct ae_term *aet;
struct indexlist *prio;
int type;
{
    int i;
    struct module *mod;
    int r;

    if (prio == NULL)
	return(0);
    mod = get_til_module();
    if (prio->a == 1) { /* It really is X > atoms */
	if (prio->indlist[0].table == SOR && prio->indlist[0].key == 0)
	    return(2);
	if (type == SUM) {
	    if ((r = sumport_member_of_set(aet, prio->indlist[0].key)) > 0)
		return(2);
	    else if (r < 0) /* we couldn't decide it */
		return(MAX_PRIO);
	} else if (member_of_set(aet,
	    &mod->set[prio->indlist[0].key].construct.set_term))
	    return(2);
	return(1);
    } else {
	for (i = 0; i < prio->a; i ++) {
	    if (prio->indlist[i].table == SOR && prio->indlist[i].key == 0)
		return(prio->a - i);
	    if (type == SUM) {
		if ((r = sumport_member_of_set(aet, prio->indlist[i].key)) > 0)
		    return(prio->a - i);
		else if (r < 0) /* we couldn't decide it */
		    return(MAX_PRIO);
	    } else if (member_of_set(aet,
		&mod->set[prio->indlist[i].key].construct.set_term))
		return(prio->a - i);
	}
	return(0);
    }
}
