#include <stdio.h>
#include <string.h>
#include "psf_stdarg.h"
#include "tiltype.h"
#include "tilutil.h"
#include "fieldex.h"
#include "eqm_local.h"
#include "eqm.h"

static char buffer[10240];
static char *bp = buffer;
static int endbuffer = 0;
/*
static char *endbp = (buffer + 9216);
*/
static char *endbp = (buffer + 4096);

static subst_t *sub = NULL;

static struct ae_term *sub_var(ind)
    struct indextype *ind;
{
    subst_elem_t *se;

    if (ind->table != VAR)
	return (NULL);
    if (sub == NULL)
	return (NULL);
    se = sub->sb_elems;
    while (se != NULL) {
	if (se->var.key == ind->key) {
	    return (term2ae_term(se->value));
	}
	se = se->next_se;
    }
    return (NULL);
}

void DECL_VARARGS_FUNC(msprintf, char *, fmt)
{
    va_list args;
    int nc;

    if (endbuffer)
	return;
    VARARGS_start(args, fmt);
    nc = vsprintf(bp, fmt, args);
    va_end(args);
    for (; *bp != '\0'; bp++);
    if (bp > endbp) {
	*(bp ++) = '.';
	*(bp ++) = '.';
	*(bp ++) = '.';
	*bp = '\0';
	endbuffer = 1;
    }
}

void msputc(c)
    char c;
{
    if (endbuffer)
	return;
    *bp++ = c;
    *bp = '\0';
    if (bp > endbp) {
	*(bp ++) = '.';
	*(bp ++) = '.';
	*(bp ++) = '.';
	*bp = '\0';
	endbuffer = 1;
    }
}

char *get_ms()
{
    char *s;

    bp = buffer;
    s = psf_strdup(buffer);
    endbuffer = 0;
    return (s);
}

char *get_msp()
{
    bp = buffer;
    endbuffer = 0;
    return(buffer);
}

static void msprint_freeformat(table, key)
    tabletype table;
    keytype key;
{
    freeformat ff;
    struct module *current_module;

    current_module = get_til_module();
    switch (table) {
    case SOR:
	ff = current_module->sor[key].ff;
	break;
    case FUN:
	ff = current_module->fun[key].ff;
	break;
    case ATM:
	ff = current_module->atm[key].ff;
	break;
    case PRO:
	ff = current_module->pro[key].ff;
	break;
    case SET:
	ff = current_module->set[key].ff;
	break;
    case COM:
	ff = current_module->com[key].ff;
	break;
    case VAR:
	ff = current_module->var[key].ff;
	break;
    case EQU:
	ff = current_module->equ[key].ff;
	break;
    case DEF:
	ff = current_module->def[key].ff;
	break;
    }
    msprintf("%s", field_extract("n", ff, table, key));
}

static int infix_operator(t, k)
    tabletype t;
    keytype k;
{
    char *s;
    struct module *current_module;

    if (t != FUN)
	return (0);
    current_module = get_til_module();
    s = field_extract("n", current_module->fun[k].ff, FUN, k);
    if (s[0] == '_' || s[strlen(s) - 1] == '_')
	return (1);
    return (0);
}

static int hook = -1;

void msprint_ae_term(term)
    ae_term *term;
{
    int i, el;
    int j;
    char *s;
    struct module *current_module;
    struct ae_term *il;
    struct ae_term *subterm;
    int infix;

    hook++;
    if (term->t == TUPLE) {
	msputc('<');
	for (il = term->ae_list, i = 0; i < term->a; i++, il++) {
	    if (i)
		msprintf(", ");
	    msprint_ae_term(il);
	}
	msputc('>');
    } else {
	if (infix_operator(term->ind.table, term->ind.key)) {
	    current_module = get_til_module();
	    s = psf_strdup(field_extract("n",
		current_module->fun[term->ind.key].ff, FUN, term->ind.key));
	    i = 0;
	    j = 0;
/*
	    if (hook > 0)
		msputc('(');
*/
	    if (s[0] == '_') {
		infix = infix_operator(term->ae_list[i].ind.table,
		    term->ae_list[i].ind.key);
		if (infix)
		    msputc('(');
		msprint_ae_term(&term->ae_list[i]);
		if (infix)
		    msputc(')');
		i++;
		j++;
		msputc(' ');
	    }
	    for (; s[j] != '_' && s[j] != '\0' && s[j] != ' ';
		    j++)
		msputc(s[j]);
	    if (s[j] == '_') {
		msputc(' ');
		infix = infix_operator(term->ae_list[i].ind.table,
		    term->ae_list[i].ind.key);
		if (infix)
		    msputc('(');
		msprint_ae_term(&term->ae_list[i]);
		if (infix)
		    msputc(')');
	    }
	    PSF_FREE(s);
/* does not agree with procgraph, so there was no matching term in animation
	    if (hook > 0)
		msputc(')');
*/
	} else {
	    if ((subterm = sub_var(&term->ind)) != NULL) {
		msprint_ae_term(subterm);
		ae_term_free(subterm);
	    } else {
		msprint_freeformat(term->ind.table,
				   term->ind.key);
		if (term->a) {
		    msputc('(');
		    el = 0;
		    for (il = term->ae_list, i = 0;
			    i < term->a; i++, il++) {
			if (el)
			    msprintf(", ");
			msprint_ae_term(il);
			el++;
		    }
		    msputc(')');
		}
	    }
	}
    }
    hook--;
}

void msprint_ind_list(il, a)
    struct indextype *il;
    int a;
{
    int i;
    struct ae_term *subterm;

    if (a)
	msputc('(');
    for (i = 0; i < a; i++, il++) {
	if (i)
	    msprintf(", ");
	if ((subterm = sub_var(il)) != NULL) {
	    msprint_ae_term(subterm);
	    ae_term_free(subterm);
	} else
	    msprint_freeformat(il->table, il->key);
    }
    if (a)
	msputc(')');
}

static void msprint_placeholder(key)
    keytype key;
{
    var_tuple *var_t;
    struct module *current_module;

    current_module = get_til_module();

    var_t = &current_module->var[key];
    msprintf("%s", field_extract("n", var_t->ff, VAR, key));
    msprintf(" in ");
    msprint_freeformat(var_t->ind.table, var_t->ind.key);
}

static int precedence(fun)
char fun;
{
    switch (fun) {
    case ALT:
        return(1);
    case MRG:
    case STAR:
    case SHARP:
        return(2);
    case SEQ:
        return(3);
    default:
        return(4);
    }
}

void msprint_process_expr(pe)
    struct process_expr *pe;
{
    struct process_expr *pexpr;
    int hook;
    int i;
    int a;
    struct indextype *ind;

    switch (pe->fun) {
    case SKP:
	msprintf("skip");
	break;
    case ALT:
	msprint_process_expr(&pe->proc_expr.pe3.pe[0]);
	msprintf(" + ");
	msprint_process_expr(&pe->proc_expr.pe3.pe[1]);
	break;
    case SEQ:
	if (precedence(pe->proc_expr.pe3.pe[0].fun) < precedence(pe->fun)) {
	    hook = 1;
	    msprintf("(");
	} else
	    hook = 0;
	msprint_process_expr(&pe->proc_expr.pe3.pe[0]);
	if (hook)
	    msprintf(")");
	msprintf(" . ");
	if (precedence(pe->proc_expr.pe3.pe[1].fun) < precedence(pe->fun)) {
	    hook = 1;
	    msprintf("(");
	} else
	    hook = 0;
	msprint_process_expr(&pe->proc_expr.pe3.pe[1]);
	if (hook)
	    msprintf(")");
	break;
    case PAR:
	if (precedence(pe->proc_expr.pe3.pe[0].fun) < precedence(pe->fun)) {
	    hook = 1;
	    msprintf("(");
	} else
	    hook = 0;
	msprint_process_expr(&pe->proc_expr.pe3.pe[0]);
	if (hook)
	    msprintf(")");
	msprintf(" || ");
	if (precedence(pe->proc_expr.pe3.pe[1].fun) < precedence(pe->fun)) {
	    hook = 1;
	    msprintf("(");
	} else
	    hook = 0;
	msprint_process_expr(&pe->proc_expr.pe3.pe[1]);
	if (hook)
	    msprintf(")");
	break;
    case INTR:
	msprintf("interrupt(");
	msprint_process_expr(&pe->proc_expr.pe3.pe[0]);
	msprintf(", ");
	msprint_process_expr(&pe->proc_expr.pe3.pe[1]);
	msprintf(")");
	break;
    case DISR:
	msprintf("disrupt(");
	msprint_process_expr(&pe->proc_expr.pe3.pe[0]);
	msprintf(", ");
	msprint_process_expr(&pe->proc_expr.pe3.pe[1]);
	msprintf(")");
	break;
    case PRIO:
	msprintf("prio(");
	a = pe->proc_expr.pe5.sets.a;
	ind = pe->proc_expr.pe5.sets.indlist;
	for (i = 0; i < a; i ++) {
	    if (i)
		msprintf(" > ");
	    msprint_freeformat(ind[i].table, ind[i].key);
	}
	msprintf(", ");
	msprint_process_expr(pe->proc_expr.pe5.pe);
	msprintf(")");
	break;
    case STAR:
    case SHARP:
	if (precedence(pe->proc_expr.pe3.pe[0].fun) < precedence(pe->fun)) {
	    hook = 1;
	    msprintf("(");
	} else
	    hook = 0;
	msprint_process_expr(&pe->proc_expr.pe3.pe[0]);
	if (hook)
	    msprintf(")");
	if (pe->fun == STAR)
	    msprintf(" * ");
	else
	    msprintf(" # ");
	if (precedence(pe->proc_expr.pe3.pe[1].fun) < precedence(pe->fun)) {
	    hook = 1;
	    msprintf("(");
	} else
	    hook = 0;
	msprint_process_expr(&pe->proc_expr.pe3.pe[1]);
	if (hook)
	    msprintf(")");
	break;
    case SUM:
	msprintf("sum(");
	msprint_placeholder(pe->proc_expr.pe1.ind.key);
	msprintf(", ");
	msprint_process_expr(pe->proc_expr.pe1.pe);
	msprintf(")");
	break;
    case MRG:
	msprintf("merge(");
	msprint_placeholder(pe->proc_expr.pe1.ind.key);
	msprintf(", ");
	msprint_process_expr(pe->proc_expr.pe1.pe);
	msprintf(")");
	break;
    case ENC:
	msprintf("encaps(");
	msprint_freeformat(pe->proc_expr.pe1.ind.table,
			   pe->proc_expr.pe1.ind.key);
	msprintf(", ");
	msprint_process_expr(pe->proc_expr.pe1.pe);
	msprintf(")");
	break;
    case HID:
	msprintf("hide(");
	msprint_freeformat(pe->proc_expr.pe1.ind.table,
			   pe->proc_expr.pe1.ind.key);
	msprintf(", ");
	msprint_process_expr(pe->proc_expr.pe1.pe);
	msprintf(")");
	break;
    case IF:
	msprintf("[");
	msprint_ae_term(&pe->proc_expr.pe4.aex);
	msprintf(" = ");
	msprint_ae_term(&pe->proc_expr.pe4.aey);
	msprintf("] -> ");
	pexpr = pe->proc_expr.pe4.pe;
	if (pexpr->fun == ALT || pexpr->fun == SEQ ||
		pexpr->fun == PAR) {
	    hook = 1;
	    msprintf("(");
	} else
	    hook = 0;
	msprint_process_expr(pe->proc_expr.pe4.pe);
	if (hook)
	    msprintf(")");
	break;
    case AET:
	msprint_ae_term(&pe->proc_expr.pe2);
	break;
    }
}

void msprint_process_expr_sub(pe, s)
    struct process_expr *pe;
    subst_t *s;
{
    sub = s;
    msprint_process_expr(pe);
    sub = NULL;
}
