#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/uio.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>
#include "psf_prototype.h"
#include "statecontrol.h"
#include "process.h"
#include "filedisplay.h"
#include "choose.h"
#include "history.h"
#include "startprocess.h"

static FILE *TB_in;
static FILE *TB_out;

/*
 * Read a line from the input.
 */
static char line[10240];

static void interface_readline()
{
    int n;
    char *p;
    int fd;

    p = line;
    fd = fileno(TB_in);
    while (1) {
	while (read(fd, p, 1) == -1) {
	    if (errno != EAGAIN) {
		fprintf(stderr, "error\n");
		exit(1);
	    }
	}
	if (*p == '\n') {
	    *p = '\0';
	    return;
	}
	p ++;
    }
}

/*
 * Initialization of the ToolBus interface.
 */
void interface_init(in, out)
char *in;
char *out;
{
    char tool[16];

    /* open the pipes */
    TB_in = fdopen(open(in, O_RDONLY | O_NONBLOCK), "r");
    TB_out = fdopen(open(out, O_WRONLY), "w");
}

/*
 * Send string with format f and argument s.
 */
void interface_send(f, s)
char *f;
char *s;
{
    fprintf(TB_out, f, s);
    fflush(TB_out);
}

/*
 * Send a quit.
 */
void interface_quit()
{
    interface_send("quit\n", NULL);
}

static void response()
{
    unsigned int markid;
    char *name;
    int i;

AGAIN:
    interface_readline();

    /* find out the command and act on it */
    if (!strcmp("<reset>", line)) {
	force_state(STATE_RESET);
    } else if (!strcmp("<quit>", line)) {
	interface_quit();
	exit(0);
    } else if (!strncmp("<save", line, 5)) {
	(void) sscanf(line, "<save(%u)>", &markid);
	history_save(markid);
	goto AGAIN;
    } else if (!strncmp("<gotomark", line, 9)) {
	(void) sscanf(line, "<gotomark(%u)>", &markid);
	history_gotomark(markid);
	force_state(STATE_CHOOSE_INIT);
    } else if (!strcmp("<process-status>", line)) {
	name = FileDisplayOpen();
	print_process_status(FileDisplay);
	FileDisplayClose();
	interface_send("process-status(%s)\n", name);
	goto AGAIN;
    } else if (!strncmp("<start", line, 6)) {
	(void) sscanf(line, "<start(%d)>", &i);
	force_state(STATE_RESET);
	SetStartProcessChoice(i);
    } else {
	sscanf(line, "%d", &i);
	SetChoice(i);
	force_state(STATE_SIMULATE);
    }
}

/*
 * Send start processes list
 */
void interface_start_process(l)
char *l;
{
    interface_send("process-list(%s)\n", l);

    response();
}

/*
 * Send choose-list to ToolBus and wait for reply.
 */
void interface_choice(chooselist)
char *chooselist;
{
    interface_send("choose(%s)\n", chooselist);

    response();
}

/*
 * Send a end or deadlock and wait
 */
void interface_halt(s)
char * s;
{
    interface_send("halt(%s)\n", s);

    response();
}

void interface_action_info(s)
char *s;
{
    interface_send("action-info(%s)\n", s);
}

static char actionbuf[1024];

void interface_action(i, s)
int i;
char *s;
{
    sprintf(actionbuf, "info(%d, %s)", i, s);
    interface_send("action(%s)\n", actionbuf);
}
