#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include "psf_prototype.h"
#include "xutil.h"

static Arg width_arg = {
    XtNwidth, (XtArgVal) NULL
};

Dimension get_width(w)
    Widget w;
{
    Dimension width;

    XtSetArg(width_arg, XtNwidth, (XtArgVal) & width);
    XtGetValues(w, &width_arg, 1);
    return (width);
}

static Arg height_arg = {
    XtNheight, (XtArgVal) NULL
};

Dimension get_height(w)
    Widget w;
{
    Dimension height;

    XtSetArg(height_arg, XtNheight, (XtArgVal) & height);
    XtGetValues(w, &height_arg, 1);
    return (height);
}

void set_width(w, width)
    Widget w;
    Dimension width;
{
    XtSetArg(width_arg, XtNwidth, (XtArgVal) width);
    XtSetValues(w, &width_arg, 1);
}

static Arg wh_arg[2] = {
    {XtNwidth, (XtArgVal) NULL},
    {XtNheight, (XtArgVal) NULL}
};

void get_wh(wid, w, h)
    Widget wid;
    Dimension *w, *h;
{
    XtSetArg(*wh_arg, XtNwidth, (XtArgVal) w);
    XtSetArg(wh_arg[1], XtNheight, (XtArgVal) h);
    XtGetValues(wid, wh_arg, 2);
}

void set_wh(wid, w, h)
    Widget wid;
    Dimension w, h;
{
    XtSetArg(*wh_arg, XtNwidth, (XtArgVal) w);
    XtSetArg(wh_arg[1], XtNheight, (XtArgVal) h);
    XtSetValues(wid, wh_arg, 2);
}
