#include <stdio.h>
#include <stdlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/cursorfont.h>
#include "psf_prototype.h"
#include "widgets.h"
#include "wait"
#include "wait_mask"
#include "inputterm.h"
#include "psfwid.h"
#include "choosewid.h"
#include "messagewid.h"
#include "procvar.h"
#include "functionwid.h"
#include "tracewid.h"
#include "tinwid.h"

/*
 * shell-widgets and inner-widgets definitions
 */
#define	W_MAIN		0
#define	W_PSF		1
#define	W_CHOOSE	2
#define	W_FUNCTION	3
#define	W_MESSAGE	4
#define W_TRACE		5
#define W_SPECIAL	6
#define	W_TIN		7

#define NR_W		8

Widget shell_widget[NR_W];

/*
 * numbering of the resources of the shell widgets
 */
#define	N_HEIGHT	0
#define	N_WIDTH		1
#define	N_X		2
#define	N_Y		3
#define	N_ICONIC	4

/*
 * definitions widget (MAIN)
 * 
 * widget main is only used as the parent of the toplevel shells
 */

/*
 * definitions widget (specification in PSF-form)
 */
static Arg shell_psf[] = {
    {NULL}
};

/*
 * definitions widget (CHOOSE next action)
 */
static Arg shell_choose[] = {
    {XtNiconic, (XtArgVal) False},
    {XtNallowShellResize, (XtArgVal) True},
};

/*
 * definitions widget (FUNCTIONS)
 */
static Arg shell_function[] = {
    {NULL}
};

/*
 * definitions widget (MESSAGES)
 */
static Arg shell_message[] = {
    {NULL}
};

/*
 * definitions widget (TRACE)
 */
static Arg shell_trace[] = {
    {NULL}
};

static Arg shell_tin[] = {
    {NULL}
};

/*
 * Determine the type of display: color or else.
 */
static int IsColorDisplay(prgname)
char *prgname;
{
    Display *dpy;
    int scrno;
    Screen *screen;
    Visual *visual;
    int color;
    char * sname;

    /*
     * This is how xrdb determines the COLOR define, so I guess this is
     * a good way.
     */
    sname = XDisplayName(NULL);
    if ((dpy = XOpenDisplay(sname)) == NULL) {
	fprintf(stderr, "%s: Can't open display '%s'\n", prgname, sname);
	exit(1);
    }
    scrno = DefaultScreen(dpy);
    screen = ScreenOfDisplay(dpy, scrno);
    visual = DefaultVisualOfScreen(screen);
    switch (visual->class) {
    case StaticColor:
    case PseudoColor:
    case TrueColor:
    case DirectColor:
	color = 1;
	break;
    default:
	color = 0;
	break;
    }
    XCloseDisplay(dpy);
    return(color);
}

XtAppContext app_context;

static XrmOptionDescRec options[] = {
    {"-b", NULL, XrmoptionSkipArg, NULL},
    {"-d", NULL, XrmoptionSkipNArgs, 0},
    {"-h", NULL, XrmoptionSkipNArgs, 0},
    {"-i", NULL, XrmoptionSkipNArgs, 0},
    {"-o", NULL, XrmoptionSkipNArgs, 0},
    {"-r", NULL, XrmoptionSkipArg, NULL},
    {"-v", NULL, XrmoptionSkipNArgs, 0},
};

String fallback[] = {
    "Sim.PSF.width:                  500",
    "Sim.PSF.height:                 350",
    "Sim.PSF.x:                      0",
    "Sim.PSF.y:                      1",
    "Sim.PSF.iconic:                 False",
    "Sim.MESSAGE.width:              500",
    "Sim.MESSAGE.height:             250",
    "Sim.MESSAGE.x:                  0",
    "Sim.MESSAGE.y:                  376",
    "Sim.MESSAGE.iconic:             False",
    "Sim.TRACE.width:                500",
    "Sim.TRACE.height:               222",
    "Sim.TRACE.x:                    0",
    "Sim.TRACE.y:                    651",
    "Sim.TRACE.iconic:               False",
    "Sim.FUNCTION.x:                 504",
    "Sim.FUNCTION.y:                 1",
    "Sim.FUNCTION.iconic:            False",
	/* We set some to 0, so we can use the more general function*height */
    "Sim.FUNCTION.height:   0",
    "Sim.FUNCTION.function.MODULES*height: 0",
    "Sim.FUNCTION.function*SimpleMenu.height: 0",
/*
    "Sim.FUNCTION.function*height:   30",
*/
    "Sim*internalHeight: 4",
    "Sim*SmeBSB.vertSpace:  100",

    "Sim.CHOOSE.x:                   504",
    "Sim.CHOOSE.y:                   368",
    "Sim.TRACE FROM STDIN.x:         690",
    "Sim.TRACE FROM STDIN.y:         1",
    "Sim.TRACE FROM STDIN.iconic:    False",
    "Sim.FUNCTION.function.MODULES.x: 400",
    "Sim.FUNCTION.function.MODULES.y: 45",
    NULL,    /* Separation from color resources */
    "Sim*cursorColor:                red",
    "Sim*background:                 honeydew",
    "Sim*Scrollbar.background:       grey",
    "Sim*Scrollbar.foreground:       mediumblue",
    "Sim*Box.background:             lightblue",
    "Sim*Form.background:            lightblue",
    "Sim*Command.background:         gray80",
    "Sim*Command.foreground:         black",
    "Sim*Toggle.background:          gray90",
    "Sim*Toggle.foreground:          black",
    "Sim*MenuButton.background:      gray95",
    "Sim*MenuButton.foreground:      black",
    "Sim*Dialog.background:          gray60",
    "Sim*Label.background:           skyblue",
    "Sim*SimpleMenu*background:      lightskyblue",
    NULL
};

/*
 * function for initializing the application context
 */
void init_app_context(argc, argv)
    int *argc;
    char *argv[];
{
    String *p;

    if (IsColorDisplay(argv[0])) {
	/*
	 * Add default color resources.
	 */
	for (p = fallback; *p != NULL; p ++);
	*p = *(p-1); /* doubling it doesn't harm anathing */
    }
    shell_widget[W_MAIN] = XtAppInitialize(&app_context, "Sim", options,
	XtNumber(options), argc, argv, fallback, NULL, 0);
}

/*
 * function for initializing and popping up of the windows
 */
void init_widgets()
{
    shell_widget[W_PSF] = XtCreatePopupShell("PSF",
	topLevelShellWidgetClass, shell_widget[W_MAIN],
	shell_psf, XtNumber(shell_psf));

    shell_widget[W_CHOOSE] = XtCreatePopupShell("CHOOSE",
	topLevelShellWidgetClass, shell_widget[W_MAIN],
	shell_choose, XtNumber(shell_choose));

    shell_widget[W_FUNCTION] = XtCreatePopupShell("FUNCTION",
	topLevelShellWidgetClass, shell_widget[W_MAIN],
	shell_function, XtNumber(shell_function));

    shell_widget[W_MESSAGE] = XtCreatePopupShell("MESSAGE",
	topLevelShellWidgetClass, shell_widget[W_MAIN],
	shell_message, XtNumber(shell_message));

    shell_widget[W_TRACE] = XtCreatePopupShell("TRACE",
	topLevelShellWidgetClass, shell_widget[W_MAIN],
	shell_trace, XtNumber(shell_trace));

    init_psf_widget(shell_widget[W_PSF]);
    init_choose_widget(shell_widget[W_CHOOSE]);
    init_function_widget(shell_widget[W_FUNCTION]);
    init_message_widget(shell_widget[W_MESSAGE]);
    init_trace_widget(shell_widget[W_TRACE]);

    XtPopup(shell_widget[W_PSF], XtGrabNone);
    XtPopup(shell_widget[W_FUNCTION], XtGrabNone);
    XtPopup(shell_widget[W_MESSAGE], XtGrabNone);
    XtPopup(shell_widget[W_TRACE], XtGrabNone);
    init_cursor();

    set_psfwindow_name();

    init_input_term(shell_widget[W_MAIN]);
    set_parent_shell_procvar(shell_widget[W_MAIN]);
}

/*
 * terminate the main application
 */
void end_widgets()
{
    end_psf_widget();

    XtDestroyWidget(shell_widget[W_MAIN]);
    exit(0);
}

static int choose_popped = 0;
static int choose_wait = 0;

void popdown_choose_widget()
{
    if (choose_popped) {
	if (choose_wait) {
	    unset_wait_cursor(1, 0);
	}
	XtPopdown(shell_widget[W_CHOOSE]);
	choose_popped = 0;
    }
}

void popup_choose_widget()
{
    if (!choose_popped) {
	XtPopup(shell_widget[W_CHOOSE], XtGrabNone);
	choose_popped = 1;
	if (choose_wait)
	    set_wait_cursor(1, 0);
	else
	    unset_wait_cursor(1, 0);
    }
}

int choosewidget_popped_up()
{
    return(choose_popped);
}

static int psf_popped = 1;	/* yes, it starts popped up */

void popdown_psf_widget()
{
    if (psf_popped) {
	XtPopdown(shell_widget[W_PSF]);
	end_psf_widget();
	psf_popped = 0;
	XtDestroyWidget(shell_widget[W_PSF]);
    }
}

void popup_psf_widget()
{
    if (!psf_popped) {
	shell_widget[W_PSF] = XtCreatePopupShell("PSF",
	    topLevelShellWidgetClass, shell_widget[W_MAIN], shell_psf,
	    XtNumber(shell_psf));
	init_psf_widget(shell_widget[W_PSF]);
	XtPopup(shell_widget[W_PSF], XtGrabNone);
	set_psfwindow_name();
	psf_popped = 1;
    }
}

void synchronize()
{
    XSync(XtDisplay(shell_widget[W_MAIN]), False);
}

static Display *Mdisp;
static Pixmap wait;
static Pixmap wait_mask;
XColor fg, bg;

static Cursor wait_cursor;

void init_cursor()
{
    Mdisp = XtDisplay(shell_widget[W_MAIN]);
    wait = XCreateBitmapFromData(Mdisp,
	RootWindowOfScreen(XtScreen(shell_widget[W_MAIN])),
	(char *) wait_bits, wait_width, wait_height);
    wait_mask = XCreateBitmapFromData(Mdisp,
	RootWindowOfScreen(XtScreen(shell_widget[W_MAIN])),
	(char *) wait_mask_bits, wait_mask_width, wait_mask_height);
    /*
     * wait_cursor = XCreateFontCursor (Mdisp, XC_watch);
     */
    bg.pixel = 0;
    bg.red = 0;
    bg.green = 0;
    bg.blue = 0;
    fg.pixel = 1;
    fg.red = 65535;
    fg.green = 65535;
    fg.blue = 65535;
    fg.flags = bg.flags = DoRed | DoGreen | DoBlue;
    wait_cursor = XCreatePixmapCursor(Mdisp, wait, wait_mask, &bg, &fg, 8, 8);
}

void set_wait_cursor(c, f)
    int c;
    int f;
{
    if (f)
	XDefineCursor(Mdisp, XtWindow(shell_widget[W_FUNCTION]),
	    wait_cursor);
    if (c) {
	choose_wait = 1;
	if (!choose_popped)
	    return;
	XDefineCursor(Mdisp, XtWindow(shell_widget[W_CHOOSE]),
	    wait_cursor);
    }
}

void unset_wait_cursor(c, f)
    int c;
    int f;
{
    if (f)
	XUndefineCursor(Mdisp, XtWindow(shell_widget[W_FUNCTION]));
    if (c) {
	choose_wait = 0;
	if (!choose_popped)
	    return;
	XUndefineCursor(Mdisp, XtWindow(shell_widget[W_CHOOSE]));
    }
}

void get_pointer(rx, ry)
    int *rx, *ry;
{
    Window rw, cw;
    int cx, cy;
    unsigned int mask;

    XQueryPointer(XtDisplay(shell_widget[W_MAIN]),
	XtWindow(shell_widget[W_FUNCTION]), &rw, &cw, rx, ry,
	&cx, &cy, &mask);
}

static int tin_popped = 0;
void popup_tin()
{
    if (tin_popped)
	return;
    shell_widget[W_TIN] = XtCreatePopupShell("TRACE FROM STDIN",
	topLevelShellWidgetClass, shell_widget[W_MAIN],
	shell_tin, XtNumber(shell_tin));
    init_tin_widget(shell_widget[W_TIN]);
    XtPopup(shell_widget[W_TIN], XtGrabNone);
    tin_popped = 1;

    /* only these widgets may be used */
    XtAddGrab(shell_widget[W_MESSAGE], False, False);
    XtAddGrab(shell_widget[W_TRACE], False, False);
    XtAddGrab(shell_widget[W_FUNCTION], False, False);
    XtAddGrab(shell_widget[W_TIN], False, False);
    XtAddGrab(shell_widget[W_PSF], False, False);
    deactivate_functions();
    deactivate_choose();
}

void popdown_tin()
{
    if (tin_popped == 0)
	return;
    /*
     * All widgets may be used, up to MESSAGE is deleted from the modal
     * cascade.
     */
    XtRemoveGrab(shell_widget[W_MESSAGE]);
    activate_functions();
    activate_choose();

    XtPopdown(shell_widget[W_TIN]);
    XtDestroyWidget(shell_widget[W_TIN]);
    tin_popped = 0;
    set_tin_continuous(0);
    s_tin_cont();
}
