#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/AsciiText.h>
#include "psf_stdarg.h"
#include "tracewid.h"

#define TRACE_BUFFER_LEN        10240
static char trace_buffer[TRACE_BUFFER_LEN];
static Arg trace_args[] = {
    {XtNallowHoriz, (XtArgVal) True},
    {XtNforceBars, (XtArgVal) True},
    /* R4 */
    {XtNeditType, (XtArgVal) XawtextAppend},
    {XtNlength, (XtArgVal) TRACE_BUFFER_LEN},
    {XtNstring, (XtArgVal) trace_buffer},
    /*
     * R4 {XtNtextOptions,        (XtArgVal) (scrollVertical | wordBreak)},
     */
    {XtNscrollVertical, (XtArgVal) XawtextScrollAlways},
    {XtNwrap, (XtArgVal) XawtextWrapWord},
};

static Widget trace_widget;

void init_trace_widget(shell)
    Widget shell;
{
    trace_widget = XtCreateManagedWidget("trace",
    /* R4 */
					 asciiTextWidgetClass, shell,
					 trace_args, XtNumber(trace_args));
    init_trace_display();
}

/* R4 */
static XawTextBlock textblock;
static XawTextPosition textpos;

static char trace_display_buf[10240];

void init_trace_display()
{
    textblock.firstPos = 0;
    textblock.format = FMT8BIT;
    textblock.ptr = trace_display_buf;

    /* R4 */
    textpos = XawTextTopPosition(trace_widget);
}

void DECL_VARARGS_FUNC(trace_display, char *, fmt)
{
    va_list args;

    VARARGS_start(args, fmt);
    vsprintf(trace_display_buf, fmt, args);
    va_end(args);
    textblock.length = strlen(trace_display_buf);
    /* R4 */
    XawTextReplace(trace_widget, textpos, textpos, &textblock);
    textpos += textblock.length;
    XawTextSetInsertionPoint(trace_widget, textpos);
}

void reset_trace_display()
{
    trace_display_buf[0] = '\0';
    textblock.length = 0;
    XawTextReplace(trace_widget, 0, textpos, &textblock);
    textpos = 0;
    XawTextSetInsertionPoint(trace_widget, textpos);
}

void trace_to_file()
{
    Widget w;

    w = XawTextGetSource(trace_widget);
    (void) XawAsciiSaveAsFile(w, "sim.trace");
}
