#include <stdio.h>
#include <setjmp.h>
#include "psf_prototype.h"
#include "tiltype.h"
#include "tilutil.h"
#include "readtil.h"
#include "messagewid.h"
#include "functionwid.h"
#include "choosewid.h"
#include "tinwid.h"
#include "statecontrol.h"
#include "simoption.h"
#include "psf_fopen.h"
#include "env_variables.h"
#include "psf_malloc.h"
#include "readtiltype.h"
#include "widgets.h"
#include "inputterm.h"
#include "historywid.h"
#include "history.h"
#include "heads.h"
#include "process.h"

static char *fun[] = {
    "file",
    "start",
    "reset",
    "sum",
    "undo",
    "redo",
    "mark",
    "goto",
    "save"
};

#define MAXFUN	(sizeof(fun)/sizeof(fun[0]))

static int get_fun_type(s)
    char *s;
{
    int i;

    for (i = 0; i < MAXFUN; i++) {
	if (!strcmp(s, fun[i]))
	    return (i);
    }
    return (-1);
}

static int read_file(s)
    char *s;
{
    struct module *mod;
    int r;
    psf_file pf;
    static suffix suffixes[] = {{TILSUFFIX, TILSUFFIX_DEFAULT}, {NULL, NULL}}
    ;

    mod = get_new_til_module(s);
    pf = psf_fopen(s, suffixes);
    filename = pf.name;
    r = read_module(mod, pf.fp);
    fclose(pf.fp);
    if (r) {
	message_display("Error in file %s\n", s);
	return (1);
    }
    return (0);
}

jmp_buf til_jenv;

static int read_expr(expr)
    struct process_expr *expr;
{
    if (setjmp(til_jenv)) {
	return (1);
    }
    read_process_expr(expr);
    return (0);
}

static int read_aet(aet)
    struct ae_term *aet;
{
    if (setjmp(til_jenv)) {
	return (1);
    }
    read_ae_term(aet);
    return (0);
}

static void pause()
{
    set_tin_pause();
    execute_events();
    while (get_tin_pause()) {
	execute_events();
	if (tin_cont_pressed())
	    return;
    }
}

static int state = 0;

static int nr_repl;
struct replace {
    int key;
    struct ae_term *aet;
};
static struct replace *repl;

int do_trace()
{
    int c;
    char buf[256];
    unsigned int choice;
    int hide;
    struct process_expr expr;
    struct ae_term aet;
    int tc;
    int i;
    int dummy;

    tc = tin_continuous();
    s_tin_cont();
    if (tin_continuous()) {
	if (! tc) {
	    popdown_choose_widget();
	}
    } else {
	if (tc) {
	    change_choose_list();
	    popup_choose_widget();
	}
    }
    set_input_file(stdin);
    while ((c = getc(stdin)) != EOF) {
	if (c == '>') {
	    dummy = fscanf(stdin, "%[^ \t\n]s ", buf);
	    switch (get_fun_type(buf)) {
	    case -1:
		message_display("Unknown > function: %s\n", buf);
		return (1);
	    case 0:		/* file */
		dummy = fscanf(stdin, " %[^\n]s", buf);
		message_display("Reading TIL-file: %s\n", buf);
		if (read_file(buf)) {
		    return (1);
		}
		set_tracetilfile(filename);
		force_state(STATE_SPECIAL_SPEC);
		dummy = fscanf(stdin, " ");
		pause();
		state = 1;
		return (0);
	    case 1:		/* start */
		if (state != 1) {
		    message_display("start may only follow file or reset\n");
		    return (1);
		}
		if (fscanf(stdin, " %u ", &choice) != 1) {
		    message_display("Error in choice\n");
		    return (1);
		}
		message_display("Start: %u\n", choice);
		if (read_expr(&expr)) {
		    message_display("Error in term\n");
		    return (1);
		}
		dummy = fscanf(stdin, " %d ", &nr_repl);
		repl = PSF_NMALLOC(struct replace, nr_repl);
		for (i = 0; i < nr_repl; i ++) {
		    dummy = fscanf(stdin, " %d ", &repl[i].key);
		    repl[i].aet = PSF_MALLOC(struct ae_term);
		    if (read_aet(repl[i].aet)) {
			message_display("Error in term for replacement\n");
			return (1);
		    }
		}
		set_item_to_choose(choice);
		set_chosen_item();
		force_state(STATE_CHOOSE_START);
		dummy = fscanf(stdin, " ");
		pause();
		state = 2;
		return (0);
	    case 2:		/* reset */
		if (state == 0) {
		    message_display("no file to reset\n");
		    return (1);
		}
		message_display("Reset\n");
		pause();
		do_reset();
		dummy = fscanf(stdin, " ");
		state = 1;
		return (0);
	    case 3:		/* sum */
		if (state != 2) {
		    message_display("no start seen\n");
		    return (1);
		}
		if (fscanf(stdin, " %u ", &choice) != 1) {
		    message_display("Error in choice of sum\n");
		    return (1);
		}
		if (read_aet(&aet)) {
		    message_display("Error in term for sum\n");
		    return (1);
		}
		message_display("choice: %u (sum)\n", choice);
		set_item_to_choose(choice);
		set_chosen_item();
		force_state(STATE_CHOOSE);
		dummy = fscanf(stdin, " ");
		pause();
		if (Option_Tracein == 0)
		    return (0);
		control_input_term(choice, &aet);
		force_state(STATE_INPUT);
		pause();
		if (Option_Tracein == 0)
		    return (0);
		control_check_term();
		MakeHeadList(get_process_table());
		change_choose_list();
		force_state(STATE_TRACEIN);
		return (0);
	    case 4:		/* undo */
		message_display("Undo\n");
		unset_item_to_choose();
		pause();
		do_undo();
		dummy = fscanf(stdin, " ");
		return(0);
	    case 5:		/* redo */
		message_display("Redo\n");
		unset_item_to_choose();
		pause();
		do_redo();
		dummy = fscanf(stdin, " ");
		return(0);
	    case 6:		/* mark */
		dummy = fscanf(stdin, " %[^\n]s", buf);
		message_display("Mark %s\n", buf);
		unset_item_to_choose();
		pause();
		do_mark(buf);
		dummy = fscanf(stdin, " ");
		return(0);
	    case 7:		/* goto */
		dummy = fscanf(stdin, " %u %[^\n]s", &choice, buf);
		message_display("Goto %s\n", buf);
		unset_item_to_choose();
		pause();
		do_goto(choice, buf);
		if (tin_continuous())
		    /*
		     * History doesn't do a save after a move.
		     * Trace from stdin only does saves when they are on stdin.
		     * So, we must unset this.
		     */
		    unset_history_move();
		dummy = fscanf(stdin, " ");
		return(0);
	    case 8:		/* save */
		if (history_save())
		    if (trace_to_stdout()) {
			printf(">save\n");
			fflush(stdout);
		    }
		dummy = fscanf(stdin, " ");
		return(0);
	    }
	} else {
	    ungetc(c, stdin);
	    if (state != 2) {
		message_display("no start seen\n");
		return (1);
	    }
	    if (fscanf(stdin, "%u %d ", &choice, &hide) != 2) {
		message_display("Error in choice or hide-flag\n");
		return (1);
	    }
	    message_display("choice: %u hide: %d\n", choice, hide);
	    if (read_expr(&expr)) {
		message_display("Error in term\n");
		return (1);
	    }
	    if (expr.fun == SKP)
		dummy = fscanf(stdin, "<%u> ", &expr.proc_expr.nr);
	    if (tin_continuous())
		force_chosen_item(choice);
	    else {
		set_item_to_choose(choice);
		set_chosen_item();
	    }
	    force_state(STATE_CHOOSE);
	    dummy = fscanf(stdin, " ");
	    pause();
	    return (0);
	}
    }
    message_display("End of input\n");
    popdown_tin();		/* only necessary when running continuously */
    set_tin_continuous(0);
    s_tin_cont();
    return (1);
}

struct ae_term *get_tracein_repl(key)
int key;
{
    int i;

    for (i = 0; i < nr_repl; i ++) {
	if (repl[i].key == key)
	    return(repl[i].aet);
    }
    return(NULL);
}

void pause_tracein()
{
    pause();
}
