#include <stdio.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/BoxP.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Toggle.h>
#include <X11/extensions/shape.h>
#include "psf_prototype.h"
#include "widgets.h"
#include "statecontrol.h"
#include "simoption.h"
#include "xutil.h"

static int pause = 0;
static int continuously = 0;
static int s_cont = 0;

static Widget tin_pause;
static Widget tin_cont;
static Widget tin_quit;
static Widget tin_box;

void set_tin_pause()
{
    if (s_cont) {
	pause = 0;
	return;
    }
    pause = 1;
}

int get_tin_pause()
{
    return (pause);
}

static void end_pause(w, client_data, call_data)
    Widget w;
    caddr_t client_data;
    caddr_t call_data;
{
    pause = 0;
}

static XtCallbackRec pause_callbacks[] = {
    {(XtCallbackProc) end_pause, NULL},
    {(XtCallbackProc) NULL, NULL},
};

static Arg pause_args[] = {
    {XtNcallback, (XtArgVal) pause_callbacks},
    {XtNsensitive, (XtArgVal) True},
    {XtNhighlightThickness, (XtArgVal) 3},
};

static void cont(w, client_data, call_data)
    Widget w;
    caddr_t client_data;
    caddr_t call_data;
{
    if (continuously) {
	continuously = 0;
    } else {
	pause = 0;
	continuously = 1;
    }
}

static XtCallbackRec cont_callbacks[] = {
    {(XtCallbackProc) cont, NULL},
    {(XtCallbackProc) NULL, NULL},
};

static Arg cont_args[] = {
    {XtNcallback, (XtArgVal) cont_callbacks},
    {XtNsensitive, (XtArgVal) True},
    {XtNhighlightThickness, (XtArgVal) 3},
};

static void quit(w, client_data, call_data)
    Widget w;
    caddr_t client_data;
    caddr_t call_data;
{
    pause = 0;
    continuously = 0;
    s_cont = 0;
    popdown_tin();
    force_state(STATE_END_TRACEIN);
    Option_Tracein = 0;
}

static XtCallbackRec quit_callbacks[] = {
    {(XtCallbackProc) quit, NULL},
    {(XtCallbackProc) NULL, NULL},
};

static Arg quit_args[] = {
    {XtNcallback, (XtArgVal) quit_callbacks},
    {XtNsensitive, (XtArgVal) True},
    {XtNhighlightThickness, (XtArgVal) 3},
};

static Arg box_args[] = {
    {XtNhSpace, (XtArgVal) 2},
    {XtNvSpace, (XtArgVal) 2},
    {XtNorientation, (XtArgVal) XtorientVertical},
};

void init_tin_widget(shell)
    Widget shell;
{
    Dimension w, mw;
    BoxWidget BW;
    int i;

    tin_box = XtCreateManagedWidget("tin", boxWidgetClass, shell,
				    box_args, XtNumber(box_args));
    tin_pause = XtCreateManagedWidget("Next step", commandWidgetClass,
				   tin_box, pause_args, XtNumber(pause_args));
    tin_cont = XtCreateManagedWidget("Stepping", toggleWidgetClass,
				     tin_box, cont_args, XtNumber(cont_args));
    tin_quit = XtCreateManagedWidget("Quit", commandWidgetClass,
				     tin_box, quit_args, XtNumber(quit_args));
    /*
     * Make the buttons have the same width.
     */
    mw = 0;
    BW = (BoxWidget) tin_box;
    for (i = 0; i < BW->composite.num_children; i ++) {
	w = get_width(BW->composite.children[i]);
	if (w > mw)
	    mw = w;
    }
    for (i = 0; i < BW->composite.num_children; i ++) {
	set_width(BW->composite.children[i], mw);
    }
}

int tin_continuous()
{
    return (s_cont);
}

void s_tin_cont()
{
    s_cont = continuously;
}

void set_tin_continuous(onoff)
int onoff;
{
    continuously = onoff;
}

int tin_cont_pressed()
{
    return (!s_cont && continuously);
}
