#include <stdio.h>
#include <string.h>
#include <sys/wait.h>
#include <unistd.h> /* for unlink */
#include "psf_prototype.h"
#include "tiltype.h"
#include "readtil.h"
#include "prtilparts.h"
#include "prtilpsf.h"
#include "writetil.h"
#include "fieldex.h"
#include "tilutil.h"
#include "psf_fopen.h"
#include "env_variables.h"
#include "psf_malloc.h"

static char *mybasename PROTO_ARGS((char *));

struct module *mod = NULL;
extern char *filename;

int read_til_spec(input)
    char *input;
{
    psf_file pf;
    static suffix suffixes[] = {{TILSUFFIX, TILSUFFIX_DEFAULT}, {NULL, NULL}};

    mod = PSF_MALLOC(struct module);
    pf = psf_fopen(input, suffixes);
    filename = pf.name;
    mod->name = mybasename(input);
    if (read_module(mod, pf.fp)) {
	fclose(pf.fp);
	return (2);
    }
    fclose(pf.fp);
    return (0);
}

static char psf_tmp_name[] = "/tmp/SIMXXXXXX";
static char tmpname[16];

void make_psfwid_file()
{
    FILE *fp;

    fp = fopen(tmpname, "w");
    Option_skipnr = 1;
    print_module(mod, fp);
    fclose(fp);
}


char *make_psf_spec()
{
    if (mod == NULL)
	return (NULL);
    (void) strcpy(tmpname, psf_tmp_name);
    (void) mktemp(tmpname);
    make_psfwid_file();
    return (tmpname);
}

void make_code_file(filename, language)
char **filename;
char **language;
{
    char *l;
    int i;
    char *ln;
    char tilfile[16];
    FILE *fp;
    char *s;
    char *psfbindir;
    int status;
    FILE *dummy;

    /* Get langauge */
    ln = "psf"; /* default */
    for (i = 1; i <= mod->entries_table[ADM]; i ++) {
	if ((l = get_ff_field("language", mod->adm[i].ff)) != NULL) {
	    ln = l;
	    break;
	}
    }
    /* Write TIL-code to temporary file */
    (void) strcpy(tilfile, psf_tmp_name);
    (void) mktemp(tilfile);
    fp = fopen(tilfile, "w");
    write_module(mod, fp);
    fclose(fp);

    /* Make file on /tmp for output */
    (void) strcpy(tmpname, psf_tmp_name);
    (void) mktemp(tmpname);

    /* Fork of and call til_<ln> and wait for finish */
    switch(fork()) {
    case -1:
	fprintf(stderr, "starting process for execution of til_%s failed\n", ln);
	exit(1);
	break;
    case 0:
	dummy = freopen(tmpname, "w", stdout);
	if ((psfbindir = getenv("PSFBINDIR")) == NULL)
	    psfbindir = DEFPSFBINDIR;
	s = PSF_NMALLOC(char, strlen(psfbindir) + strlen(ln) + 6);
	(void) strcpy(s, psfbindir);
	(void) strcat(s, "/til_");
	(void) strcat(s, ln);
	(void) execl(s, s, tilfile, (char *) 0);
	fprintf(stderr, "execution of %s failed\n", s);
	exit(1);
	break;
    default:
	wait(&status);
	if (WIFEXITED(status)) {
	    break;
	} else {
	    fprintf(stderr, "execution of til_%s stopped by a signal\n", ln);
	    exit(1);
	}
	break;
    }

    /* Remove TIL-code file */
    unlink(tilfile);

    /* Set return values */
    *filename = tmpname;
    *language = psf_strdup(ln);
}

static char *mybasename(s)
    char *s;
{
    char *p, *q, *r;
    int n;

    n = strlen(s);
    p = &s[n];
    while (*p != '/' && p != s)
	p--;
    if (*p == '/')
	p++;
    n = strlen(p);
    q = &p[n];
    while (*q != '.' && q != p)
	q--;
    if (q != p)
	*q = '\0';
    r = psf_strdup(p);
    if (q != p)
	*q = '.';
    return (r);
}

struct module *get_til_module()
{
    return (mod);
}

static struct module *new_mod;

struct module *get_new_til_module(name)
    char *name;
{
    new_mod = PSF_MALLOC(struct module);
    new_mod->name = mybasename(name);
    return (new_mod);
}

void change_til_module()
{
    mod = new_mod;
}
