#include <stdio.h>
#include <stdlib.h>
#include <X11/Intrinsic.h>
#include "psf_prototype.h"
#include "tiltype.h"
#include "tilutil.h"
#include "simutil.h"
#include "freetil.h"
#include "process.h"
#include "widgets.h"
#include "choosewid.h"
#include "functionwid.h"
#include "simulate.h"
#include "messagewid.h"
#include "tracewid.h"
#include "statecontrol.h"
#include "simoption.h"
#include "tracein.h"
#include "procvar.h"
#include "sumport.h"
#include "headtail.h"
#include "history.h"
#include "inputterm.h"
#include "parsetermutil.h"
#include "tinwid.h"
#include "tbinterface.h"
#include "heads.h"

static int state = STATE_INIT;
static int state_forced = -1;

int start_process = -1;

static long int check_events()
{
    return (XtAppPending(app_context));
}

static void init_per_spec()
{
    init_head_tail();
    init_parse_util(get_til_module());
    init_inputterm_history();
    init_procvar_history();
    init_sumport();
}

static void keep_history()
{
    if (Option_History) {
	if (!Option_Tracein) {
	    if (history_save())
		if (trace_to_stdout()) {
		    printf(">save\n");
		    fflush(stdout);
		}
	}
    }
}

static void wait_for_event()
{
    XEvent event;

    XtAppNextEvent(app_context, &event);
    XtDispatchEvent(&event);
}

void state_control()
{
    int old_state = -1;
    int random_sim = -1;	/* lint complained over  used before set */
    int break_type;
    int had_break = 0;
    int last_init;
    int suminlist = 0;
    int i;
    struct module *mod;
    struct ae_term *aet;

    execute_events();

    init_per_spec();

    while (1) {

#ifdef	DEBUG
	if (old_state != state)
	    fprintf(stderr, "state = %d\n", state);
#endif

	switch (state) {
	case STATE_INIT:	/* 0 */
	    /* initialize for simulation */
	    if (make_start_process_list() == 0) {
		/* we have no start processes */
		if (Option_Tracein) {
		    state = STATE_TRACEIN;
		    last_init = STATE_CHOOSE_START;
		} else {
		    state = STATE_NOTHING;
		    message_display("No start processes\n");
		}
		break;
	    }
	    unmanage_random_choose();
	    if (!tin_continuous() && !tin_cont_pressed() && (start_process == -1)) {
		popup_choose_widget();
	    }
	    old_state = state;
	    if (Option_Tracein) {
		state = STATE_TRACEIN;
		last_init = STATE_CHOOSE_START;
	    } else
		state = STATE_CHOOSE_START;
	    break;
	case STATE_CHOOSE_START:	/* 1 */
	    /* choose start proces */
	    if (Option_ToolBus && !tb_control())
		activate_special_quit();
	    if (item_is_chosen()) {
		if (Option_ToolBus && !tb_control())
		    deactivate_special_quit();
		mod = get_til_module();
                i = get_chosen_item();
		start_process = i;
		set_item_to_choose(i);
		if ((aet = fill_in_vars(i, &mod->def[i + 1].ae_t)) == NULL) {
		    unset_item_to_choose();
		    break;
		}
		set_wait_cursor(1, 1);
		manage_random_choose();
		if (init_process_table(aet) == -1) {
		    state = STATE_DEADLOCK;
		    unset_wait_cursor(1, 1);
		} else
		    state = STATE_CHOOSE_INIT;
		last_init = state; /* for trace from stdin */
	    } else
		wait_for_event();
	    break;
	case STATE_SIMULATE:	/* 2 */
	    /* simulate, one step */
	    if (had_break) {
		break_type = 0;
		had_break = 0;
	    }
	    simulate(random_sim, break_type);
	    if (!nr_processes_in_table()) {
		state = STATE_END;
		unset_wait_cursor(1, 1);
	    } else
		state = STATE_CHOOSE_INIT;
	    break;
	case STATE_SETTINGS:	/* 3 */
	    /* break- and trace-point settings */
	    /* only on return */
	    state = STATE_SIMULATE;
	    break;
	case STATE_CHOOSE_INIT:/* 4 */
	    MakeHeadList(get_process_table());
	    if (length_choose_list() == 0) {
		state = STATE_DEADLOCK;
		change_choose_list();	/* otherwise we get a redisplay of the
					 * list when the list is corrupted */
		unset_wait_cursor(1, 1);
		break;
	    }
	    if (Option_ToolBus && !tb_control()) {
		state = STATE_TB;
		random_sim = 0;
		if (choosewidget_popped_up()) {
		    change_choose_list();
		    popdown_choose_widget();
		}
		break;
	    }
	    if (suminlist)
		activate_choose();
	    suminlist = HeadListSum();
	    if ((random_sim = (random_choose() & (!suminlist))) ||
		tin_continuous()) {
		if (break_type = get_breakpoint_type()) {
		    if (HeadListBreakOn(break_type)) {
			had_break = 1;
			trace_display("break>\n");
			set_random_choose(0);
			random_sim = 0;
			change_choose_list();
			popup_choose_widget();
			state = STATE_CHOOSE;
			break;
		    }
		}
		if (choosewidget_popped_up()) {
		    change_choose_list();
		    popdown_choose_widget();
		}
		state = STATE_SIMULATE;
		unset_wait_cursor(0, 1);
		if (Option_Tracein) {
		    state = STATE_TRACEIN;
		    last_init = STATE_CHOOSE;
		} else
		    state = STATE_CHOOSE;
	    } else {
		if (break_type = get_breakpoint_type()) {
		    if (HeadListBreakOn(break_type)) {
			had_break = 1;
			trace_display("break>\n");
		    }
		}
		if (suminlist)
		    deactivate_choose();
		keep_history();
		popup_choose_widget();
		change_choose_list();
		unset_wait_cursor(1, 1);
		if (Option_Tracein) {
		    state = STATE_TRACEIN;
		    last_init = STATE_CHOOSE;
		} else
		    state = STATE_CHOOSE;
	    }
	    break;
	case STATE_TB:
	    unset_wait_cursor(1,1);
	    execute_events();
		keep_history();
	    tb_choice(concat_choose_strings());
	    break;
	case STATE_CHOOSE:	/* 5 */
	    /* choose one of the possible actions */
	    if (old_state != state || HeadListSum()) {
		unset_wait_cursor(1, 1);
		old_state = state;
	    }
	    if (item_is_chosen() ||
		(random_sim |= (random_choose() |
		    random_choose_once()) &
		    (!HeadListSum())) || tin_continuous()) {
		/*
		 * popdown_choose_widget ();
		 */
		state = STATE_SIMULATE;
		if (! random_choose())
		    set_wait_cursor(1, 1);
	    } else
		wait_for_event();
	    break;
	case STATE_SPECIAL_SPEC:	/* 6 */
	    /* new specification */
	    popdown_choose_widget();
	    popdown_psf_widget();
	    popdown_modules();
	    execute_events();	/* for ReDisplay */
	    free_choose_list();
	    destroy_process_table();
	    DestroyHeadList();
	    history_reset();
	    free_simutil();
	    free_til_module(get_til_module());
	    if (!Option_Tracein) {
		reset_message_display();
		reset_trace_display();
		message_display("--- new specification ---\n");
		trace_display("--- new specification ---\n");
	    }
	    change_til_module();
	    init_simutil();
	    init_per_spec();
	    execute_events();
	    popup_psf_widget();
	    init_modules_list();
	    state = STATE_INIT;
	    break;
	case STATE_END:	/* 7 */
	    if (old_state != state) {
		unset_wait_cursor(1, 1);
		message_display("THE END\n");
		trace_display("THE END\n");
		popdown_choose_widget();
		old_state = state;
		DestroyHeadList(); /* otherwise it appears in status */
		keep_history();
		if (Option_ToolBus) {
		    tb_end();
		    deactivate_controltoanim();
		}
	    } else
		wait_for_event();
	    break;
	case STATE_RESET:	/* 8 */
	    /* RESET button is pressed */
	    set_wait_cursor(1, 1);
	    execute_events();
	    free_choose_list();
	    destroy_process_table();
	    DestroyHeadList();
	    history_reset();
	    state = STATE_INIT;
	    start_process = -1;
	    unset_wait_cursor(1, 1);
	    if (Option_ToolBus && tb_control()) {
		activate_tbcontrol();
	    }
	    /*
	     * print_count ();
	     */
	    break;
	case STATE_DEADLOCK:	/* 9 */
	    if (old_state != state) {
		message_display("DEADLOCK\n");
		trace_display("DEADLOCK\n");
		popdown_choose_widget();
		old_state = state;
		keep_history();
		if (Option_ToolBus) {
		    tb_deadlock();
		    deactivate_controltoanim();
		}
	    } else
		wait_for_event();
	    break;
	case STATE_HALT:
	    unset_wait_cursor(1, 1);
	    popdown_choose_widget();
	    if (old_state != state) {
		message_display("System halted.\n");
		old_state = state;
	    }
	    break;
	case STATE_NOTHING:
	    /* do nothing */
	    break;
	case STATE_TRACEIN:
	    popup_tin();
	    unset_wait_cursor(1, 1);
	    execute_events();
	    if (do_trace()) {
		Option_Tracein = 0;
		if (!nr_processes_in_table() &&
		    last_init != STATE_CHOOSE_START) {
		    state = STATE_END;
		} else {
		    state = last_init;
		    if (suminlist)
			deactivate_choose();
		    change_choose_list();
		    popup_choose_widget();
		}
	    }
	    break;
	case STATE_END_TRACEIN:
	    state = last_init;
	    Option_Tracein = 0;
	    if (state == STATE_CHOOSE_START ||
		    state == STATE_CHOOSE)
		unset_item_to_choose();
	    break;
	case STATE_INPUT:
	    break;
	default:
	    /*
	     * PANIC, I've lost the state, I where in. AH, I've found the exit
	     */
	    fprintf(stderr, "LOST CONTROL OF STATE\n");
	    exit(2);
	}
	if (check_events())
	    execute_events();
	if (state_forced != -1) {
	    state = state_forced;
	    state_forced = -1;
	}
    }
}

void execute_events()
{
    XEvent event;

    synchronize();

    while (XtAppPending(app_context)) {
	XtAppNextEvent(app_context, &event);
	XtDispatchEvent(&event);
    }
}

void force_state(ft)
    int ft;
{
    state_forced = ft;
}

int get_state()
{
    return(state);
}
