#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/Sme.h>
#include <X11/Xaw/SmeBSB.h>
#include "psf_prototype.h"
#include "tiltype.h"
#include "readtil.h"
#include "tilutil.h"
#include "statecontrol.h"
#include "tracewid.h"
#include "functionwid.h"
#include "messagewid.h"
#include "widgets.h"
#include "specialwid.h"
#include "psf_fopen.h"
#include "env_variables.h"
#include "dialogwid.h"
#include "tbinterface.h"

static void save_trace(w, client_data, call_data)
    Widget w;
    caddr_t client_data;
    caddr_t call_data;
{
    trace_to_file();
}

static XtCallbackRec save_trace_callbacks[] = {
    {(XtCallbackProc) save_trace, NULL},
    {(XtCallbackProc) NULL, NULL},
};

static Arg save_trace_args[] = {
    {XtNcallback, (XtArgVal) save_trace_callbacks},
};

static void load_spec(w, client_data, call_data)
    Widget w;
    XtPointer client_data;
    XtPointer call_data;
{
    popup_special_dialog();
}

static XtCallbackRec load_spec_callbacks[] = {
    {(XtCallbackProc) load_spec, NULL},
    {(XtCallbackProc) NULL, NULL},
};

static Arg load_spec_args[] = {
    {XtNcallback, (XtArgVal) load_spec_callbacks},
};

static void quit_sim(w, client_data, call_data)
    Widget w;
    XtPointer client_data;
    XtPointer call_data;
{
    if (Option_ToolBus) {
	tb_quit();
    }

    message_display("QUIT pressed\n");
    end_widgets();
}

static XtCallbackRec quit_sim_callbacks[] = {
    {(XtCallbackProc) quit_sim, NULL},
    {(XtCallbackProc) NULL, NULL},
};

static Arg quit_sim_args[] = {
    {XtNcallback, (XtArgVal) quit_sim_callbacks},
};

static Widget special_save_trace;
static Widget special_load_spec;
static Widget special_quit_sim;

static Widget menu;
static Arg menu_args[] = {
    {XtNmenuOnScreen, (XtArgVal) True},
};

void init_special_widget(shell)
    Widget shell;
{
    menu = XtCreatePopupShell("SPECIAL",
			      simpleMenuWidgetClass, shell,
			      menu_args, XtNumber(menu_args));
    special_save_trace = XtCreateManagedWidget("Save trace",
					       smeBSBObjectClass, menu,
				  save_trace_args, XtNumber(save_trace_args));
    special_load_spec = XtCreateManagedWidget("Load specification",
					      smeBSBObjectClass, menu,
				    load_spec_args, XtNumber(load_spec_args));
    special_quit_sim = XtCreateManagedWidget("Quit simulator",
					     smeBSBObjectClass, menu,
				      quit_sim_args, XtNumber(quit_sim_args));

    init_dialog_widget(shell);
}

static void ending_dialog(d_string)
    char *d_string;
{
    psf_file pf;
    static suffix suffixes[] = {{TILSUFFIX, TILSUFFIX_DEFAULT}, {NULL, NULL}};
    int c;
    struct module *new_mod;

    if (strlen(d_string) == 0) {
	change_dialog_label("error : empty string");
	return;
    }
    pf = psf_fopen(d_string, suffixes) ;
    if (0) {
	change_dialog_label("error : file is not readable"); }
    new_mod = get_new_til_module(d_string);
    filename = pf.name;
    c = read_module(new_mod, pf.fp);

    fclose(pf.fp);

    if (c) {
	change_dialog_label("error: incorrect TIL-code in file");
	return;
    }
    popdown_special_dialog();

    set_tracetilfile(filename);

    force_state(STATE_SPECIAL_SPEC);
}

void popup_special_dialog()
{
    int x, y;

    get_pointer(&x, &y);
    popup_dialog(x - 35, y - 78, "Filename :", get_til_file(), ending_dialog);
}

void popdown_special_dialog()
{
    popdown_dialog();
}

void deactivate_special()
{
    XtSetSensitive(special_load_spec, False);
}

void activate_special()
{
    XtSetSensitive(special_load_spec, True);
}

void deactivate_special_quit()
{
    XtSetSensitive(special_quit_sim, False);
}

void activate_special_quit()
{
    XtSetSensitive(special_quit_sim, True);
}
