#include <stdio.h>
#include "psf_prototype.h"
#include "tiltype.h"
#include "choosewid.h"
#include "functionwid.h"
#include "process.h"
#include "headtail.h"
#include "myrandom.h"
#include "simulate.h"
#include "writetil.h"
#include "inputterm.h"
#include "statecontrol.h"
#include "prio.h"
#include "sumport.h"
#include "simutil.h"
#include "tracewid.h"
#include "widgets.h"
#include "tbinterface.h"
#include "heads.h"

static unsigned int weight_tree(p, break_type)
    struct process *p;
    int break_type;
{
    struct process **c;
    int i;

    if (p->nr_children == 0) {
	if (p->flag & DEADLOCK || p->flag & DISABLED_PROCESS)
	    p->weight = 0;
	else if ((p->flag & PORT_PROCESS) && !(p->priority == MAX_PRIO))
	    p->weight = 0;
	else if ((p->encaps_flag != NULL) || p->priority < 0)
	    p->weight = p->com_flag & 1;

	/************ & really is
		if (break_type == 2) {
			if (p -> com_flag == 2)
				p -> weight = 0;
			else
				p -> weight = p -> com_flag;
		} else
			p -> weight = com_flag;
	************/

	else if (break_type == 2
		 && break_on(&p->h_t->head->proc_expr.pe2.ind))
	    p->weight = p->com_flag & 1;
	else
	    p->weight = 1;
    } else {
	c = p->child;
	p->weight = 0;
	for (i = 0; i < p->nr_children; i++, c++) {
	    if (*c == NULL)
		continue;
	    if (weight_tree(*c, break_type))
		p->weight++;
	}
    }
    return (p->weight);
}

static struct process *pick_process(p)
    struct process *p;
{
    struct process **c;
    unsigned int ran;

    if (p->nr_children == 0)
	return (p);
    ran = myrandom(p->weight);
    for (c = p->child;; c++) {
	if (*c == NULL)
	    continue;
	if ((*c)->weight == 0)
	    continue;
	if (ran == 0)
	    return (pick_process(*c));
	ran--;
    }
}

static void random_weight(pp, cp, break_type)
    struct process **pp;
    struct communication **cp;
    int break_type;
{
    struct process *p;
    unsigned int ran;
    struct communication *com, *h;
    unsigned int nr_com;
    int not_p;

    com = GetCommList();
    for (h = com; h != NULL; h = h->next) {
	if (h->encaps_flag != NULL || h->priority < 0) {
	    h->p_left->com_flag = 2;
	    h->p_right->com_flag = 2;
	    continue;
	}
	if (break_type == 2) {
	    if (break_on(&h->aet->ind)) {
		h->p_left->com_flag = 2;
		h->p_right->com_flag = 2;
		h->break_on = 1;
	    } else
		h->break_on = 0;
	}
    }
    p = get_process_table();
    (void) weight_tree(p, break_type);
    p = pick_process(p);
    for (nr_com = 0, h = com; h != NULL; h = h->next) {
	if (h->p_left == p || h->p_right == p) {
	    if ((h->encaps_flag != NULL) || h->priority < 0)
		continue;
	    /*
	     * if (! (break_type == 2 && break_on (& com -> aet -> ind)))
	     */
	    if (!(break_type == 2 && h->break_on))
		nr_com++;
	}
    }
    not_p = (p->encaps_flag != NULL) || p->priority < 0 ||
	(break_type == 2 && break_on(&p->h_t-> head->proc_expr.pe2.ind));
    if (not_p) {
	ran = myrandom(nr_com);
	ran++;
    } else
	ran = myrandom(nr_com + 1);
    if (ran == 0 && !not_p) {
	*pp = p;
	*cp = NULL;
    } else {
	*pp = NULL;
	while (ran) {
	    if (com->p_left == p || com->p_right == p) {
		if ((com->encaps_flag != NULL) || com->priority < 0) {
		    com = com->next;
		    continue;
		}
		/*
		 * if (! (break_type == 2 && break_on (& com -> aet -> ind)))
		 */
		if (!(break_type == 2 && com->break_on))
		    ran--;
	    }
	    if (ran)
		com = com->next;
	}
	*cp = com;
    }
}

static void break_2(pp, cp)
    struct process **pp;
    struct communication **cp;
{
    unsigned int ran;
    int nr_actions;

    nr_actions = GetNrHeadListNoBreak();
    ran = myrandom(nr_actions);
    GetChosenHeadNoBreak(ran, pp, cp);
}

static unsigned int choice;

static void chosen_action(pp, cp, random_sim, break_type)
    struct process **pp;
    struct communication **cp;
    int random_sim;
    int break_type;
{
    struct head *h;
    struct communication *com;
    unsigned int nr_item;

    if (random_sim) {
	if (get_random_type()) {
	    random_weight(pp, cp, break_type);
	    choice = GetHeadListNr(*pp, *cp);
	    return;
	} else if (break_type == 2) {
	    break_2(pp, cp);
	    choice = GetHeadListNr(*pp, *cp);
	    return;
	} else
	    nr_item = myrandom(length_choose_list());
    } else
	nr_item = get_chosen_item();

    choice = nr_item;

    GetChosenHead(nr_item, pp, cp);
}

static void do_action(p)
    struct process *p;
{
    if (Option_ToolBus) {
	tb_atom(p->h_t->string);
    }

    if (p->h_t->head->fun == SKP) {
	if (default_trace())
	    trace_display("            %s\n", p->h_t->string);
	if (trace_to_stdout()) {
	    printf("%u 0 <skip><%u>\n", choice, p->h_t->head->proc_expr.nr);
	    fflush(stdout);
	}
	return;
    }
    if (trace_to_stdout()) {
	printf("%u %d ", choice, p->hide_flag == NULL ? 0 : 1);
	write_ae_term(p->h_t->ae_t);
	printf("\n");
	fflush(stdout);
    }

    if (get_breakpoint_type() == 0 &&
	    break_on(&p->h_t->head->proc_expr.pe2.ind)) {
	trace_display("break> atom %s\n", p->h_t->string);
	set_random_choose(0);
    } else if (trace_on(&p->h_t->head->proc_expr.pe2.ind)) {
	trace_display("trace> atom %s\n", p->h_t->string);
    } else if (p->encaps_flag != NULL)
	return;
    else if (default_trace())
	trace_display("       atom %s\n", p->h_t->string);
}

static void do_communication(com)
    struct communication *com;
{
    if (trace_to_stdout()) {
	printf("%u %d ", choice, com->hide_flag == NULL ? 0 : 1);
	write_ae_term(com->aet);
	printf("\n");
	fflush(stdout);
    }
    if (get_breakpoint_type() == 0 &&
	    break_on(&com->aet->ind)) {
	trace_display("break> com. %s\n", com->string);
	set_random_choose(0);
    } else if (trace_on(&com->aet->ind)) {
	trace_display("trace> com. %s\n", com->string);
    } else if (default_trace())
	trace_display("       com. %s\n", com->string);

    if (Option_ToolBus) {
	tb_atom(com->string);
    }
}

void simulate(random_sim, break_type)
    int random_sim;
    int break_type;
{
    struct process *p, *pl, *pr;
    struct communication *com;
    int ret_value;

    chosen_action(&p, &com, random_sim, break_type);
    if (p != NULL) {
	if (p->h_t->head->fun == SUM) {
	    set_item_to_choose(get_chosen_item());
	    unset_wait_cursor(1, 1);
	    popup_inputterm_sum(p);
	    force_state(STATE_INPUT);
	    return;
	}
	do_action(p);
	execute_events();
	p = remove_alternate_processes(p);
	if (p == NULL)
	    ret_value = 0;
	else
	    ret_value = next_head_tail(p);
    } else {
	do_communication(com);
	if (com->p_left->flag & PORT_PROCESS)
	    com->p_left = create_sumport(com->p_left, com->sub);
	else if (com->p_right->flag & PORT_PROCESS)
	    com->p_right = create_sumport(com->p_right, com->sub);
	execute_events();
	com->p_right->encaps_flag = com->p_right->hide_flag = NULL;
	com->p_left->encaps_flag = com->p_left->hide_flag = NULL;
	com->p_left->com_flag = com->p_right->com_flag = 0;
	pr = remove_alternate_processes(com->p_right);
	pl = remove_alternate_processes(com->p_left);
	if (pl == NULL)
	    ret_value = 0;
	else
	    ret_value = next_head_tail(pl);
	if (pr != NULL)
	    ret_value = next_head_tail(pr);
    }
    switch (ret_value) {
    case -1:			/* all processes have ended */

#ifdef	DEBUG
	fprintf(stderr, "NO MORE PROCESSES\n");
#endif

	break;
    case 0:			/* everything ok */
	break;
    case 1:			/* new processes are added */
	break;
    default:			/* not yet implemented functions */
	fprintf(stderr, "UNIMPLEMENTED FUNCTION\n");
	break;
    }
}
