#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/AsciiText.h>
#include <ctype.h>
#include <unistd.h> /* for unlink */
#include "psf_prototype.h"
#include "tilutil.h"
#include "psfwid.h"

#define PSF_Vfile      4
static Arg psf_args[] = {
    {XtNallowVert, (XtArgVal) True},
    {XtNforceBars, (XtArgVal) True},
    {XtNeditType, (XtArgVal) XawtextRead},
    {XtNtype, (XtArgVal) XawAsciiFile},
    {XtNstring, (XtArgVal) "SIMXXXXXX"},
    {XtNscrollVertical, (XtArgVal) XawtextScrollAlways},
    {XtNwrap, (XtArgVal) XawtextWrapWord},
};

static Widget psf_widget;

static int tabs[20] = {
    4, 8, 12, 16, 20, 24, 28, 32, 36, 40,
    44, 48, 52, 56, 60, 64, 68, 72, 78, 80
};

/* We like to know the length of the lines for pretty-printing
static void get_line_length()
{
    Arg arglist;
    Widget ts;
    Dimension w;
    XawTextPosition pos;
    int rw, rh;

    XtSetArg(arglist, XtNtextSink, &ts);
    XtGetValues(psf_widget, &arglist, 1);
    XtSetArg(arglist, XtNwidth, &w);
    XtGetValues(ts, &arglist, 1);
    fprintf(stderr, "%d\n", w);
    XawTextSinkFindPosition(ts, 69, 0, w, 0, &pos, &rw, &rh);
    fprintf(stderr, "%d %d %d\n", pos, rw, rh);
}
*/

static char *psfwindow_name;

static Widget psfshell;

void init_psf_widget(shell)
    Widget shell;
{
    Arg arglist;
    Widget w;
    char *inputfile;

    make_code_file(&inputfile, &psfwindow_name);
    psf_args[PSF_Vfile].value = (XtArgVal) inputfile;

    psfshell = shell; /* for set_psfwindow_name() */

    psf_widget = XtCreateManagedWidget("psf",
    /* R4 */
				       asciiTextWidgetClass, shell,
				       psf_args, XtNumber(psf_args));
    /*
     * Set tab to 4. Don't know if this will work in future versions of X.
     */
    XtSetArg(arglist, XtNtextSink, &w);
    XtGetValues(psf_widget, &arglist, 1);
    XawTextSinkSetTabs(w, 10, tabs);
/*
    execute_events();
    get_line_length();
*/
}

void set_psfwindow_name()
{
    char *c;

    for (c = psfwindow_name; *c != '\0'; c ++)
	*c = (char) toupper((int) *c);
    XStoreName(XtDisplay(psfshell), XtWindow(psfshell), psfwindow_name);
}

void end_psf_widget()
{
    XtDestroyWidget(psf_widget);
    unlink((char *) psf_args[PSF_Vfile].value);
}
