#include <stdio.h>
#include <string.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/ViewportP.h>
#include <X11/Xaw/Command.h>
#include "psf_prototype.h"
#include "tiltype.h"
#include "tilutil.h"
#include "fieldex.h"
#include "psf_malloc.h"
#include "msprint.h"
#include "eqm.h"
#include "headtail.h"
#include "functionwid.h"
#include "simoption.h"
#include "tracein.h"
#include "tinwid.h"
#include "xutil.h"
#include "inputterm.h"
#include "eqm_local.h"
#include "writetil.h"
#include "statecontrol.h"

/* We sure need a lot of widgets to do this. */
static Widget w_procvar;
static Widget w_box;
static Widget w_label;
static Widget w_lists;
static Widget w_varbox;
static Widget w_valuebox;
static Widget w_varlabel;
static Widget w_valuelabel;
static Widget w_varview;
static Widget w_valueview;
static Widget w_var;
static Widget w_value;
static Widget w_buttonbox;
static Widget w_confirm;
static Widget w_cancel;
static Widget w_history;
static Widget w_up;
static Widget w_down;

#define VAR_WIDTH 100
#define VALUE_WIDTH 300
#define LABEL_HEIGHT 24

static int size_list = 0;
static int max_size_list = 0;
struct var_data {
    int key;
    struct ae_term *aet;
    char *string;
};
static struct var_data *var_list;
static String *vars;
static String *values;

static int c_confirm;
static int c_cancel;

static void confirm(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
    int i;

    /*
     * Everything must be filled to confirm.
     */
    for (i = 0; i < size_list; i ++) {
	if (var_list[i].aet == NULL)
	    return;
    }
    c_confirm = 1;
}

static void cancel(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
    c_cancel = 1;
}

static void change_list()
{
    Dimension w, h;

    /*
     * Here it goes again. Resizing because a list change makes everything
     * smaller.
     */
    get_wh(w_valueview, &w, &h);
    XawListChange(w_value, values, size_list, 0, True);
    XtResizeWidget(w_valueview, w, h, 1);
    XtResizeWidget(w_valuebox, w+2, h+LABEL_HEIGHT+4, 0);
}

static int nr_done;

static void var_select(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
    XawListReturnStruct *item;
    int new;

    item = XawListShowCurrent(w_var);
    new = popup_inputterm_pro(var_list[item->list_index].key,
	&var_list[item->list_index].aet, &var_list[item->list_index].string);

    XawListUnhighlight(w_var);

    if (!new)
	return;

    if (values[item->list_index][0] == '\0') {
	nr_done ++;
	if (nr_done == size_list)
	    XtSetSensitive(w_confirm, True);
    }
    values[item->list_index] = var_list[item->list_index].string;

    change_list();
}

static void value_select(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
    XawListReturnStruct *item;

    /*
     * We give it to var_select, which is behind us in the callback list.
     */
    item = XawListShowCurrent(w_value);
    XawListUnhighlight(w_value);
    XawListHighlight(w_var, item->list_index);
}

/*
 * History package
 */
struct history_v {
    char * *value;
    struct ae_term * *aet;
    struct history_v * next;
    struct history_v * prev;
};
struct history_t {
    int nr_v;
    struct history_v * values;
    struct history_v * current;
    struct history_v * last;
};
static struct history_t * history = NULL;
static int nr_defs;
static int current;

static void end_procvar_history()
{
    int i, j;
    struct history_v *v1, *v2;

    for (i = 1; i <= nr_defs; i ++) {
	v1 = history[i].last;
	while (v1 != NULL) {
	    v2 = v1;
	    v1 = v2->prev;
	    for (j = 0; j < history[i].nr_v; j ++) {
		PSF_FREE(v2->value[i]);
		ae_term_free(v2->aet[i]);
	    }
	    PSF_FREE(v2->value);
	    PSF_FREE(v2->aet);
	    PSF_FREE(v2);
	}
    }
    PSF_FREE(history);
}

static int count_vars(aet)
struct ae_term *aet;
{
    int count;
    int i;

    count = 0;
    if (aet->ind.table == VAR)
	count ++;
    else
	for (i = 0; i < aet->a; i ++)
	    count += count_vars(&aet->ae_list[i]);
    return(count);
}

void init_procvar_history()
{
    struct module * mod;
    int i;

    if (history != NULL)
	end_procvar_history();

    mod = get_til_module();
    nr_defs = mod->entries_table[DEF];
    history = PSF_NMALLOC(struct history_t, nr_defs+1);
    for (i = 1; i <= nr_defs; i ++) {
	history[i].nr_v = count_vars(&mod->def[i].ae_t);
	history[i].values = NULL;
	history[i].last = NULL;
    }
}

static void new_history(nr_def)
int nr_def;
{
    struct history_v * new, * last;
    int i;

    current = nr_def;
    last = history[current].last;
    new = PSF_MALLOC(struct history_v);
    new->next = NULL;
    new->value = PSF_NMALLOC(char *, history[current].nr_v);
    new->aet = PSF_NMALLOC(struct ae_term *, history[current].nr_v);
    for (i = 0; i < history[current].nr_v; i ++) {
	new->value[i] = values[i];
	new->aet[i] = var_list[i].aet;
    }
    if (last == NULL) {
	history[current].values = new;
	history[current].last = new;
	new->prev = NULL;
    } else {
	last->next = new;
	new->prev = last;
	history[current].last = new;
    }
    history[current].current = new;

    if (new->prev != NULL)
	XtSetSensitive(w_up, True);
    else
	XtSetSensitive(w_up, False);
    XtSetSensitive(w_down, False);
}

static void record_history()
{
    struct history_v *h;
    int equal;
    int i;

    if (c_cancel) {
	h = history[current].last;
	history[current].last = h->prev;
	if (h->prev == NULL)
	    history[current].values = NULL;
	else
	    history[current].last->next = NULL;
	PSF_FREE(h->value);
	PSF_FREE(h->aet);
	PSF_FREE(h);
    } else {
	h = history[current].last;
	while ((h = h->prev) != NULL) {
	    equal = 1;
	    for (i = 0; i < history[current].nr_v; i ++) {
		if (cmp_ae_term(h->aet[i], var_list[i].aet)) {
		    equal = 0;
		    break;
		}
	    }
	    if (equal) {
		h->next->prev = h->prev;
		if (h->prev == NULL)
		    history[current].values = h->next;
		else
		    h->prev->next = h->next;
		for (i = 0; i < history[current].nr_v; i ++) {
		    if (h->value[i] != values[i])
			PSF_FREE(h->value[i]);
		    if (h->aet[i] != var_list[i].aet)
			ae_term_free(h->aet[i]);
		}
		PSF_FREE(h->value);
		PSF_FREE(h->aet);
		PSF_FREE(h);
		break;
	    }
	}
	h = history[current].last;
	for (i = 0; i < history[current].nr_v; i ++) {
	    h->value[i] = var_list[i].string;
	    h->aet[i] = var_list[i].aet;
	}
    }
}

static void up_term(w, client_data, call_data)
    Widget w;
    caddr_t client_data;
    caddr_t call_data;
{
    int i;

    if (history[current].current->prev != NULL) {
	if (history[current].current->next == NULL) {
	    XtSetSensitive(w_down, True);
	    XtSetSensitive(w_confirm, True);
	    /* save values */
	    for (i = 0; i < history[current].nr_v; i ++) {
		history[current].current->value[i] = values[i];
		history[current].current->aet[i] = var_list[i].aet;
	    }
	}

	history[current].current = history[current].current->prev;
	for (i = 0; i < history[current].nr_v; i ++) {
	    values[i] = history[current].current->value[i];
	    var_list[i].string = values[i];
	    var_list[i].aet = history[current].current->aet[i];
	}
	change_list();

	if (history[current].current->prev == NULL)
	    XtSetSensitive(w_up, False);
    }
}

static void down_term(w, client_data, call_data)
    Widget w;
    caddr_t client_data;
    caddr_t call_data;
{
    int i;

    if (history[current].current->next != NULL) {
	if (history[current].current->prev == NULL)
	    XtSetSensitive(w_up, True);

	history[current].current = history[current].current->next;
	for (i = 0; i < history[current].nr_v; i ++) {
	    values[i] = history[current].current->value[i];
	    var_list[i].string = values[i];
	    var_list[i].aet = history[current].current->aet[i];
	}
	change_list();

	if (history[current].current->next == NULL) {
	    XtSetSensitive(w_down, False);
	    for (i = 0; i < size_list; i ++) {
		if (var_list[i].aet == NULL) {
		    XtSetSensitive(w_confirm, False);
		    return;
		}
	    }
	}
    }
}
/*
 * end History package
 */

static Arg procvar_args[] = {
    {XtNx, (XtArgVal) 504},
    {XtNy, (XtArgVal) 368},
    {XtNtransient, (XtArgVal) True},
    {XtNheight, (XtArgVal) 0},
    {XtNwidth, (XtArgVal) 0},
};

static Arg box_args[] = {
    {XtNorientation, (XtArgVal) XtorientVertical},
};

#define LABEL_IDX 2
static Arg label_args[] = {
    {XtNresize, (XtArgVal) True},
    {XtNjustify, (XtArgVal) XtJustifyLeft},
    {XtNlabel, (XtArgVal) NULL},
};

static Arg lists_args[] = {
    {XtNborderWidth, (XtArgVal) 0},
    {XtNhSpace, (XtArgVal) 0},
    {XtNvSpace, (XtArgVal) 0},
    {XtNorientation, (XtArgVal) XtorientHorizontal},
};

static Arg varbox_args[] = {
    {XtNborderWidth, (XtArgVal) 0},
    {XtNhSpace, (XtArgVal) 0},
    {XtNvSpace, (XtArgVal) 0},
    {XtNorientation, (XtArgVal) XtorientVertical},
};

static Arg varlabel_args[] = {
    {XtNresize, (XtArgVal) False},
    {XtNjustify, (XtArgVal) XtJustifyCenter},
};

static Arg varview_args[] = {
    {XtNallowHoriz, (XtArgVal) True},
    {XtNforceBars, (XtArgVal) True},
    {XtNuseBottom, (XtArgVal) True},
};

static String var_dlist[] = {
    "ddddddddddddddddddddddddddd",
    "xxxxxx"
};

static XtCallbackRec varlist_callbacks[] = {
    {(XtCallbackProc) var_select, NULL},
    {(XtCallbackProc) NULL, NULL},
};

#define LIST_IDX 4
#define NUMBER_IDX 5
static Arg var_args[] = {
    {XtNwidth, (XtArgVal) VAR_WIDTH},
    {XtNdefaultColumns, (XtArgVal) 1},
    {XtNverticalList, (XtArgVal) True},
    {XtNforceColumns, (XtArgVal) True},
    {XtNlist, (XtArgVal) var_dlist},
    {XtNnumberStrings, (XtArgVal) 2},
    {XtNcallback, (XtArgVal) varlist_callbacks},
};

static Arg valuebox_args[] = {
    {XtNborderWidth, (XtArgVal) 0},
    {XtNhSpace, (XtArgVal) 0},
    {XtNvSpace, (XtArgVal) 0},
    {XtNorientation, (XtArgVal) XtorientVertical},
};

static Arg valuelabel_args[] = {
    {XtNresize, (XtArgVal) False},
    {XtNjustify, (XtArgVal) XtJustifyCenter},
    {XtNwidth, (XtArgVal) VALUE_WIDTH},
};

static Arg valueview_args[] = {
    {XtNallowHoriz, (XtArgVal) True},
    {XtNforceBars, (XtArgVal) True},
    {XtNuseBottom, (XtArgVal) True},
};

static String value_dlist[] = {
    "",
    "xxxxxx"
};

static XtCallbackRec valuelist_callbacks[] = {
    {(XtCallbackProc) value_select, NULL},
    {(XtCallbackProc) var_select, NULL},
    {(XtCallbackProc) NULL, NULL},
};

static Arg value_args[] = {
    {XtNdefaultColumns, (XtArgVal) 1},
    {XtNverticalList, (XtArgVal) True},
    {XtNforceColumns, (XtArgVal) True},
    {XtNlist, (XtArgVal) value_dlist},
    {XtNnumberStrings, (XtArgVal) 2},
    {XtNwidth, (XtArgVal) VALUE_WIDTH},
    {XtNcallback, (XtArgVal) valuelist_callbacks},
};

static Arg history_args[] = {
    {XtNborderWidth, (XtArgVal) 0},
    {XtNvSpace, (XtArgVal) 0},
    {XtNhSpace, (XtArgVal) 6},
    {XtNorientation, (XtArgVal) XtorientVertical},
};

#include "updblarr"
static XtCallbackRec up_callbacks[] = {
    {(XtCallbackProc) up_term, NULL},
    {(XtCallbackProc) NULL, NULL},
};
static Arg up_args[] = {
    {XtNbitmap, (XtArgVal) NULL},
    {XtNwidth, (XtArgVal) LABEL_HEIGHT},
    {XtNheight, (XtArgVal) LABEL_HEIGHT},
    {XtNinternalWidth, (XtArgVal) 2},
    {XtNcallback, (XtArgVal) up_callbacks},
};

#include "downdblarr"
static XtCallbackRec down_callbacks[] = {
    {(XtCallbackProc) down_term, NULL},
    {(XtCallbackProc) NULL, NULL},
};
static Arg down_args[] = {
    {XtNbitmap, (XtArgVal) NULL},
    {XtNwidth, (XtArgVal) LABEL_HEIGHT},
    {XtNheight, (XtArgVal) LABEL_HEIGHT},
    {XtNinternalWidth, (XtArgVal) 2},
    {XtNcallback, (XtArgVal) down_callbacks},
};

static Arg buttonbox_args[] = {
    {XtNborderWidth, (XtArgVal) 0},
    {XtNvSpace, (XtArgVal) 0},
    {XtNorientation, (XtArgVal) XtorientHorizontal},
};

static XtCallbackRec confirm_callbacks[] = {
    {(XtCallbackProc) confirm, NULL},
    {(XtCallbackProc) NULL, NULL},
};
static Arg confirm_args[] = {
    {XtNcallback, (XtArgVal) confirm_callbacks},
};

static XtCallbackRec cancel_callbacks[] = {
    {(XtCallbackProc) cancel, NULL},
    {(XtCallbackProc) NULL, NULL},
};
static Arg cancel_args[] = {
    {XtNcallback, (XtArgVal) cancel_callbacks},
};

static Widget Shell;
void set_parent_shell_procvar(shell)
Widget shell;
{
    Shell = shell;
}

static void init_procvar(shell)
Widget shell;
{
    Pixmap bm;
    Dimension w, h;

    w_procvar = XtCreatePopupShell("PROCESS VAR", topLevelShellWidgetClass,
	shell, procvar_args, XtNumber(procvar_args));
    w_box = XtCreateManagedWidget("box", boxWidgetClass, w_procvar,
	box_args, XtNumber(box_args));
    w_label = XtCreateManagedWidget("process name", labelWidgetClass, w_box,
	label_args, XtNumber(label_args));
    w_lists = XtCreateManagedWidget("lists", boxWidgetClass, w_box,
	lists_args, XtNumber(lists_args));
    w_varbox = XtCreateManagedWidget("variables", boxWidgetClass, w_lists,
	varbox_args, XtNumber(varbox_args));
    w_varlabel = XtCreateManagedWidget("Variables", labelWidgetClass, w_varbox,
	varlabel_args, XtNumber(varlabel_args));
    get_wh(w_varlabel, &w, &h);
    w_varview = XtCreateManagedWidget("view", viewportWidgetClass, w_varbox,
	varview_args, XtNumber(varview_args));
    XtSetArg(var_args[0], XtNwidth, (XtArgVal) w);
    w_var = XtCreateManagedWidget("list", listWidgetClass, w_varview,
	var_args, XtNumber(var_args));
    w_valuebox = XtCreateManagedWidget("values", boxWidgetClass, w_lists,
	valuebox_args, XtNumber(valuebox_args));
    w_valuelabel = XtCreateManagedWidget("Values", labelWidgetClass, w_valuebox,
	valuelabel_args, XtNumber(valuelabel_args));
    w_valueview = XtCreateManagedWidget("view", viewportWidgetClass, w_valuebox,
	valueview_args, XtNumber(valueview_args));
    w_value = XtCreateManagedWidget("list", listWidgetClass, w_valueview,
	value_args, XtNumber(value_args));
    w_history = XtCreateManagedWidget("history", boxWidgetClass, w_lists,
	history_args, XtNumber(history_args));
    bm = XCreateBitmapFromData(XtDisplay(shell),
	RootWindowOfScreen(XtScreen(shell)), (char *) updblarr_bits,
	updblarr_width, updblarr_height);
    XtSetArg(up_args[0], XtNbitmap, (XtArgVal) bm);
    XtSetArg(up_args[1], XtNwidth, (XtArgVal) h);
    XtSetArg(up_args[2], XtNheight, (XtArgVal) h);
    w_up = XtCreateManagedWidget("up", commandWidgetClass,
	w_history, up_args, XtNumber(up_args));
    bm = XCreateBitmapFromData(XtDisplay(shell),
	RootWindowOfScreen(XtScreen(shell)), (char *) downdblarr_bits,
	downdblarr_width, downdblarr_height);
    XtSetArg(down_args[0], XtNbitmap, (XtArgVal) bm);
    XtSetArg(down_args[1], XtNwidth, (XtArgVal) h);
    XtSetArg(down_args[2], XtNheight, (XtArgVal) h);
    w_down = XtCreateManagedWidget("down", commandWidgetClass,
	w_history, down_args, XtNumber(down_args));
    w_buttonbox = XtCreateManagedWidget("buttons", boxWidgetClass, w_box,
	buttonbox_args, XtNumber(buttonbox_args));
    w_confirm = XtCreateManagedWidget("Confirm", commandWidgetClass,
	w_buttonbox, confirm_args, XtNumber(confirm_args));
    w_cancel = XtCreateManagedWidget("Cancel", commandWidgetClass, w_buttonbox,
	cancel_args, XtNumber(cancel_args));
}

static void popup_procvar(grab)
XtGrabKind grab;
{
    Dimension w, h, hs;

    /*
     * The viewports put the scrollbar inside the geometry , instead of
     * outside, so we have to enlarge them.
     */
    get_wh(((ViewportWidget) w_varview)->viewport.horiz_bar, &w, &hs);
    get_wh(w_var, &w, &h);
    XtResizeWidget(w_varview, w, h+hs, 1);
    XtResizeWidget(w_valueview, VALUE_WIDTH, h+hs, 1);

    XtPopup(w_procvar, grab);
}

static void popdown_procvar()
{
    XtPopdown(w_procvar);
}

static void deactivate_buttons()
{
    XtSetSensitive(w_confirm, False);
    XtSetSensitive(w_cancel, False);
}

static void activate_buttons()
{
    XtSetSensitive(w_confirm, True);
    XtSetSensitive(w_cancel, True);
}

static void enlist_vars(aet)
struct ae_term *aet;
{
    int i;

    if (aet->ind.table == VAR) {
	for (i = 0; i < size_list; i++) {
	    if (var_list[i].key == aet->ind.key)
		return;    /* only one value for a variable */
	}
	if (size_list == max_size_list) {
	    if (size_list) {
		max_size_list *= 2;
		var_list = PSF_REALLOC(var_list, struct var_data,
		    max_size_list);
		vars = PSF_REALLOC(vars, String, max_size_list);
		values = PSF_REALLOC(values, String, max_size_list);
	    } else {
		max_size_list = 4;
		var_list = PSF_NMALLOC(struct var_data, max_size_list);
		vars = PSF_NMALLOC(String, max_size_list);
		values = PSF_NMALLOC(String, max_size_list);
	    }
	}
	var_list[size_list].key = aet->ind.key;
	var_list[size_list].aet = NULL;
	var_list[size_list].string = NULL;
	vars[size_list] = psf_strdup(field_extract("n", get_til_module()->var[
	    aet->ind.key].ff, VAR, aet->ind.key));
	values[size_list] = "";
	size_list ++;
    } else {
	for (i = 0; i < aet->a; i ++) {
	    enlist_vars(&aet->ae_list[i]);
	}
    }
}

static void destroy_vars()
{
    int i;

    for (i = 0; i < size_list; i ++) {
	PSF_FREE(vars[i]);
	if (var_list[i].string != NULL) {
    /*
	    PSF_FREE(var_list[i].string);
	    ae_term_free(var_list[i].aet);
    */
	    /* PSF_FREE(values[i]); points to var_list[i].string */
	}
    }
}

static char buf[256];

static void change_label(aet)
struct ae_term *aet;
{
    msprint_ae_term(aet);
    sprintf(buf, "%s", get_msp());
    XtSetArg(label_args[LABEL_IDX], XtNlabel, (XtArgVal) buf);
}

struct ae_term *fill_in_vars(nr, aet)
int nr;
struct ae_term *aet;
{
    struct ae_term *naet;
    subst_t *sub;
    eqm_t *eqm;
    struct indextype index;
    int i;

    /*
     * We create and destroy all widgets everytime, because of
     * resize-problems.
     */

    /* Make list of variables */
    size_list = 0;
    enlist_vars(aet);

    nr_done = 0;

    if (Option_Tracein) {
	for (i = 0; i < size_list; i ++) {
	    var_list[i].aet = get_tracein_repl(var_list[i].key);
	    if (!tin_continuous()) {
		msprint_ae_term(var_list[i].aet);
		var_list[i].string = get_ms();
		values[i] = var_list[i].string;
	    }
	}
	nr_done = size_list;
    }

    if (size_list == 0) {
	if (trace_to_stdout()) {
	    printf(">start %u ", nr);
	    write_ae_term(aet);
	    printf(" 0 \n");
	    fflush(stdout);
	}
	return (aet);
    }

    /* Lists and label can be set beforehand */
    change_label(aet);
    XtSetArg(var_args[LIST_IDX], XtNlist, (XtArgVal) vars);
    XtSetArg(var_args[NUMBER_IDX], XtNnumberStrings, (XtArgVal) size_list);
    XtSetArg(value_args[LIST_IDX], XtNlist, (XtArgVal) values);
    XtSetArg(value_args[NUMBER_IDX], XtNnumberStrings, (XtArgVal) size_list);

    if (!tin_continuous()) {
	init_procvar(Shell);
	if (Option_Tracein) {
	    deactivate_buttons();
	    popup_procvar(XtGrabNone);
	} else {
	    XtSetSensitive(w_confirm, False);
	    popup_procvar(XtGrabExclusive);
	}

	if (Option_Tracein) {
	    pause_tracein();
	    if (!Option_Tracein) {
		activate_buttons();
		XtAddGrab(w_procvar , True, False);
		goto cont;
	    }
	} else {
cont:
	    new_history(nr+1);
	    c_confirm = 0;
	    c_cancel = 0;
	    while(!c_confirm && !c_cancel)
		execute_events();
	    record_history();
	}

	popdown_procvar();
	XtDestroyWidget(w_procvar);
    }

    /* fill in variables in aet */
    if (c_confirm || Option_Tracein) {
	sub = NULL;
	eqm = get_eqm();
	index.table = VAR;
	for (i = 0; i < size_list; i ++) {
	    index.key = var_list[i].key;
	    sub = copy_add_to_sub(sub, &index, var_list[i].aet, eqm);
	}
	naet = term_instantiate(aet, sub, eqm);
	subst_free(sub);
    }

    if (trace_to_stdout()) {
	printf(">start %u ", nr);
	write_ae_term(aet);
	printf(" %d", size_list);
	for (i = 0; i < size_list; i ++) {
	    printf(" %d ", var_list[i].key);
	    write_ae_term(var_list[i].aet);
	}
	printf("\n");
	fflush(stdout);
    }

    destroy_vars();

    if (c_cancel && !Option_Tracein)
	return(NULL);
    return(naet);
}
