#ifndef _PROCESS_H_
#define _PROCESS_H_

#include "eqm.h"
struct tailheap {
    struct process_expr *expr;
    unsigned int nr;
    struct tailheap *tail;
};
struct head_tail {
    struct process_expr *head;
    subst_t *sub;
    int top;
    struct ae_term *ae_t;
    struct tailheap *tail;
    char *string;
};
struct set_list {
    int stype;
    struct s_term *set;
    int key; /* added for port checking */
    struct set_list *next;
};
struct process {
    unsigned int id;
    int flag;
    struct process *parent;
    unsigned int sleeping;
    struct head_tail *h_t;
    struct process **child;
    unsigned int nr_children;
    struct set_list *set;
    struct set_list *hide_flag;
    struct set_list *encaps_flag;
    int com_flag;
    struct process *next;
    struct process *prev;
    unsigned int weight;
    int loop_count;
    int priority;
    keytype *sumvar;
    int nr_sumvar;
};

/* defines for flag */
#define	NORMAL_PROCESS		0
#define	TEMP_PROCESS		1
#define	DEADLOCK		2
#define DISABLED_PROCESS	4
#define PORT_PROCESS		8
struct head {
    struct process *p;
    struct head *next;
    int break_on;
};
struct communication {
    struct ae_term *aet;
    struct process *p_left;
    struct process *p_right;
    struct process *merge;
    subst_t *sub;
    char *string;
    struct set_list *encaps_flag;
    struct set_list *hide_flag;
    struct communication *next;
    int break_on;
    int priority;
};

/* process.c */
extern int init_process_table PROTO_ARGS((struct ae_term *aet));
extern struct process *get_process_table PROTO_ARGS((void));
extern struct process *create_process PROTO_ARGS((struct process *parent, struct process_expr *counter));
extern void alloc_children PROTO_ARGS((struct process *p, unsigned int nr));
extern void destroy_process PROTO_ARGS((struct process *p));
extern void add_process_to_table PROTO_ARGS((struct process *p));
extern void delete_process_from_table PROTO_ARGS((struct process *p));
extern unsigned int nr_processes_in_table PROTO_ARGS((void));
extern void destroy_process_table PROTO_ARGS((void));
extern void put_process_to_sleep PROTO_ARGS((struct process *p, unsigned int nr_children));
extern void awaken_process PROTO_ARGS((struct process *p, struct process *child));
extern void print_process_status PROTO_ARGS((void));
extern int make_start_process_list PROTO_ARGS((void));
extern void mark_process_tree PROTO_ARGS((struct process *p, int flag));
extern int replace_var PROTO_ARGS((subst_t *sub, struct ae_term *caet, struct ae_term *paet, keytype *sumvar, int nr_sumvar));

#endif /* _PROCESS_H_ */
