#include <X11/IntrinsicP.h>
#include <stdio.h>
#include <X11/Xos.h>
#include <ctype.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/ListP.h>
#include "psf_prototype.h"
#include "widgets.h"
#include "mylist.h"

static void MYPaintItemName();
static void MYHighlightBackground();
static void MYNotify();
static int CvtToItem();
static void MYSet();
static void MYRedisplay();
static void BlockSelect();

static int **highlight_items;
static int nr_highlight_items;
static int xs, ys, xn, yn;

static void MYPaintItemName(w, item)
    Widget w;
    int item;
{
    char *str;
    GC gc;
    int x, y, str_y;
    ListWidget lw = (ListWidget) w;

    if (lw->list.vertical_cols) {
	x = lw->list.col_width * (item / lw->list.nrows)
	    + lw->list.internal_width;
	y = lw->list.row_height * (item % lw->list.nrows)
	    + lw->list.internal_height;
    } else {
	x = lw->list.col_width * (item % lw->list.ncols)
	    + lw->list.internal_width;
	y = lw->list.row_height * (item / lw->list.ncols)
	    + lw->list.internal_height;
    }

    str_y = y + lw->list.font->max_bounds.ascent;

    if (*highlight_items[item]) {
	gc = lw->list.revgc;
	MYHighlightBackground(w, x, y, item, lw->list.normgc);
    } else {
	gc = lw->list.normgc;
	MYHighlightBackground(w, x, y, item, lw->list.revgc);
    }

    str = lw->list.list[item];	/* draw it */
    XDrawString(XtDisplay(w), XtWindow(w), gc, x, str_y, str,
		strlen(str));
}

static void MYHighlightBackground(w, x, y, item, gc)
    Widget w;
    int x, y, item;
    GC gc;
{
    ListWidget lw = (ListWidget) w;
    int hl_x, hl_y, width, height;

    hl_x = x - lw->list.column_space / 2;
    width = XTextWidth(lw->list.font, lw->list.list[item],
		       lw->list.longest) + lw->list.column_space;
    hl_y = y - lw->list.row_space / 2 + 1;
    height = lw->list.row_height + lw->list.row_space - 2;

    XFillRectangle(XtDisplay(w), XtWindow(w), gc, hl_x, hl_y, width, height);
}

static void MYNotify(w, event, params, num_params)
    Widget w;
    XEvent *event;
    String *params;
    Cardinal *num_params;
{
    ListWidget lw = (ListWidget) w;
    int item, item_len;

    /* R4 */
    XawListReturnStruct ret_value;

    xn = event->xbutton.x;
    yn = event->xbutton.y;
    if (((CvtToItem(w, event->xbutton.x, event->xbutton.y, &item))
	 == OUT_OF_RANGE) || (lw->list.highlight != item)) {
	/*
	 * XawListUnhighlight(w);
	 */
	BlockSelect(w);
	return;
    }
    if (*highlight_items[item])
	*highlight_items[item] = 0;
    else
	*highlight_items[item] = 1;

    item_len = strlen(lw->list.list[item]);

    if (lw->list.paste)		/* if XtNpasteBuffer set then paste it. */
	XStoreBytes(XtDisplay(w), lw->list.list[item], item_len);

    MYRedisplay(w, NULL, NULL, NULL);
    /*
     * Call Callback function.
     */

    ret_value.string = lw->list.list[item];
    ret_value.list_index = item;

    XtCallCallbacks(w, XtNcallback, (caddr_t) & ret_value);
}

static int CvtToItem(w, xloc, yloc, item)
    Widget w;
    int xloc, yloc;
    int *item;
{
    int one, another;
    ListWidget lw = (ListWidget) w;
    int ret_val = OKAY;

    if (lw->list.vertical_cols) {
	one = lw->list.nrows * ((xloc - (int) lw->list.internal_width)
				/ lw->list.col_width);
	another = (yloc - (int) lw->list.internal_height)
	    / lw->list.row_height;
	/* If out of range, return minimum possible value. */
	if (another >= lw->list.nrows) {
	    another = lw->list.nrows - 1;
	    ret_val = OUT_OF_RANGE;
	}
    } else {
	one = (lw->list.ncols * ((yloc - (int)
			    lw->list.internal_height) / lw->list.row_height));
	/* If in right margin handle things right. */
	another = (xloc - (int) lw->list.internal_width) /
	    lw->list.col_width;
	if (another >= lw->list.ncols) {
	    another = lw->list.ncols - 1;
	    ret_val = OUT_OF_RANGE;
	}
    }
    if ((xloc < 0) || (yloc < 0))
	ret_val = OUT_OF_RANGE;
    if (one < 0)
	one = 0;
    if (another < 0)
	another = 0;
    *item = one + another;
    if (*item >= lw->list.nitems)
	return (OUT_OF_RANGE);
    return (ret_val);
}

static void MYSet(w, event, params, num_params)
    Widget w;
    XEvent *event;
    String *params;
    Cardinal *num_params;
{
    ListWidget lw = (ListWidget) w;
    int item;

    /* Find item and if out of range then return. */

    xs = event->xbutton.x;
    ys = event->xbutton.y;
    if ((CvtToItem(w, event->xbutton.x, event->xbutton.y, &item))
	    == OUT_OF_RANGE)
	return;

    lw->list.highlight = item;
}

static void MYUnset(w, event, params, num_params)
    Widget w;
    XEvent *event;
    String *params;
    Cardinal *num_params;
{
}

/*	Function Name: FindCornerItems.
 *	Description: Find the corners of the rectangle in item space.
 *	Arguments: w - the list widget.
 *                 event - the event structure that has the rectangle it it.
 *                 ul_ret, lr_ret - the corners ** RETURNED **.
 *	Returns: none.
 */

static void
FindCornerItems(w, event, ul_ret, lr_ret)
Widget w;
XEvent * event;
int *ul_ret, *lr_ret;
{
    int xloc, yloc;

    xloc = event->xexpose.x;
    yloc = event->xexpose.y;
    CvtToItem(w, xloc, yloc, ul_ret);
    xloc += event->xexpose.width;
    yloc += event->xexpose.height;
    CvtToItem(w, xloc, yloc, lr_ret);
}

/*	Function Name: ItemInRectangle
 *	Description: returns TRUE if the item passed is in the given rectangle.
 *	Arguments: w - the list widget.
 *                 ul, lr - corners of the rectangle in item space.
 *                 item - item to check.
 *	Returns: TRUE if the item passed is in the given rectangle.
 */

static Boolean
ItemInRectangle(w, ul, lr, item)
Widget w;
int ul, lr, item;
{
    ListWidget lw = (ListWidget) w;
    int mod_item;
    int things;
    
    if (item < ul || item > lr) 
        return(FALSE);
    if (lw->list.vertical_cols)
        things = lw->list.nrows;
    else
        things = lw->list.ncols;

    mod_item = item % things;
    if ( (mod_item >= ul % things) && (mod_item <= lr % things ) )
        return(TRUE);
    return(FALSE);
}

static void MYRedisplay(w, event, params, num_params)
    Widget w;
    XEvent *event;
    String *params;
    Cardinal *num_params;
{
    int item;			/* an item to work with. */
    int ul_item, lr_item;	/* corners of items we need to paint. */
    ListWidget lw = (ListWidget) w;

    if (event == NULL) {	/* repaint all. */
	ul_item = 0;
	lr_item = lw->list.nrows * lw->list.ncols - 1;
	XClearWindow(XtDisplay(w), XtWindow(w));
    } else
	FindCornerItems(w, event, &ul_item, &lr_item);

    for (item = ul_item; (item <= lr_item && item < lw->list.nitems);
	    item++)
	if (ItemInRectangle(w, ul_item, lr_item, item))
	    MYPaintItemName(w, item);
}

static XtActionsRec actionTable[] = {
    {"MYSet", MYSet},
    {"MYUnset", MYUnset},
    {"MYNotify", MYNotify},
    {"MYRedisplay", MYRedisplay},
};

#define	NR_ACTIONS	4

static char mytranslations[] =
"<Btn1Down>:		MYSet()\n\
	<Btn1Up>:		MYNotify()\n\
	<Expose>:		MYRedisplay()";

void init_mylist(w, str_list, nr_str, int_list, nr_int)
    Widget w;
    String *str_list;
    int nr_str;
    int **int_list;
    int nr_int;
{
    XtAppAddActions(app_context, actionTable, NR_ACTIONS);
    XtOverrideTranslations(w, XtParseTranslationTable(mytranslations));
    /* circumvent bug in List widget  part1 */
    if (nr_str == 0)
	str_list = NULL;

    XawListChange(w, str_list, nr_str, 0, True);
    /* part2 */
    if (nr_str == 0)
	((ListWidget) w)->list.nitems = 0;

    highlight_items = int_list;
    nr_highlight_items = nr_int;
}

static void BlockSelect(w)
    Widget w;
{
    ListWidget lw = (ListWidget) w;
    int x, y, xl, yl, xh, yh;
    int cw, rh;
    int item;

    if (xs < xn) {
	xl = xs;
	xh = xn;
    } else {
	xl = xn;
	xh = xs;
    }
    if (ys < yn) {
	yl = ys;
	yh = yn;
    } else {
	yl = yn;
	yh = ys;
    }
    cw = lw->list.col_width;
    rh = lw->list.row_height;
    if (xl % cw > xh % cw)
	xh += cw;
    if (yl % rh > yh % rh)
	yh += rh;
    for (x = xl; x <= xh; x += cw) {
	for (y = yl; y <= yh; y += rh) {
	    if (CvtToItem(w, x, y, &item) != OUT_OF_RANGE) {
		if (*highlight_items[item])
		    *highlight_items[item] = 0;
		else
		    *highlight_items[item] = 1;
	    }
	}
    }
    MYRedisplay(w, NULL, NULL, NULL);
}
