#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/AsciiText.h>
#include "psf_stdarg.h"
#include "messagewid.h"

#define MESSAGE_BUFFER_LEN      10240
static char message_buffer[MESSAGE_BUFFER_LEN];
static Arg message_args[] = {
    {XtNallowHoriz, (XtArgVal) True},
    {XtNforceBars, (XtArgVal) True},

    /* R4 */
    {XtNeditType, (XtArgVal) XawtextAppend},
    {XtNlength, (XtArgVal) MESSAGE_BUFFER_LEN},
    {XtNstring, (XtArgVal) message_buffer},
    /*
     * R4 {XtNtextOptions,        (XtArgVal) (scrollVertical | wordBreak)},
     */
    {XtNscrollVertical, (XtArgVal) XawtextScrollAlways},
    {XtNwrap, (XtArgVal) XawtextWrapWord},
};

static Widget message_widget;

void init_message_widget(shell)
    Widget shell;
{
    message_widget = XtCreateManagedWidget("message",
    /* R4 */
					   asciiTextWidgetClass, shell,
					message_args, XtNumber(message_args));
    init_message_display();
}

/* R4 */
static XawTextBlock textblock;
static XawTextPosition textpos;

static char message_display_buf[10240];

void init_message_display()
{
    textblock.firstPos = 0;
    textblock.format = FMT8BIT;
    textblock.ptr = message_display_buf;

    /* R4 */
    textpos = XawTextTopPosition(message_widget);
}

void DECL_VARARGS_FUNC(message_display, char *, fmt)
{
    va_list args;

    VARARGS_start(args, fmt);
    vsprintf(message_display_buf, fmt, args);
    va_end(args);
    textblock.length = strlen(message_display_buf);
    /* R4 */
    XawTextReplace(message_widget, textpos, textpos, &textblock);
    textpos += textblock.length;
    XawTextSetInsertionPoint(message_widget, textpos);
}

void reset_message_display()
{
    message_display_buf[0] = '\0';
    textblock.length = 0;
    XawTextReplace(message_widget, 0, textpos, &textblock);
    textpos = 0;
    XawTextSetInsertionPoint(message_widget, textpos);
}
