#include <stdio.h>
#include <X11/Intrinsic.h>
#include "psf_prototype.h"
#include "tilutil.h"
#include "simutil.h"
#include "widgets.h"
#include "myrandom.h"
#include "statecontrol.h"
#include "functionwid.h"
#include "patchlevel.h"
#include "psf_standards.h"
#include "tbinterface.h"

int Option_Break = 0;
int Option_Random = 0;
int Option_Tracein = 0;
int Option_Test = 0;
int Option_History = 1;

extern int getopt PROTO_ARGS((int, char * PROTO_CONST *,  PROTO_CONST char *));
extern int optind;
extern char *optarg;

char *progname;
char *filename;

static int defaulttrace = 0;
static int stdouttrace = 0;

static char empty_file[] = "/dev/null";

#define USAGE	 "usage: %s [ -b exec|one|all ] [ -d ] [ -h ] [ -i ] [ -o ]  [ -r normal|weighted ] [ -v ] [file]\n"

int main(argc, argv)
    int argc;
    char *argv[];
{
    int opt;
    char *pn;
    char *tilfile;
    char *tbin, *tbout;

    init_app_context(&argc, argv);

    while ((opt = getopt(argc, argv, "b:dhHior:vtT")) != -1) {
	switch (opt) {
	case 'b':
	    if (!strcmp(optarg, "exec")) {
		Option_Break = 0;
		break;
	    }
	    if (!strcmp(optarg, "one")) {
		Option_Break = 1;
		break;
	    }
	    if (!strcmp(optarg, "all")) {
		Option_Break = 2;
		break;
	    }
	    fprintf(stderr,
		    "%s: illegal argument '%s' for option -b\n",
		    argv[0], optarg);
	    exit(1);
	case 'd':
	    defaulttrace = 1;
	    break;
	case 'h':
	    fprintf(stderr, USAGE, argv[0]);
	    exit(0);
	case 'H':
	    Option_History = 0;
	    break;
	case 'i':
	    Option_Tracein = 1;
	    force_state(STATE_TRACEIN);
	    break;
	case 'o':
	    stdouttrace = 1;
	    break;
	case 'r':
	    if (!strcmp(optarg, "normal")) {
		Option_Random = 0;
		break;
	    }
	    if (!strcmp(optarg, "weighted")) {
		Option_Random = 1;
		break;
	    }
	    fprintf(stderr, "%s: illegal argument '%s' for option -r\n", argv[0], optarg);
	    exit(1);
	case 'v':
	    fprintf(stderr, "%s version %s.%d, last compiled %s\n", argv[0],
		    VERSION, PATCHLEVEL, DATE);
	    exit(0);
	case 't':
	    Option_Test = 1;
	    break;
	case 'T':
	    tbin = argv[optind ++];
	    tbout = argv[optind ++];
	    tb_init(tbin, tbout);
	    break;
	case '?':
	    exit(1);
	}
    }
    progname = psf_basename(pn = argv[0]);
    argc -= optind - 1;
    argv += optind - 1;

    if (argc > 2) {
	fprintf(stderr, "%s: too many arguments\n", pn);
	fprintf(stderr, USAGE, pn);
	exit(1);
    }
    if (argc == 1) {
	tilfile = empty_file;
    } else
	tilfile = argv[1];
    switch (read_til_spec(tilfile)) {
    case 0:
	break;
    case 1:
	fprintf(stderr, "%s: can't read file %s\n",
		pn, argv[1]);
	exit(1);
    case 2:
	fprintf(stderr, "%s: error in input-file\n", pn);
	exit(1);
    }

    write_til_init();

    set_tracetilfile(filename);

    init_simutil();

    init_widgets();

    if (stdouttrace)
	set_tracestdout(1);
    if (defaulttrace)
	set_defaulttrace(1);

    init_myrandom();

    state_control();

    exit(0);
    return (0);			/* lint demands it */
                                /*
                                 * Don't bother about lint, cause it
                                 * is stupid.
                                 */
}
