#include <stdio.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>
#include "psf_prototype.h"
#include "psf_malloc.h"
    /* psf_malloc includes stdlib, and that must be done before AsciiTextP */
#include <X11/Xaw/AsciiTextP.h>
#include <X11/Xaw/Text.h>
#include <X11/Xaw/Command.h>
#include "scanterm.h"
#include "parseterm.h"
#include "parsetermerror.h"
#include "functionwid.h"
#include "choosewid.h"
#include "statecontrol.h"
#include "tiltype.h"
#include "tilutil.h"
#include "process.h"
#include "headtail.h"
#include "eqm.h"
#include "msprint.h"
#include "fieldex.h"
#include "widgets.h"
#include "tinwid.h"
#include "ownscanio.h"
#include "summerge.h"
#include "eqm_local.h"
#include "writetil.h"
#include "xutil.h"
#include "y.tab.h"

#define M_SUM    0
#define M_PRO    1
static int mode;

static Widget inputterm;
static Widget form;
static Widget form_label;
static Widget input_label;
static Widget input_w;
static Widget error_label;
static Widget error;
static Widget confirm;
static Widget cancel;
static Widget left;
static Widget right;
static Widget up;
static Widget down;

static char inputbuf[256] = "";
static char errorbuf[256] = "";

static struct process *P;
static int Key;
static struct ae_term *Aet;

static int ready;
static int cancelled;

static Arg args = {
    XtNlabel, (XtArgVal) NULL
};

static void change_label(s)
char *s;
{
    XtSetArg(args, XtNlabel, (XtArgVal) s);
    XtSetValues(form_label, &args, 1);
}

static char label[256];

static void set_label(key)
int    key;
{
    char *s;
    struct indextype *ind;
    struct module *mod;

    mod = get_til_module();
    ind = &mod->var[key].ind;
    if (ind->table == SOR) {
	s = field_extract("n", mod->sor[ind->key].ff, ind->table, ind->key);
    } else { /* SET */
	s = field_extract("n", mod->set[ind->key].ff, ind->table, ind->key);
    }
    sprintf (label, "Give a term of type %s", s);
    change_label(label);
}

static Arg xarg = {
    XtNdisplayPosition, (XtArgVal) 0
};

#define	MAX_CONTENT	256
#define	MAX_VIEW	50
#define MIN_VIEW	5

static Widget text;
static Widget errortext;

static char scanbuf[256];

static XawTextBlock block = {0, 0, NULL, 0};

static void print_error(s)
    char *s;
{
    block.ptr = s;
    block.length = strlen(s);
    XawTextReplace(error, 0, strlen(errorbuf), &block);
}

static void set_sensitive(p)
XawTextPosition p;
{
    XtSetSensitive(left, p == 0 ? False : True);
    XtSetSensitive(right, p >= MAX_CONTENT - MAX_VIEW - 6 ? False : True);
}

static void left_term(w, client_data, call_data)
    Widget w;
    caddr_t client_data;
    caddr_t call_data;
{
    XawTextPosition p;

    p = XawTextTopPosition(text);
    if (p > MAX_VIEW)
	p = p - MAX_VIEW;
    else if (p > 0)
	p = 0;
    XtSetArg(xarg, XtNdisplayPosition, (XtArgVal) p);
    XtSetValues(text, &xarg, 1);
    set_sensitive(p);
}

static void right_term(w, client_data, call_data)
    Widget w;
    caddr_t client_data;
    caddr_t call_data;
{
    XawTextPosition p;

    p = XawTextTopPosition(text);
    if (p < MAX_CONTENT - 2 * MAX_VIEW)
	p = p + MAX_VIEW;
    else if (p < MAX_CONTENT - MAX_VIEW)
	p = p + MAX_VIEW;
    XtSetArg(xarg, XtNdisplayPosition, (XtArgVal) p);
    XtSetValues(text, &xarg, 1);
    set_sensitive(p);
}

static void begin_term(s)
char *s;
{
    int l;

    l = strlen(inputbuf);
    (void) strcpy(inputbuf, s);
    block.ptr = inputbuf;
    block.length = strlen(block.ptr);
    XawTextReplace(text, 0, l, &block);
    l = block.length - MAX_VIEW;
    if (l < 0)
	l = 0;
    XtSetArg(xarg, XtNdisplayPosition, (XtArgVal) l);
    XtSetValues(text, &xarg, 1);
    XawTextSetInsertionPoint(text, block.length);
    set_sensitive(l);
}

static void keyreport_term(w, event, params, num_params)
    Widget w;
    XEvent *event;
    String *params;
    Cardinal *num_params;
{
    XawTextPosition p, x;

    p = XawTextTopPosition(text);
    x = XawTextGetInsertionPoint(w);
    if (x > p + MAX_VIEW)
	p = x - MAX_VIEW;
    else if (x < p)
	p = x - MAX_VIEW;
    else if (x < p + MIN_VIEW && x >= MIN_VIEW)
	p = x - MIN_VIEW;
    XtSetArg(xarg, XtNdisplayPosition, (XtArgVal) p);
    XtSetValues(w, &xarg, 1);
    set_sensitive(p);
}

/*
 * History package
 */
struct history_v {
    char * value;
    struct history_v * next;
    struct history_v * prev;
};
struct history_t {
    struct history_v * values;
    struct history_v * current;
    struct history_v * last;
};
static int nr_sorts;
static int nr_sets;
static struct history_t * history = NULL;
static int current;
static char lastbuf[256];

static void end_inputterm_history()
{
    int i;
    struct history_v *v1, *v2;

    for (i = 0; i <= nr_sorts + nr_sets; i ++) {
	v1 = history[i].last;
	while (v1 != NULL) {
	    v2 = v1;
	    v1 = v2->prev;
	    PSF_FREE(v2->value);
	    PSF_FREE(v2);
	}
    }
    PSF_FREE(history);
}

void init_inputterm_history()
{
    struct module * mod;
    int i;

    if (history != NULL)
	end_inputterm_history();

    mod = get_til_module();
    nr_sorts = mod->entries_table[SOR];
    nr_sets = mod->entries_table[SET];
    history = PSF_NMALLOC(struct history_t, nr_sorts + nr_sets + 1);
    for (i = 0; i <= nr_sorts + nr_sets; i ++) {
	history[i].values = NULL;
	history[i].last = NULL;
    }
}

static void new_history()
{
    struct module * mod;
    struct indextype * ind;
    struct history_v * new, * last;

    mod = get_til_module();
    if (mode == M_SUM)
	ind = &mod->var[P->h_t->head->proc_expr.pe1.ind.key].ind;
    else
	ind = &mod->var[Key].ind;
    if (ind->table == SOR) {
	current = ind->key;
    } else {
	current = ind->key + nr_sorts;
    }
    last = history[current].last;
    new = PSF_MALLOC(struct history_v);
    new->next = NULL;
    new->value = lastbuf;
    if (last == NULL) {
	history[current].values = new;
	history[current].last = new;
	new->prev = NULL;
    } else {
	last->next = new;
	new->prev = last;
	history[current].last = new;
    }
    history[current].current = new;

    if (new->prev != NULL)
	XtSetSensitive(up, True);
    else
	XtSetSensitive(up, False);
    XtSetSensitive(down, False);
}

static void record_history()
{
    struct history_v *h;

    if (strlen(inputbuf) == 0) {
	h = history[current].last;
	history[current].last = h->prev;
	if (h->prev == NULL)
	    history[current].values = NULL;
	else
	    history[current].last->next = NULL;
	PSF_FREE(h);
    } else {
	h = history[current].last;
	while ((h = h->prev) != NULL) {
	    if (!strcmp(h->value, inputbuf)) {
		h->next->prev = h->prev;
		if (h->prev == NULL)
		    history[current].values = h->next;
		else
		    h->prev->next = h->next;
		PSF_FREE(h->value);
		PSF_FREE(h);
		break;
	    }
	}
	history[current].last->value = psf_strdup(inputbuf);
    }
}

static void up_term(w, client_data, call_data)
    Widget w;
    caddr_t client_data;
    caddr_t call_data;
{
    if (history[current].current->prev != NULL) {
	if (history[current].current->next == NULL) {
	    XtSetSensitive(down, True);
	    (void) strcpy(lastbuf, inputbuf);
	}

	history[current].current = history[current].current->prev;
	begin_term(history[current].current->value);

	if (history[current].current->prev == NULL)
	    XtSetSensitive(up, False);
    }
}

static void down_term(w, client_data, call_data)
    Widget w;
    caddr_t client_data;
    caddr_t call_data;
{
    if (history[current].current->next != NULL) {
	if (history[current].current->prev == NULL)
	    XtSetSensitive(up, True);

	history[current].current = history[current].current->next;
	begin_term(history[current].current->value);

	if (history[current].current->next == NULL)
	    XtSetSensitive(down, False);
    }
}
/*
 * end History package
 */

static int popped = 0;
static void popup_inputterm()
{
    if (!tin_continuous()) {
	new_history();
	XtPopup(inputterm, XtGrabExclusive);
	if (mode == M_SUM)
	    set_label(P->h_t->head->proc_expr.pe1.ind.key);
	else
	    set_label(Key);
	/* If we put set_label in front of Xtpopup, we get weird result with
	 * large labels.
	 */
	popped = 1;
    }
}

void popdown_inputterm()
{
    if (mode == M_SUM) {
	unset_item_to_choose();
	force_state(STATE_CHOOSE);
    }
    if (popped) {
	XtPopdown(inputterm);
	popped = 0;
	record_history();
    }
}

void popup_inputterm_sum(p)
struct process *p;
{
    P = p;
    mode = M_SUM;
    begin_term("");
    popup_inputterm();
}

int popup_inputterm_pro(key, paet, pstr)
int key;
struct ae_term **paet;
char **pstr;
{
    Key = key;
    mode = M_PRO;
    ready = 0;
    cancelled = 0;
    if (*pstr == NULL)
	begin_term("");
    else
	begin_term(*pstr);
    popup_inputterm();
    while (!ready && ! cancelled)
	execute_events();
    popdown_inputterm();
    if (cancelled)
	return(0);
    *paet = Aet;
    *pstr = psf_strdup(inputbuf);
    return(1);
}

extern int yyparse PROTO_ARGS((void));

static int parse_term()
{
    int p, ep;

    print_error("");
    strcpy(scanbuf, inputbuf);
    scanbuf[strlen(scanbuf)] = '\n';
    set_buffer(scanbuf);
    scan_reset_chars();
    if (yyparse())
	return(1);
    if (Parseterm_Aet == NULL) {
	if (Parseterm_status) {
	    print_error(get_parseterm_error());
	    ep = scan_get_chars();
	    p = XawTextTopPosition(text);
	    if (ep >= (int) strlen(inputbuf))
		XawTextSetInsertionPoint(text, ep - 1);
	    else
		XawTextSetInsertionPoint(text, ep);
	    if (ep < p || ep > (p + MAX_VIEW + 1)) {
		p = ep - MAX_VIEW / 2;
		if (p < 0)
		    p = 0;
	    }
	    XtSetArg(xarg, XtNdisplayPosition, (XtArgVal) p);
	    XtSetValues(text, &xarg, 1);
	    return (1);
	} else
	    return (1);
    }
    return (0);
}

static void check_term()
{
    keytype key;
    struct module *mod;
    eqm_t *eqm;
    struct ae_term *aet;

    if (parse_term())
	return;
    if (mode == M_SUM)
	key = P->h_t->head->proc_expr.pe1.ind.key;
    else
	key = Key;
    mod = get_til_module();
    eqm = get_eqm();
    aet = term_reduce(eqm, Parseterm_Aet);
    if (mod->var[key].ind.table == SOR) {
	if (mod->fun[aet->ind.key].return_list.indlist[0].key
		!= mod->var[key].ind.key) {
	    print_error("wrong sort type");
	    return;
	}
    } else {
	if (!member_of_sortset(mod, aet, &mod->set[mod->var[key].ind.key])) {
	    print_error("not member of set");
	    return;
	}
    }
    if (mode == M_SUM) {
	if (make_sum_aet(P, aet, eqm)) {
	    print_error("results in deadlock");
	    ae_term_free(aet);
	    return;
	}
	if (trace_to_stdout()) {
	    printf(">sum %u ", get_chosen_item());
	    write_ae_term(aet);
	    printf("\n");
	}
	ae_term_free(aet);
	popdown_inputterm();
	force_state(STATE_CHOOSE_INIT);
    } else {
	Aet = aet;
	ready = 1;
    }
}

static void confirm_term(w, client_data, call_data)
    Widget w;
    caddr_t client_data;
    caddr_t call_data;
{
    check_term();
}

static void keyconfirm_term(w, event, params, num_params)
    Widget w;
    XEvent *event;
    String *params;
    Cardinal *num_params;
{
    check_term();

}

static void cancel_term(w, client_data, call_data)
    Widget w;
    caddr_t client_data;
    caddr_t call_data;
{
    if (mode == M_SUM)
	popdown_inputterm();
    else
	cancelled = 1;
}

#define	HEIGHT	24
#define WIDTH	100
#define DIST	6
static Arg inputterm_args[] = {
/*
    {XtNheight, (XtArgVal) 5 * HEIGHT + 7 * DIST + 8},
*/
    {XtNwidth, (XtArgVal) 594},
    {XtNtransient, (XtArgVal) True},
    {XtNx, (XtArgVal) 504},
    {XtNy, (XtArgVal) 368 - (5 * HEIGHT + 7 * DIST + 8)},
};

static Arg form_args[] = {
    {XtNdefaultDistance, (XtArgVal) DIST},
};

static Arg form_label_args[] = {
/*
    {XtNheight, (XtArgVal) HEIGHT},
*/
    {XtNresizable, (XtArgVal) False},
    /* If it is resizable it doesn't change size when the label is too large
     * to fit in the parent! (too bad)
     */
    {XtNtop, (XtArgVal) XawChainTop},
    {XtNbottom, (XtArgVal) XawChainTop},
    {XtNleft, (XtArgVal) XawChainLeft},
    {XtNright, (XtArgVal) XawChainRight},
    {XtNjustify, (XtArgVal) XtJustifyLeft},
};

static Arg input_label_args[] = {
    {XtNfromVert, (XtArgVal) NULL},
/*
    {XtNheight, (XtArgVal) HEIGHT},
*/
    {XtNwidth, (XtArgVal) WIDTH},
    {XtNresizable, (XtArgVal) False},
    {XtNtop, (XtArgVal) XawChainTop},
    {XtNbottom, (XtArgVal) XawChainTop},
    {XtNleft, (XtArgVal) XawChainLeft},
    {XtNright, (XtArgVal) XawChainLeft},
};

static Arg error_label_args[] = {
    {XtNfromVert, (XtArgVal) NULL},
/*
    {XtNheight, (XtArgVal) HEIGHT},
*/
    {XtNwidth, (XtArgVal) WIDTH},
    {XtNresizable, (XtArgVal) True},
    {XtNtop, (XtArgVal) XawChainTop},
    {XtNbottom, (XtArgVal) XawChainTop},
    {XtNleft, (XtArgVal) XawChainLeft},
    {XtNright, (XtArgVal) XawChainLeft},
    {XtNvertDistance, (XtArgVal) 3*DIST},
};

static XtCallbackRec left_callbacks[] = {
    {(XtCallbackProc) left_term, NULL},
    {(XtCallbackProc) NULL, NULL},
};

#include "leftdblarr"
static Arg left_args[] = {
    {XtNbitmap, (XtArgVal) 0},
    {XtNfromHoriz, (XtArgVal) NULL},
    {XtNfromVert, (XtArgVal) NULL},
    {XtNwidth, (XtArgVal) HEIGHT+DIST},
    {XtNheight, (XtArgVal) HEIGHT},
    {XtNresizable, (XtArgVal) False},
    {XtNtop, (XtArgVal) XawChainTop},
    {XtNbottom, (XtArgVal) XawChainTop},
    {XtNleft, (XtArgVal) XawChainRight},
    {XtNright, (XtArgVal) XawChainRight},
    {XtNcallback, (XtArgVal) left_callbacks},
};

static XtCallbackRec right_callbacks[] = {
    {(XtCallbackProc) right_term, NULL},
    {(XtCallbackProc) NULL, NULL},
};

#include "rightdblarr"
static Arg right_args[] = {
    {XtNbitmap, (XtArgVal) 0},
    {XtNfromHoriz, (XtArgVal) NULL},
    {XtNfromVert, (XtArgVal) NULL},
    {XtNwidth, (XtArgVal) HEIGHT+DIST},
    {XtNheight, (XtArgVal) HEIGHT},
    {XtNresizable, (XtArgVal) False},
    {XtNtop, (XtArgVal) XawChainTop},
    {XtNbottom, (XtArgVal) XawChainTop},
    {XtNleft, (XtArgVal) XawChainRight},
    {XtNright, (XtArgVal) XawChainRight},
    {XtNcallback, (XtArgVal) right_callbacks},
    {XtNhorizDistance, (XtArgVal) 0},
};

static XtCallbackRec confirm_callbacks[] = {
    {(XtCallbackProc) confirm_term, NULL},
    {(XtCallbackProc) NULL, NULL},
};

static Arg confirm_args[] = {
    {XtNfromVert, (XtArgVal) NULL},
/*
    {XtNheight, (XtArgVal) HEIGHT},
*/
    /*
     * {XtNwidth,		(XtArgVal) WIDTH},
     */
    {XtNresizable, (XtArgVal) False},
    {XtNtop, (XtArgVal) XawChainBottom},
    {XtNbottom, (XtArgVal) XawChainBottom},
    {XtNleft, (XtArgVal) XawChainRight},
    {XtNright, (XtArgVal) XawChainRight},
    {XtNcallback, (XtArgVal) confirm_callbacks},
};

static XtCallbackRec cancel_callbacks[] = {
    {(XtCallbackProc) cancel_term, NULL},
    {(XtCallbackProc) NULL, NULL},
};

static Arg cancel_args[] = {
    {XtNfromHoriz, (XtArgVal) NULL},
    {XtNfromVert, (XtArgVal) NULL},
/*
    {XtNheight, (XtArgVal) HEIGHT},
*/
    /*
     * {XtNwidth,		(XtArgVal) WIDTH},
     */
    {XtNresizable, (XtArgVal) False},
    {XtNtop, (XtArgVal) XawChainBottom},
    {XtNbottom, (XtArgVal) XawChainBottom},
    {XtNleft, (XtArgVal) XawChainRight},
    {XtNright, (XtArgVal) XawChainRight},
    {XtNcallback, (XtArgVal) cancel_callbacks},
};

static Arg input_args[] = {
    {XtNfromHoriz, (XtArgVal) NULL},
    {XtNfromVert, (XtArgVal) NULL},
    {XtNheight, (XtArgVal) HEIGHT},
    {XtNstring, (XtArgVal) inputbuf},
    {XtNeditType, (XtArgVal) XawtextEdit},
    {XtNuseStringInPlace, (XtArgVal) True},
    {XtNlength, (XtArgVal) 256},
    {XtNtop, (XtArgVal) XawChainTop},
    {XtNbottom, (XtArgVal) XawChainTop},
    {XtNleft, (XtArgVal) XawChainLeft},
    {XtNright, (XtArgVal) XawChainRight},
};

static Arg error_args[] = {
    {XtNfromHoriz, (XtArgVal) NULL},
    {XtNfromVert, (XtArgVal) NULL},
    {XtNheight, (XtArgVal) HEIGHT + 20},	/* + scrollbar */
    {XtNstring, (XtArgVal) errorbuf},
    {XtNeditType, (XtArgVal) XawtextEdit},
    {XtNuseStringInPlace, (XtArgVal) True},
    {XtNlength, (XtArgVal) 256},
    {XtNtop, (XtArgVal) XawChainTop},
    {XtNbottom, (XtArgVal) XawChainTop},
    {XtNleft, (XtArgVal) XawChainLeft},
    {XtNright, (XtArgVal) XawChainRight},
    {XtNallowHoriz, (XtArgVal) True},
    {XtNforceBars, (XtArgVal) True},
    {XtNscrollHorizontal, (XtArgVal) XawtextScrollAlways},
    {XtNvertDistance, (XtArgVal) 3*DIST},
};

#include "updblarr"
static XtCallbackRec up_callbacks[] = {
    {(XtCallbackProc) up_term, NULL},
    {(XtCallbackProc) NULL, NULL},
};

static Arg up_args[] = {
    {XtNbitmap, (XtArgVal) 0},
    {XtNfromHoriz, (XtArgVal) NULL},
    {XtNfromVert, (XtArgVal) NULL},
    {XtNwidth, (XtArgVal) 0},
    {XtNheight, (XtArgVal) HEIGHT+DIST},
    {XtNhorizDistance, (XtArgVal) 26},
    {XtNvertDistance, (XtArgVal) DIST},
    {XtNresizable, (XtArgVal) False},
    {XtNtop, (XtArgVal) XawChainTop},
    {XtNbottom, (XtArgVal) XawChainTop},
    {XtNleft, (XtArgVal) XawChainRight},
    {XtNright, (XtArgVal) XawChainRight},
    {XtNcallback, (XtArgVal) up_callbacks},
    {XtNinternalWidth, (XtArgVal) 2},
};

#include "downdblarr"
static XtCallbackRec down_callbacks[] = {
    {(XtCallbackProc) down_term, NULL},
    {(XtCallbackProc) NULL, NULL},
};

static Arg down_args[] = {
    {XtNbitmap, (XtArgVal) 0},
    {XtNfromHoriz, (XtArgVal) NULL},
    {XtNfromVert, (XtArgVal) NULL},
    {XtNwidth, (XtArgVal) 0},
    {XtNheight, (XtArgVal) HEIGHT+DIST},
    {XtNhorizDistance, (XtArgVal) 26},
    {XtNresizable, (XtArgVal) False},
    {XtNtop, (XtArgVal) XawChainTop},
    {XtNbottom, (XtArgVal) XawChainTop},
    {XtNleft, (XtArgVal) XawChainRight},
    {XtNright, (XtArgVal) XawChainRight},
    {XtNcallback, (XtArgVal) down_callbacks},
    {XtNinternalWidth, (XtArgVal) 2},
    {XtNvertDistance, (XtArgVal) 0},
};

static XtActionsRec actionTable[] = {
    {"keyconfirm", keyconfirm_term},
    {"keyreport", keyreport_term},
};

static char input_translations[] =
"<Key>Return: keyconfirm()\n\
	<Key>Linefeed: keyconfirm()\n\
	<KeyUp>: keyreport()";

void init_input_term(shell)
    Widget shell;
{
    Pixmap bm;
    Dimension w, h;

    inputterm = XtCreatePopupShell("TERM", topLevelShellWidgetClass,
			     shell, inputterm_args, XtNumber(inputterm_args));
    form = XtCreateManagedWidget("form", formWidgetClass, inputterm,
				 form_args, XtNumber(form_args));
    form_label = XtCreateManagedWidget("Give a term", labelWidgetClass,
			    form, form_label_args, XtNumber(form_label_args));

    XtSetArg(input_label_args[0], XtNfromVert, (XtArgVal) form_label);
    input_label = XtCreateManagedWidget("Term:", labelWidgetClass,
			  form, input_label_args, XtNumber(input_label_args));

    XtSetArg(input_args[0], XtNfromHoriz, (XtArgVal) input_label);
    XtSetArg(input_args[1], XtNfromVert, (XtArgVal) form_label);
    XtSetArg(input_args[2], XtNheight, (XtArgVal) get_height(input_label));
    input_w = XtCreateManagedWidget("value", asciiTextWidgetClass, form,
				  input_args, XtNumber(input_args));
    XtAppAddActions(app_context, actionTable, 2);
    XtOverrideTranslations(input_w,
			   XtParseTranslationTable(input_translations));
    /*
     * scrollbar = ((AsciiWidget) input_w)->text.hbar;
     */
    text = ((AsciiWidget) input_w)->core.self;	/* It's hard to find. */

    bm = XCreateBitmapFromData(XtDisplay(shell),
	RootWindowOfScreen(XtScreen(shell)), (char *) leftdblarr_bits,
	leftdblarr_width, leftdblarr_height);
    XtSetArg(left_args[0], XtNbitmap, (XtArgVal) bm);
    XtSetArg(left_args[1], XtNfromHoriz, (XtArgVal) input_w);
    XtSetArg(left_args[2], XtNfromVert, (XtArgVal) form_label);
    XtSetArg(left_args[3], XtNwidth, (XtArgVal) get_height(input_label));
    XtSetArg(left_args[4], XtNheight, (XtArgVal) get_height(input_label));
    left = XtCreateManagedWidget("left", commandWidgetClass, form,
				 left_args, XtNumber(left_args));
    bm = XCreateBitmapFromData(XtDisplay(shell),
	RootWindowOfScreen(XtScreen(shell)), (char *) rightdblarr_bits,
	rightdblarr_width, rightdblarr_height);
    XtSetArg(right_args[0], XtNbitmap, (XtArgVal) bm);
    XtSetArg(right_args[1], XtNfromHoriz, (XtArgVal) left);
    XtSetArg(right_args[2], XtNfromVert, (XtArgVal) form_label);
    XtSetArg(right_args[3], XtNwidth, (XtArgVal) get_height(input_label));
    XtSetArg(right_args[4], XtNheight, (XtArgVal) get_height(input_label));
    right = XtCreateManagedWidget("right", commandWidgetClass, form,
				  right_args, XtNumber(right_args));

    XtSetArg(error_label_args[0], XtNfromVert, (XtArgVal) input_w);
    error_label = XtCreateManagedWidget("Error:", labelWidgetClass,
			  form, error_label_args, XtNumber(error_label_args));

    XtSetArg(error_args[0], XtNfromHoriz, (XtArgVal) error_label);
    XtSetArg(error_args[1], XtNfromVert, (XtArgVal) input_w);
    XtSetArg(error_args[2], XtNheight, (XtArgVal) get_height(error_label) + 20);
    error = XtCreateManagedWidget("error", asciiTextWidgetClass, form,
				  error_args, XtNumber(error_args));
    errortext = ((AsciiWidget) error)->core.self;	/* It's hard to find. */
    XawTextDisplayCaret(errortext, False);

    XtSetArg(confirm_args[0], XtNfromVert, (XtArgVal) error);
    confirm = XtCreateManagedWidget("Confirm", commandWidgetClass, form,
				    confirm_args, XtNumber(confirm_args));

    XtSetArg(cancel_args[0], XtNfromHoriz, (XtArgVal) confirm);
    XtSetArg(cancel_args[1], XtNfromVert, (XtArgVal) error);
    cancel = XtCreateManagedWidget("Cancel", commandWidgetClass, form,
				   cancel_args, XtNumber(cancel_args));

    get_wh(left, &w, &h);
    bm = XCreateBitmapFromData(XtDisplay(shell),
	RootWindowOfScreen(XtScreen(shell)), (char *) updblarr_bits,
	updblarr_width, updblarr_height);
    XtSetArg(up_args[0], XtNbitmap, (XtArgVal) bm);
    XtSetArg(up_args[1], XtNfromHoriz, (XtArgVal) input_w);
    XtSetArg(up_args[2], XtNfromVert, (XtArgVal) NULL);
    XtSetArg(up_args[3], XtNwidth, (XtArgVal) h);
    XtSetArg(up_args[4], XtNheight, (XtArgVal) h);
    XtSetArg(up_args[5], XtNhorizDistance, (XtArgVal) w-h/2+DIST+1);
    XtSetArg(up_args[6], XtNvertDistance, (XtArgVal) 2 * DIST);
    up = XtCreateManagedWidget("up", commandWidgetClass, form,
				 up_args, XtNumber(up_args));
    bm = XCreateBitmapFromData(XtDisplay(shell),
	RootWindowOfScreen(XtScreen(shell)), (char *) downdblarr_bits,
	downdblarr_width, downdblarr_height);
    XtSetArg(down_args[0], XtNbitmap, (XtArgVal) bm);
    XtSetArg(down_args[1], XtNfromHoriz, (XtArgVal) input_w);
    XtSetArg(down_args[2], XtNfromVert, (XtArgVal) left);
    XtSetArg(down_args[3], XtNwidth, (XtArgVal) h);
    XtSetArg(down_args[4], XtNheight, (XtArgVal) h);
    XtSetArg(down_args[5], XtNhorizDistance, (XtArgVal) w-h/2+DIST+1);
    down = XtCreateManagedWidget("down", commandWidgetClass, form,
				 down_args, XtNumber(down_args));

    XtSetKeyboardFocus(form, input_w);
}

void control_input_term(choice, aet)
    unsigned int choice;
    struct ae_term *aet;
{
    struct process *p;

    for (p = get_process_table(); p != NULL; p = p->next) {
	if (p->flag & DEADLOCK)
	    continue;
	if (p->sleeping)
	    continue;
	if (p->encaps_flag != NULL)
	    continue;
	if (choice == 0) {
	    P = p;
	    break;
	} else
	    choice--;
    }
    msprint_ae_term(aet);
    block.ptr = get_msp();
    block.length = strlen(block.ptr);
    XawTextReplace(input_w, 0, strlen(inputbuf), &block);
    if (!tin_continuous()) {
	mode = M_SUM;
	XtPopup(inputterm, XtGrabNone);
	set_label(P->h_t->head->proc_expr.pe1.ind.key);
	popped = 1;
    }
}

void control_check_term()
{
    check_term();
}
