#include <stdio.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/SimpleMenP.h>
#include <X11/Xaw/Sme.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include "psf_prototype.h"
#include "history.h"
#include "statecontrol.h"
#include "widgets.h"
#include "psf_malloc.h"
#include "functionwid.h"
#include "tracewid.h"
#include "process.h"
#include "dialogwid.h"

/*
 * History menu with a submenu for the marks.
 * The submenu is implemented through callbacks and translations.
 */

/* Our widgets. */
static Widget menu;
static Widget his_undo;
static Widget his_redo;
static Widget his_mark;
static Widget his_gotomark;
static Widget markmenu;

/* Keep an array of widgets for marks (dynamically). */
struct entry {
    unsigned long id;
    Widget w;
};
static int entryind = 0;
static int maxentryind = 10;
static struct entry *markentry;

/* We need to register the position of the menu for positioning
   the submenu */
static Position menu_x, menu_y;

/*
 * Keep track of the popup-state of the menu's, through
 * callbacks on popup and popdown.
 */
static int menu_is_up = 0;
static int markmenu_is_up = 0;

static void menuup(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
    Arg arg[2];

    XtSetArg(arg[0], XtNy, &menu_y);
    XtSetArg(arg[1], XtNx, &menu_x);
    XtGetValues(w, arg, 2);
/*
fprintf(stderr, "%d %d\n", menu_x, menu_y);
*/
    menu_is_up = 1;
}

static void menudown(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
    menu_is_up = 0;
}

static XtCallbackRec menuup_callbacks[] = {
    { (XtCallbackProc) menuup, NULL },
    { (XtCallbackProc) NULL, NULL }
};

static XtCallbackRec menudown_callbacks[] = {
    { (XtCallbackProc) menudown, NULL },
    { (XtCallbackProc) NULL, NULL }
};

static Arg menu_args[] = {
    { XtNmenuOnScreen, (XtArgVal) True },
    { XtNpopupCallback, (XtArgVal) menuup_callbacks },
    { XtNpopdownCallback, (XtArgVal) menudown_callbacks },
};

/*
 * Alter the translations of the menu for popping up the
 * submenu.
 */
static char menutranslations[] =
"   <EnterWindow>: highlight() submenu()\n\
    <LeaveWindow>: unhighlight()\n\
    <Motion>: highlight() submenu()\n\
    <BtnUp>: MenuPopdown() notify() unhighlight()\n";

/*
 * This is copied from SimpleMenu.c. We need it for submenu().
 */
static SmeObject GetEventEntry(w, event)
Widget w;
XEvent * event;
{
    Position x_loc, y_loc;
    SimpleMenuWidget smw = (SimpleMenuWidget) w;
    SmeObject * entry;
    
    switch (event->type) {
    case MotionNotify:
        x_loc = event->xmotion.x;
        y_loc = event->xmotion.y;
        break;
    case EnterNotify:
    case LeaveNotify:
        x_loc = event->xcrossing.x;
        y_loc = event->xcrossing.y;
        break;
    case ButtonPress:
    case ButtonRelease:
        x_loc = event->xbutton.x;
        y_loc = event->xbutton.y;
        break;
    default:
        XtAppError(XtWidgetToApplicationContext(w),
                   "Unknown event type in GetEventEntry().");
        break;
    }
    
    if ( (x_loc < 0) || (x_loc >= (int)smw->core.width) || (y_loc < 0) ||
        (y_loc >= (int)smw->core.height) )
        return(NULL);
    
    for (entry = (SmeObject *) smw->composite.children;
	entry < (SmeObject *) (smw->composite.children +
	    smw->composite.num_children);
	entry ++) {
        if (!XtIsManaged ((Widget) *entry)) continue;
 
        if ( ((*entry)->rectangle.y < y_loc) &&
            ((*entry)->rectangle.y + (int) (*entry)->rectangle.height > y_loc) )
            if ( *entry == smw->simple_menu.label )
                return(NULL);   /* cannot select the label. */
            else
                return(*entry);
    }
    
    return(NULL);
}

/*
 * submenu() pops up the sub-menu when the pointer is in
 * the right place.
 */
static void submenu(w, event, params, num_params)
Widget w;
XEvent * event;
String * params;
Cardinal * num_params;
{
    SmeObject entry;
    Position x_loc, y_loc;
    Arg arg[2];
    
    if ( !XtIsSensitive(w) ) return;
    
    entry = GetEventEntry(w, event);
 
    if (entry == NULL) return;
 
    if ( !XtIsSensitive( (Widget) entry))
        return;

    if ( (Widget) entry != his_gotomark || !menu_is_up)
	return;

    switch (event->type) {
    case MotionNotify:
        x_loc = event->xmotion.x;
        y_loc = event->xmotion.y;
        break;
    case EnterNotify:
    case LeaveNotify:
        x_loc = event->xcrossing.x;
        y_loc = event->xcrossing.y;
        break;
    case ButtonPress:
    case ButtonRelease:
        x_loc = event->xbutton.x;
        y_loc = event->xbutton.y;
        break;
    default:
        XtAppError(XtWidgetToApplicationContext(w),
                   "Unknown event type in GetEventEntry().");
        break;
    }
    if ((Position)(entry->rectangle.width - 30) > x_loc)
	return;

    XtSetArg(arg[0], XtNy, menu_y + entry->rectangle.y);
    XtSetArg(arg[1], XtNx, menu_x + entry->rectangle.width - 30  - 2);
    XtSetValues(markmenu, arg, 2);
    XtPopup(markmenu, XtGrabExclusive);
}

/* The actions we have to add. */
static XtActionsRec actionsList[] = {
    { "submenu", submenu },
};

/*
 * Keep track of the popup-state of the sub-menu, through
 * callbacks on popup and popdown.
 */
static void markmenuup(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
    markmenu_is_up = 1;
}

static void markmenudown(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
    markmenu_is_up = 0;
}

static XtCallbackRec markmenuup_callbacks[] = {
    { (XtCallbackProc) markmenuup, NULL },
    { (XtCallbackProc) NULL, NULL }
};

static XtCallbackRec markmenudown_callbacks[] = {
    { (XtCallbackProc) markmenudown, NULL },
    { (XtCallbackProc) NULL, NULL }
};

static Arg markmenu_args[] = {
    { XtNmenuOnScreen, (XtArgVal) True },
    { XtNpopupCallback, (XtArgVal) markmenuup_callbacks },
    { XtNpopdownCallback, (XtArgVal) markmenudown_callbacks },
};

/*
 * Alter the translations of the sub-menu for popping down the
 * submenu on leaving the window.
 */
static char markmenutranslations[] =
"   <EnterWindow>: highlight()\n\
    <LeaveWindow>: MenuPopdown() unhighlight()\n\
    <Motion>: highlight()\n\
    <BtnUp>: MenuPopdown() notify() unhighlight()\n";

/*
 * The items in the menu.
 */
static void undo(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
    popdown_choose_widget();
    history_backward();
    force_state(STATE_CHOOSE_INIT);
    trace_display("Undo\n");
    if (trace_to_stdout()) {
	printf(">undo\n");
	fflush(stdout);
    }
}

static XtCallbackRec undo_callbacks[] = {
    { (XtCallbackProc) undo, NULL },
    { (XtCallbackProc) NULL, NULL }
};

static Arg undo_args[] = {
    { XtNcallback, (XtArgVal) undo_callbacks },
    { XtNsensitive, (XtArgVal) False },
};

static void redo(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
    popdown_choose_widget();
    history_forward();
    if (!nr_processes_in_table())
	force_state(STATE_END);
    else
	force_state(STATE_CHOOSE_INIT);
    trace_display("Redo\n");
    if (trace_to_stdout()) {
	printf(">redo\n");
	fflush(stdout);
    }
}

static XtCallbackRec redo_callbacks[] = {
    { (XtCallbackProc) redo, NULL },
    { (XtCallbackProc) NULL, NULL }
};

static Arg redo_args[] = {
    { XtNcallback, (XtArgVal) redo_callbacks },
    { XtNsensitive, (XtArgVal) False },
};

static void mark(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
    popup_dialog(menu_x, menu_y, "Mark :", history_getmark(), history_addmark);
}

static XtCallbackRec mark_callbacks[] = {
    { (XtCallbackProc) mark, NULL },
    { (XtCallbackProc) NULL, NULL }
};

static Arg mark_args[] = {
    { XtNcallback, (XtArgVal) mark_callbacks },
    { XtNsensitive, (XtArgVal) False },
};

static void gotomark(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
}

static XtCallbackRec gotomark_callbacks[] = {
    { (XtCallbackProc) gotomark, NULL },
    { (XtCallbackProc) NULL, NULL }
};

#include "gotomark"
static Arg gotomark_args[] = {
    { XtNrightBitmap, (XtArgVal) 0 },
    { XtNrightMargin, (XtArgVal) 25 },
    { XtNcallback, (XtArgVal) gotomark_callbacks },
    { XtNsensitive, (XtArgVal) False },
};

static Widget dummy;
static Arg dummy_args[] = {
    { XtNvertSpace, (XtArgVal) -90 },
};

void init_history_widget(shell)
Widget shell;
{
    Pixmap gotomark;

    menu = XtCreatePopupShell("HISTORY", simpleMenuWidgetClass, shell,
	menu_args, XtNumber(menu_args));
    XtAppAddActions(app_context, actionsList, XtNumber(actionsList));
    XtOverrideTranslations(menu,
	XtParseTranslationTable(menutranslations));

    /* Use spaces in the name for undo to make the menu width enough. */
    his_undo = XtCreateManagedWidget("Undo              ", smeBSBObjectClass,
	menu, undo_args, XtNumber(undo_args));
    his_redo = XtCreateManagedWidget("Redo", smeBSBObjectClass,
	menu, redo_args, XtNumber(redo_args));
    his_mark = XtCreateManagedWidget("Mark", smeBSBObjectClass,
	menu, mark_args, XtNumber(mark_args));
    gotomark = XCreateBitmapFromData(XtDisplay(shell),
	RootWindowOfScreen(XtScreen(shell)), (char *) gotomark_bits,
	gotomark_width, gotomark_height);
    XtSetArg(gotomark_args[0], XtNrightBitmap, gotomark);
    his_gotomark = XtCreateManagedWidget("Goto Mark", smeBSBObjectClass,
	menu, gotomark_args, XtNumber(gotomark_args));

    markmenu = XtCreatePopupShell("MARK MENU", simpleMenuWidgetClass, shell,
	markmenu_args, XtNumber(markmenu_args));
    XtOverrideTranslations(markmenu,
	XtParseTranslationTable(markmenutranslations));
    /*
     * dummy is used to give the menu a height, because an empty menu
     * cause a X error.
     * It should be unmanaged when there are other menu-entries.
     */
    dummy = XtCreateManagedWidget("     ", smeBSBObjectClass,
	markmenu, dummy_args, XtNumber(dummy_args));

    /* Alloc minimum amount of sub-menu widgets */
    markentry = PSF_NMALLOC(struct entry, maxentryind);
}

/*
 * Control sensitivity of the menu-items.
 */
void activate_history_undo()
{
    XtSetSensitive(his_undo, True);
}

void deactivate_history_undo()
{
    XtSetSensitive(his_undo, False);
}

void activate_history_redo()
{
    XtSetSensitive(his_redo, True);
}

void deactivate_history_redo()
{
    XtSetSensitive(his_redo, False);
}

void activate_history_mark()
{
    XtSetSensitive(his_mark, True);
}

void deactivate_history_mark()
{
    XtSetSensitive(his_mark, False);
}

/*
 * Callback for the sub-menu.
 */
static void mark_select(w, number, garbage)
Widget w;
XtPointer number;
XtPointer garbage;
{
/*
    fprintf(stderr, "mark: %d\n", (int) number);
*/
    popdown_choose_widget();
    history_gotomark((unsigned long) number);
    if (!nr_processes_in_table())
	force_state(STATE_END);
    else
	force_state(STATE_CHOOSE_INIT);
    trace_display("Goto Mark %s\n", history_getmark());
    if (trace_to_stdout()) {
	printf(">goto %lu %s\n", (unsigned long) number, history_getmark());
	fflush(stdout);
    }
}

/*
 * Add/remove item to/from the sub-menu.
 */

void add_markbutton(s, i)
char *s;
unsigned long i;
{
    char s5[6];
    char *ps;

    if (entryind == maxentryind) {
	maxentryind *= 2;
	markentry = PSF_REALLOC(markentry, struct entry, maxentryind);
    }
    markentry[entryind].id = i;
    /*
     * Make it a minimum size of 5 characters.
     * The minimum width has to be at least the width of the rightsensivity
     * of gotomark.
     */
    if (strlen(s) < (size_t) 5) {
	sprintf(s5, "%-5s", s);
	ps = s5;
    } else
	ps = s;
    markentry[entryind].w = XtCreateManagedWidget(ps, smeBSBObjectClass,
	markmenu, NULL, 0);
    XtAddCallback(markentry[entryind].w, XtNcallback, mark_select,
	(XtPointer) i);
    if (!entryind) {
	XtSetSensitive(his_gotomark, True);
	XtUnmanageChild(dummy); /* now we don't need it */
    }
    entryind ++;
    popdown_dialog();
    trace_display("Mark %s\n", history_getmark());
    if (trace_to_stdout()) {
	printf(">mark %s\n", history_getmark());
	fflush(stdout);
    }
}

void remove_markbutton(id)
unsigned long id;
{
    int i;

    if (entryind == 1) /* to not to leave the menu empty */
	XtManageChild(dummy);

    for (i = 0; i < entryind; i ++) {
	if (markentry[i].id == id)
	    break;
    }
/*
    XtRemoveCallback(markentry[i].w, XtNcallback, mark_select,
	(XtPointer) i);
    XtUnmanageChild(markentry[i].w);
*/
    XtDestroyWidget(markentry[i].w);
    for (i ++; i < entryind; i ++) {
	markentry[i - 1].id = markentry[i].id;
	markentry[i - 1].w = markentry[i].w;
    }
    entryind --;
    if (!entryind) {
	XtSetSensitive(his_gotomark, False);
    }
    execute_events();
}

void do_undo()
{
    undo();
}

void do_redo()
{
    redo();
}

void do_mark(s)
char *s;
{
    history_addmark(s);
}

void do_goto(n, s)
unsigned long n;
char *s;
{
    int i;

    for (i = 0; i < entryind; i ++) {
	if (markentry[i].id == n)
	    break;
    }
    mark_select(markentry[i].w, (XtPointer) n, NULL);
}
