#include <stdio.h>
#include "psf_prototype.h"
#include "tiltype.h"
#include "process.h"
#include "alloccontrol.h"
#include "psf_malloc.h"
#include "historywid.h"

static struct ae_term *copy_ae_term_children(aet)
struct ae_term *aet;
{
    struct ae_term *h;
    int i;

    if (aet->a == 0)
	return(NULL);
    h = get_ae_list(aet->a); /* eqmterm */
    for (i = 0; i < aet->a; i ++) {
	h[i] = aet->ae_list[i];
	h[i].ae_list = copy_ae_term_children(&aet->ae_list[i]);
    }
    return(h);
}

static struct ae_term *copy_ae_term(aet)
struct ae_term *aet;
{
    struct ae_term *h;

    h = get_ae_term(); /* eqmterm */
    *h = *aet;
    h->ae_list = copy_ae_term_children(aet);
    return(h);
}

static struct process *copy_process(p, parent)
struct process *p;
struct process *parent;
{
    struct process *h;
    struct tailheap *ht, *pt;
    struct set_list *hsl, *psl, *endset;
    int i;

    /*
     * Alloc process and make a copy.
     */
    h = alloc_process();
    *h = *p;

    h->parent = parent;
    /*
     * Copy head and tail.
     */
    h->h_t = alloc_h_t();
    h->h_t->head = p->h_t->head;
    h->h_t->tail = NULL;
    h->h_t->top = p->h_t->top;
    if (p->h_t->top) {
	h->h_t->sub = copy_add_sub_to_sub(p->h_t->sub, NULL); /* match */
	h->h_t->top = p->h_t->top; /* 1 */
    } else {
	if (h->parent == NULL)
	    h->h_t->sub = NULL;
	else
	    h->h_t->sub = h->parent->h_t->sub;
    }
    if ((p->h_t->ae_t != NULL) && !(p->flag & PORT_PROCESS))
	h->h_t->ae_t = copy_ae_term(p->h_t->ae_t);
    else
	h->h_t->ae_t = p->h_t->ae_t;
    ht = NULL;
    for (pt = p->h_t->tail; pt != NULL; pt = pt->tail) {
	if (ht == NULL) {
	    ht = alloc_tail();
	    h->h_t->tail = ht;
	} else {
	    ht->tail = alloc_tail();
	    ht = ht->tail;
	}
	ht->expr = pt->expr;
	ht->nr = pt->nr;
	ht->tail = NULL;
    }
    if (p->h_t->string == NULL)
	h->h_t->string = NULL;
    else
	h->h_t->string = psf_strdup(p->h_t->string);

    /*
     * Copy set list.
     */
    h->set = hsl = NULL;
    if (p->parent != NULL)
	endset = p->parent->set;
    else
	endset = NULL;
    if (p->set == endset) {
	if (h->parent != NULL)
	    h->set = h->parent->set;
	else
	    h->set = NULL;
    } else {
	for (psl = p->set; psl != endset; psl = psl->next) {
	    if (hsl == NULL) {
		hsl = alloc_set();
		h->set = hsl;
	    } else {
		hsl->next = alloc_set();
		hsl = hsl->next;
	    }
	    *hsl = *psl;
	}
	if (hsl != NULL) {
	    if (h->parent != NULL)
		hsl->next = h->parent->set;
	    else
		hsl->next = NULL;
	}
    }

    /*
     * Copy sum vars.
     */
    if (h->nr_sumvar = p->nr_sumvar) {
	h->sumvar = PSF_NMALLOC(keytype, p->nr_sumvar);
	for (i = p->nr_sumvar - 1; i >= 0; i --)
	    h->sumvar[i] = p->sumvar[i];
    }

    return(h);
}

static struct process *copy_ptree(p, parent)
struct process *p;
struct process *parent;
{
    struct process *h;
    int i;

    if (p == NULL)
	return(NULL);
    h = copy_process(p, parent);
    if (p->nr_children) {
	h->child = alloc_child(p->nr_children);
	for (i = 0; i < p->nr_children; i ++) {
	    h->child[i] = copy_ptree(p->child[i], h);
	}
    }
    return(h);
}

struct his_str {
    int markid;
    char *mark;
    struct process *ptree;
    struct his_str *prev;
    struct his_str *next;
};
static struct his_str *his_list = NULL;

static int markid = 0;

static void add_ptree(pt)
struct process *pt;
{
    struct his_str *hs;

    hs = PSF_MALLOC(struct his_str);
    hs->ptree = pt;
    hs->next = NULL;
    hs->prev = his_list;
    hs->mark = NULL;
    hs->markid = markid ++;
    if (his_list != NULL)
	his_list->next = hs;
    his_list = hs;
}

static void destroy_ptree(p)
struct process *p;
{
    int i;

    for (i = 0; i < p->nr_children; i++)
	if (p->child[i] != NULL)
	    destroy_ptree(p->child[i]);
    destroy_process(p);
}

static void delete_future()
{
    struct his_str *h1, *h2;

    if (his_list == NULL)
	return;
    for (h1 = his_list->next; h1 != NULL; ) {
	h2 = h1;
	h1 = h2->next;
	if (h2->ptree != NULL)
	    destroy_ptree(h2->ptree);
	if (h2->mark != NULL) {
	    PSF_FREE(h2->mark);
	    remove_markbutton(h2->markid);
	}
	PSF_FREE(h2);
	markid --;
    }
}

static int history_move = 0;

int history_save()
{
    int rv;

#ifdef DEBUG_MEMUSE
    return;
#endif /* DEBUG_MEMUSE */
    if (!history_move) {
	delete_future();
	add_ptree(copy_ptree(get_process_table(), NULL));
	rv = 1;
    } else {
	history_move = 0;
	rv = 0;
    }
    if (his_list->prev != NULL && his_list->prev->prev == NULL)
	activate_history_undo();
    if (his_list->next == NULL)
	deactivate_history_redo();
    if (his_list->prev == NULL)
	activate_history_mark();
    return(rv);
}

static void ptree_to_table(p)
struct process *p;
{
    int i;

    if (p == NULL)
	return;
    p->next = NULL;
    add_process_to_table(p);
    for (i = 0; i < p->nr_children; i ++) {
	ptree_to_table(p->child[i]);
    }
}

void history_backward()
{
    destroy_process_table();
    his_list = his_list->prev;
    ptree_to_table(copy_ptree(his_list->ptree, NULL));
    if (his_list->prev == NULL)
	deactivate_history_undo();
    activate_history_redo();
    history_move = 1;
}

void history_forward()
{
    destroy_process_table();
    his_list = his_list->next;
    ptree_to_table(copy_ptree(his_list->ptree, NULL));
    if (his_list->next == NULL)
	deactivate_history_redo();
    activate_history_undo();
    history_move = 1;
}

void history_reset()
{
    struct his_str *h;

    delete_future();
    while (his_list != NULL) {
	his_list->next = NULL;
	h = his_list;
	his_list = his_list->prev;
	if (h->ptree != NULL)
	    destroy_ptree(h->ptree);
	if (h->mark != NULL) {
	    PSF_FREE(h->mark);
	    remove_markbutton(h->markid);
	}
	PSF_FREE(h);
	markid --;
    }
    deactivate_history_undo();
    deactivate_history_redo();
    deactivate_history_mark();
}

void history_gotomark(id)
int id;
{
    if (his_list->markid == id)
	return;
    if (his_list->markid > id) {
	for ( ; his_list->markid != id; his_list = his_list->prev);
	if (his_list->prev == NULL)
	    deactivate_history_undo();
	activate_history_redo();
    } else {
	for ( ; his_list->markid != id; his_list = his_list->next);
	if (his_list->next == NULL)
	    deactivate_history_redo();
	activate_history_undo();
    }
    destroy_process_table();
    ptree_to_table(copy_ptree(his_list->ptree, NULL));
    history_move = 1;
}

void history_addmark(s)
char *s;
{
    if (his_list->mark != NULL) {
	PSF_FREE(his_list->mark);
	remove_markbutton(his_list->markid);
    }
    his_list->mark = psf_strdup(s);
    add_markbutton(his_list->mark, his_list->markid);
}

char *history_getmark()
{
    return(his_list->mark);
}

/* Just for trace from stdin */
void unset_history_move()
{
    history_move = 0;
}
