#include <stdio.h>
#include <string.h>
#include "psf_prototype.h"
#include "tiltype.h"
#include "tilutil.h"
#include "simutil.h"
#include "tracewid.h"
#include "eqm.h"
#include "eqm_local.h"
#include "process.h"
#include "msprint.h"
#include "freetil.h"
#include "statecontrol.h"
#include "alloccontrol.h"
#include "functionwid.h"
#include "headtail.h"
#include "fieldex.h"
#include "psf_standards.h"
#include "simoption.h"
#include "sumport.h"
#include "summerge.h"
#include "messagewid.h"

static eqm_t *eqm;

eqm_t *get_eqm()
{
    return (eqm);
}

void init_head_tail()
{
    int i;
    struct module *mod;

    mod = get_til_module();
    eqm = create_eqm(mod->entries_table[FUN]);
    for (i = 1; i <= mod->entries_table[EQU]; i++)
	eqm = add_equation(eqm, mod->equ[i]);
}

void add_tail(h_t, expr)
    struct head_tail *h_t;
    struct process_expr *expr;
{
    struct tailheap *new_tail;

    new_tail = alloc_tail();
    new_tail->expr = expr;
    new_tail->nr = 0;
    new_tail->tail = h_t->tail;
    h_t->tail = new_tail;
}

void delete_tail(h_t)
    struct head_tail *h_t;
{
    struct tailheap *old_tail;

    if (h_t->tail == NULL)
	return;
    old_tail = h_t->tail;
    h_t->tail = old_tail->tail;
    free_tail(old_tail);
}

static void mark_tree PROTO_ARGS((struct process *p, int flag));

int next_head_tail(p)
    struct process *p;
{
    register struct head_tail *h_t;
    struct process_expr *expr;
    arity a;
    struct process *parent, *newp;
    struct set_list *sl;
    int nr;
    int i;

    h_t = p->h_t;
    if (h_t->string != NULL) {
	free_string(h_t->string);
	h_t->string = NULL;
    }
    if (h_t->ae_t != NULL) {
	ae_term_free(h_t->ae_t);
	h_t->ae_t = NULL;
    }
    if (h_t->tail == NULL || p->flag & DEADLOCK) {
	/* process ends, so wake it's parent */
	parent = p->parent;

#ifdef	DEBUG
	fprintf(stderr, "SIGNAL from %d to parent ", p->id);
	if (parent != NULL)
	    fprintf(stderr, "%d\n", parent->id);
	else
	    fprintf(stderr, "---\n");
#endif

	if (parent != NULL) {
	    awaken_process(parent, p);
	    if (p->flag & DEADLOCK)
		parent->flag |= DEADLOCK;
	    delete_process_from_table(p);
	    destroy_process(p);
	} else if (!(p->flag & DEADLOCK)) {
	    delete_process_from_table(p);
	    destroy_process(p);
	}
	if (parent != NULL) {
	    if ((!parent->sleeping) || parent->h_t->tail->expr->fun == INTR ||
		    parent->h_t->tail->expr->fun == DISR ||
		    parent->h_t->tail->expr->fun == STAR ||
		    parent->h_t->tail->expr->fun == SHARP)
		return (next_head_tail(parent));
	    else if (parent->sleeping == 1 &&
		parent->h_t->tail->expr->fun == PAR) {
		if (parent->h_t->tail->tail == NULL && parent->parent != NULL) {
		    struct process *gp;
		    int j;

		    gp = parent->parent;
		    for (i = gp->nr_children - 1; i >= 0; i--) {
			if (gp->child[i] == parent) {
			    
			    for (j = 0; parent->child[j] == NULL; j++);
			    gp->child[i] = parent->child[j];
			    parent->child[j]->parent = gp;
			    parent->set = NULL;
			    /* take sub with us */
			    if (parent->h_t->top) {
				if (Option_Test) {
				    gp->h_t->top = 1;
				    gp->h_t->sub = parent->h_t->sub;
				    parent->h_t->top = 0;
				} else {
				    if (parent->child[j]->h_t->sub ==
					parent->h_t->sub) {
					parent->child[j]->h_t->top = 1;
					parent->h_t->top = 0;
				    }
				}
			    }
			    delete_process_from_table(parent);
			    destroy_process(parent);
			}
		    }
		}
		return(0);
	    }
	    else
		return (0);
	} else
	    return (-1);
    }
    expr = h_t->tail->expr;
    switch (expr->fun) {
    case SEQ:
	a = expr->proc_expr.pe3.a;
	if (++h_t->tail->nr == a) {
	    /* no more arguments of SEQ */
	    delete_tail(h_t);
	    return (next_head_tail(p));
	} else {
	    /* next argument of SEQ */
	    nr = h_t->tail->nr;
	    if (nr + 1 == a)
		delete_tail(h_t);
	    /* deleting the tail makes it possible to remove extra processes */
	    add_tail(h_t, &expr->
		     proc_expr.pe3.pe[nr]);
	    return (make_head_tail(p));
	}

#ifdef SUMMERGE
    case INTR:
	if (p->nr_children && p->child[0] != NULL) {
	    if (p->child[0]->flag & DISABLED_PROCESS) {
		newp = create_process(p, &p->h_t->tail->
		      expr->proc_expr.pe3.pe[1]);
		newp->flag = TEMP_PROCESS;
		add_process_to_table(newp);
		p->child[1] = newp;
		mark_tree(p->child[0], DISABLED_PROCESS);
		p->sleeping ++;
		return(make_head_tail(p->child[1]));
	    }
	} else {
	    if (p->child != NULL) {
		destroy_process_tree(p, p->child[0]);
		p->child[1] = NULL;
	    }
	    free_child(p->child);
	    p->child = NULL;
	    p->sleeping = 0;
	    p->nr_children = 0;
	}
	delete_tail(h_t);
	return (next_head_tail(p));
    case DISR:
	/*
	 * if nr_children == 0, we had a disrupt process consisting of a
	 * single action (only necessary if it ain't the top-process
	 */
	if (p->nr_children) {
	    if (p->child[1] != NULL) {
		destroy_process_tree(p, p->child[0]);
		p->child[1] = NULL;
		free_child(p->child);
		p->child = NULL;
		p->sleeping = 0;
		p->nr_children = 0;
	    }
	}
	delete_tail(h_t);
	return (next_head_tail(p));
    case STAR:
	p->loop_count --;
	if (p->loop_count < 0) {
	    if (p->child == NULL)
		alloc_children(p, 1);
	    p->child[0] = create_process(p, &p->h_t->tail->expr->
		proc_expr.pe3.pe[0]);
	    p->child[0]->flag = TEMP_PROCESS;
	    add_process_to_table(p->child[0]);
	    if (p->nr_children > 1)
		mark_tree(p->child[1], DISABLED_PROCESS);
	    p->sleeping ++;
	    return(make_head_tail(p->child[0]));
	}
	delete_tail(h_t);
	return (next_head_tail(p));
    case SHARP:
	p->loop_count --;
	if (p->loop_count != 0) {
	    if (p->loop_count > 0 && p->sleeping == 1) {
		if (p->child[0]->flag & DISABLED_PROCESS)
		    mark_tree(p->child[0], DISABLED_PROCESS);
		return(0);
	    }
	    if (p->child == NULL)
		alloc_children(p, 1);
	    p->child[0] = create_process(p, &p->h_t->tail->expr->
		proc_expr.pe3.pe[0]);
	    p->child[0]->flag = TEMP_PROCESS;
	    add_process_to_table(p->child[0]);
	    p->sleeping ++;
	    if (p->sleeping > 1)
		if (p->child[1]->flag & DISABLED_PROCESS)
		    mark_tree(p->child[1], DISABLED_PROCESS);
	    return(make_head_tail(p->child[0]));
	}
	if (p->sleeping) {
	    p->nr_children = 1;
	    destroy_process_tree(p, NULL);
	    free_child(p->child);
	    p->child = NULL;
	    p->sleeping = 0;
	    p->nr_children = 0;
	}
	delete_tail(h_t);
	return (next_head_tail(p));
    case ALT:
    case SUM:
    case MRG:
    case PAR: /* we want to see <p> in process_status */
    case PRIO:
	delete_tail(h_t);
	return (next_head_tail(p));
#endif

    case ENC:
    case HID:
	sl = p->set;
	p->set = sl->next;
	free_set(sl);
	delete_tail(h_t);
	return (next_head_tail(p));
	/* all other cases */
    default:
	return (make_head_tail(p));
    }
}

int cmp_ae_term(aet1, aet2)
    struct ae_term *aet1;
    struct ae_term *aet2;
{
    int i;
    int res;

    if (aet1->ind.table != aet2->ind.table)
	return (aet1->ind.table - aet2->ind.table);
    if (aet1->ind.key != aet2->ind.key)
	return (aet1->ind.key - aet2->ind.key);
    if (aet1->a != aet2->a)
	return (aet1->a - aet2->a);
    for (i = 0; i < aet1->a; i++) {
	res = cmp_ae_term(&aet1->ae_list[i], &aet2->ae_list[i]);
	if (res)
	    return (res);
    }
    return (0);
}

int make_head_tail(p)
    struct process *p;
{
    register struct head_tail *h_t;
    struct process_expr *expr;
    struct process *newp;
    int nr, i;
    struct set_list *new_set_list;
    keytype key;
    struct module *mod;
    int ret_value;
    struct process_expr *pe;
    struct process *parent;
    struct ae_term *aex, *aey;
    int res;
    char *f;

    h_t = p->h_t;

#ifdef	DEBUG
    if (h_t->tail->expr->fun == AET)
	fprintf(stderr, "-AET-");
    else
	fprintf(stderr, "-%c-", h_t->tail->expr->fun);
#endif

    switch (h_t->tail->expr->fun) {
    case AET:
	expr = h_t->tail->expr;
	if (expr->proc_expr.pe2.ind.table == ATM) {
	    /* found head */
	    h_t->head = expr;
	    delete_tail(h_t);
	    if (h_t->ae_t != NULL) {
		ae_term_free(h_t->ae_t);
		h_t->ae_t = NULL;
	    }
	    h_t->ae_t = term_instantiate(&expr-> proc_expr.pe2, h_t->sub,
		eqm);
	    p->encaps_flag = atom_in_set_list(h_t->ae_t, p->set, ENC);
	    p->hide_flag = atom_in_set_list(h_t->ae_t, p->set, HID);
	    make_head_string(p);
	    return (0);
	} else {
	    /*
	     * Function may not appear here, so it must be
	     * a process.
	     */
	    if (h_t->ae_t != NULL) {
		ae_term_free(h_t->ae_t);
		h_t->ae_t = NULL;
	    }
	    h_t->ae_t = term_instantiate(&expr->
					 proc_expr.pe2, h_t->sub, eqm);
	    ret_value = match_process(p);
	    if (ret_value != -1)
		remove_loop_process(p);
	    return (0);
	}
    case SKP:	/* just skip */
	h_t->head = h_t->tail->expr;
	delete_tail(h_t);
	make_head_string(p);
	/* clear flags */
	p->encaps_flag = NULL;
	p->hide_flag = NULL;
	return (0);
    case DLK:	/* It's like a no match */
	parent = p->parent;
	if (parent != NULL) {
	    awaken_process(parent, p);
	    delete_process_from_table(p);
	    destroy_process(p);
	    parent->flag |= DEADLOCK;
	    if (!parent->sleeping)
		(void) next_head_tail(parent);
/*
	    remove_loop_process(parent);
*/
	} else {
	    delete_process_from_table(p);
	    destroy_process(p);
	    force_state(STATE_DEADLOCK);
	}
	return (0);
    case INTR:
    case DISR:
	nr = h_t->tail->expr->proc_expr.pe3.a;
	alloc_children(p, nr);
	put_process_to_sleep(p, nr + 1);
	p->child[0] = create_process(p, &h_t->tail->expr->proc_expr.pe3.pe[0]);
	p->child[1] = create_process(p, &h_t->tail->expr->proc_expr.pe3.pe[1]);
	    /*
	     * child[1] created here because of remove_loop_process when
	     * child[0] is deadlock.
	     */
	p->child[0]->flag = TEMP_PROCESS;
	add_process_to_table(p->child[0]);
	ret_value = make_head_tail(p->child[0]);
	if (p->child[0] == NULL) { /* deadlock */
	    destroy_process(p->child[1]);
	    p->child[1] = NULL;
	    free_child(p->child);
	    p->child = NULL;
	    p->nr_children = 0;
	    p->sleeping = 0;
	    p->parent->sleeping --;
	    p->flag |= DEADLOCK;
	    p->parent->flag |= DEADLOCK;
	    return(ret_value);
	}
	p->child[1]->flag = TEMP_PROCESS;
	add_process_to_table(p->child[1]);
	make_head_tail(p->child[1]);
	if (p->child[1] == NULL)
	    p->flag &= ~DEADLOCK;
		/* There is no interrupt possible, but no DLK */
	p->sleeping --;
	return(ret_value);
    case STAR:
    case SHARP:
	nr = h_t->tail->expr->proc_expr.pe3.a;
	alloc_children(p, nr);
	put_process_to_sleep(p, nr + 1);
	p->child[0] = create_process(p, &h_t->tail->expr->proc_expr.pe3.pe[0]);
	p->child[1] = create_process(p, &h_t->tail->expr->proc_expr.pe3.pe[1]);
	    /*
	     * child[1] created here because of remove_loop_process when
	     * child[0] is deadlock.
	     */
	p->child[0]->flag = TEMP_PROCESS;
	add_process_to_table(p->child[0]);
	ret_value = make_head_tail(p->child[0]);
	if (p->sleeping == nr)
	    p->loop_count = 1;
	else
	    p->loop_count = 0;
	p->child[1]->flag = TEMP_PROCESS;
	add_process_to_table(p->child[1]);
	ret_value = make_head_tail(p->child[1]);
	p->sleeping --;
	if (p->sleeping)
	    p->flag &= ~DEADLOCK;
	return(ret_value);
    case ALT:	/*
		 * For each argument make a temporary process,
		 * and find head and tail for each of them.
		 * When one of these heads is chosen, the
		 * temporary processes not involved with this
		 * choice must be deleted. And the unnecessary
		 * processes for this choice (the processes
		 * made by the ALT operator) must be deleted
		 * also.
		 */
	nr = h_t->tail->expr->proc_expr.pe3.a;
	alloc_children(p, nr);
	put_process_to_sleep(p, nr + 1);
	for (i = nr - 1; i >= 0; i--) {
	    newp = create_process(p, &h_t->tail->
				  expr->proc_expr.pe3.pe[i]);
	    newp->flag = TEMP_PROCESS;
	    add_process_to_table(newp);
	    p->child[i] = newp;
	}
	for (i = nr - 1; i >= 0; i--)
	    make_head_tail(p->child[i]);
	p->sleeping --;

	/*
	 * Remove unnecessary process.
	 */
	if (p->sleeping == 1) {
	    if (p->h_t->tail->tail == NULL && p->parent != NULL) {
		struct process *parent;
		int j;

		parent = p->parent;
		for (i = parent->nr_children - 1; i >= 0; i--) {
		    if (parent->child[i] == p) {
			for (j = 0; p->child[j] == NULL; j++);
			parent->child[i] = p->child[j];
			p->child[j]->parent = parent;
			p->set = NULL;
			/* take sub with us */
			if (p->h_t->top) {
			    if (Option_Test) {
				parent->h_t->top = 1;
				parent->h_t->sub = p->h_t->sub;
				p->h_t->top = 0;
			    } else {
				if (p->child[j]->h_t->sub == p->h_t->sub) {
				    p->child[j]->h_t->top = 1;
				    p->h_t->top = 0;
				}
			    }
			}
			delete_process_from_table(p);
			destroy_process(p);
		    }
		}
		p = parent;
	    }
	}

	if (p->sleeping)
	    p->flag &= ~DEADLOCK;
	if (!nr_processes_in_table())
	    return (-1);
	else
	    return (0);
    case SEQ:	/* continue with the first argument */
	h_t->tail->nr = 0;
	add_tail(h_t, &h_t->tail->expr->
		 proc_expr.pe3.pe[0]);
	return (make_head_tail(p));
    case PAR:	/* for each argument make a new process */
	nr = h_t->tail->expr->proc_expr.pe3.a;
	pe = h_t->tail->expr->proc_expr.pe3.pe;
/* we want <p> to appear in process-status (see next_head_tail)
	delete_tail(h_t);
*/
	alloc_children(p, nr);
	put_process_to_sleep(p, nr + 1);
	for (i = nr - 1; i >= 0; i--, pe++) {
	    newp = create_process(p, pe);
	    add_process_to_table(newp);
	    p->child[i] = newp;
	}
	for (i = nr - 1; i >= 0; i--)
	    make_head_tail(p->child[i]);
	p->sleeping--;
	if (!p->sleeping) {
	    if ((parent = p->parent) != NULL) {
		awaken_process(parent, p);
		parent->flag |= DEADLOCK;
		delete_process_from_table(p);
		destroy_process(p);
	    }
	}

	return (0);
    case SUM:

#ifdef SUMMERGE
	mod = get_til_module();
	key = h_t->tail->expr->proc_expr.pe1.ind.key;
	if (mod->var[key].ind.table == SET) {
	    key = mod->var[key].ind.key;
	    if ((f = get_ff_field("enum", mod->set[key].ff)) != NULL)
		sscanf(f, "%d", &key);
	} else {
	    key = mod->var[key].ind.key;
	    if ((f = get_ff_field("enum", mod->sor[key].ff)) != NULL)
		sscanf(f, "%d", &key);
	    else
		goto noenumsum;
	}
	if (!make_set_tree(p, &mod->set[key], ALT, eqm)) {
/*
	    if (p->sleeping)
		p->flag &= ~DEADLOCK;
*/
	    return (0);
	}
noenumsum:
	h_t->head = h_t->tail->expr;
	p->encaps_flag = NULL;
	decide_sumport(p); /* check for port */
	make_head_string(p);
	return (0);
#else
	message_display("sum not implemented.\n");
	p->flag = DEADLOCK;
	force_state(STATE_HALT);
#endif

	break;
    case MRG:

#ifdef SUMMERGE
	mod = get_til_module();
	key = h_t->tail->expr->proc_expr.pe1.ind.key;
	if (mod->var[key].ind.table == SET) {
	    key = mod->var[key].ind.key;
	    if ((f = get_ff_field("enum", mod->set[key].ff)) != NULL)
		sscanf(f, "%d", &key);
	} else {
	    key = mod->var[key].ind.key;
	    if ((f = get_ff_field("enum", mod->sor[key].ff)) != NULL)
		sscanf(f, "%d", &key);
	    else
		goto noenummrg;
	}
	if (!make_set_tree(p, &mod->set[key], PAR, eqm)) {
/*
	    if (p->sleeping)
		p->flag &= ~DEADLOCK;
*/
	    return (0);
	}
noenummrg:
	key = h_t->tail->expr->proc_expr.pe1.ind.key;
	message_display("Merge only implemented for set enumeration (%s %s).\n",
	    mod->var[key].ind.table == SET ? "set" : "sort",
	    field_extract("n", mod->var[key].ind.table == SET ?
		mod->set[mod->var[key].ind.key].ff :
		mod->sor[mod->var[key].ind.key].ff,
		mod->var[key].ind.table, mod->var[key].ind.key));
	p->flag = DEADLOCK;
	force_state(STATE_HALT);
#else
	message_display("merge not implemented.\n");
	p->flag = DEADLOCK;
	force_state(STATE_HALT);
#endif

	break;
    case ENC:
	new_set_list = alloc_set();
	key = h_t->tail->expr->proc_expr.pe1.ind.key;
	mod = get_til_module();
	while (mod->set[key].u_tag == 0) {
	    if (mod->set[key].construct.sort.table !=
		    SET) {
		if (mod->set[key].construct.sort.key == 0)
		    break;
		message_display("%s\n",
				"encaps botch.");
		force_state(STATE_HALT);
		return (2);
	    }
	    key = mod->set[key].construct.sort.key;
	}
	new_set_list->set = &mod->
	    set[key].construct.set_term;
	new_set_list->next = p->set;
	new_set_list->stype = ENC;
	new_set_list->key = key; /* for port checking */
	p->set = new_set_list;
	add_tail(h_t, h_t->tail->expr->
		 proc_expr.pe1.pe);
	return (make_head_tail(p));
    case HID:
	new_set_list = alloc_set();
	key = h_t->tail->expr->proc_expr.pe1.ind.key;
	mod = get_til_module();
	while (mod->set[key].u_tag == 0) {
	    if (mod->set[key].construct.sort.table !=
		    SET) {
		if (mod->set[key].construct.sort.key == 0)
		    break;
		message_display("%s\n",
				"hide botch.");
		force_state(STATE_HALT);
		return (2);
	    }
	    key = mod->set[key].construct.sort.key;
	}
	new_set_list->set = &mod->
	    set[key].construct.set_term;
	new_set_list->next = p->set;
	new_set_list->stype = HID;
	new_set_list->key = key; /* for port checking */
	p->set = new_set_list;
	add_tail(h_t, h_t->tail->expr->
		 proc_expr.pe1.pe);
	return (make_head_tail(p));
    case IF:
	expr = h_t->tail->expr;
	aex = term_instantiate(&expr->
			       proc_expr.pe4.aex, h_t->sub, eqm);
	aey = term_instantiate(&expr->
			       proc_expr.pe4.aey, h_t->sub, eqm);
	res = cmp_ae_term(aex, aey);
	ae_term_free(aex);
	ae_term_free(aey);
	if (res == 0) {
	    delete_tail(h_t);
	    add_tail(h_t, expr->proc_expr.pe4.pe);
	    return (make_head_tail(p));
	} else {
	    if ((parent = p->parent) != NULL) {
		awaken_process(parent, p);
		parent->flag |= DEADLOCK;
		delete_process_from_table(p);
		destroy_process(p);
	    } else
		p->flag |= DEADLOCK;
	    return (0);
	}
    case PRIO:
	alloc_children(p, 1);
	put_process_to_sleep(p, 1);
	p->child[0] = create_process(p, h_t->tail->expr->proc_expr.pe5.pe);
	add_process_to_table(p->child[0]);
	return(make_head_tail(p->child[0]));
    }
    return (2);
}


int check_set_var(sub)
    subst_t *sub;
{
    subst_elem_t *se;
    struct module *mod;
    int key;
    struct ae_term *aet;
    int r;

    se = sub->sb_elems;
    mod = get_til_module();
    while (se != NULL) {
	key = se->var.key;
	if (mod->var[key].ind.table == SET) {
	    aet = term2ae_term(se->value);
	    key = mod->var[key].ind.key;
	    r = member_of_sortset(mod, aet, &mod-> set[key]);
	    ae_term_free(aet);
	    if (!r)
		return (0);
	}
	se = se->next_se;
    }
    return (1);
}

int check_set_sumvar(se, sumvar)
    subst_elem_t *se;
    keytype sumvar;
{
    int i;
    struct module *mod;
    struct ae_term *aet;
    int r;

    mod = get_til_module();
    if (mod->var[sumvar].ind.table == SET) {
	aet = term2ae_term(se->value);
	r = member_of_sortset(mod, aet, &mod->set[mod->var[sumvar].ind.key]);
	ae_term_free(aet);
	return(r);
    }
    return(1);
}

static struct process_expr alt_expr = {ALT};

int match_process(p)
    struct process *p;
{
    keytype key;
    int i;
    struct module *mod;
    struct process *newp, *oldp;
    int nrmp;
    int ret_value;
    struct process *parent;
    subst_t *sub;

    if (break_on(&p->h_t->ae_t->ind)) {
	msprint_ae_term(p->h_t->ae_t);
	trace_display("break> process %s\n", get_msp());
	set_random_choose(0);
    }
    mod = get_til_module();
    key = p->h_t->tail->expr->proc_expr.pe2.ind.key;
    newp = NULL;
    nrmp = 0;
    for (i = mod->entries_table[DEF]; i > 0; i--) {
	if (mod->def[i].ae_t.ind.key == key) {
	    sub = term_match(&mod->def[i].ae_t, p->h_t->ae_t);
	    if (sub == NULL)
		continue;
	    if (!check_set_var(sub)) {
		subst_free(sub);
		continue;
	    }
	    oldp = newp;
	    newp = create_process(p, &mod->def[i].p_expr);
	    if (sub->sb_elems != NULL) {
		newp->h_t->sub = sub;
		newp->h_t->top = 1;
	    } else {
		newp->h_t->sub = p->h_t->sub;
		newp->h_t->top = 0;
		subst_free(sub);
	    }
	    newp->flag = TEMP_PROCESS;
	    newp->next = oldp;
	    nrmp++;
	}
    }
    if (nrmp) {
	p->h_t->tail->expr = &alt_expr;
	alloc_children(p, nrmp);
	put_process_to_sleep(p, nrmp + 1);
	i = 0;
	while (newp != NULL) {
	    p->child[i] = newp;
	    add_process_to_table(newp);
	    newp = newp->next;
	    i++;
	}

	if (trace_on(&p->h_t->ae_t->ind)) {
	    msprint_ae_term(p->h_t->ae_t);
	    trace_display("trace> process %s\n",
			  get_msp());
	}
	for (i = 0; i < nrmp; i++)
	    ret_value = make_head_tail(p->child[i]);
	p->sleeping--;
	if (p->sleeping)
	    p->flag &= ~DEADLOCK;
	return (ret_value);
    }
    parent = p->parent;

    if (trace_on(&p->h_t->ae_t->ind)) {
	msprint_ae_term(p->h_t->ae_t);
	trace_display("trace> process %s : No Match\n",
		      get_msp());
    }

#ifdef	DEBUG
    fprintf(stderr, "SIGNAL from %d to parent ", p->id);
    if (parent != NULL)
	fprintf(stderr, "%d\n", parent->id);
    else
	fprintf(stderr, "---\n");
#endif

    if (parent != NULL) {
	awaken_process(parent, p);
	delete_process_from_table(p);
	destroy_process(p);
	parent->flag |= DEADLOCK;
	if (!parent->sleeping)
	    (void) next_head_tail(parent);
	return (-1);
    } else {
	delete_process_from_table(p);
	destroy_process(p);
	force_state(STATE_DEADLOCK);
	return (-1);
    }
}

static void mark_tree(p, flag)
struct process *p;
int flag;
{
    int i;

    p->flag ^= flag;
    for (i = 0; i < p->nr_children; i ++)
	if (p->child[i] != NULL)
	    mark_tree(p->child[i], flag);
}

struct process *remove_alternate_processes(p)
    struct process *p;
{
    struct process *parent, *return_process;
    int i;
    char fun;

    return_process = p;
    while (p->flag & TEMP_PROCESS) {
	parent = p->parent;
	if (parent->h_t->tail == NULL) {
	    p = parent;
	    continue;
	}
	fun = parent->h_t->tail->expr->fun;
	switch (fun) {
	case ALT:
	case SUM:
	    destroy_process_tree(parent, p);
	    for (i = 0; i < parent->nr_children; i++)
		if (parent->child[i] == p)
		    parent->child[i] = NULL;
	    parent->child[0] = p;
	    parent->sleeping = 1;
	    parent->nr_children = 1;

	    /*
	     * Remove unnecessary parent.
	     */
	    if (parent->h_t->tail->tail == NULL && parent->parent != NULL) {
		struct process *gp;
		int j;

		gp = parent->parent;
		for (i = gp->nr_children - 1; i >= 0; i--) {
		    if (gp->child[i] == parent) {
			for (j = 0; parent->child[j] == NULL; j++);
			gp->child[i] = parent->child[j];
			parent->child[j]->parent = gp;
			parent->set = NULL;
			/* take sub with us */
			if (parent->h_t->top) {
			    if (Option_Test) {
				gp->h_t->top = 1;
				gp->h_t->sub = parent->h_t->sub;
				parent->h_t->top = 0;
			    } else {
				if (parent->child[j]->h_t->sub ==
				    parent->h_t->sub) {
				    parent->child[j]->h_t->top = 1;
				    parent->h_t->top = 0;
				}
			    }
			}
			delete_process_from_table(parent);
			destroy_process(parent);
		    }
		}
		parent = gp;
		break;
	    }

	    remove_loop_process(parent);
	    if (p->parent == parent) {
		p = parent;
	    }
	    /*
	     * Don't remove ALT-child processes, cause the sub for the tail is
	     * different from the sub of the remaining child
	     */
		
	    break;

	case DISR:
	    if (p == parent->child[1]) {
		destroy_process_tree(parent, p);
		for (i = 0; i < parent->nr_children; i++)
		    if (parent->child[i] == p)
			parent->child[i] = NULL;
		parent->child[0] = p;
		parent->sleeping = 1;
		parent->nr_children = 1;
		remove_loop_process(parent);
		if (p->parent == parent) {
		    p = parent;
		}
	    } else
		p = parent;
	    break;
	case INTR:
	    if (p == parent->child[1]) {
		if (!(parent->child[0]->flag & DISABLED_PROCESS))
		    /*
		     * Only disabling it once, otherwise it gets enabled.
		     */
		    mark_tree(parent->child[0], DISABLED_PROCESS);
	    }
	    p = parent;
	    break;
	case STAR:
	    if (p == parent->child[1]) {
		destroy_process_tree(parent, p);
		for (i = 0; i < parent->nr_children; i++)
/*
		    if (parent->child[i] == p)
*/
			parent->child[i] = NULL;
		parent->child[0] = p;
		parent->sleeping = 1;
		parent->nr_children = 1;
		if (parent->loop_count <= 0)
		    parent->loop_count = 1 - parent->loop_count;
		remove_loop_process(parent);
		if (p->parent == parent) {
		    p = parent;
		}
	    } else {
		if (parent->sleeping > 1)
		    /*
		     * if the second operand is deadlock, then it is for sure
		     * that sleeping == 1 (nr_children maybe 1 or 2)
		     */
		    if (!(parent->child[1]->flag & DISABLED_PROCESS)) {
			mark_tree(parent->child[1], DISABLED_PROCESS);
		    }
		p = parent;
	    }
	    break;
	case SHARP:
	    if (parent->loop_count > 0) {
		p = parent;
		break;
	    }
	    if (p == parent->child[1]) {
		if (!(parent->child[0]->flag & DISABLED_PROCESS)) {
		    mark_tree(parent->child[0], DISABLED_PROCESS);
		    parent->loop_count = 1 - parent->loop_count;
		}
		p = parent;
	    } else {
		if (parent->sleeping > 1)
		    /*
		     * if the second operand is deadlock, then it is for sure
		     * that sleeping == 1 (nr_children maybe 1 or 2)
		     */
		    if (!(parent->child[1]->flag & DISABLED_PROCESS)) {
			mark_tree(parent->child[1], DISABLED_PROCESS);
		    }
		p = parent;
	    }
	    break;
	default:
	    p = parent;
	    break;
	}
    }
    mark_process_tree(p, NORMAL_PROCESS);
    remove_loop_process(p);
    return (return_process);
}

void destroy_process_tree(p, child)
    struct process *p;
    struct process *child;
{
    int i;

    for (i = 0; i < p->nr_children; i++) {
	if (p->child[i] == child)
	    continue;
	if (p->child[i] == NULL)
	    continue;
	if (p->child[i]->nr_children)
	    destroy_process_tree(p->child[i], (struct process *)
				 NULL);
	delete_process_from_table(p->child[i]);
	destroy_process(p->child[i]);
	p->child[i] = NULL; /* Just in case */
    }
}

void make_head_string(p)
    struct process *p;
{
    register struct head_tail *h_t;

    h_t = p->h_t;
    if (h_t->string != NULL)
	fprintf(stderr, "head not freed\n");
    if (h_t->head->fun == SKP)
	msprintf("skip<%u>", h_t->head->proc_expr.nr);
    else if (h_t->head->fun == DLK)
	msprintf("delta");
    else if (h_t->head->fun == SUM)
	msprint_process_expr_sub(h_t->head, h_t->sub);
    else if (p->hide_flag != NULL) {
	msprintf("skip ");
	msprint_ae_term(h_t->ae_t);
    } else
	msprint_ae_term(h_t->ae_t);
    h_t->string = get_ms();
    alloc_string(); /* accounting */
}

int member_of_set(aet, set)
    struct ae_term *aet;
    struct s_term *set;
{
    int i;
    int member;
    struct module *mod;
    keytype set_key;
    struct subst_t *sub;

#ifdef	DEBUG
    fprintf(stderr, "\nset: k = %u  fun = %c\n", key, set->fun);
#endif

    for (i = 0; i < set->a; i++) {
	if (set->u_tag[i])
	    member = member_of_set(aet, set->arr[i].s_t);
	else if (set->arr[i].ae_t->ind.table == SOR)
	    member = 1;
	else if (set->arr[i].ae_t->ind.table == SET) {
	    set_key = set->arr[i].ae_t->ind.key;
	    mod = get_til_module();
            member = 0;
	    while (mod->set[set_key].u_tag == 0) {
		if (mod->set[set_key].construct.sort.table == SOR) {
		    member = 1;
		    break;
		} else { /* SET */
		    set_key = mod->set[set_key].construct.sort.key;
		}
	    }
	    if (! member)
		member = member_of_set(aet, &mod->
				   set[set_key].construct.set_term);
	} else {

#ifdef	DEBUG
	    fprintf(stderr, "mem = %u ~", set->arr[i].ae_t->ind.key);
#endif

	    if ((sub = term_match(set->arr[i].ae_t, aet)) == NULL)
		member = 0;
	    else {
		member = check_set_var(sub);
		subst_free(sub);
	    }
	}
	switch (set->fun) {
	case UNI:
	    if (member)
		return (1);
	    break;
	case INT:
	    if (!member)
		return (0);
	    break;
	case DIF:
	    if (i) {
		if (member)
		    return (0);
		else
		    member = 1;
	    } else {
		if (!member)
		    return (0);
	    }
	    break;
	case ENU:
	    if (member)
		return (1);
	    break;
	}
    }
    return (member);
}

int member_of_sortset(mod, aet, set)
    struct module *mod;
    struct ae_term *aet;
    set_tuple *set;
{
    if (set->u_tag)
	return(member_of_set(aet, &set->construct.set_term));
    if (set->construct.sort.table == SET)
	return(member_of_sortset(mod, aet,
	    &mod->set[set->construct.sort.key]));
    return(set->construct.sort.key ==
	mod->fun[aet->ind.key].return_list.indlist[0].key);
}

struct set_list *atom_in_set_list(aet, sl, stype)
    struct ae_term *aet;
    struct set_list *sl;
    int stype;
{
    while (sl != NULL) {
	if (sl->set == NULL || member_of_set(aet, sl->set)) {
	    if (sl->stype == stype)
		return (sl);
	    else
		return (NULL);
	}
	sl = sl->next;
    }
    return (NULL);
}

int handle_deadlock(p)
    struct process *p;
{
    struct process *parent;

    do {
	if (p->flag == NORMAL_PROCESS) {
	    message_display("deadlock on process with id %u\n",
			    p->id);
	}
	parent = p->parent;
	if (parent != NULL)
	    awaken_process(parent, p);
	delete_process_from_table(p);
	if (parent != NULL)
	destroy_process(p);
	if (parent == NULL)
	    return (-1);
	p = parent;
    } while (!p->sleeping);
    return (0);
}

void remove_loop_process(p)
    struct process *p;
{
    struct process *parent;
    struct tailheap *tail;
    int i, j;

    if ((parent = p->parent) == NULL)
	return;
    if (p->sleeping != 1)
	return;
    if ((tail = p->h_t->tail) != NULL) {
	if (tail->tail != NULL)
	    return;
	if (tail->expr->fun == SEQ) {
	    if (tail->expr->proc_expr.pe3.a - 1 != tail->nr)
		return;
	} else if (tail->expr->fun != ALT &&
	    tail->expr->fun != DISR &&
	    tail->expr->fun != INTR &&
	    tail->expr->fun != STAR &&
	    tail->expr->fun != SHARP)
	    return;
	if (p->h_t->top && parent->h_t->top && parent->h_t->tail
		!= NULL) {
	    if (parent->h_t->tail->expr->fun == SEQ) {
		if (parent->h_t->tail->expr->proc_expr.pe3.a
			- 1 != parent->h_t->tail->nr)
		    return;
	    } else if (parent->h_t->tail->expr->fun != ALT &&
		parent->h_t->tail->expr->fun != DISR &&
		parent->h_t->tail->expr->fun != INTR &&
		parent->h_t->tail->expr->fun != STAR &&
		parent->h_t->tail->expr->fun != SHARP)
		return;
	    if (parent->h_t->tail->tail != NULL)
		return;
	}
    }
    for (i = parent->nr_children - 1; i >= 0; i--) {
	if (parent->child[i] == p) {
	    for (j = 0; p->child[j] == NULL; j++);
	    parent->child[i] = p->child[j];
	    p->child[j]->parent = parent;
	    p->set = NULL;
	    /* take sub with us */
	    if (p->h_t->top) {
		if (Option_Test) {
		    parent->h_t->top = 1;
		    parent->h_t->sub = p->h_t->sub;
		    p->h_t->top = 0;
		} else {
		    if (p->child[j]->h_t->sub == p->h_t->sub) {
			p->child[j]->h_t->top = 1;
			p->h_t->top = 0;
		    }
		}
	    }
	    delete_process_from_table(p);
	    destroy_process(p);
	    return;
	}
    }
}

void remove_loop_tail(p)
    struct process *p;
{
    struct tailheap *tail;

    if ((tail = p->h_t->tail) == NULL)
	return;
    if (tail->expr->fun == SEQ)
	if (tail->expr->proc_expr.pe3.a - 1 == tail->nr)
	    delete_tail(p->h_t);
}
