#include <stdio.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/cursorfont.h>
#include <X11/Shell.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/FormP.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Toggle.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/Sme.h>
#include <X11/Xaw/SmeBSB.h>
#include "select"
#include <X11/Xaw/ListP.h>
#include <X11/Xaw/Label.h>
#include <X11/extensions/shape.h>
#include "psf_prototype.h"
#include "tiltype.h"
#include "simutil.h"
#include "mylist.h"
#include "process.h"
#include "statecontrol.h"
#include "widgets.h"
#include "messagewid.h"
#include "tracewid.h"
#include "functionwid.h"
#include "simoption.h"
#include "xutil.h"
#include "historywid.h"
#include "specialwid.h"
#include "tbinterface.h"

#include "menu12"

static Widget function_widget;
    /* breakpoint and trace form a radio-group */
static Widget function_breakpoint;
static Widget function_trace = NULL;
static Widget function_default_trace;
static Widget function_reset;
static Widget function_process_status;
static Widget function_tracestdout;
static Widget function_random;
static Widget function_tbcontrol;

#define	BUTTON_WIDTH	180

#define	COM_BREAKPOINT	0
#define	COM_TRACE	1
static int current_command;

static int modules_on = 0;
static void breakpoint(w, client_data, call_data)
    Widget w;
    caddr_t client_data;
    caddr_t call_data;
{
    if (modules_on) {
	popdown_modules();
	modules_on = 0;
    } else {
	current_command = COM_BREAKPOINT;
	popup_modules();
	modules_on = 1;
    }
}

static XtCallbackRec breakpoint_callbacks[] = {
    {(XtCallbackProc) breakpoint, NULL},
    {(XtCallbackProc) NULL, NULL},
};

static Arg breakpoint_args[] = {
    {XtNleftBitmap, (XtArgVal) 0},
    {XtNcallback, (XtArgVal) breakpoint_callbacks},
    {XtNsensitive, (XtArgVal) True},
    {XtNhighlightThickness, (XtArgVal) 3},
    {XtNtop, (XtArgVal) XawChainTop},
    {XtNbottom, (XtArgVal) XawChainTop},
    {XtNleft, (XtArgVal) XawChainLeft},
    {XtNright, (XtArgVal) XawChainRight},
};

static Widget function_breakpoint_type;
static Arg breakpoint_type_args[] = {
    {XtNfromVert, (XtArgVal) NULL},
    {XtNleftBitmap, (XtArgVal) 0},
    {XtNmenuName, (XtArgVal) "BREAKPOINT TYPE"},
    {XtNsensitive, (XtArgVal) True},
    {XtNhighlightThickness, (XtArgVal) 3},
    {XtNtop, (XtArgVal) XawChainTop},
    {XtNbottom, (XtArgVal) XawChainTop},
    {XtNleft, (XtArgVal) XawChainLeft},
    {XtNright, (XtArgVal) XawChainRight},
};

static Widget menu_breakpoint_type;
static Arg menu_breakpoint_type_args[] = {
    {XtNmenuOnScreen, (XtArgVal) True},
};

static Pixmap breakpoint_mark;
static unsigned long Breakpoint_Type = 0;

#define	NR_BREAKPOINT	3
static Widget breakpoint_entry[NR_BREAKPOINT];

static void breakpoint_type_select(w, number, garbage)
    Widget w;
    XtPointer number;
    XtPointer garbage;
{
    Arg arglist[1];
    unsigned long num = (unsigned long) number;
    int i;

    if (Breakpoint_Type == num)
	return;
    Breakpoint_Type = num;
    XtSetArg(arglist[0], XtNleftBitmap, breakpoint_mark);
    XtSetValues(w, arglist, 1);
    XtSetArg(arglist[0], XtNleftBitmap, None);
    for (i = 0; i < NR_BREAKPOINT; i++) {
	if (i == num)
	    continue;
	XtSetValues(breakpoint_entry[i], arglist, 1);
    }
}

static Arg breakpoint_entry_args[] = {
    {XtNleftMargin, (XtArgVal) 25},
};

static void trace(w, client_data, call_data)
    Widget w;
    caddr_t client_data;
    caddr_t call_data;
{
    if (modules_on) {
	popdown_modules();
	modules_on = 0;
    } else {
	current_command = COM_TRACE;
	popup_modules();
	modules_on = 1;
    }
}

static XtCallbackRec trace_callbacks[] = {
    {(XtCallbackProc) trace, NULL},
    {(XtCallbackProc) NULL, NULL},
};

static Arg trace_args[] = {
    {XtNfromVert, (XtArgVal) NULL},
    {XtNleftBitmap, (XtArgVal) 0},
    {XtNcallback, (XtArgVal) trace_callbacks},
    {XtNsensitive, (XtArgVal) True},
    {XtNhighlightThickness, (XtArgVal) 3},
    {XtNtop, (XtArgVal) XawChainTop},
    {XtNbottom, (XtArgVal) XawChainTop},
    {XtNleft, (XtArgVal) XawChainLeft},
    {XtNright, (XtArgVal) XawChainRight},
};

static int tracing_default = 0;
static void trace_default(w, client_data, call_data)
    Widget w;
    caddr_t client_data;
    caddr_t call_data;
{
    if (tracing_default)
	tracing_default = 0;
    else
	tracing_default = 1;
}

static XtCallbackRec default_trace_callbacks[] = {
    {(XtCallbackProc) trace_default, NULL},
    {(XtCallbackProc) NULL, NULL},
};

static Arg default_trace_args[] = {
    {XtNfromVert, (XtArgVal) NULL},
    {XtNcallback, (XtArgVal) default_trace_callbacks},
    {XtNsensitive, (XtArgVal) True},
    {XtNhighlightThickness, (XtArgVal) 3},
    {XtNtop, (XtArgVal) XawChainTop},
    {XtNbottom, (XtArgVal) XawChainTop},
    {XtNleft, (XtArgVal) XawChainLeft},
    {XtNright, (XtArgVal) XawChainRight},
};

static void reset(w, client_data, call_data)
    Widget w;
    caddr_t client_data;
    caddr_t call_data;
{
    force_state(STATE_RESET);
    message_display("RESET pressed, restarting specification\n");
    trace_display("--- RESET ---\n");
    if (trace_to_stdout()) {
	printf(">reset\n");
	fflush(stdout);
    }
    if (Option_ToolBus) {
	tb_reset();
    }
}

static XtCallbackRec reset_callbacks[] = {
    {(XtCallbackProc) reset, NULL},
    {(XtCallbackProc) NULL, NULL},
};

static Arg reset_args[] = {
    {XtNfromVert, (XtArgVal) NULL},
    {XtNcallback, (XtArgVal) reset_callbacks},
    {XtNsensitive, (XtArgVal) True},
    {XtNhighlightThickness, (XtArgVal) 3},
    {XtNtop, (XtArgVal) XawChainTop},
    {XtNbottom, (XtArgVal) XawChainTop},
    {XtNleft, (XtArgVal) XawChainLeft},
    {XtNright, (XtArgVal) XawChainRight},
};

static void process_status(w, client_data, call_data)
    Widget w;
    caddr_t client_data;
    caddr_t call_data;
{
    print_process_status();
}

static XtCallbackRec process_status_callbacks[] = {
    {(XtCallbackProc) process_status, NULL},
    {(XtCallbackProc) NULL, NULL},
};

static Arg process_status_args[] = {
    {XtNfromVert, (XtArgVal) NULL},
    {XtNcallback, (XtArgVal) process_status_callbacks},
    {XtNsensitive, (XtArgVal) True},
    {XtNhighlightThickness, (XtArgVal) 3},
    {XtNtop, (XtArgVal) XawChainTop},
    {XtNbottom, (XtArgVal) XawChainTop},
    {XtNleft, (XtArgVal) XawChainLeft},
    {XtNright, (XtArgVal) XawChainRight},
};

static int tracetostdout = 0;
static char til_file[256];

static void outputtilfile()
{
    printf(">file %s\n", til_file);
    fflush(stdout);
}

char *get_til_file()
{
    return (til_file);
}

static void tracestdout(w, client_data, call_data)
    Widget w;
    caddr_t client_data;
    caddr_t call_data;
{
    if (tracetostdout) {
	tracetostdout = 0;
    } else {
	tracetostdout = 1;
	outputtilfile();
    }
}

static XtCallbackRec tracestdout_callbacks[] = {
    {(XtCallbackProc) tracestdout, NULL},
    {(XtCallbackProc) NULL, NULL},
};

static Arg tracestdout_args[] = {
    {XtNfromVert, (XtArgVal) NULL},
    {XtNcallback, (XtArgVal) tracestdout_callbacks},
    {XtNsensitive, (XtArgVal) True},
    {XtNhighlightThickness, (XtArgVal) 3},
    {XtNtop, (XtArgVal) XawChainTop},
    {XtNbottom, (XtArgVal) XawChainTop},
    {XtNleft, (XtArgVal) XawChainLeft},
    {XtNright, (XtArgVal) XawChainRight},
};

static int choosing_random = 0;
static void random(w, client_data, call_data)
    Widget w;
    caddr_t client_data;
    caddr_t call_data;
{
    if (choosing_random) {
	choosing_random = 0;
	activate_history();
    } else {
	choosing_random = 1;
	deactivate_history();
    }
}

static XtCallbackRec random_callbacks[] = {
    {(XtCallbackProc) random, NULL},
    {(XtCallbackProc) NULL, NULL},
};

static Arg random_args[] = {
    {XtNfromVert, (XtArgVal) NULL},
    {XtNcallback, (XtArgVal) random_callbacks},
    {XtNsensitive, (XtArgVal) True},
    {XtNhighlightThickness, (XtArgVal) 3},
    {XtNtop, (XtArgVal) XawChainTop},
    {XtNbottom, (XtArgVal) XawChainTop},
    {XtNleft, (XtArgVal) XawChainLeft},
    {XtNright, (XtArgVal) XawChainRight},
};

static Arg function_args[] = {
    {XtNdefaultDistance, (XtArgVal) 2},
};

static Widget function_random_type;
static Arg random_type_args[] = {
    {XtNfromVert, (XtArgVal) NULL},
    {XtNleftBitmap, (XtArgVal) 0},
    {XtNmenuName, (XtArgVal) "RANDOM TYPE"},
    {XtNsensitive, (XtArgVal) True},
    {XtNhighlightThickness, (XtArgVal) 3},
    {XtNtop, (XtArgVal) XawChainTop},
    {XtNbottom, (XtArgVal) XawChainTop},
    {XtNleft, (XtArgVal) XawChainLeft},
    {XtNright, (XtArgVal) XawChainRight},
};

static Widget menu_random_type;
static Arg menu_random_type_args[] = {
    {XtNmenuOnScreen, (XtArgVal) True},
};

static Pixmap random_mark;
static unsigned long Random_Type = 0;

#define	NR_RANDOM	2
static Widget random_entry[NR_RANDOM];

static void random_type_select(w, number, garbage)
    Widget w;
    XtPointer number;
    XtPointer garbage;
{
    Arg arglist[2];
    unsigned long num = (unsigned long) number;
    int i;

    if (Random_Type == num)
	return;
    Random_Type = num;
    XtSetArg(arglist[0], XtNleftBitmap, random_mark);
    XtSetValues(w, arglist, 1);
    XtSetArg(arglist[0], XtNleftBitmap, None);
    for (i = 0; i < NR_RANDOM; i++) {
	if (i == num)
	    continue;
	XtSetValues(random_entry[i], arglist, 1);
    }
}

static Arg random_entry_args[] = {
    {XtNleftMargin, (XtArgVal) 25},
};

static Widget function_history;
static Arg history_args[] = {
    {XtNfromVert, (XtArgVal) NULL},
    {XtNleftBitmap, (XtArgVal) 0},
    {XtNmenuName, (XtArgVal) "HISTORY"},
    {XtNsensitive, (XtArgVal) True},
    {XtNhighlightThickness, (XtArgVal) 3},
    {XtNtop, (XtArgVal) XawChainTop},
    {XtNbottom, (XtArgVal) XawChainTop},
    {XtNleft, (XtArgVal) XawChainLeft},
    {XtNright, (XtArgVal) XawChainRight},
};

static Widget function_special;
static Arg special_args[] = {
    {XtNfromVert, (XtArgVal) NULL},
    {XtNleftBitmap, (XtArgVal) 0},
    {XtNmenuName, (XtArgVal) "SPECIAL"},
    {XtNsensitive, (XtArgVal) True},
    {XtNhighlightThickness, (XtArgVal) 3},
    {XtNtop, (XtArgVal) XawChainTop},
    {XtNbottom, (XtArgVal) XawChainTop},
    {XtNleft, (XtArgVal) XawChainLeft},
    {XtNright, (XtArgVal) XawChainRight},
};

static int active_tbcontrol;

static void tbcontrol(w, client_data, call_data)
    Widget w;
    caddr_t client_data;
    caddr_t call_data;
{
    deactivate_tbcontrol();
    tb_give_control();
}

static XtCallbackRec tbcontrol_callbacks[] = {
    {(XtCallbackProc) tbcontrol, NULL},
    {(XtCallbackProc) NULL, NULL},
};

static Arg tbcontrol_args[] = {
    {XtNfromVert, (XtArgVal) NULL},
    {XtNcallback, (XtArgVal) tbcontrol_callbacks},
    {XtNsensitive, (XtArgVal) True},
    {XtNhighlightThickness, (XtArgVal) 3},
    {XtNtop, (XtArgVal) XawChainTop},
    {XtNbottom, (XtArgVal) XawChainTop},
    {XtNleft, (XtArgVal) XawChainLeft},
    {XtNright, (XtArgVal) XawChainRight},
};

void init_function_widget(shell)
    Widget shell;
{
    Arg arglist[1];
    Display *disp;
    Pixmap menux;
    Dimension w, mw;
    int i;
    FormWidget FW;

    disp = XtDisplay(shell);
    menux = XCreateBitmapFromData(disp, RootWindowOfScreen(XtScreen(shell)),
	(char *) menu12_bits, menu12_width, menu12_height);

    function_widget = XtCreateManagedWidget("function", formWidgetClass, shell,
        function_args, XtNumber(function_args));

    XtSetArg(breakpoint_args[0], XtNleftBitmap, menux);
    function_breakpoint = XtCreateManagedWidget("Breakpoint",
	toggleWidgetClass, function_widget, breakpoint_args,
	XtNumber(breakpoint_args));

    XtSetArg(breakpoint_type_args[0], XtNfromVert, function_breakpoint);
    XtSetArg(breakpoint_type_args[1], XtNleftBitmap, menux);
    function_breakpoint_type = XtCreateManagedWidget("Breakpoint type",
	menuButtonWidgetClass, function_widget, breakpoint_type_args,    
	XtNumber(breakpoint_type_args));
    menu_breakpoint_type = XtCreatePopupShell("BREAKPOINT TYPE",
	simpleMenuWidgetClass, function_breakpoint_type,
	menu_breakpoint_type_args, XtNumber(menu_breakpoint_type_args));
    breakpoint_entry[0] = XtCreateManagedWidget("on execution   ",
	smeBSBObjectClass, menu_breakpoint_type, breakpoint_entry_args,
	XtNumber(breakpoint_entry_args));
    XtAddCallback(breakpoint_entry[0], XtNcallback, breakpoint_type_select,
	(XtPointer) 0);
    breakpoint_entry[1] = XtCreateManagedWidget("stop when one",
	smeBSBObjectClass, menu_breakpoint_type, breakpoint_entry_args,
	XtNumber(breakpoint_entry_args));
    XtAddCallback(breakpoint_entry[1], XtNcallback, breakpoint_type_select,
	(XtPointer) 1);
    breakpoint_entry[2] = XtCreateManagedWidget("stop when all",
	smeBSBObjectClass, menu_breakpoint_type, breakpoint_entry_args,
	XtNumber(breakpoint_entry_args));
    XtAddCallback(breakpoint_entry[2], XtNcallback, breakpoint_type_select,
	(XtPointer) 2);
    breakpoint_mark = XCreateBitmapFromData(XtDisplay(shell),
	RootWindowOfScreen(XtScreen(shell)), (char *) select_bits,
	select_width, select_height);
    XtSetArg(arglist[0], XtNleftBitmap, breakpoint_mark);
    XtSetValues(breakpoint_entry[Option_Break], arglist, 1);
    Breakpoint_Type = Option_Break;

    XtSetArg(trace_args[0], XtNfromVert, function_breakpoint_type);
    XtSetArg(trace_args[1], XtNleftBitmap, menux);
    function_trace = XtCreateManagedWidget("Trace", toggleWidgetClass,
	function_widget, trace_args, XtNumber(trace_args));
    /* make the radio-group */
    XawToggleChangeRadioGroup(function_trace, function_breakpoint);

    XtSetArg(default_trace_args[0], XtNfromVert, function_trace);
    function_default_trace = XtCreateManagedWidget("Default trace",
	toggleWidgetClass, function_widget, default_trace_args,
	XtNumber(default_trace_args));

    XtSetArg(reset_args[0], XtNfromVert, function_default_trace);
    function_reset = XtCreateManagedWidget("Reset", commandWidgetClass,
	function_widget, reset_args, XtNumber(reset_args));

    XtSetArg(process_status_args[0], XtNfromVert, function_reset);
    function_process_status = XtCreateManagedWidget("Process status",
	commandWidgetClass, function_widget, process_status_args,
	XtNumber(process_status_args));

    XtSetArg(tracestdout_args[0], XtNfromVert, function_process_status);
    function_tracestdout = XtCreateManagedWidget("Trace to stdout",
	toggleWidgetClass, function_widget, tracestdout_args,
	XtNumber(tracestdout_args));

    XtSetArg(random_args[0], XtNfromVert, function_tracestdout);
    function_random = XtCreateManagedWidget("Random", toggleWidgetClass,
	function_widget, random_args, XtNumber(random_args));

    XtSetArg(random_type_args[0], XtNfromVert, function_random);
    XtSetArg(random_type_args[1], XtNleftBitmap, menux);
    function_random_type = XtCreateManagedWidget("Random type",
	menuButtonWidgetClass, function_widget, random_type_args,
	XtNumber(random_type_args));
    menu_random_type = XtCreatePopupShell("RANDOM TYPE", simpleMenuWidgetClass,
	function_random_type, menu_random_type_args,
	XtNumber(menu_random_type_args));
    random_entry[0] = XtCreateManagedWidget("normal         ",
	smeBSBObjectClass, menu_random_type, random_entry_args,
	XtNumber(random_entry_args));
    XtAddCallback(random_entry[0], XtNcallback, random_type_select,
	(XtPointer) 0);
    random_entry[1] = XtCreateManagedWidget("weighted", smeBSBObjectClass,
	menu_random_type, random_entry_args, XtNumber(random_entry_args));
    XtAddCallback(random_entry[1], XtNcallback, random_type_select,
	(XtPointer) 1);
    random_mark = breakpoint_mark;
    XtSetArg(arglist[0], XtNleftBitmap, random_mark);
    XtSetValues(random_entry[Option_Random], arglist, 1);
    Random_Type = Option_Random;

    XtSetArg(history_args[0], XtNfromVert, function_random_type);
    XtSetArg(history_args[1], XtNleftBitmap, menux);
    if (Option_ToolBus)
	XtSetArg(history_args[3], XtNsensitive, False);
    function_history = XtCreateManagedWidget("History", menuButtonWidgetClass,
	function_widget, history_args, XtNumber(history_args));

    if (Option_ToolBus) {
	XtSetArg(tbcontrol_args[0], XtNfromVert, function_random_type);
	if (tb_keep_control())
	    XtSetArg(tbcontrol_args[2], XtNsensitive, False);
	function_tbcontrol = XtCreateManagedWidget("Control to anim",
	    commandWidgetClass, function_widget, tbcontrol_args,
	    XtNumber(tbcontrol_args));

	XtUnmanageChild(function_history);

	XtSetArg(special_args[0], XtNfromVert, function_tbcontrol);
    } else {
	XtSetArg(special_args[0], XtNfromVert, function_history);
    }
    XtSetArg(special_args[1], XtNleftBitmap, menux);
    function_special = XtCreateManagedWidget("Special", menuButtonWidgetClass,
	function_widget, special_args, XtNumber(special_args));

    /*
     * Make the buttons have the same width.
     */
    mw = 0;
    FW = (FormWidget) function_widget;
    for (i = 0; i < FW->composite.num_children; i ++) {
	w = get_width(FW->composite.children[i]);
	if (w > mw)
	    mw = w;
    }
    for (i = 0; i < FW->composite.num_children; i ++) {
	set_width(FW->composite.children[i], mw);
    }

    if (!Option_History)
	deactivate_history();
    init_history_widget(function_history);

    init_special_widget(function_special);

    init_modules_widget(function_widget);

    if (Option_ToolBus) {
	if (!active_tbcontrol)
	    deactivate_tbcontrol();
	deactivate_special();
    }
}

/*************************************************
	module widget and breakpoint/trace widgets
*************************************************/

static Widget modules_shell;

static Arg shell_modules[] = {
    {XtNtransient, (XtArgVal) True},
    {XtNallowShellResize, (XtArgVal) True},
};

static Widget modules;
static Widget infosetting_shell;

static void modules_activate(w, client_data, call_data)
    Widget w;
    caddr_t client_data;
    caddr_t call_data;
{
    char **strl;
    unsigned int nrstr;
    int **intl;
    unsigned int nrint;
    Arg arglist[3];
    Position x, y;
    Dimension h;

    /* R4 */
    XawListReturnStruct *selected_module;

    popdown_infosetting();
    /* R4 */
    selected_module = XawListShowCurrent(w);
    get_name_list(selected_module->list_index, &strl, &nrstr);
    if (current_command == COM_BREAKPOINT)
	get_breakpoint_list(selected_module->list_index, &intl,
			    &nrint);
    else
	get_trace_list(selected_module->list_index, &intl,
		       &nrint);

    /*
     * Place INFOSETTING right below MODULES
     */
    XtSetArg(arglist[0], XtNy, &y);
    XtSetArg(arglist[1], XtNx, &x);
    XtSetArg(arglist[2], XtNheight, &h);
    XtGetValues(modules_shell, arglist, 3);
    XtSetArg(arglist[0], XtNy, y + h + 1);
    XtSetArg(arglist[1], XtNx, x - 1);
    XtSetValues(infosetting_shell, arglist, 2);
    popup_infosetting(strl, nrstr, intl, nrint);
}

static XtCallbackRec modules_callbacks[] = {
    {(XtCallbackProc) modules_activate, NULL},
    {(XtCallbackProc) NULL, NULL},
};

char *dummylist[] = {
    " ",
    NULL
};
static Arg modules_args[] = {
    {XtNcallback, (XtArgVal) modules_callbacks},
    {XtNdefaultColumns, (XtArgVal) 1},
    {XtNlist, (XtArgVal) dummylist},
    {XtNnumberStrings, (XtArgVal) 1},
    {XtNverticalList, (XtArgVal) True},
    {XtNmaxHeight, (XtArgVal) 320},
    /* added to circumvent bug in Xorg */
    {XtNforceColumns, (XtArgVal) True},
};

#define	MODULES_Vlist		2
#define	MODULES_VnumberStrings	3

static void quit_modules_activate(w, client_data, call_data)
    Widget w;
    caddr_t client_data;
    caddr_t call_data;
{
/*
    popdown_modules();
*/
    if (current_command == COM_BREAKPOINT) {
	XawToggleUnsetCurrent(function_breakpoint);
    } else {
	XawToggleUnsetCurrent(function_trace);
    }
    /*
     * for checking the settings print_sim_info_tables ();
     */
}

static XtCallbackRec quit_modules_callbacks[] = {
    {(XtCallbackProc) quit_modules_activate, NULL},
    {(XtCallbackProc) NULL, NULL},
};

static Arg quit_modules_args[] = {
    {XtNcallback, (XtArgVal) quit_modules_callbacks},
    {XtNsensitive, (XtArgVal) True},
    {XtNhighlightThickness, (XtArgVal) 3},
};

static Widget quit_modules;

static Arg box_args[] = {
    {XtNhSpace, (XtArgVal) 2},
    {XtNvSpace, (XtArgVal) 2},
};

static Widget box_for_modules;

static Arg box_label_args[] = {
    {XtNinternalHeight, (XtArgVal) 5},
};

static Widget box_label;

void init_modules_widget(shell)
    Widget shell;
{
    modules_shell = XtCreatePopupShell("MODULES",
	topLevelShellWidgetClass, shell,
	shell_modules, XtNumber(shell_modules));
    box_for_modules = XtCreateManagedWidget("box",
	boxWidgetClass, modules_shell,
	box_args, XtNumber(box_args));
    box_label = XtCreateManagedWidget("<<MODULES>>",
	labelWidgetClass, box_for_modules,
	box_label_args, XtNumber(box_label_args));
    modules = XtCreateManagedWidget("modules",
	listWidgetClass, box_for_modules,
	modules_args, XtNumber(modules_args));
    init_modules_list();
    quit_modules = XtCreateManagedWidget("Quit",
	commandWidgetClass, box_for_modules,
	quit_modules_args, XtNumber(quit_modules_args));

    init_infosetting_widget(modules_shell);
}

void init_modules_list()
{
    char **modules_list;
    unsigned int nr_modules;
    Arg arglist[1];
    int nr_columns, nr_rows;

    get_modules_list(&modules_list, &nr_modules);
    /* maybe no-list */
    if (nr_modules == 0)
	modules_list = NULL;
    XawListChange(modules, modules_list, nr_modules, 0, True);
    if (nr_modules == 0)
	((ListWidget) modules)->list.nitems = 0;
    /*
     * Decide the number of columns in order to maximize the height of
     * the list.
     */
    nr_rows = 320 / (int)( ((ListWidget) modules)->list.row_height +
	((ListWidget) modules)->list.row_space);
    if (nr_modules == 0)
	nr_columns = 1;
    else
	nr_columns = (nr_modules - 1) / (nr_rows + 1) + 1;
    XtSetArg(arglist[0], XtNdefaultColumns, nr_columns);
    XtSetValues(modules, arglist, 1);
}

void popup_modules()
{
    XtPopup(modules_shell, XtGrabNone);
}

void popdown_modules()
{
    if (modules_on) {
	popdown_infosetting();
	XawListUnhighlight(modules);
	XtPopdown(modules_shell);
	modules_on = 0;
    }
}

/*********************************************************
	infosetting widget
*********************************************************/

static Arg shell_infosetting[] = {
    {XtNtransient, (XtArgVal) True},
    {XtNallowShellResize, (XtArgVal) True},
};

static Widget infosetting;
static Widget noitem;

void infosetting_activate(w, client_data, call_data)
    Widget w;
    caddr_t client_data;
    caddr_t call_data;
{
}

static XtCallbackRec infosetting_callbacks[] = {
    {(XtCallbackProc) infosetting_activate, NULL},
    {(XtCallbackProc) NULL, NULL},
};

static Arg infosetting_args[] = {
    {XtNcallback, (XtArgVal) infosetting_callbacks},
/*
*/
    {XtNdefaultColumns, (XtArgVal) 0},
    {XtNlist, (XtArgVal) dummylist},
    {XtNnumberStrings, (XtArgVal) 1},
    {XtNverticalList, (XtArgVal) True},
    {XtNheight, (XtArgVal) 400},
    {XtNmaxHeight, (XtArgVal) 400},
};

#define	INFOSETTING_Vlist		2
#define	INFOSETTING_VnumberStrings	3

static Arg box_info_args[] = {
    {XtNhSpace, (XtArgVal) 2},
    {XtNvSpace, (XtArgVal) 2},
};

static Widget box_for_infosetting;

static Arg info_label_args[] = {
    {XtNinternalHeight, (XtArgVal) 5},
};

static Arg noitem_args[] = {
/*
    {XtNinternalHeight, (XtArgVal) 5},
*/
    {XtNborderWidth, (XtArgVal) 0},
};

void init_infosetting_widget(shell)
    Widget shell;
{
    infosetting_shell = XtCreatePopupShell("INFOSETTING",
					   topLevelShellWidgetClass, shell,
			      shell_infosetting, XtNumber(shell_infosetting));
    box_for_infosetting = XtCreateManagedWidget("box",
					    boxWidgetClass, infosetting_shell,
				      box_info_args, XtNumber(box_info_args));
    box_label = XtCreateManagedWidget("<<OBJECTS>>",
				      labelWidgetClass, box_for_infosetting,
				  info_label_args, XtNumber(info_label_args));
    infosetting = XtCreateManagedWidget("infosetting",
					listWidgetClass, box_for_infosetting,
				infosetting_args, XtNumber(infosetting_args));
    noitem = XtCreateWidget("no items",
				      labelWidgetClass, box_for_infosetting,
				  noitem_args, XtNumber(noitem_args));
}

static int infosetting_popup = 0;
static int unmanaged_info = 0;

void popup_infosetting(strl, nrstr, intl, nrint)
    char **strl;
    unsigned int nrstr;
    int **intl;
    unsigned int nrint;
{
    Arg arglist[1];
    int nr_columns, nr_rows;

    init_mylist(infosetting, strl, nrstr, intl, nrint);
    if (!nrstr) {
	XtUnmanageChild(infosetting);
	unmanaged_info = 1;
	XtManageChild(noitem);
	nr_columns = 1;
    } else {

	/*
	 * Decide the number of columns in order to maximize the height of
	 * the list.
	 */
	nr_rows = 400 / (int)( ((ListWidget) infosetting)->list.row_height +
	    ((ListWidget) infosetting)->list.row_space);
	nr_columns = (nrstr - 1) / (nr_rows + 1) + 1;
	XtSetArg(arglist[0], XtNdefaultColumns, nr_columns);
	XtSetValues(infosetting, arglist, 1);

	if (unmanaged_info) {
	    XtUnmanageChild(noitem);
	    XtManageChild(infosetting);
	    unmanaged_info = 0;
	}
    }
    if (!infosetting_popup) {
	XtPopup(infosetting_shell, XtGrabNone);
	infosetting_popup = 1;
    };
}

void popdown_infosetting()
{
    if (infosetting_popup) {
	XtPopdown(infosetting_shell);
	infosetting_popup = 0;
    };
}


/*********************************************
* default trace
*********************************************/

int default_trace()
{
    return (tracing_default);
}

static Arg defaulttrace_off[] = {
    {XtNstate, (XtArgVal) True},
};

void set_defaulttrace(onoff)
    int onoff;
{
    tracing_default = onoff;
    XtSetValues(function_default_trace, defaulttrace_off, 1);
}

/*********************************************
* trace to stdout
*********************************************/

int trace_to_stdout()
{
    return (tracetostdout);
}

static Arg tracestdout_off[] = {
    {XtNstate, (XtArgVal) True},
};

void set_tracestdout(onoff)
    int onoff;
{
    tracetostdout = onoff;
    XtSetValues(function_tracestdout, tracestdout_off, 1);
    outputtilfile();
}

void set_tracetilfile(s)
    char *s;
{
    strcpy(til_file, s);
    if (tracetostdout)
	outputtilfile();
}

/*********************************************
* random choose
*********************************************/

int random_choose()
{
    return (choosing_random);
}

static Arg random_off[] = {
    {XtNstate, (XtArgVal) False},
};

void set_random_choose(onoff)
    int onoff;
{
    choosing_random = onoff;
    XtSetValues(function_random, random_off, 1);
    activate_history();
}

int get_random_type()
{
    return (Random_Type);
}

int get_breakpoint_type()
{
    return (Breakpoint_Type);
}

void do_reset()
{
    reset();
}

/*
 * (de)activation of functions for trace from stdin, etc
 */

void deactivate_functions ()
{
    XtSetSensitive(function_breakpoint, False);
    XtSetSensitive(function_reset, False);
    XtSetSensitive(function_random, False);
    deactivate_history();
    deactivate_special();
}

void activate_functions ()
{
    XtSetSensitive(function_breakpoint, True);
    XtSetSensitive(function_reset, True);
    XtSetSensitive(function_random, True);
    activate_history();
    activate_special();
}

void deactivate_history()
{
    if (!Option_ToolBus)
	XtSetSensitive(function_history, False);
}

void activate_history()
{
    if (Option_History)
    if (!Option_ToolBus)
	XtSetSensitive(function_history, True);
}

void deactivate_tbcontrol()
{
    XtSetSensitive(function_tbcontrol, False);
    XtSetSensitive(function_reset, False);
    deactivate_special_quit();
    active_tbcontrol = 1;
}

void activate_tbcontrol()
{
    XtSetSensitive(function_tbcontrol, True);
    XtSetSensitive(function_reset, True);
    activate_special_quit();
    active_tbcontrol = 0;
}

void init_active_tbcontrol(a)
int a;
{
    active_tbcontrol = a;
}

void deactivate_controltoanim()
{
    XtSetSensitive(function_tbcontrol, False);
}
