#include <stdio.h>
#include "psf_prototype.h"
#include "tiltype.h"
#include "freetil.h"
#include "psf_malloc.h"

#ifndef NEWFF
#define FF_FREE PSF_FREE
#else
void ff_free(ff)
    freeformat ff;
{
    if (ff) {
	ff_free(ff->next);
	PSF_FREE(ff->tag);
	PSF_FREE(ff->info);
	PSF_FREE(ff);
    }
}

#define FF_FREE ff_free
#endif
static void free_adm(adm)
    adm_tuple *adm;
{
    FF_FREE(adm->ff);
}

static void free_sor(sor)
    sor_tuple *sor;
{
    FF_FREE(sor->ff);
}

static void free_indexlist(list)
    struct indexlist *list;
{
    PSF_FREE(list->indlist);
}

static void free_fun(fun)
    fun_tuple *fun;
{
    free_indexlist(&fun->sor_indlist);
    free_indexlist(&fun->return_list);
    FF_FREE(fun->ff);
}

static void free_atm(atm)
    atm_tuple *atm;
{
    free_indexlist(&atm->sor_indlist);
    FF_FREE(atm->ff);
}

static void free_pro(pro)
    atm_tuple *pro;
{
    free_indexlist(&pro->sor_indlist);
    FF_FREE(pro->ff);
}

static void free_ae_term(aet)
    struct ae_term *aet;
{
    int i;

    for (i = 0; i < aet->a; i++)
	free_ae_term(&aet->ae_list[i]);
    PSF_FREE(aet->ae_list);
}

static void free_s_term(st)
    struct s_term *st;
{
    int i;

    for (i = 0; i < st->a; i++)
	if (st->u_tag[i])
	    free_s_term(st->arr[i].s_t);
	else
	    free_ae_term(st->arr[i].ae_t);
    PSF_FREE(st->u_tag);
    PSF_FREE(st->arr);
}

static void free_set(set)
    set_tuple *set;
{
    if (set->u_tag)
	free_s_term(&set->construct.set_term);
    FF_FREE(set->ff);
}

static void free_com(com)
    com_tuple *com;
{
    int i;

    for (i = 0; i < 3; i++)
	free_ae_term(&com->aet[i]);
    FF_FREE(com->ff);
}

static void free_var(var)
    var_tuple *var;
{
    FF_FREE(var->ff);
}

static void free_equation(eq)
    struct equation *eq;
{
    free_ae_term(&eq->aet1);
    free_ae_term(&eq->aet2);
}

static void free_equ(equ)
    equ_tuple *equ;
{
    int i;

    free_ae_term(&equ->aet1);
    free_ae_term(&equ->aet2);
    if (equ->a) {
	for (i = 0; i < equ->a; i++)
	    free_equation(&equ->guard[i]);
	PSF_FREE(equ->guard);
    }
    FF_FREE(equ->ff);
}

static void free_process_expr(pe)
    struct process_expr *pe;
{
    int i;

    switch (pe->fun) {
    case AET:
	free_ae_term(&pe->proc_expr.pe2);
	break;
    case ALT:
    case SEQ:
    case PAR:
	for (i = 0; i < pe->proc_expr.pe3.a; i++)
	    free_process_expr(&pe->
			      proc_expr.pe3.pe[i]);
	PSF_FREE(pe->proc_expr.pe3.pe);
	break;
    case SKP:
	break;
    case SUM:
    case MRG:
    case ENC:
    case HID:
	free_process_expr(pe->proc_expr.pe1.pe);
	PSF_FREE(pe->proc_expr.pe1.pe);
	break;
    }
}

static void free_def(def)
    def_tuple *def;
{
    free_ae_term(&def->ae_t);
    free_process_expr(&def->p_expr);
    FF_FREE(def->ff);
}

/*
 * static	void	free_par (par) par_tuple	* par; { free_indexlist
 * (& par -> par_attr); free (par -> ff); }
 * 
 * static	void	free_ren (ren) ren_tuple	* ren; { free (ren -> ff); }
 * 
 * static	void	free_bin (bin) bin_tuple	* bin; { free_indexlist (& bin
 * -> ren_indlist); free (bin -> ff); }
 * 
 * static	void	free_imp (imp) imp_tuple	* imp; { free_indexlist (& imp
 * -> bin_indlist); free_indexlist (& imp -> ren_indlist); free (imp -> ff); }
 * 
 * static	void	free_mod (mod) mod_tuple	* mod; { free (mod -> ff); }
 * 
 * static	void	free_und (und) und_tuple	* und; { free (und -> ff); }
 */

void free_til_module(mod)
    struct module *mod;
{
    unsigned int ent;
    unsigned int i;

    ent = mod->entries_table[ADM];
    for (i = 1; i <= ent; i++)
	free_adm(&mod->adm[i]);
    PSF_FREE(mod->adm);
    ent = mod->entries_table[SOR];
    for (i = 1; i <= ent; i++)
	free_sor(&mod->sor[i]);
    PSF_FREE(mod->sor);
    ent = mod->entries_table[FUN];
    for (i = 1; i <= ent; i++)
	free_fun(&mod->fun[i]);
    PSF_FREE(mod->fun);
    ent = mod->entries_table[ATM];
    for (i = 1; i <= ent; i++)
	free_atm(&mod->atm[i]);
    PSF_FREE(mod->atm);
    ent = mod->entries_table[PRO];
    for (i = 1; i <= ent; i++)
	free_pro(&mod->pro[i]);
    PSF_FREE(mod->pro);
    ent = mod->entries_table[SET];
    for (i = 1; i <= ent; i++)
	free_set(&mod->set[i]);
    PSF_FREE(mod->set);
    ent = mod->entries_table[COM];
    for (i = 1; i <= ent; i++)
	free_com(&mod->com[i]);
    PSF_FREE(mod->com);
    ent = mod->entries_table[VAR];
    for (i = 1; i <= ent; i++)
	free_var(&mod->var[i]);
    PSF_FREE(mod->var);
    ent = mod->entries_table[EQU];
    for (i = 1; i <= ent; i++)
	free_equ(&mod->equ[i]);
    PSF_FREE(mod->equ);
    ent = mod->entries_table[DEF];
    for (i = 1; i <= ent; i++)
	free_def(&mod->def[i]);
    PSF_FREE(mod->def);
    /*
     * ent = mod -> entries_table[PRM]; for  (i = 1; i <= ent; i ++) free_par
     * (& mod -> par[i]); free (mod -> par); ent = mod -> entries_table[REN];
     * for  (i = 1; i <= ent; i ++) free_ren (& mod -> ren[i]); free (mod ->
     * ren); ent = mod -> entries_table[BIN]; for  (i = 1; i <= ent; i ++)
     * free_bin (& mod -> bin[i]); free (mod -> bin); ent = mod ->
     * entries_table[IMP]; for  (i = 1; i <= ent; i ++) free_imp (& mod ->
     * imp[i]); free (mod -> imp); ent = mod -> entries_table[MOD]; for  (i =
     * 1; i <= ent; i ++) free_mod (& mod -> mod[i]); free (mod -> mod); ent =
     * mod -> entries_table[UND]; for  (i = 1; i <= ent; i ++) free_und (& mod
     * -> und[i]); free (mod -> und);
     */
    PSF_FREE(mod->name);
    PSF_FREE(mod);
}
