#include <stdio.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>
#include "Dialog.h"
#include <X11/Xaw/Text.h>	/* for changing value widget of dialog */
#include "psf_prototype.h"
#include "widgets.h"

static Widget dialog_shell;
static Widget dialog;
static Widget dialog_confirm;
static Widget dialog_cancel;

void (* ending_dialog)();

void popdown_dialog();

static Arg shell_dialog[] = {
    {XtNx, (XtArgVal) 504},
    {XtNy, (XtArgVal) 368},
    {XtNwidth, (XtArgVal) 475},
/*
    {XtNheight, (XtArgVal) 90},
*/
    {XtNtransient, (XtArgVal) True},
    {XtNresizable, (XtArgVal) False},
    {XtNbottom, (XtArgVal) XtChainBottom},
    {XtNtop, (XtArgVal) XtChainTop},
    {XtNleft, (XtArgVal) XtChainLeft},
    {XtNright, (XtArgVal) XtChainRight},
};

static Arg label_arg = {
    XtNlabel, (XtArgVal) NULL
};

#define STRINGSIZE 64
static char def_string[STRINGSIZE] = "";
static Arg dialog_args[] = {
    {XtNlabel, (XtArgVal) ""},
    {XtNvalue, (XtArgVal) def_string},
};

static void confirm(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
    ending_dialog(def_string);
}

static XtCallbackRec confirm_callbacks[] = {
    {(XtCallbackProc) confirm, NULL},
    {(XtCallbackProc) NULL, NULL},
};

static Arg confirm_args[] = {
    {XtNcallback, (XtArgVal) confirm_callbacks},
};

static void cancel(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
    popdown_dialog();
}

static XtCallbackRec cancel_callbacks[] = {
    {(XtCallbackProc) cancel, NULL},
    {(XtCallbackProc) NULL, NULL},
};

static Arg cancel_args[] = {
    {XtNcallback, (XtArgVal) cancel_callbacks},
};

static void dialog_keyconfirm(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
    ending_dialog(def_string);
}

static XtActionsRec actionTable[] = {
    {"dialog_keyconfirm", dialog_keyconfirm},
};
static char dialog_translations[] =
"<Key>Return: dialog_keyconfirm()";

void init_dialog_widget(shell)
Widget shell;
{
    Widget dialogvalue_widget;

    dialog_shell = XtCreatePopupShell("DIALOG", topLevelShellWidgetClass,
	shell, shell_dialog, XtNumber(shell_dialog));
    dialog = XtCreateManagedWidget("Dialog", mydialogWidgetClass,
	dialog_shell, dialog_args, XtNumber(dialog_args));
    dialogvalue_widget = XtNameToWidget(dialog, "value");
    XtAppAddActions(app_context, actionTable, 1);
    XtOverrideTranslations(dialogvalue_widget,
	XtParseTranslationTable(dialog_translations));
    dialog_confirm = XtCreateManagedWidget("Confirm", commandWidgetClass,
	dialog, confirm_args, XtNumber(confirm_args));
    dialog_cancel = XtCreateManagedWidget("Cancel", commandWidgetClass,
	dialog, cancel_args, XtNumber(cancel_args));
}

void change_dialog_label(str)
char *str;
{
    XtSetArg(label_arg, XtNlabel, (XtArgVal) str);
    XtSetValues(dialog, &label_arg, 1);
}

void popup_dialog(x, y, label, default_input, func)
int x;
int y;
char *label;
char *default_input;
void (* func)();
{
    Arg arg[1];

    change_dialog_label(label);
    if (default_input == NULL)
	def_string[0] = '\0';
    else
	strcpy(def_string, default_input);
    XtSetArg(arg[0], XtNvalue, (XtArgVal) def_string);
    XtSetValues(dialog, arg, 1);
    ending_dialog = func;
    XtMoveWidget(dialog_shell, x, y);
    XtPopup(dialog_shell, XtGrabExclusive);
}

void popdown_dialog()
{
    XtPopdown(dialog_shell);
}

char *get_dialog_value()
{
    return(def_string);
}
