#include <stdio.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/ViewportP.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/Command.h>
#include "psf_prototype.h"
#include "xutil.h"
#include "choosewid.h"
#include "psf_malloc.h"
#include "statecontrol.h"

static Widget choose_random_once;
static Widget choose_item;

static int choosing_random_once;
static Dimension choose_random_width;
static Dimension choose_random_height;
static void random_once(w, client_data, call_data)
    Widget w;
    caddr_t client_data;
    caddr_t call_data;
{
    choosing_random_once = 1;
}

static XtCallbackRec random_once_callbacks[] = {
    {(XtCallbackProc) random_once, NULL},
    {(XtCallbackProc) NULL, NULL},
};

static Arg random_once_args[] = {
    {XtNcallback, (XtArgVal) random_once_callbacks},
    {XtNsensitive, (XtArgVal) True},
/*
    {XtNwidth, (XtArgVal) 135 - 2},
    {XtNheight, (XtArgVal) 30},
*/
    {XtNhighlightThickness, (XtArgVal) 3},
};

static void item_activate(w, client_data, call_data)
    Widget w;
    caddr_t client_data;
    caddr_t call_data;
{
    set_chosen_item();
    XawListUnhighlight(choose_item);
}

static XtCallbackRec item_callbacks[] = {
    {(XtCallbackProc) item_activate, NULL},
    {(XtCallbackProc) NULL, NULL},
};

#define	DEF_SIZE_ITEM_LIST	16
static String *choose_item_list;
static unsigned int size_choose_item_list = 0;
static unsigned int maxsize_choose_item_list = DEF_SIZE_ITEM_LIST;
static Arg choose_item_args[] = {
    {XtNcallback, (XtArgVal) item_callbacks},
    {XtNdefaultColumns, (XtArgVal) 1},
    {XtNlist, (XtArgVal) NULL},
    {XtNnumberStrings, (XtArgVal) 0},
    {XtNverticalList, (XtArgVal) True},
    {XtNmaxHeight, (XtArgVal) 400},
    {XtNcursor, (XtArgVal) None},
    {XtNforceColumns, (XtArgVal) True},
};

#define	CHOOSE_Vlist		2
#define	CHOOSE_VnumberStrings	3

static Arg choose_args[] = {
    {XtNhSpace, (XtArgVal) 2},
    {XtNvSpace, (XtArgVal) 2},
};

static Widget choose_widget;

#define	VIEWWIDTH	500
#define VIEWHEIGHT	400
static Arg view_args[] = {
    {XtNallowHoriz, (XtArgVal) True},
    {XtNallowVert, (XtArgVal) True},
    {XtNuseBottom, (XtArgVal) True},
    {XtNuseRight, (XtArgVal) True},
/*
    {XtNwidth, (XtArgVal) VIEWWIDTH},
    {XtNheight, (XtArgVal) VIEWHEIGHT},
*/
    {XtNcursor, (XtArgVal) None},
};

static Widget view;
static Widget Shell;

void init_choose_widget(shell)
    Widget shell;
{
    Shell = shell;
    choose_widget = XtCreateManagedWidget("choose", boxWidgetClass, shell,
	choose_args, XtNumber(choose_args));
    choose_random_once = XtCreateManagedWidget("Random once",
	commandWidgetClass, choose_widget, random_once_args,
	XtNumber(random_once_args));
    get_wh(choose_random_once, &choose_random_width, &choose_random_height);
    init_choose_list();
    view = XtCreateManagedWidget("view", viewportWidgetClass, choose_widget,
	view_args, XtNumber(view_args));
    choose_item = XtCreateManagedWidget("choose_item", listWidgetClass, view,
	choose_item_args, XtNumber(choose_item_args));

    XtUnmanageChild(choose_item);
}

static int managed_random;

void manage_random_choose()
{
    XtManageChild(choose_random_once);
    managed_random = 1;
}

void unmanage_random_choose()
{
    XtUnmanageChild(choose_random_once);
    managed_random = 0;
}

/*************************
	routines for the list to choose from
*************************/

void init_choose_list()
{
    int i;

    choose_item_list = PSF_NMALLOC(String ,DEF_SIZE_ITEM_LIST );
    for (i = 0; i < DEF_SIZE_ITEM_LIST; i++)
	choose_item_list[i] = NULL;
    XtSetArg(choose_item_args[CHOOSE_Vlist], XtNlist, (XtArgVal)
	     choose_item_list);
}

void add_choose_list(item, nr)
    char *item;
    int *nr;
{
    if (size_choose_item_list == maxsize_choose_item_list) {
	maxsize_choose_item_list += 4;
	choose_item_list = PSF_REALLOC(choose_item_list,String ,
				maxsize_choose_item_list );
    }
    choose_item_list[size_choose_item_list] = item;
    *nr = size_choose_item_list++;
}

void change_choose_list()
{
    Dimension w, h, hs;

    XawListChange(choose_item, choose_item_list, size_choose_item_list,
		  0, True);
    XtManageChild(choose_item);
    /*
     * We have to resize everything, because this is not properly done
     * within the widget
     */
    execute_events();
    /*
     * Maybe we don't have a scrollbar in the viewport, so we can't ask
     * for the height of it.
     */
    hs = 20;

    get_wh(choose_item, &w, &h);
    if (w > (Dimension) (VIEWWIDTH - 8)) {
        w = VIEWWIDTH;
        if (h < 20)
            h = 20;
        h += hs;
    } else if (w < choose_random_width)
        w = choose_random_width;
    if (h > (Dimension) (VIEWHEIGHT - 8)) {
        h = VIEWHEIGHT;
	w += hs;
    }
    XtResizeWidget(view, w, h, 2);
    /* Yes, Shell and not choose_widget */
    h += 8;
    if (managed_random)
        h += choose_random_height + 4;
    XtResizeWidget(Shell, w+8, h, 2);
    XtResizeWindow(Shell); /* For sometimes the window is not width enough. */

    choosing_random_once = 0;
}

void free_choose_list()
{
    int i;

    size_choose_item_list = 0;
    for (i = 0; i < maxsize_choose_item_list; i++)
	choose_item_list[i] = NULL;
    XtUnmanageChild(choose_item);
}

unsigned int length_choose_list()
{
    return (size_choose_item_list);
}

/*************************
	routines for getting the chosen items
*************************/

static unsigned int chosen_item;
static int chosen_item_set = 0;

void set_chosen_item()
{
    /* R4 */
    XawListReturnStruct *item;

    /* R 4 */
    item = XawListShowCurrent(choose_item);
    chosen_item = item->list_index;
    chosen_item_set = 1;
}

void force_chosen_item(item)
int item;
{
    chosen_item = item;
    chosen_item_set = 1;
}

unsigned int get_chosen_item()
{
    chosen_item_set = 0;
    choosing_random_once = 0;
    return (chosen_item);
}

int item_is_chosen()
{
    return (chosen_item_set);
}

void set_item_to_choose(item)
    int item;
{
    XawListHighlight(choose_item, item);
}

void unset_item_to_choose()
{
    XawListUnhighlight(choose_item);
    chosen_item_set = 0;
}

int random_choose_once()
{
    return (choosing_random_once);
}

/*************************
 (de)activation for trace form stdin
*************************/

void deactivate_choose()
{
    XtSetSensitive(choose_random_once, False);
}

void activate_choose()
{
    XtSetSensitive(choose_random_once, True);
}

/*
 * Concatinate the strings from the choose list (for animation).
 */
static char buf[2048];

char *concat_choose_strings()
{
    int i;

    *buf = '\0';
    for (i = 0; i < size_choose_item_list; i ++) {
	if (i)
	    (void) strcat(buf, "#");
	(void) strcat(buf, choose_item_list[i]);
    }
    return(buf);
}

void make_choice(choice)
char *choice;
{
    int i;

    for (i = 0; i < size_choose_item_list; i ++) {
	if (!strcmp(choose_item_list[i], choice)) {
	    force_chosen_item(i);
	    break;
	}
    }
}
