#include <stdio.h>
#include "psf_prototype.h"
#include "tiltype.h"
#include "process.h"
#include "psf_malloc.h"

#ifdef DEBUG_MEMUSE
static int count_process_new = 0;
static int count_process_old = 0;
static int count_process_free = 0;
static int count_tail_new = 0;
static int count_tail_old = 0;
static int count_tail_free = 0;
static int count_set_new = 0;
static int count_set_old = 0;
static int count_set_free = 0;
static int count_expr_new = 0;
static int count_expr_old = 0;
static int count_expr_free = 0;
static int count_h_t_new = 0;
static int count_h_t_old = 0;
static int count_h_t_free = 0;
static int count_child_new = 0;
static int count_child_old = 0;
static int count_child_free = 0;
static int count_string_new = 0;
static int count_string_old = 0;
static int count_string_free = 0;
#endif /* DEBUG_MEMUSE */

static struct process *p_list = NULL;

struct process *alloc_process()
{
    struct process *p;

    if (p_list) {
	p = p_list;
	p_list = p_list->parent;
#ifdef DEBUG_MEMUSE
	count_process_old ++;
#endif /* DEBUG_MEMUSE */
	return (p);
    } else {
#ifdef DEBUG_MEMUSE
	count_process_new ++;
#endif /* DEBUG_MEMUSE */
	return (PSF_MALLOC(struct process));
    }
}

void free_process(p)
    struct process *p;
{
#ifdef DEBUG_MEMUSE
    count_process_free ++;
#endif /* DEBUG_MEMUSE */
    /*
     * free (p);
     */
    p->parent = p_list;
    p_list = p;
}

static struct tailheap *t_list = NULL;

struct tailheap *alloc_tail()
{
    struct tailheap *t;

    if (t_list) {
	t = t_list;
	t_list = t_list->tail;
#ifdef DEBUG_MEMUSE
	count_tail_old ++;
#endif /* DEBUG_MEMUSE */
	return (t);
    } else {
#ifdef DEBUG_MEMUSE
	count_tail_new ++;
#endif /* DEBUG_MEMUSE */
	return (PSF_MALLOC(struct tailheap));
    }
}

void free_tail(t)
    struct tailheap *t;
{
#ifdef DEBUG_MEMUSE
    count_tail_free ++;
#endif /* DEBUG_MEMUSE */
    /*
     * free (t);
     */
    t->tail = t_list;
    t_list = t;
}

struct set_list *alloc_set()
{
#ifdef DEBUG_MEMUSE
	count_set_new ++;
#endif /* DEBUG_MEMUSE */
    return (PSF_MALLOC(struct set_list ));
}

void free_set(t)
    struct set_list *t;
{
#ifdef DEBUG_MEMUSE
    count_set_free ++;
#endif /* DEBUG_MEMUSE */
    free(t);
}

static struct process_expr *e_list = NULL;

struct process_expr *alloc_expr()
{
    struct process_expr *e;

    if (e_list) {
	e = e_list;
	e_list = e_list->proc_expr.pe1.pe;
#ifdef DEBUG_MEMUSE
	count_expr_old ++;
#endif /* DEBUG_MEMUSE */
	return (e);
    } else {
#ifdef DEBUG_MEMUSE
	count_expr_new ++;
#endif /* DEBUG_MEMUSE */
	return (PSF_MALLOC(struct process_expr));
    }
}

void free_expr(e)
    struct process_expr *e;
{
#ifdef DEBUG_MEMUSE
    count_expr_free ++;
#endif /* DEBUG_MEMUSE */
    /*
     * free (e);
     */
    e->proc_expr.pe1.pe = e_list;
    e_list = e;
}

struct head_tail *alloc_h_t()
{
#ifdef DEBUG_MEMUSE
	count_h_t_new ++;
#endif /* DEBUG_MEMUSE */
    return (PSF_MALLOC(struct head_tail ));
}

void free_h_t(t)
    struct head_tail *t;
{
#ifdef DEBUG_MEMUSE
    count_h_t_free ++;
#endif /* DEBUG_MEMUSE */
    free(t);
}

struct process **alloc_child(nr)
    unsigned int nr;
{
#ifdef DEBUG_MEMUSE
	count_child_new ++;
#endif /* DEBUG_MEMUSE */
    return (PSF_NMALLOC(struct process *,nr ));
}

void free_child(t)
    struct process **t;
{
#ifdef DEBUG_MEMUSE
    count_child_free ++;
#endif /* DEBUG_MEMUSE */
    free(t);
}

void alloc_string()
{
#ifdef DEBUG_MEMUSE
	count_string_new ++;
#endif /* DEBUG_MEMUSE */
}

void free_string(s)
char *s;
{
#ifdef DEBUG_MEMUSE
    count_string_free ++;
#endif /* DEBUG_MEMUSE */
    free(s);
}

#ifdef DEBUG_MEMUSE
void print_alloc_count()
{
    fprintf(stderr, "process : %11d %11d %11d %11d\n", count_process_new,
	count_process_old, count_process_free, count_process_new +
	count_process_old - count_process_free);
    fprintf(stderr, "tail    : %11d %11d %11d %11d\n", count_tail_new,
	count_tail_old, count_tail_free, count_tail_new +
	count_tail_old - count_tail_free);
    fprintf(stderr, "set     : %11d %11d %11d %11d\n", count_set_new,
	count_set_old, count_set_free, count_set_new +
	count_set_old - count_set_free);
    fprintf(stderr, "expr    : %11d %11d %11d %11d\n", count_expr_new,
	count_expr_old, count_expr_free, count_expr_new +
	count_expr_old - count_expr_free);
    fprintf(stderr, "h_t     : %11d %11d %11d %11d\n", count_h_t_new,
	count_h_t_old, count_h_t_free, count_h_t_new +
	count_h_t_old - count_h_t_free);
    fprintf(stderr, "child   : %11d %11d %11d %11d\n", count_child_new,
	count_child_old, count_child_free, count_child_new +
	count_child_old - count_child_free);
    fprintf(stderr, "string  : %11d %11d %11d %11d\n", count_string_new,
	count_string_old, count_string_free, count_string_new +
	count_string_old - count_string_free);
}
#endif /* DEBUG_MEMUSE */
