.TH GENANIM 1L "June 21, 2005" "PSF-Toolkit" "LOCAL COMMANDS"
.UC 4
.SH NAME
genanim \- generate animations for simanim
.SH SYNOPSIS
.B genanim
[\|-C\|]
[\|-E\|]
[\|-G \fIorientation\fP\|]
[\|-H\|]
[\|-N\|]
[\|-O\|]
[\|-R\|]
[\|-S\|]
[\|-U\|]
\fIstart-process TIL-code\fP
.br
.B genanim
[\|-h\|]
.SH DESCRIPTION
.B Genanim
generates animations for
.BR simanim (1L).
It builds a process graph for the
.I start-process
and generates a list of atoms and communications that can occur.
From the graph, input for
.BR dot (1L)
is generated that calculates positions for the nodes and edges in the
graph.
The output of
.BR dot (1L)
is transformed into an animation by
.BR dot2anim (1L),
and from the list of atoms and communications the action and choose
functions for the animation are generated.
.SH OPTIONS
.TP
.B \-h
Prints a help message.
.TP
.B \-C
Combine processes that run in parallel but do not communicate with
each other.
.TP
.B \-E
Extend atoms and communications by replacing terms that contain
a variable with a variable.
Except terms that start with a function for which no equation can be
found with a left-hand-side that starts with this function.
In this case, the same is done for the subterms.
.TP
.B \-G \fIorientation\fP
Defines the orientation of the graph.
.I orientation
may be either TB (for top to bottom, the default) or LR (for left
to right).
.TP
.B \-H
Use heuristics. For deciding the direction of a communication,
the names of the communications-partners are checked on being equal
to 'snd' and 'rec', or 'send' and 'receive', or
starting with 'snd-' and 'rec-'.
.TP
.B \-N
No input- and output-process. Normally for atoms that are not hidden,
a input- and output-process is generated with lines to the
appropriate processes. Now these atoms are considered local to their
process.
.TP
.B \-O
No ordering of processes. Normally processes are ordered based on
having local actions (high ordering) or sum-port actions (low ordering).
.TP
.B \-R
Remove duplicate processes, atoms, and communications.
When processes appear on both sides of
an alternation, they appear twice in the process graph. This
option filters one of them unless it is hidden or encapsulated.
Duplicate atoms which belong to the same process are removed.
Duplicate communications between the same two processes are also
removed.
.TP
.B \-S
Sub-process mapping. In the following cases a sub-process is mapped
onto another process:
.sp
\- If one side of a merge starts with an atom, this side is considered
part of the process which contains the merge and not a new process.
The other side is considered a process that runs in parallel with the
process which contains the merge.
.sp
\- A sub-process that is expanded (replaced by its process definition)
and that is not part of merge, is mapped onto its parent process.
.br
This makes it possible to split a process definition in several parts.
.sp
\- If a process with a name consist of a sum-port (one or more nested
sum operators with an atom for receiving value(s) from another process)
with a single process as sub-process, then this sub-process is mapped
onto the process containing the sum-port.
.TP
.B \-U
Show unused processes in the animation. Processes that have no atoms
and no communications associated with them are normally not shown
in an animation.
.SH SEE ALSO
.BR simanim (1L),
.BR dot (1L),
.BR dot2anim (1L)
.LP
.BR dot (1L)
is part of the package GraphViz, which can be  found on WWW
.RS
<URL:http://www.research.att.com/sw/tools/graphviz/>.
.RE
.SH AUTHOR
Bob Diertens, University of Amsterdam (bobd@science.uva.nl)
