.TH PPP 1L "February 1, 1995" "PSF-Toolkit" "LOCAL COMMANDS"
.UC 4
.SH NAME
ppp \- PSF pretty printer
.SH SYNOPSIS
.in +\w'\fBppp \fR'u
.ti -\w'\fBppp \fR'u
.B ppp
[\ \fB\-ai\fR\ ]
[ \fB\-bac\fR\ |\ \fB\-nbac\fR\ ]
[ \fB\-bals\fR\ |\ \fB\-nbals\fR\ ]
[\ \fB\-bas\fR\ |\ \fB\-nbas\fR\ ]
[\ \fB\-bc\fR\ |\ \fB\-nbc\fR\ ]
[\ \fB\-bei\fR\ |\ \fB\-nbei\fR\ ]
[\ \fB\-br\fR\ |\ \fB\-nbr\fR\ ]
[\ \fB\-bsr\fR\ |\ \fB\-nbsr\fR\ ]
[\ \fB\-ci\fR\fIn\fR\ ]
[\ \fB\-di\fR\fIn\fR\ ]
[\ \fB\-D\fR\ ]
[\ \fB\-df\fR\ |\ \fB\-ndf\fR\ ]
[\ \fB\-ei\fR\fIn\fR\ ]
[\ \fB\-h\fR\ ]
[\ \fB\-i\fR\fIn\fR\ ]
[\ \fB\-idpre\fIs\fR\ ]
[\ \fB\-idpost\fIs\fR\ ]
[\ \fB\-kef\fR\ |\ \fB\-nkef\fR\ ]
[\ \fB\-kwpre\fIs\fR\ ]
[\ \fB\-kwpost\fIs\fR\ ]
[\ \fB\-l\fR\fIn\fR\ ]
[\ \fB\-n\fR\ ]
[\ \fB\-pc\fR\fIn\fR\ ]
[\ \fB\-pei\fR\fIn\fR\ ]
[\ \fB\-pel\fR\ |\ \fB\-npel\fR\ ]
[\ \fB\-phi\fR\fIn\fR\ ]
[\ \fB\-sf\fR\ |\ \fB\-nsf\fR\ ]
[\ \fB\-si\fR\fIn\fR\ ]
[\ \fB\-tcn\fR\ |\ \fB\-ntcn\fR\ ]
[\ \fB\-tg\fR\ |\ \fB\-ntg\fR\ ]
[\ \fB\-ti\fR\fIn\fR\ ]
[\ \fB\-tl\fR\fIn\fR\ ]
[\ \fB\-ts\fR\fIn\fR\ ]
[\ \fB\-v\fR\ ]
[\ \fIfile\fR\ ...\ ]
.SH DESCRIPTION
.B ppp
is a PSF specification formatter.
It reformats the specification according to the switches taken from
the command-line and/or from the environment variable
.BR PSFPRETTY .
Options on the command-line precede options given in
.BR PSFPRETTY .
.SH OPTIONS
.TP
.BI \-ai n
Sets indentation for arguments to
.IR n .
The arguments (including the ':') are put after the current indentation
plus the argument indentation. If this position is already reached,
a single space is put in for separation from the arguments.
The default is 12.
.TP
.BR \-bac , \-nbac
If
.B \-bac
is specified, a blank after a comma in a comma separated list is
generated.
Default:
.BR \-bac .
.TP
.BR \-bals , \-nbals
if
.B \-bals
is specified, a blank is put before and after the argument list
separation ('#').
Default:
.BR \-bals .
.TP
.BR \-bas , \-nbas
If
.B \-bas
is specified, a blank line after each section is forced.
The beginning of a module is considered a section.
Default:
.BR \-nbas .
.TP
.BR \-bc , \-nbc
If
.B \-bc
is specified, after each comma in a list of items, a newline is
inserted. Otherwise these comma's are dealt with as specified by option
.BR \-bac / \-nbac .
Currently this is only done for sorts and imports.
An import with bindings and/or renamings, however, always begins on a
new line.
Default:
.BR \-nbc .
.TP
.BR \-bei , \-nbei
If
.B \-bei
is specified, a block delimited by 'begin' and 'end' gets an extra indent.
The module block is not altered by this option.
Default:
.BR \-nbei .
.TP
.BR \-br , \-nbr
Specifying
.B \-br
lets a block begin on the right side instead of on the next line.
A block is considered a piece of code delimited
by 'begin' and 'end', '{' and '}', '[' and ']'.
Default:
.BR \-nbr .
.TP
.BR \-bsr , \-nbsr
If
.B \-bsr
is specified, the contents of a block is started on the right of the
beginning of a block, instead of on a new line.
This is only valid for blocks delimited by '{' and '}', and '[' and ']'.
Default:
.BR \-nbsr .
.TP
.BI \-ci n
Sets the continuation indent to be
.IR n .
Continuation lines will be indented the normal indentation plus the
continuation indent.
The default is the same as the default value of
.BR \-i .
.TP
.BI \-di n
Sets indentation for process definitions to
.IR n .
The right-hand-side of the process definition is put after the
current indentation plus the definition indentation.
If this position is already reached, a single space is used for separation.
The default is 12.
.TP
.BR \-df , \-ndf
If
.B \-df
is specified, definitions are formatted in a special way, for example:
.br
.in +0.5i
.nf
.ta 0.3i +0.3i +0.3i
	expr1
\&.	expr2
+	encaps(H,
			expr3
		.	expr4
	)
.in -0.5i
.fi
Default:
.BR \-df .
.br
Note:
.B -df
overrides
.BR \-kef .
.TP
.B \-D
Device independent code is generated, for use with one of the
postprocessors
.BR ppptoroff (1L),
and
.BR ppptotex (1L).
.TP
.BI \-ei n
Sets indentation for equation to
.IR n .
The equations start this much from the beginning of the tag.
If the tag is too long, the equation is separated from the tag by a single
space.
The default is 8.
.TP
.B \-h
Displays a help message.
Not allowed in environment variable
.BR PSFPRETTY .
.TP
.BI \-i n
Sets the indentation to be
.IR n .
The default is 4.
.TP
.BI \-idpre s
Prints the string
.I s
before every identifier. Operators are not considered to be identifiers.
The default is printing nothing.
.TP
.BI \-idpost s
Prints the string
.I s
after every identifier.
The default is printing nothing.
.TP
.BR \-kef , \-nkef
If
.B \-kef
is specified expresssion formats are kept the way they are found,
that is newlines and space on the beginning of the lines are kept, but
not the spaces in a line.
Default:
.BR \-nkef .
.br
Note:
.B \-kef
is only in effect when
.BR \-ndf .
.TP
.BI \-kwpre s
Prints the string
.I s
before every keyword.
The default is printing nothing.
.TP
.BI \-kwpost s
Prints the string
.I s
after every keyword.
The default is printing nothing.
.TP
.BI \-l n
Maximum length of an output line.
A length smaller than the indentation gives unpretty results.
Comments may exceeds the length.
The default is 78.
.TP
.B \-n
Numbers the output lines.
.TP
.BI \-pc n
Controls the placement of comments which are not in the middle of code.
Comments are placed
.I n
indentation levels to the left of the code. Negative numbers are allowed.
The default is 1.
.TP
.BI \-pei n
Sets indentation for process-expression (the right-part of the
definitions) to
.IR n .
Here,
.I n
should be larger than 2, because that is the maximum length of an
operator symbol in process-expression, although smaller values are
possible.
The default is 3.
.TP
.BR \-pel , \-npel
If
.B \-pel
is specified, empty lines are preserved.
Although, empty lines on the start of the code are not preserved.
Default:
.BR \-npel .
.TP
.BI \-phi n
Sets the indentation for placeholders (those of communications) to
.IR n .
The placeholder is put after the beginning of the communication
plus the placeholder indentation.
If this position is already reached, a single space is used for separation.
The default is 32.
.TP
.BR \-sf , \-nsf
If
.B \-sf
is specified, set-expressions are formatted in a special way, for example:
.br
.in +0.5i
.nf
.ta 0.3i +0.3i +0.3i
	expr1
\&+	expr2
\\	(
			expr3
		.	expr4
	)
.in -0.5i
.fi
Default:
.BR \-sf .
.TP
.BI \-si n
Sets indentation for set definitions to
.IR n .
The right-hand-side of the set definition is put after the
current indentation plus the definition indentation.
If this position is already reached, a single space is used for separation.
The default is 8.
.TP
.BR \-tcn , \-ntcn
If
.B \-tcn
is specified, tags are numbered continuously over the modules.
This is only taken into account if
.BR \-tg
is specified.
Default:
.BR \-ntcn .
.TP
.BR \-tg , \-ntg
If
.B \-tg
is specified, tags on equations are generated. They are numbered 01, 02,
03, ... .
Default:
.BR \-ntg .
.TP
.BI \-ti n
Sets indentation for tags to
.IR n .
The default is 0.
.TP
.BI \-tl n
Sets the length of the tags to
.IR n .
This is only taken into account if
.BR \-tg
is specified.
The default is 2.
.TP
.BI \-ts n
Sets the start of the tag numbering to
.IR n.
This is only taken into account if
.BR \-tg
is specified.
The default is 1.
.TP
.B \-v
Displays the version-number of
.BR ppp .
Not allowed in environment variable
.BR PSFPRETTY .
.SH DIAGNOSTICS
Comments are a rather difficult matter in pretty printing.
.B ppp
tries to maintain the positions of the comments, such that comments on the
left are kept on the left, and comments on the right are kept on the right.
Also the order of the comments are kept, which may cause a comment somewhere
in the middle of the code to appear after a comment on the right.
.PP
The supply of the options \fB-kwpre\fR, \fB-kwpost\fR,
\fB-idpre\fR, and \fB-idpost\fR is a rather poor attempt
to support textformatters.
However, the following input for Troff gives decent results.
.nf
.in +0.5i
\&.\\" set constant width characters
\&.cs R 24
\&.cs B 24
\&.cs I 24
\&.\\" ligature mode off
\&.lg 0
\&.nf
    pretty printed code with options:
    -kwpre"\\fB" -kwpost"\\fP" -idpre"\\fI" -idpost"\\fP"
\&.fi
\&.lg
\&.cs R
\&.cs B
\&.cs I
.in -0.5i
.fi
It is better to use
.B \-D
and one of the postprocessors.
.PP
For doing a better job, like aligning the argument list for functions,
atoms, and processes, a two-pass pretty printer is needed.
The first pass for gathering information, and the second for printing
with knowledge of this information.
This can also help in solving the bugs, mentioned below.
.SH ENVIRONMENT
.TP 15n
.B PSFPRETTY
Options to be set by default. Options must be given in the same way as
on the command-line.
.SH SEE ALSO
.BR ppptoroff (1L),
.BR ppptotex (1L)
.SH BUGS
When
.B \-df
is specified, an expression that has not a . + or || operator as top
node, is indented to much.
.SH AUTHOR
Bob Diertens, University of Amsterdam (bobd@fwi.uva.nl)
