%{
/*============================================================================*
 *									      *
 *	file: pp.y							      *
 *	info: the YACC grammar for the PSF parser (Pretty Printer)     	      * 
 *									      *
 *============================================================================*/


#include <stdio.h>
#include <string.h>
#include "psf_prototype.h"
#include "psf_exits.h"
#include "lex.h"
#include "getextopt.h"
#include "pretty.h"
#include "errordet.h"

static void hook_start PROTO_ARGS((void));
static void hook_end PROTO_ARGS((void));

#undef yyerror
#define yyerror(x) pp_newline(); errordet(yystate)

extern int lex_state; /* from lex */

extern int errorseen;
void on_syntax_err()
{
    errorseen = EXIT_SYNTAX_ERR;
}
%}

%start	specification

%union  {
	    char *literal;
	    int nl;
	}

%token DATA_SYM MODULE_SYM BEGIN_SYM END_SYM PARAMETERS_SYM EXPORTS_SYM 
%token IMPORTS_SYM RENAMED_SYM BY_SYM ARROW_SYM BOUND_SYM TO_SYM SORTS_SYM 
%token FUNCTIONS_SYM VARIABLES_SYM EQUATIONS_SYM WHEN_SYM IMPLIES_SYM
%token PROCESS_SYM ATOMS_SYM PROCESSES_SYM SETS_SYM OF_SYM IN_SYM
%token COMMUNICATIONS_SYM FOR_SYM DEFINITIONS_SYM SKIP_SYM DELTA_SYM
%token GEN_MERGE_SYM SUM_SYM ENCAPS_SYM HIDE_SYM INTR_SYM DISR_SYM
%token PRIO_SYM CHAIN_SYM EMPTY_LINE

%token	<literal>	IDENTIFIER_SYM
%token	<literal>	OPERATOR_SYM
%token	<literal>	NEWLINE

%left	'+'
%left	'\\' 
%left	'.'
%left   NEWLINE
%left	ARROW_SYM OPERATOR_SYM

%%


specification : 
            module_list
;

module_list :
            module
        |   module_list module 
;

module :
            DATA_SYM MODULE_SYM IDENTIFIER_SYM {
		lex_start_all();
		pp_empty_codeline();
		pp_start_module();
		pp_keyword("data");
		pp_space();
		pp_keyword("module");
		pp_space();
		pp_identifier($3);
	    }
	    BEGIN_SYM {
		pp_newline();
		pp_keyword("begin");
		pp_newline();
		pp_end_section();
		pp_inc();
	    }
	    data_parameters
	    data_exports
	    imports 
	    sorts 
	    functions 
	    variables 
	    equations
	    END_SYM {
		pp_dec();
		pp_keyword("end");
		pp_space();
	    }
	    IDENTIFIER_SYM {
		pp_identifier($16);
		pp_newline();
		pp_end_module();
		pp_newline();
	    }
	|   PROCESS_SYM MODULE_SYM IDENTIFIER_SYM {
		lex_start_all();
		pp_empty_codeline();
		pp_start_module();
		pp_keyword("process");
		pp_space();
		pp_keyword("module");
		pp_space();
                pp_identifier($3);
	    }
	    BEGIN_SYM {
		pp_newline();
		pp_keyword("begin");
		pp_newline();
		pp_end_section();
		pp_inc();
	    }
	    process_parameters
	    process_exports
	    imports 
	    atoms 
	    processes 
	    sets 
	    communications 
	    variables 
	    definitions

	    END_SYM {
                pp_dec();
                pp_keyword("end");
		pp_space();
	    }
	    IDENTIFIER_SYM {
                pp_identifier($18);
                pp_newline();
		pp_end_module();
                pp_newline();
	    }
;

data_parameters :
	    PARAMETERS_SYM {
		pp_begin_section();
                pp_keyword("parameters");
                pp_inc();
                pp_newline();
	    }
            data_parameter_list {
                pp_dec();
		pp_newline();
		pp_end_section();
	    }
        | /* empty */
;

data_parameter_list :
	    data_parameter
	|   data_parameter_list ',' {
		pprint(",");
                pp_newline();
	    }
            data_parameter
;

data_parameter :
	    IDENTIFIER_SYM {
                pp_identifier($1);
	    }
            BEGIN_SYM {
		pp_beginend_indent();
                pp_begin_block("begin");
		pp_end_section();
	    }
            sorts
            functions 
            END_SYM {
		pp_end_block("end");
		pp_dec();
	    }
            IDENTIFIER_SYM {
		pp_space();
                pp_identifier($9);
	    }
;

process_parameters :
	    PARAMETERS_SYM {
		pp_begin_section();
                pp_keyword("parameters");
                pp_inc();
		pp_newline();
	    }
	    process_parameter_list {
		pp_dec();
		pp_newline();
		pp_end_section();
	    }
	| /* empty */
;

process_parameter_list :
            process_parameter
	|   process_parameter_list ',' {
                pprint(",");
                pp_newline();
	    }
            process_parameter
;

process_parameter :
	    IDENTIFIER_SYM {
                pp_identifier($1);
	    }
            BEGIN_SYM {
		pp_beginend_indent();
                pp_begin_block("begin");
		pp_end_section();
	    }
	    sorts
	    functions atoms processes par_sets 
	    END_SYM {
                pp_end_block("end");
		pp_dec();
	    }
	    IDENTIFIER_SYM {
		pp_space();
                pp_identifier($12);
	    }
;

data_exports :
	    EXPORTS_SYM {
		pp_begin_section();
                pp_keyword("exports");
	    }
	    BEGIN_SYM {
		pp_beginend_indent();
                pp_begin_block("begin");
		pp_end_section();
	    }
	    sorts functions 
	    END_SYM {
                pp_end_block("end");
		pp_dec();
		pp_newline();
		pp_end_section();
	    }
	| /* empty */
;

process_exports :
	    EXPORTS_SYM {
		pp_begin_section();
                pp_keyword("exports");
	    }
	    BEGIN_SYM {
		pp_beginend_indent();
                pp_begin_block("begin");
		pp_end_section();
	    }
	    atoms processes sets
	    END_SYM {
                pp_end_block("end");
		pp_dec();
		pp_newline();
                pp_end_section();
	    }
	| /* empty */
;

imports :
	    IMPORTS_SYM {
		pp_begin_section();
                pp_keyword("imports");
                pp_inc();
                pp_newline();
		lex_start_inlist();
		pp_list_start();
		pp_fit_start();
	    }
	    module_expression_list {
		pp_fit_end();
		pp_list_end();
                pp_dec();
                pp_newline();
                pp_end_section();
		lex_start_restore(2);
	    }
	| /* empty */ 
;

module_expression_list :
	    module_expression
	|   module_expression_list ',' EMPTY_LINE {
                pp_comma();
		pp_fit_end();
                pp_line_comma();
		pp_fit_start();
		pp_newline();
		pp_empty_codeline();
	    }
	    module_expression
	|   module_expression_list ',' {
                pp_comma();
		pp_fit_end();
                pp_line_comma();
		pp_fit_start();
	    }
	    module_expression
;

module_expression :
	    sidentifier
	|   sidentifier EMPTY_LINE {
		pp_fit_end();
		pp_newline();
		pp_empty_codeline();
		pp_fit_start();
	    }
	|   IDENTIFIER_SYM '{' {
		pp_fit_end();
		pp_newline();
		pp_fit_start();
		pp_identifier($1);
		pp_fit_end();
		lex_start_all();
                pp_begin_block("{");
	    }
	    modifier end_block {
		pp_fit_start();
	    }
;

end_block :
	    end_block_symbol EMPTY_LINE {
		lex_start_inlist();
	    }
	|   end_block_symbol {
		lex_start_inlist();
	    }
;

end_block_symbol :
	    '}' {
		pp_newline();
                pp_end_block("}");
	    }
;

modifier :
	    renamed	
	|   renamed {
		pp_newline();
                pp_end_section();
	    }
	    bound_list
	|   bound_list
	|   bound_list {
		pp_newline();
                pp_end_section();
	    }
	    renamed
;

renamed :
	    RENAMED_SYM {
		pp_fit_start();
                pp_keyword("renamed");
		pp_space();
	    } BY_SYM {
		pp_keyword("by");
		pp_fit_end();
	    }
	    renamings 
;

renamings :
	    '[' {
                pp_begin_block("[");
	    }
	    renaming_list
	    ']' {
		pp_newline();
                pp_end_block("]");
	    }
;

renaming_list :
	    renaming
	|   renaming_list ',' {
		pp_fit_start();
                pp_comma();
		pp_fit_end();
                pp_line_comma();
	    }
	    renaming
;

renaming :
	    ident_or_operator ARROW_SYM {
		pp_fit_start();
		pp_space();
		pp_fit_end();
		pp_fit_start();
                pprint("->");
		pp_fit_end();
		pp_fit_start();
		pp_space();
		pp_fit_end();
	    }
	    ident_or_operator
;

ident_or_operator :
	    IDENTIFIER_SYM {
		pp_fit_start();
		pp_identifier($1);
		pp_fit_end();
	    }
	|   OPERATOR_SYM '_' {
		pp_fit_start();
                pprint($1);
                pprint("_");
		pp_fit_end();
	    }
	|   '_' OPERATOR_SYM '_'	
	    {
		pp_fit_start();
                pprint("_");
                pprint($2);
                pprint("_");
		pp_fit_end();
	    }
;

bound_list :
	    bound
	|   bound_list {
		pp_newline();
                pp_end_section();
	    }
	    bound
;

bound :
	    identifier bound_word TO_SYM {
		pp_fit_start();
		pp_space();
		pp_keyword("to");
		pp_space();
		pp_fit_end();
	    }
	    identifier
	|   identifier bound_word BY_SYM {
		pp_space();
		pp_keyword("by");
		pp_fit_end();
	    }
	    renamings TO_SYM {
		pp_fit_start();
		pp_space();
                pp_keyword("to");
		pp_space();
		pp_fit_end();
	    }
	    identifier
;

bound_word :
	BOUND_SYM {
	    pp_fit_start();
	    pp_space();
	    pp_keyword("bound");
	}
;

sorts :
	    SORTS_SYM {
		pp_begin_section();
                pp_keyword("sorts");
                pp_inc();
                pp_newline();
		pp_list_start();
		pp_fit_start();
	    }
	    sort_list
	    {
		pp_fit_end();
		pp_list_end();
                pp_dec();
		pp_newline();
                pp_end_section();
	    }
	| /* empty */ 
;

sort_list :
	    IDENTIFIER_SYM {
                pp_identifier($1);
	    }
	|   sort_list ',' IDENTIFIER_SYM {
		pp_comma();
		pp_fit_end();
		pp_line_comma();
		pp_fit_start();
                pp_identifier($3);
	    }
;

functions :
	    FUNCTIONS_SYM {
		pp_begin_section();
                pp_keyword("functions");
                pp_inc();
                pp_newline();
	    }
	    function_list {
                pp_dec();
		pp_newline();
                pp_end_section();
	    }
	| /* empty */
;

function_list :
	    function
	|   function_list {
		pp_newline();
	    }
	    function
;

function :
	    function_id ':' {
		pp_arg_indent(":");
		pp_arg_start();
	    } input_type ARROW_SYM {
		pp_fit_start();
		pp_space();
		pprint("->");
		pp_space();
		pp_fit_end();
	    } output_type {
		pp_arg_end();
	    }
;

function_id :
	    IDENTIFIER_SYM {
                pp_identifier($1);
	    }
	|   OPERATOR_SYM '_' {
                pprint($1);
                pprint("_");
	    }
	|   '_' OPERATOR_SYM '_' 
	    {
                pprint("_");
                pprint($2);
                pprint("_");
	    }
	|   error
	    '\n'
;

input_type : 
	    {
                pp_space();
	    }
	    product
	| /* empty */ 
;

output_type :
	    IDENTIFIER_SYM {
		pp_fit_start();
		pp_identifier($1);
		pp_fit_end();
	    }
;

product :
	    IDENTIFIER_SYM {
		pp_fit_start();
		pp_identifier($1);
		pp_fit_end();
	    }
	|   product '#' {
		pp_fit_start();
                pp_arg_sep("#");
		pp_fit_end();
	    } IDENTIFIER_SYM {
		pp_fit_start();
                pp_identifier($4);
		pp_fit_end();
	    }
;

atoms :
	    ATOMS_SYM {
		pp_begin_section();
                pp_keyword("atoms");
                pp_inc();
                pp_newline();
		lex_start_inlist();
		pp_list_start();
		pp_fit_start();
	    }
	    atom_list {
		pp_fit_end();
		pp_dec();
		pp_newline();
		pp_end_section();
		lex_start_restore(2);
	    }
	| /* empty */	
;

atom_list :
	    atom_decl {
	    }
	|   atom_list {
		pp_list_start();
		pp_fit_start();
	    }
	    atom_decl
;

atom_decl :
	    sidentifier {
		pp_space();
		pp_fit_end();
		pp_list_end();
	    }
	|   sidentifier ',' {
                pp_comma();
		pp_fit_end();
		pp_fit_start();
	    }
	    atom_decl {
		pp_newline();
	    }
	|   sidentifier ':' {
		pp_fit_end();
		pp_list_end();
                pp_arg_indent(":");
		pp_arg_start();
		pp_space();
	    }
	    atom_args {
		pp_arg_end();
                pp_newline();
	    }
	|   EMPTY_LINE {
		pp_empty_codeline();
	    }
	|   error
	    '\n'
;

atom_args :
	    atom_arg
	|   error
	    '\n'
;

atom_arg :
	    IDENTIFIER_SYM {
		pp_fit_start();
                pp_identifier($1);
		pp_fit_end();
	    }
	|   atom_arg '#' IDENTIFIER_SYM {
		pp_fit_start();
                pp_arg_sep("#");
		pp_fit_end();
		pp_fit_start();
                pp_identifier($3);
		pp_fit_end();
	    }
;

processes :
	    PROCESSES_SYM {
		pp_begin_section();
                pp_keyword("processes");
                pp_inc();
                pp_newline();
		lex_start_inlist();
		pp_list_start();
		pp_fit_start();
	    }
	    process_list {
		pp_fit_end();
                pp_dec();
		pp_newline();
                pp_end_section();
		lex_start_restore(2);
	    }
	| /* empty */	
;

process_list :
	    process_decl {
	    }
	|   process_list {
		pp_list_start();
		pp_fit_start();
	    }
	    process_decl
;

process_decl :
	    sidentifier {
		pp_space();
		pp_fit_end();
		pp_list_end();
	    }
	|   sidentifier ',' {
		pp_comma();
		pp_fit_end();
		pp_fit_start();
	    } process_decl {
		pp_newline();
	    }
	|   sidentifier ':' {
		pp_fit_end();
		pp_list_end();
                pp_arg_indent(":");
		pp_arg_start();
		pp_space();
	    } process_args {
		pp_arg_end();
                pp_newline();
	    }
	|   EMPTY_LINE {
		pp_empty_codeline();
	    }
	|   error
	    '\n'
;
		
identifier :
	IDENTIFIER_SYM {
	    pp_fit_start();
	    pp_identifier($1);
	    pp_fit_end();
	}
;

sidentifier :
	IDENTIFIER_SYM {
	    pp_identifier($1);
	}
;

process_args :
	    process_arg
	|   error
	    '\n'
;

process_arg :
	    IDENTIFIER_SYM {
		pp_fit_start();
                pp_identifier($1);
		pp_fit_end();
	    }
	|   process_arg '#' {
		pp_fit_start();
                pp_arg_sep("#");
		pp_fit_end();
	    } IDENTIFIER_SYM
	    {
		pp_fit_start();
                pp_identifier($4);
		pp_fit_end();
	    }
;

par_sets :
	    SETS_SYM {
		pp_begin_section();
                pp_keyword("sets");
                pp_inc();
                pp_newline();
	    }
	    par_set_defs_list {
                pp_dec();
		pp_end_section();
	    }
	|  /* empty */
;

par_set_defs_list :
	    par_set_defs
	|   par_set_defs_list
	    par_set_defs
;

par_set_defs :
	    OF_SYM {
                pp_keyword("of");
		pp_space();
                pp_inc();
	    }
	    identifier_or_atoms par_set_definition_list {
                pp_dec();
                pp_newline();
	    }
	|   error
	    '\n'
;

par_set_definition_list :
	    par_set_definition
	|   par_set_definition_list {
		pp_newline();
	    }
	    par_set_definition
	|   error
	    '\n'
;

par_set_definition :
	    IDENTIFIER_SYM {
                pp_identifier($1);
	    }
;

sets :
	    SETS_SYM {
		pp_begin_section();
                pp_keyword("sets");
                pp_inc();
                pp_newline();
		pp_start_set();
	    }
	    set_defs_list {
                pp_dec();
		pp_end_section();
	    }
	|   /* empty */
;

set_defs_list :
	    set_defs
	|   set_defs_list
	    set_defs
;

set_defs :
	    OF_SYM {
		pp_keyword("of");
		pp_space();
		pp_inc();
	    }
	    identifier_or_atoms
	    set_definition_list {
		pp_dec();
	    }
	|   error
	    '\n'
;

identifier_or_atoms :
	    IDENTIFIER_SYM {
                pp_identifier($1);
                pp_newline();
	    }
	|   ATOMS_SYM {
                pp_keyword("atoms");
                pp_newline();
	    }
;

set_definition_list :
	    set_definition
	|   set_definition_list
	    set_definition
	|   error
	    '\n'
;

set_definition :
	    identifier '=' {
		pp_exp_start("=");
	    }
	    set_exp {
		pp_exp_end();
	    }
;

set_exp :
	    IDENTIFIER_SYM {
		pp_exp_indent();
		pp_fit_start();
		pp_identifier($1);
		pp_fit_end();
		pp_dec();
	    }
	|   ATOMS_SYM {
		pp_exp_indent();
		pp_fit_start();
		pp_keyword("atoms");
		pp_fit_end();
		pp_dec();
	    }
	|   set_enum_start {
		lex_start_nobar();
		pp_space();
	    }
	    set_item_list enum_cont  {
		lex_start_all();
	    }
	|   set_enum_start '}' {
                pp_space();
		pp_fit_start();
                pprint("}");
		pp_fit_end();
		pp_dec();
	    }
	|   set_exp OPERATOR_SYM {
                pp_exp_preop();
                pp_operator($2);
                pp_exp_postop();
	    }
	    set_exp
	|   '(' {
		pp_exp_indent();
		pp_fit_start();
                pprint("(");
		pp_fit_end();
		pp_exp_indent();
		pp_exp_newline();
	    }
	    set_exp ')' {
		pp_dec();
		pp_exp_newline();
		pp_fit_start();
                pprint(")");
		pp_fit_end();
		pp_dec();
	    }
;

set_enum_start :
	    '{' {
		pp_exp_indent();
		pp_fit_start();
                pprint("{");
		pp_fit_end();
		pp_fit_start();
	    }
;

enum_cont :
	    '}' {
		pp_fit_end();
		pp_fit_start();
		pp_space();
                pprint("}");
		pp_fit_end();
		pp_dec();
	    }
	|   '|' {
		pp_fit_end();
		pp_fit_start();
		pp_space();
                pp_operator("|");
		pp_space();
		pp_fit_end();
		pp_fit_start();
	    }
	    placeholder_list '}' {
		pp_fit_end();
		pp_fit_start();
		pp_space();
                pprint("}");
		pp_fit_end();
		pp_dec();
	    }
;

set_item_list :
	    set_item
	|   set_item_list ',' {
		pp_comma();
		pp_fit_end();
		pp_fit_start();
	    }
	    set_item
	|   error
	    '\n'
;

set_item :
	    term
;

placeholder_list :
	    placeholder
	|   placeholder_list ',' {
                pp_comma();
		pp_fit_end();
		pp_fit_start();
	    }
	    placeholder
	|   error
	    '\n'
;

placeholder :
            sidentifier IN_SYM {
		pp_fit_end();
		pp_fit_start();
		pp_space();
                pp_keyword("in");
		pp_fit_end();
		pp_fit_start();
		pp_space();
	    } sidentifier
;

communications :
	    COMMUNICATIONS_SYM {
		lex_start_nobar();
		pp_begin_section();
                pp_keyword("communications");
                pp_inc();
                pp_newline();
		pp_list_start();
	    }
	     communication_def_list {
		pp_list_end();
		lex_start_all();
                pp_dec();
                pp_newline();
		pp_end_section();
	    }
	|    /* empty */
;

communication_def_list :
	    communication_def
	|   communication_def_list {
                pp_newline();
	    }
	    communication_def
	|   error
	    '\n'
;

communication_def :
	    communication
	|   communication FOR_SYM {
                pp_inc();
                pp_placeholder_start();
		pp_fit_start();
                pp_keyword("for");
		pp_fit_end();
		pp_fit_start();
		pp_space();
		pp_fit_end();
		pp_fit_start();
	    }
	    placeholder_list {
		pp_fit_end();
                pp_placeholder_end();
                pp_dec();
	    }
;

communication :
	    atom_exp '|' {
		pp_fit_start();
		pp_space();
                pprint("|");
		pp_space();
		pp_fit_end();
	    }
	    atom_exp '=' {
		pp_fit_start();
		pp_space();
                pprint("=");
		pp_space();
		pp_fit_end();
	    }
	    atom_exp
;

atom_exp :
	    identifier
	|   identifier '(' {
		hook_start();
		pp_fit_start();
                pprint("(");
		pp_fit_end();
	    }
	    start_term_list ')' {
		hook_end();
		pp_fit_start();
                pprint(")");
		pp_fit_end();
	    }
;

variables :
	    VARIABLES_SYM {
		pp_begin_section();
                pp_keyword("variables");
                pp_inc();
                pp_newline();
	    }
	    variable_list {
                pp_dec();
		pp_end_section();
	    }
	|   /* empty */
;

variable_list :
	    var_decl 
	|   variable_list
	    var_decl 
;

var_decl :
	    {
		pp_list_start();
		pp_fit_start();
	    }
	    var_list ':' {
		pp_fit_end();
		pp_list_end();
		pp_arg_indent(":");
		pp_arg_start();
	    } ARROW_SYM {
		pp_fit_start();
		pp_space();
                pprint("->");
		pp_space();
		pp_fit_end();
	    } IDENTIFIER_SYM {
		pp_fit_start();
                pp_identifier($7);
		pp_fit_end();
		pp_arg_end();
                pp_newline();
	    }
	|   error
	    '\n'
;

var_list :
	    IDENTIFIER_SYM {
                pp_identifier($1);
	    }
	|   var_list ',' {
		pp_comma();
		pp_fit_end();
		pp_fit_start();
	    } IDENTIFIER_SYM {
		pp_identifier($4);
	    }
;

equations :
	    EQUATIONS_SYM {
		pp_begin_section();
                pp_keyword("equations");
		pp_init_tag();
                pp_tag_indent();
                pp_newline(); 
	    }
	    equation_list {
		pp_dec();
		pp_end_section();
	    }
	|   /* empty */
;

equation_list :
	    tag_equation {
		pp_dec();
		pp_newline();
	    }
	|   equation_list tag_equation {
		pp_dec();
		pp_newline();
	    }
;

tag_equation :
	    tag {
		pp_equ_start();
	    }
	    cond_equation {
		pp_equ_end();
	    }
;

cond_equation :
	    equation_serie IMPLIES_SYM {
		pp_equ_end();
		pp_newline();
		pp_equ_toindent();
		pp_equ_start();
		pp_fit_start();
                pp_keyword("==>");
		pp_fit_end();
		pp_equ_space();
	    }
	    equation
	|   equation
	|   equation WHEN_SYM {
		pp_equ_space();
		pp_fit_start();
                pp_keyword("when");
		pp_fit_end();
		pp_equ_end();
		pp_inc();
		pp_newline();
		pp_equ_toindent();
		pp_equ_start();
	    }
	    equation_serie {
		pp_dec();
	    }
;

tag :
	    '[' IDENTIFIER_SYM ']' {
		pprint("[");
		pp_tag($2);
		pprint("]");
		pp_equ_indent();
	    }
;

equation_serie :
	    equation
	|   equation_serie ',' {
		pp_fit_start();
                pprint(",");
		pp_fit_end();
		pp_equ_end();
		pp_newline();
		pp_equ_toindent();
		pp_equ_start();
	   }
	    equation
;

equation :
	    start_term '=' {
		pp_equ_space();
		pp_fit_start();
		pprint("=");
		pp_fit_end();
		pp_equ_space();
	    }
	    start_term
;

definitions :
	    DEFINITIONS_SYM {
		lex_start_process_term();
		pp_start_def();
		pp_begin_section();
                pp_keyword("definitions");
                pp_inc();
                pp_newline();
		if (Keep_exp_format)
		    Accept_newlines = 1;
	    }
	    process_def_list {
                pp_dec();
		pp_end_section();
		lex_start_all();
		Accept_newlines = 0;
	    }
	|   /* empty */
;

process_def_list :
	    process_def NEWLINE
	|   process_def
	|   NEWLINE {
		pp_spec_indent($1);
	    } process_def
	|   process_def_list process_def NEWLINE
	|   process_def_list process_def
;

process_def :
	    process_def_head '=' {
		pp_exp_start("=");
		if (Keep_exp_format)
		    Accept_newlines = 1;
	    }
	    process_exp %prec '.' {
		pp_exp_end();
	    }
;

process_def_head :
	    IDENTIFIER_SYM { pp_identifier($1); }
	|   IDENTIFIER_SYM '(' {
                pp_identifier($1);
                pprint("(");
		hook_start();
		pp_list_start();
	    }
	    start_term_list ')' {
		pp_fit_start();
                pprint(")");
		pp_fit_end();
		pp_list_end();
		hook_end();
	    }
;

process_exp :
	    process_exp NEWLINE %prec '+' {
		pp_spec_indent($2);
	    }
	|   NEWLINE {
		pp_spec_indent($1);
	    } process_exp
	|   proc_exp
;

proc_exp :
	    SKIP_SYM {
		pp_exp_indent();
		pp_fit_start();
                pp_keyword("skip");
		pp_fit_end();
		pp_dec();
	    }
	|   DELTA_SYM {
		pp_exp_indent();
		pp_fit_start();
                pp_keyword("delta");
		pp_fit_end();
		pp_dec();
	    }
	|   IDENTIFIER_SYM {
		pp_exp_indent();
                pp_exp_newline();
		pp_fit_start();
                pp_identifier($1);
		pp_fit_end();
		pp_dec();
	    }
	|   IDENTIFIER_SYM '(' {
		pp_exp_indent();
                pp_exp_newline();
		pp_fit_start();
                pp_identifier($1);
                pprint("(");
		pp_fit_end();
		hook_start();
	    }
	    start_term_list ')' {
		pp_fit_start();
                pprint(")");
		pp_fit_end();
		pp_dec();
		hook_end();
	    }
	|   process_exp OPERATOR_SYM {
                pp_exp_preop();
		pp_operator($2);
                pp_exp_postop();
		pp_subexp_start();
	    }
	    process_exp
	|   prefix_operator '(' {
		pprint("(");
		pp_fit_end();
		pp_exp_indent();
		pp_exp_newline();
	    }
	    process_exp ',' {
		pp_dec();
		pp_exp_newline();
		pp_fit_start();
		pp_comma();
		pp_fit_end();
		pp_exp_indent();
		pp_exp_newline();
	    }
	    process_exp ')' {
                pp_dec();
                pp_exp_newline();
		pprint(")");
		pp_dec();
	    }
	|   gen_operator '(' {
                pprint("(");
		pp_fit_end();
		pp_fit_start();
	    }
	    placeholder ',' {
                pp_comma();
		pp_fit_end();
                pp_exp_indent();
	    }
	    process_exp ')' {
                pp_dec();
                pp_exp_newline();
		pp_fit_start();
                pprint(")");
		pp_fit_end();
		pp_dec();
	    }
	|   set_operator '(' {
                pprint("(");
	    }
	    set_identifier ',' {
                pp_comma();
		pp_fit_end();
                pp_exp_indent();
	    }
	    process_exp ')' {
                pp_dec();
                pp_exp_newline();
		pp_fit_start();
                pprint(")");
		pp_fit_end();
		pp_dec();
	    }
	|   PRIO_SYM '(' {
		pp_exp_indent();
		pp_fit_start();
		pp_keyword("prio");
		pprint("(");
		pp_fit_end();
		pp_fit_start();
	    }
	    chain ',' {
		pp_comma();
		pp_fit_end();
		pp_exp_indent();
	    }
	    process_exp ')' {
		pp_dec();
		pp_exp_newline();
		pp_fit_start();
		pprint(")");
		pp_fit_end();
		pp_dec();
	    }
	|   '(' {
		pp_exp_indent();
                pp_exp_newline();
		pp_fit_start();
                pprint("(");
		pp_fit_end();
                pp_exp_indent();
	    }
	    process_exp ')' {
                pp_dec();
                pp_exp_newline();
		pp_fit_start();
                pprint(")");
		pp_fit_end();
		pp_dec();
	    }
	|   '[' {
		pp_exp_indent();
                pp_exp_newline();
		pp_fit_start();
                pprint("[");
		pp_fit_end();
	    }
	    equation ']' ARROW_SYM {
		pp_fit_start();
                pprint("]");
		pp_space();
		pprint("->");
		pp_fit_end();
		pp_exp_indent();
                pp_exp_newline();
		pp_subexp_start();
	    }
	    process_exp {
		pp_dec();
		pp_dec();
	    }
;

prefix_operator :
	    INTR_SYM {
		pp_exp_indent();
		pp_fit_start();
		pp_keyword("interrupt");
	    }
	|   DISR_SYM {
		pp_exp_indent();
		pp_fit_start();
		pp_keyword("disrupt");
	    }
;

gen_operator :
	    SUM_SYM {
		pp_exp_indent();
                pp_exp_newline();
		pp_fit_start();
                pp_keyword("sum");
	    }
	|   GEN_MERGE_SYM {
		pp_exp_indent();
                pp_exp_newline();
		pp_fit_start();
                pp_keyword("merge");
	    }
;

set_operator :
	    ENCAPS_SYM {
		pp_exp_indent();
                pp_exp_newline();
		pp_fit_start();
                pp_keyword("encaps");
	    }
	|   HIDE_SYM {
		pp_exp_indent();
                pp_exp_newline();
		pp_fit_start();
                pp_keyword("hide");
	    }
;

chain :
	    set_identifier
	|   chain CHAIN_SYM {
		pp_space();
		pprint(">");
		pp_space();
	    } set_identifier
;

set_identifier :
	    IDENTIFIER_SYM {
		pp_identifier($1);
	    }
	|   ATOMS_SYM {
		pp_keyword("atoms");
	    }
;

start_term :
	    {
		pp_fit_start();
	    }
	    term {
		pp_fit_end();
	    }
;

start_term_list :
	    {
		pp_fit_start();
	    }
	    term_list {
		pp_fit_end();
	    }
;

term :
	    primary
	|   term OPERATOR_SYM {
		pp_fit_end();
		pp_space();
		pp_fit_start();
                pprint($2);
		pp_fit_end();
		pp_space();
		pp_fit_start();
	    }
	    primary
;

primary :
	    IDENTIFIER_SYM {
                pp_identifier($1);
	    }
	|   IDENTIFIER_SYM '(' {
		hook_start();
                pp_identifier($1);
                pprint("(");
		pp_fit_end();
		pp_fit_start();
	    }
	    term_list ')' {
		hook_end();
                pprint(")");
	    }
	|   OPERATOR_SYM {
		pp_fit_end();
		pp_fit_start();
                pprint($1);
		pp_fit_end();
                pp_space();
		pp_fit_start();
	    }
	    primary
	|   '(' {
		pp_fit_end();
		hook_start();
		pp_fit_start();
                pprint("(");
		pp_fit_end();
		pp_fit_start();
	    }
	    term ')' {
		hook_end();
                pprint(")");
	    }
;

term_list :
	    term
	|   term_list ',' {
                pp_comma();
		pp_fit_end();
		pp_fit_start();
	    }
	    term
	|   error
	    '\n'
;

%%

static int save_lex_state;
static int hook_level = 0;

static void hook_start()
{
    if (hook_level ++ == 0) {
	save_lex_state = lex_state;
	lex_start_all();
    }
}

static void hook_end()
{
    if (-- hook_level == 0) {
	lex_start_restore(save_lex_state);
    }
}
