%{
/*============================================================================*
 *									      *
 *	file: pp.l							      *
 *      info: lexical definitions for lex to generate a pretty printer        *
 * 	      for algebraic specifications written in PSFd 		      *
 *									      *
 *============================================================================*/

/* #include <stdio.h>   -- already included by lex; makedepend objects to
			-- including it twice */
#include <string.h>
#include "psf_prototype.h"
#include "y.tab.h"
#include "getextopt.h"
#include "pretty.h"
#include "psf_malloc.h"

static void set_yylval PROTO_ARGS((void));

%}

id_char		[A-Za-z0-9\']
op_symbol	[!@$%\^&+\-*;?~/|\\]
ident		{id_char}(({id_char}|-)*{id_char})?
set_op		[+.\\]
operator	({op_symbol}+)|(\.{ident}\.)
newline		[\r\f\n]
notnewline	[^\r\f\n]
layout		[ \t\r\f\n]
commentchar     [^\n\r\f\-]
comment         --(-?{commentchar})*(--|-?{newline})
codecomment	--(-?{commentchar})*--
space		[ \t]*

si_op_symbol	[!@$%\^&+\-*;?~/\\]
si_operator	({si_op_symbol}+)|(\.{ident}\.)

%p 3200
%start all no_bar_op process_term in_list
%%
"data"			return(DATA_SYM);
"process"		return(PROCESS_SYM);
"module"		return(MODULE_SYM);
"begin"			return(BEGIN_SYM);
"end"			return(END_SYM);
"parameters"		return(PARAMETERS_SYM);
"exports"		return(EXPORTS_SYM);
"imports"		return(IMPORTS_SYM);
"renamed"		return(RENAMED_SYM);
"by"			return(BY_SYM);
"->"			return(ARROW_SYM);
"bound"			return(BOUND_SYM);
"to"			return(TO_SYM);
"sorts"			return(SORTS_SYM);
"functions"		return(FUNCTIONS_SYM);
"atoms"			return(ATOMS_SYM);
"processes"		return(PROCESSES_SYM);
"sets"			return(SETS_SYM);
"communications"	return(COMMUNICATIONS_SYM);
"for"			return(FOR_SYM);
"of"			return(OF_SYM);
"in"			return(IN_SYM);
"variables"		return(VARIABLES_SYM);
"equations"		return(EQUATIONS_SYM);
"when"			return(WHEN_SYM);
"definitions"		return(DEFINITIONS_SYM);
"skip"			return(SKIP_SYM);
"delta"			return(DELTA_SYM);
"merge"			return(GEN_MERGE_SYM);
"sum"			return(SUM_SYM);
"encaps"		return(ENCAPS_SYM);
"hide"			return(HIDE_SYM);
"interrupt"		return(INTR_SYM);
"disrupt"		return(DISR_SYM);
"prio"			return(PRIO_SYM);
">"			return(CHAIN_SYM);
{set_op}		{
			  set_yylval();
		  	  return(OPERATOR_SYM); 
			}
{ident}			{
			  set_yylval();
			  return(IDENTIFIER_SYM);
			}
<no_bar_op>{si_operator}	|
<process_term>"||"	|
<process_term>"*"	|
<process_term>"#"	|
<all>{operator}		{
			  set_yylval();
			  return(OPERATOR_SYM);
			}
==(=)*(\>|\n)		return(IMPLIES_SYM);

<in_list>^{space}{newline}	return(EMPTY_LINE);
^{space}{newline}	pp_empty(yytext);
^{space}\.\.\.{space}{newline} {pp_skipcode(". . .");}
{newline}{space}\.\.\.{space}{newline} {pp_skipcode(". . .");}
{newline}{space}{newline}{space}{codecomment}{notnewline}    save_comment(yytext, COMMENT_LEFT);
{newline}{space}{codecomment}{notnewline}    save_comment(yytext, COMMENT_LEFT);
^{space}{comment}	save_comment(yytext, COMMENT_LINE);
^{newline}{space}{comment}{space}{newline}	|
^{newline}{space}{comment}    save_comment(yytext, COMMENT_LINE);
{space}{codecomment}{notnewline}    {
			    if (comments_saved())
				save_comment(yytext, COMMENT_RIGHT);
			    else
				pp_comment2(yytext);
			}
{space}{comment}		save_comment(yytext, COMMENT_RIGHT);
{space}{codecomment}		pp_comment2(yytext);
{space}{comment}	|
{newline}{space}{comment}    save_comment(yytext, COMMENT_LINE);
{newline}{space}	{
			    if (Accept_newlines) {
				set_yylval();
				return(NEWLINE);
			    }
			}
[ \t]			|
{layout}		;
.			return(yytext[0]);
%%

/*
^{newline}{space}{codecomment}{notnewline}    save_comment(yytext, COMMENT_LEFT);
*/
yywrap()
{ 
	return(1); 
} /* yywrap */

static void set_yylval()
{
	yylval.literal=psf_strdup( yytext);
#define YYLVAL_DEBUG 0
#if YYLVAL_DEBUG
	fprintf(stderr,"DEBUG: yylval.literal := '%s'\n",yytext);
#endif
} /* set_yylval */

int lex_state;

void lex_start_all()
{
    BEGIN all;
    lex_state = all;
}

void lex_start_nobar()
{
    BEGIN no_bar_op;
    lex_state = no_bar_op;
}

void lex_start_process_term()
{
    BEGIN process_term;
    lex_state = process_term;
}

void lex_start_inlist()
{
    BEGIN in_list;
    lex_state = in_list;
}

void lex_start_restore(save)
int save;
{
    BEGIN save;
    lex_state = save;
}
