#include <stdio.h>
#include <string.h>
#include "psf_prototype.h"
#include "psf_malloc.h"
#include "psf_fopen.h"
#include "psf_standards.h"
#include "psf_exits.h"
#include "getextopt.h"
#include "env_variables.h"
#include "version.h"
#include "pretty.h"

char *progname;

static void version()
{
    fprintf(stderr, "ppp version %s, last compiled %s\n", VERSION,
	    __DATE__);
}

static void usage()
{
    fprintf(stderr, "usage: %s [many options] [file ...]\n", progname);
}

int main(argc, argv)
    int argc;
    char *argv[];
{
    int i;

    if (argc == 0) {
	(void) fprintf(stderr, "who am I ?\n");
	exit(EXIT_HELP);
    };

    progname = psf_basename(argv[0]);

    /* catch -h and -v options */
    for (i = 1; i < argc; i ++) {
	if (*argv[i] != '-')
	    break;
	if (!strcmp(argv[i], "-v")) {
	    version();
	    exit(0);
	}
	if (!strcmp(argv[i], "-h")) {
	    usage();
	    exit(0);
	}
    }

    exit(pretty_print(argc, argv, stdout));
}
