#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "psf_prototype.h"
#include "getextopt.h"

static void set_default(options)
struct option *options;
{
    struct option *p;

    for (p = options; p->name; p ++) {
	if (p->type == T_INT || p->type == T_BOOL)
	    *(int *) p->value = p->def;
	else if (p->type == T_CHAR)
	    *(char *) p->value = (char) p->def;
    }
}

static char *param_start;

static struct option *get_struct(arg, options)
char *arg;
struct option *options;
{
    char *s, *a;
    struct option *p;

    for (p = options; p->name; p ++) {
	for (s = p->name, a = arg; *s; s ++, a ++) {
	    if (*s != *a)
		break;
	}
	if (!*s) {
	    param_start = a;
	    return(p);
	}
    }
    return(NULL);
}

static int error = 0;

static int set_arg_options(argc, argv, options)
int argc;
char *argv[];
struct option *options;
{
    int i;
    struct option *p;

    for (i = 0; i < argc; i ++) {
	if (*argv[i] != '-')  /* no more options */
	    return(i);
	if ((p = get_struct(argv[i], options)) == NULL) {
	    error = 1;
	    return(i);
	}
	switch(p->type) {
	case T_NOP:
	    break;
	case T_INT:
	    if (*param_start == '\0') {
		i ++;
		param_start = argv[i];
	    }
	    *(int *) p->value = atoi(param_start);
	    break;
	case T_CHAR:
	    if (*param_start == '\0') {
		i ++;
		param_start = argv[i];
	    }
	    *(char *) p->value = *param_start;
	    break;
	case T_CHARP:
	    if (*param_start == '\0') {
		i ++;
		param_start = argv[i];
	    }
	    *(char **) p->value = strdup(param_start);
	    break;
	case T_BOOL:
	    if (p->def)
		*(int *)p->value = 0;
	    else
		*(int *)p->value = 1;
	    break;
	default:
	    break;
	}
    }
    return(i);
}

int get_ext_env_options(env, options)
char *env;
struct option *options;
{
    char *e;
    int c;
    char **v;
    char *s;

    if ((e = getenv(env)) == NULL)
	return(0);
    e = strdup(e);
    for (c = 0, s = e; *s; s ++) {
	if (*s != ' ') {
	    c ++;
	    while (*s != ' ' && *s != '\0')
		s++;
	}
    }
    v = (char **) malloc(c * sizeof(char *));
    for (c = 0, s = e; *s; s ++) {
	if (*s != ' ') {
	    v[c] = s;
	    c ++;
	    while (*s != ' ' && *s != '\0')
		s++;
	    if (*s != '\0') {
		*s = '\0';
	    }
	}
    }
    if (set_arg_options(c, v, options) != c) {
	error = 2;
	return(1);
    }
    free(v);
    return(0);
}

int get_ext_options(argc, argv, env, options)
int argc;
char *argv[];
char *env;
struct option *options;
{
    error = 0;
    set_default(options);
    if (env != NULL) {
	if (get_ext_env_options(env, options)) {
	    return(0);
	}
    }
    return(set_arg_options(argc, argv, options));
}

/*
 * 0 ok
 * 1 illegal option
 * 2 error in environment variable
 */
int get_ext_options_error()
{
    return(error);
}
