/*
 * ppp back-end for TeX
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "psf_prototype.h"
#include "psf_standards.h"
#include "version.h"

#define USAGE "usage: ppptotex [-hv]\n"

#define C_PSF 1
#define C_ENDPSF 2
#define C_MODULE 3
#define C_ENDMODULE 4
#define C_SECTION 5
#define C_INDENT 6
#define C_TO 7
#define C_SETINDENT 8
#define C_KEYWORD 9
#define C_IDENTIFIER 10
#define C_FITS 11
#define C_FITE 12
#define C_FITOP 13
#define C_OP 14
#define C_FLUSH 15
#define C_LHOOK 16
#define C_RHOOK 17

#define CHAR_INCH 16
#define POINTS_INCH 72

struct code {
    char *str;
    int nr;
};

static struct code comm[] = {
    { "psf", C_PSF },
    { "/psf", C_ENDPSF },
    { "module", C_MODULE },
    { "/module", C_ENDMODULE },
    { "section", C_SECTION },
    { "indent", C_INDENT },
    { "to", C_TO },
    { "I", C_SETINDENT },
    { "keyword", C_KEYWORD },
    { "identifier", C_IDENTIFIER },
    { "fit", C_FITS },
    { "/fit", C_FITE },
    { "fitop", C_FITOP },
    { "op", C_OP },
    { "flush", C_FLUSH },
    { "lhook", C_LHOOK },
    { "rhook", C_RHOOK },
    { NULL, 0 }
};

static int get_code(s)
char *s;
{
    int i;

    for (i = 0; comm[i].str != NULL; i ++) {
	if (!strcmp(comm[i].str, s))
	    return(comm[i].nr);
    }
    return(-1);
}

struct strstr {
    char *str1;
    char *str2;
};

static struct strstr opstr[] = {
    { "||", "par" },
    { ".", "seq" },
    { "+", "alt" },
    { "*", "star" },
    { "#", "sharp" },
    { "\\", "dif" },
    { "|", "comm" },
    { NULL, NULL }
};

static char * get_opstring(s)
char *s;
{
    int i;

    for (i = 0; opstr[i].str1 != NULL; i ++) {
	if (!strcmp(opstr[i].str1, s))
	    return(opstr[i].str2);
    }
    return(NULL);
}

static int pos = 0; /* position on the output-line */
static int indent = 0;
static int NewLine = 1;
static int OpenBox = 0;

static void pr_char_next(c, next)
int c;
int next;
{
    int c2;

    if (c == '\\')
	putchar('\\');
    else if (c == '#')
	putchar('\\');
    else if (c == '&')
	putchar('\\');
    else if (c == '$') {
	printf("\\$");
	return;
    } else if (c == '{') {
	printf("$\\{$");
	return;
    } else if (c == '}') {
	printf("$\\}$");
	return;
    } else if (c == '|') {
	printf("$\\vert$");
	return;
    } else if (c == '>') {
	printf("$>$");
	return;
    } else if (c == '<') {
	printf("$<$");
	return;
    } else if (c == '^') {
	printf("\\char'136");
	return;
    } else if (c == '~') {
	printf("\\~");
	return;
    } else if (c == '_') {
	printf("\\_");
	return;
    } else if (c == '-') {
	if (next) {
	    c2 = getchar();
	    if (c2 == '>') {
		printf("$\\rightarrow$");
		return;
	    }
	    ungetc(c2, stdin);
	}
	printf("$-$");
	return;
    } else if (c == ' ' && (pos == 0 || NewLine))
	return;
    else if (c == ' ')
	printf("\\ ");
    if (! (c == '\n' && NewLine))
	putchar(c);
    if (c == '\n') {
/* no using \line withe the FLUSH
	printf("\\hbox{}\\\\\n");
*/
	NewLine = 1;
	pos = 0;
    } else {
	pos ++;
	NewLine = 0;
    }
}

static void pr_char(c)
int c;
{
    pr_char_next(c, 1);
}

static void closebox()
{
    if (OpenBox)
	printf("}");
}

static void newline()
{
    if (! NewLine)
	printf("\n");
}

static char buf[256];
static int fitind;
static int lastindent;

static void command()
{
    int i;
    char c;
    char *s;

    scanf("%[^> ]s", buf);
    switch(get_code(buf)) {
    case C_PSF:
	/*
	 * Break the current line.
	 */
	printf("\\par\n");
	/*
	 * Header of the pretty printed code. The macro psfevbegin can be
	 * defined by the user.
	 */
	printf("\\ifx\\cs\\psfevbegin\\relax\n");
	printf("\\vglue 0.1in plus 10pt\n");
	printf("\\hrule\n");
	printf("\\vskip 0.1in\n");
	printf("\\advance\\hsize by -20pt\n");
	printf("\\else\n");
	printf("\\psfevbegin\n");
	printf("\\fi\n");
	/*
	 * We switch to a new environment.
	 */
	printf("\\begingroup\n");
	/* Define our own line macro. (LaTeX ruins the \line) */
	printf("\\def\\psfline{\\hbox to\\hsize}\n");
	printf("\\dimen2=\\parindent\n");
	    /* TeX: \break  LaTeX: \\ */
	printf("\\ifx\\cs\\\\\\relax\\def\\\\{\\break }\\fi\n");
	    /* keywords and identifiers pre and post strings */
	printf("\\ifx\\cs\\psfevkwpre\\relax\\def\\psfevkwpre{\\bf }\\fi\n");
	printf("\\ifx\\cs\\psfevkwpost\\relax\\def\\psfevkwpost{}\\fi\n");
		/* identifiers in italic with skew corrections */
	printf("\\ifx\\cs\\psfevidpre\\relax\\def\\psfevidpre{\\it }\\fi\n");
	printf("\\ifx\\cs\\psfevidpost\\relax\\def\\psfevidpost{}\\fi\n");
	    /* define the process operator-strings */
	printf("\\ifx\\cs\\psfevoppar\\relax\\def\\psfevoppar{$\\|$}\\fi\n");
	printf("\\ifx\\cs\\psfevopseq\\relax\\def\\psfevopseq{$\\cdot$}\\fi\n");
	printf("\\ifx\\cs\\psfevopalt\\relax\\def\\psfevopalt{$+$}\\fi\n");
	printf("\\ifx\\cs\\psfevopstar\\relax\\def\\psfevopstar{\\bf *}\\fi\n");
	printf("\\ifx\\cs\\psfevopsharp\\relax\\def\\psfevopsharp{\\raise0.2em\\hbox{$\\sharp$}}\\fi\n");
	printf("\\ifx\\cs\\psfevopcomm\\relax\\def\\psfevopcomm{$\\vert$}\\fi\n");
	printf("\\ifx\\cs\\psfevopdif\\relax\\def\\psfevopdif{$\\setminus$}\\fi\n");
	printf("\\ifx\\cs\\psfevoparrow\\relax\\def\\psfevoparrow{$\\rightarrow$}\\fi\n");
	break;
    case C_ENDPSF:
	printf("\\hbox{}\n");
	printf("\\endgroup\n"); /* Return from the psf environment. */
	printf("\\par\n");
	/*
	 * Trailer of the pretty printed code. The macro psfevend can be
	 * defined by the user.
	 */
	printf("\\ifx\\cs\\psfevend\\relax\n");
	printf("\\advance\\hsize by 20pt\n");
	printf("\\hrule\n");
	printf("\\vskip 0.1in\n");
	/* printf("\\\\\n"); */
	printf("\\else\n");
	printf("\\psfevend\n");
	printf("\\fi\n");
	break;
    case C_MODULE:
	printf("\\vglue0pt plus 10pt\n");
/*
	printf("\\vglue0pt plus 1fil\n");
*/
	break;
    case C_ENDMODULE:
	break;
    case C_SECTION:
	printf("\\vglue0pt plus 10pt\n");
/*
	printf("\\vglue0pt plus 1fil\n");
*/
	break;
    case C_INDENT:
	/*
	 * If we have something in box1, then print it.
	 * Do an indent.
	 * Start a new box1.
	 */
	printf("\\ifvoid1 \\else \\box1\\hfil\n\\fi\n");
	printf("\\parindent=\\dimen2\n");
	printf("\\advance\\parindent by %dpt\n",
	    (indent*POINTS_INCH)/CHAR_INCH);
	printf("\\setbox1=\\hbox{");
	OpenBox = 1;
	NewLine = 0;
	lastindent = indent;
	break;
    case C_TO:
	scanf(" %d", &i);
	closebox();
	newline();
	/*
	 * If there fits a space between the point we are and the point we
	 * are going to, then append a horizontal move to this point.
	 * Else, append a horizontal move the width of a space.
	 * Start an append to box1.
	 */
	printf("\\dimen3=%dpt\n", (i*POINTS_INCH)/CHAR_INCH);
	printf("\\advance\\dimen3 by -\\the\\wd1\n");
	printf("\\ifdim %dpt>\\wd1 \\setbox1=\\hbox{\\unhbox1\\hskip\\dimen3}\n",
	    (i*POINTS_INCH)/CHAR_INCH);
	printf("\\else \\setbox1=\\hbox{\\unhbox1\\ }\\fi\n");
	printf("\\dimen4=%dpt\n", (i*POINTS_INCH)/CHAR_INCH);
	printf("\\setbox1=\\hbox{\\unhbox1");
	OpenBox = 1;
	NewLine = 0;
	break;
    case C_SETINDENT:
	scanf(" %c%d", &c, &i);
	if (c == '-')
	    indent -= i;
	else
	    indent += i;
	break;
    case C_KEYWORD:
	scanf(" %[^>]s", buf);
	/*
	 * Keywords with pre and post strings.
	 */
	printf("{\\psfevkwpre{");
	if (*buf == '{' || *buf == '}')
	    pr_char(*buf);
	else
	    printf("%s", buf);
	printf("}\\psfevkwpost}");
	pos += strlen(buf);
	NewLine = 0;
	break;
    case C_IDENTIFIER:
	scanf(" %[^>]s", buf);
	/*
	 * Identifiers with pre and post strings.
	 */
	printf("{\\psfevidpre{%s}\\psfevidpost}", buf);
	pos += strlen(buf);
	NewLine = 0;
	break;
    case C_FITS:
	scanf(" %d", &fitind);
	closebox();
	newline();
	/*
	 * Start a string for the thing we have to fit.
	 */
	printf("\\setbox2=\\hbox{");
	OpenBox = 1;
	NewLine = 0;
	break;
    case C_FITE:
	closebox();
	newline();
	/*
	 * If pexpr doesn't fit on this line, then
	 *    output the line
	 *    go to a new line
	 *    do an indent
	 *    define the start of a newline to be pexpr
	 * Else append pexpr to the line.
	 */
	printf("\\setbox3=\\hbox{\\copy1\\ \\copy2}\n");
	printf("\\dimen3=\\wd3\n");
	printf("\\advance\\dimen3 by \\parindent\n");
	printf("\\ifdim \\dimen3>\\hsize\n");
/* no using \psfline withe the FLUSH
	printf("\\indent\\box1\\hfil\n");
	printf("\\\\\n");
*/
	printf("\\psfline{\\indent\\box1\\hfil}\n");
	printf("\\parindent=\\dimen2\n");
	printf("\\advance\\parindent by %dpt\n", (indent*POINTS_INCH)/CHAR_INCH);
	printf("\\advance\\parindent by -\\dimen4\n");
	printf("\\setbox1=\\hbox{\\hskip\\dimen4\\unhbox2}\n");
	printf("\\else\n");
	printf("\\setbox1=\\hbox{\\unhbox1\\unhbox2}\n\\fi\n");
	printf("\\dimen4=0pt\n");
	OpenBox = 0;
	NewLine = 1;
	break;
    case C_FITOP:
	closebox();
	newline();
	scanf(" %[^>]s", buf);
	/*
	 * The same as with C_FITE, but we have also do spacing around
	 * the operator.
	 */
	printf("\\setbox3=\\hbox{\\copy1\\ \\psfevop%s\\ }\n",
	    get_opstring(buf));
	printf("\\dimen3=\\wd3\n");
	printf("\\advance\\dimen3 by \\parindent\n");
	printf("\\ifdim \\dimen3 > \\hsize\n");
/* no using \psfline withe the FLUSH
	printf("\\indent\\box1\\hfil\n");
	printf("\\\\\n");
*/
	printf("\\psfline{\\indent\\box1\\hfil}\n");
	printf("\\parindent=\\dimen2\n");
	printf("\\advance\\parindent by %dpt\n",
	    (indent*POINTS_INCH)/CHAR_INCH);
	printf("\\setbox1=\\hbox{\\psfevop%s\\ }\n", get_opstring(buf));
	printf("\\else\n");
	printf("\\setbox1=\\hbox{\\unhbox1\\ \\psfevop%s\\ }\n\\fi\n",
	    get_opstring(buf));
	OpenBox = 0;
	NewLine = 1;
	break;
    case C_OP:
	closebox();
	newline();
	scanf(" %[^>]s", buf);
	/*
	 * Simple add the string for the operator.
	 */
	printf("\\setbox1=\\hbox{\\unhbox1\\ \\psfevop%s}\n",
	    get_opstring(buf));
	OpenBox = 0;
	NewLine = 1;
	break;
    case C_FLUSH:
	closebox();
	newline();
	/*
	 * Output the line and make it empty.
	 */
	printf("\\ifvoid1 \\else ");
	printf("\\psfline{\\indent\\box1\\hfil}\n\\fi\n");
	OpenBox = 0;
	NewLine = 1;
	break;
    case C_LHOOK:
	pr_char('<');
	break;
    case C_RHOOK:
	pr_char('>');
	break;
    default:
	fprintf(stderr, "unknown command \"%s\"\n", buf);
	exit(1);
    }
}

int main(argc, argv)
int argc;
char *argv[];
{
    char *progname;
    int opt;
    int c;

    progname = psf_basename(argv[0]);
    while ((opt = getopt(argc, argv, "hv")) != -1) {
	switch (opt) {
	case 'h':
	case '?':
	    fprintf(stderr, USAGE);
	    exit (1);
	case 'v':
	    fprintf(stderr, "%s version %s, last compiled %s\n", progname,
		VERSION, __DATE__);
	    exit(0);
	}
    }

    while ((c = getchar()) != EOF) {
	if (c == '<') {
	    command();
	    getchar(); /* '>' */
	} else {
	    pr_char(c);
	}
    }
    exit(0);
}
