.TH PPPTOROFF 1L "February 2, 1995" "PSF-Toolkit" "LOCAL COMMANDS"
.UC 4
.SH NAME
ppptoroff \- generates Troff code from ppp device independent code
.SH SYNOPSIS
.B ppptoroff
[
.B \-hv
]
.SH DESCRIPTION
.B ppptoroff
generates Troff code out of the device independent code produced
with the
.B \-D
option of
.BR ppp (1L).
The input is read from standard input and written on standard
ouput.
.PP
The generated Troff code makes use of some of the additions of
the groff document formatting system, and therefor
.BR groff (1)
should be used.
The groff document formatting system is copyrighted by the
Free Software Foundation, Inc and so contributed to the world.
.PP
The following macros will be defined, if they are not already defined.
.TP
.B PSFB
Invoked at the beginning of the PSF code. By default, it draws
a horizontal line across the page and does
.nf
\&    .nr psfev*ll +0.5i
\&    .nr psfev*in +0.5i
.fi
which alter the linelength and indentation.
.TP
.B PSFE
Invoked at the end of the PSF code. By default, it draws a horizontal
line across the page. The linelength and indentation are automatically
reset to their original values.
.PP
The following strings will be defined, if they are not already defined.
.TP
.B psfev*idpost
String put after an identifier.
.br
Default: \\fP\\/ (previous font,
skew correction)
.TP
.B psfev*idpre
String put before an identifier.
.br
Default: \\,\\fI (skew correction, italic)
.TP
.B psfev*kwpost
String put after a keyword.
.br
Default: \\fP (previous font)
.TP
.B psfev*kwpre
String put before a keyword.
.br
Default: \\fB (bold)
.TP
.B psfev*op||
String for the || operator.
.br
Default: \\v'-0.1m'\\s-1\\fB\\|\\(br\\|\\(br\\|\\fP\\s+1\\v'+0.1m'
.TP
.B psfev*op+
String for the + operator.
.br
Default: \\fB+\\fP
.TP
.B psfev*op.
String for the . operator.
.br
Default: \\v'-0.2m'\\fB.\\fP\\v'+0.2m'
.TP
.B psfev*op*
String for the * operator.
.br
Default: \\v'-0.2m'\\fB*\\fP\\v'+0.2m'
.TP
.B psfev*op#
String for the # operator.
.br
Default: \\v'-0.2m'\\fB#\\fP\\v'+0.2m'
.TP
.B psfev*op\e
String for the \\ operator.
.br
Default: \\v'+0.2m'\\s+2\\fB\\e\\fP\\s-2\\v'-0.2m'
.TP
.B psfev*op|
String for |.
.br
Default: \\v'-0.1m'\\s-1\\fB\\(br\\fP\\s+1\\v'+0.1m'
.SH OPTIONS
.TP
.B \-h
usage summary
.TP
.B \-v
Displays the version-number of ppptoroff.
.SH SEE ALSO
.BR ppp (1L),
.BR groff (1)
.SH AUTHOR
Bob Diertens, University of Amsterdam (bobd@fwi.uva.nl)
