
namespace eval StatusBar {
    variable bar
    variable msg

    package provide StatusBar 0.1
}

proc StatusBar::Init {w} {
    variable bar
    variable msg

    set bar $w

    frame $bar -bd 0 -relief sunken
    pack $bar

    label $bar.l -bd 0 -text "status"
    label $bar.msg -bd 1 -relief sunken -textvariable StatusBar::msg -anchor w
    pack $bar.l -in $bar -side left -expand 0
    pack $bar.msg -in $bar -side left -expand 1 -fill x
    set msg ""
}

proc StatusBar::Display {s} {
    variable msg

    set msg $s
}

proc StatusBar::Clear {} {
    variable msg

    set msg ""
}

