
namespace eval Display {
    variable display
    variable displaytext

    package provide Display 0.1
}

proc Display::Init {path} {
    variable display
    variable displaytext

    set display $path

    frame $display
    pack $display

    frame $display.f -bd 0
    pack $display.f -in $display
    set displaytext $display.f.list
    text $displaytext -bd 1 -highlightthickness 0 -width 50 -height 8 -wrap none \
	-xscrollcommand "$display.xs set" -yscrollcommand "$display.ys set"
    pack $displaytext -in $display.f -expand 1 -fill both -padx 0 -pady 0
    scrollbar $display.xs -orient horizontal -width 8 -highlightthickness 0 \
	-takefocus 0 -command "$displaytext xview" -bd 1
    scrollbar $display.ys -orient vertical -width 8 -highlightthickness 0 \
	-takefocus 0 -command "$displaytext yview" -bd 1
    grid $display.f -row 0 -column 0 -rowspan 1 -columnspan 1 -sticky news \
	-padx 0 -pady 0
    grid $display.ys -row 0 -column 1 -rowspan 1 -columnspan 1 -sticky ns \
	-padx 0 -pady 0
    grid $display.xs -row 1 -column 0 -rowspan 1 -columnspan 1 -sticky ew \
	-padx 0 -pady 0
    grid rowconfig $display 0 -weight 1 -minsize 0
    grid rowconfig $display 1 -weight 0
    grid columnconfig $display 0 -weight 1 -minsize 0
    grid columnconfig $display 1 -weight 0
}

proc Display::Write {item} {
    variable displaytext

    $displaytext insert end $item
    $displaytext yview end
}

proc Display::Clear {} {
    variable displaytext

    $displaytext delete 0.0 end
}

proc Display::Resize {} {
    variable displaytext

}
