#include <stdio.h>
#include "psf_prototype.h"
#include "psf_malloc.h"
#include "tiltype.h"
#include "ptree.h"
#include "partree.h"
#include "eqm.h"
#include "main.h"

static int *realproc = NULL;
static int max = 0;

static int Option_List = 1;

static void CalcRealProcessIds(pt, id)
ptree *pt;
int id;
{
    int nid;
    pedge *e;
    ptree *h;

    if (pt->pid != NULL && pt->pid->aet != NULL)
	nid = pt->pid->id;
    else
	nid = id;
    for (e = pt->edge; e != NULL; e = e->next) {
	CalcRealProcessIds(e->node, nid);
    }
    if (pt->fun == PAR) {
	e = pt->edge;
	if (e->node->pid->aet != NULL && e->next->node->pid->aet == NULL) {
	    realproc[e->next->node->pid->id] = id;
	    e->next->node->pid = NULL;
	} else if (e->node->pid->aet == NULL && e->next->node->pid->aet != NULL) {
	    realproc[e->node->pid->id] = id;
	    e->node->pid = NULL;
	}
    }
    if (Option_List) {
	if (pt->pid != NULL && pt->edge != NULL) {
	    h = pt->edge->node;
	    if (h->fun == SUM) {
		while (h->edge->node->fun == SUM)
		    h = h->edge->node;
		if (h->edge->node->pid != NULL) {
/*
	printf("xxx %d %d\n", pt->pid->id, h->edge->node->pid->id);
*/
		    realproc[h->edge->node->pid->id] = pt->pid->id;
		    h->edge->node->pid = NULL;
		}
	    }
	}
    }
}

void SetRealProcessIds(pl)
process_id *pl;
{
    process_id *pi;
    int hi;

    for (pi = pl; pi != NULL; pi = pi->next) {
	for (hi = pi->id; hi != realproc[hi]; hi = realproc[hi]);
	    pi->id = hi;
    }
}

void RealProcess(pt, maxid, pl)
partree *pt;
int maxid;
process_id *pl;
{
    int i;

    max = maxid;
    realproc = PSF_NMALLOC(int, maxid);
    for (i = 0; i < maxid; i ++)
	realproc[i] = i;
    CalcRealProcessIds(pt->pt, pt->pt->pid->id);
    SetRealProcessIds(pl);
}

int RealProcessId(id)
int id;
{
    int h;

    for (h = id; h != realproc[h]; h = realproc[h]);
    return(h);
}

int IsRealProcessId(id)
int id;
{
    if (realproc[id] == id)
	return 1;
    else
	return 0;
}

void PrintRealProcess()
{
    int i;

    for (i = 0; i < max; i ++) {
	if (realproc[i] != i)
	    printf("rp: %d -> %d\n", i, realproc[i]);
    }
}
