struct ptree; /* forward declaration */

typedef struct process_id {
    int id;
    struct ae_term *aet;
    struct process_id *next;
} process_id;

typedef struct atomlist {
    process_expr *atom;
    struct {
	int sum;
	int encaps;
	int hide;
	process_id *pid;
	int comm;
    } props;
    struct atomlist *next;
} atomlist;

typedef struct pedge {
    struct ptree *node;
    atomlist *atom;
    struct pedge *next;
} pedge;

#define COMM_SYNC 1
#define COMM_TO 2
#define COMM_FROM 4
#define COMM_BOTH 8

typedef struct commlist {
    struct ae_term *comm;
    process_id *p1;
    process_id *p2;
    struct {
	int encaps;
	int hide;
	int direction;
    } props;
    struct commlist *next;
} commlist;

typedef struct ptree {
    struct ae_term *id;
    process_id *pid;
    char fun;
    struct process_expr *pe;
    pedge *edge;
    commlist *comm;
    struct ptree *next;
} ptree;

extern ptree *NullPtree;

extern ptree *AllocPtree PROTO_ARGS((void));
extern void FreePtree PROTO_ARGS((ptree *));

extern void PrintAccountPtree PROTO_ARGS((void));

extern pedge *AllocPedge PROTO_ARGS((void));
extern void FreePedge PROTO_ARGS((pedge *));

extern void PrintAccountPedge PROTO_ARGS((void));

extern atomlist *AllocAtom PROTO_ARGS((void));
extern void FreeAtom PROTO_ARGS((atomlist *));

extern void PrintAccountAtom PROTO_ARGS((void));

extern ptree *BuildPtree PROTO_ARGS((ae_term *, process_expr *));
extern void DestroyPtree PROTO_ARGS((ptree *));
extern ptree *CopyPtree PROTO_ARGS((ptree *));
extern void PrintPtree PROTO_ARGS((ptree *));
