.TH PROCGRAPH 1L "November 05, 2014" "UvA/TCS" "PSF-Toolkit"
.SH NAME
procgraph \- generate process graph
.SH SYNOPSIS
.B procgraph
[\|-c\|]
[\|-d\|]
[\|-e\|]
[\|-g LR|TB\|]
[\|-h\|]
[\|-n\|]
[\|-o\|]
[\|-r\|]
[\|-s\|]
[\|-t\|]
[\|-u\|]
-p \fIstart-process TIL-code\fP
.SH DESCRIPTION
.B procgraph
generates a process graph for
.IR start-process .
.SH OPTIONS
.TP
.B \-c
Combines sub-processes that do not communicate with each other and
have a parent-process with a name.
.TP
.B \-d
Debug mode. Dumps all kinds of usefull information.
.TP
.B \-e
Extends atoms and communications by replacing terms that contains a
variable with a variable.
Except terms that start with a function for which no equation can be
found with a left-hand-side that starts with this function.
In this case, the same is done for the subterms.
.TP
.BR \-g " LR|TB"
Defines the orientation of the graph. TB for top to bottom (the default) and
LR for left to right.
.TP
.B \-h
Use heuristics.
When the direction of a communication cannot be decided upon, the
names of the communications are used to decide this.
When one equals 'snd' and the other 'rec' or 'send' and 'receive'
respectively, this is considered a communication from 'snd' (or 'send')
to 'rec' (or 'receive').
The same applies if one starts with 'snd-' and the other with 'rec-'.
.TP
.B \-n
No input- and output-process. Normally for atoms that are not hidden,
a input- and output-process is generated with lines to the
appropriate processes. Now these atoms are considered local to their
process.
.TP
.B \-o
No ordering of processes. Normally processes are ordered based on
having local actions (high ordering) or sum-port actions (low ordering).
.TP
.BI \-p " start-process
Defines the process to generate a graph for.
.TP
.B \-r
Remove duplicate processes, atoms, and communications.
When processes appear on both sides of
an alternation, they appear twice in the process graph. This
option filters one of them unless it is hidden or encapsulated.
Duplicate atoms which belong to the same process are removed.
Duplicate communications between the same two processes are also
removed.
.TP
.B \-s
Sub-process mapping. In the following cases a sub-process is mapped
onto another process:
.sp
\- If one side of a merge starts with an atom, this side is considered
part of the process which contains the merge and not a new process.
The other side is considered a process that runs in parallel with the
process which contains the merge.
.sp
\- A sub-process that is expanded (replaced by its process definition)
and that is not part of merge, is mapped onto its parent process.
.br
This makes it possible to split a process definition in several parts.
.sp
\- If a process with a name consist of a sum-port (one or more nested
sum operators with an atom for receiving value(s) from another process)
with a single process as sub-process, then this sub-process is mapped
onto the process containing the sum-port.
.TP
.B \-t
Produce a table instead of a graph.
.TP
.B \-u
Unused processes are shown in the animation.
.SH AUTHOR
Bob Diertens, University of Amsterdam
