#include <stdio.h>
#include <string.h>
#include "psf_prototype.h"
#include "psf_malloc.h"
#include "tiltype.h"
#include "fieldex.h"
#include "ptree.h"
#include "partree.h"
#include "eqm.h"
#include "main.h"
#include "prtilparts.h"

#define RANK_NONE 0
#define RANK_MIN 1
#define RANK_MAX 32

typedef struct proc {
    int used;
    int rank;
} proc;
proc *Proc;
int nrProc = 0;
int **Comm;

static void PropsProcesses(pt, pidl)
partree *pt;
process_id *pidl;
{
    int i, j;
    atomlist *a;
    commlist *c;

    nrProc = GetMaxProcessId();
    Proc = PSF_NMALLOC(proc, nrProc + 1);
    for (i = 0; i <= nrProc; i ++) {
	Proc[i].used = 0;
	Proc[i].rank = RANK_NONE;
    }
    for (a = pt->al; a != NULL; a = a->next) {
	Proc[a->props.pid->id].used = 1;
	if (! Option_NoOrder) {
	    if ((!a->props.hide) && (a->atom->fun != SKP)) {
		if (a->props.sum)
		    Proc[a->props.pid->id].rank |= RANK_MIN;
		else
		    Proc[a->props.pid->id].rank |= RANK_MAX;
		/* maybe we should consider processes that are input and output */
	    }
	}
    }
    Comm = PSF_NMALLOC(int *, nrProc + 1);
    for (i = 0; i <= nrProc; i ++) {
	Comm[i] = PSF_NMALLOC(int, nrProc + 1);
	for (j = 0; j <= nrProc; j ++) {
	    Comm[i][j] = 0;
	}
    }
    for (c = pt->cl; c != NULL; c = c->next) {
	Proc[c->p1->id].used = 1;
	Proc[c->p2->id].used = 1;
/*
	if (c->p1->id < c->p2->id) {
	    Comm[c->p1->id][c->p2->id] |= c->props.direction;
	} else {
	    if (c->props.direction == COMM_TO) {
		Comm[c->p2->id][c->p1->id] |= COMM_FROM;
	    } else if (c->props.direction == COMM_FROM) {
		Comm[c->p2->id][c->p1->id] |= COMM_TO;
	    } else {
		Comm[c->p2->id][c->p1->id] |= c->props.direction;
	    }
	}
*/
    }
}

static int indent = 0;

static void Indent()
{
    int i;

    for (i = 0; i < indent; i ++) {
	printf("    ");
    }
}

static void PrintProcesses(pidl)
process_id *pidl;
{
    process_id *pid;

    for (pid = pidl; pid != NULL; pid = pid->next) {
	if (Proc[pid->id].used || Option_Unused) {
	    Indent();
	    if (Proc[pid->id].rank == RANK_MIN)
		printf("{ rank=min; ");
	    else if (Proc[pid->id].rank == RANK_MAX)
		printf("{ rank=max; ");
	    printf("n%d [label=\"", pid->id);
	    if (pid->aet == NULL)
		printf("_?_");
	    else
		print_ae_term(pid->aet);
	    printf("\"];");
	    if (Proc[pid->id].rank == RANK_MIN)
		printf(" }");
	    else if (Proc[pid->id].rank == RANK_MAX)
		printf(" }");
	    printf("\n");
	}
    }
}

static void NormalizeComm(c)
commlist *c;
{
    process_id *hp;

    switch (c->props.direction) {
    case COMM_FROM:
	hp = c->p1;
	c->p1 = c->p2;
	c->p2 = hp;
	c->props.direction = COMM_TO;
	break;
    case COMM_TO:
	break;
    case COMM_SYNC:
    case COMM_BOTH:
	if (c->p1->id > c->p2->id) {
	    hp = c->p1;
	    c->p1 = c->p2;
	    c->p2 = hp;
	}
	break;
    }
}

static int DoneComm(id1, id2, dir)
int id1;
int id2;
int dir;
{
    int h;

    if (id1 > id2) {
	h = id1;
	id1 = id2;
	id2 = h;
	if (dir == COMM_TO)
	    dir = COMM_FROM;
	else if (dir == COMM_FROM)
	    dir = COMM_TO;
    }
    if (Comm[id1][id2] & dir)
	return(1);
    Comm[id1][id2] |= dir;
    return(0);
}

static void PrintCommunications(cl)
commlist *cl;
{
    commlist *c;
    int i, j;

    for (c= cl; c != NULL; c = c->next) {
	if (DoneComm(c->p1->id, c->p2->id, c->props.direction))
	    continue;
	Indent();
	NormalizeComm(c);
	printf("n%d -> n%d [dir=", c->p1->id, c->p2->id);
	switch(c->props.direction) {
	case COMM_SYNC:
	    printf("none");
	    break;
	case COMM_TO:
	    printf("forward");
	    break;
	case COMM_FROM:
	    printf("back");
	    break;
	case COMM_BOTH:
	    printf("both");
	    break;
	}
	printf("];\n");
    }
}

static int cluster = 0;
static void PrintClusters(pt)
ptree *pt;
{
    pedge *e;

    if (pt->pid != NULL) {
	if (Proc[pt->pid->id].used || (Option_Unused && pt->pid->aet != NULL)) {
	    Indent();
	    if (Proc[pt->pid->id].rank == RANK_MIN)
		printf("{ rank=min; ");
	    else if (Proc[pt->pid->id].rank == RANK_MAX)
		printf("{ rank=max; ");
	    printf("n%d [label=\"", pt->pid->id);
	    if (pt->pid->aet == NULL)
		printf("_?_");
	    else
		print_ae_term(pt->pid->aet);
	    printf("\"];");
	    if (Proc[pt->pid->id].rank == RANK_MIN)
		printf(" }");
	    else if (Proc[pt->pid->id].rank == RANK_MAX)
		printf(" }");
	    printf("\n");
	}
    }
    if (pt->id == NULL && pt->fun == AET)
	return;
    for (e = pt->edge; e != NULL; e = e->next) {
	if (pt->fun == ENC) {
	    cluster ++;
	    Indent();
	    printf("subgraph cluster%d {\n", cluster);
	    indent ++;
	}
	PrintClusters(e->node);
	if (pt->fun == ENC) {
	    indent --;
	    Indent();
	    printf("}\n");
	}
    }
    if (pt->fun == PAR && pt->comm)
	PrintCommunications(pt->comm);
}

static void RenameVars()
{
    int i;
    freeformat ff;
    char *new;

    for (i = 1; i <= Mod->entries_table[VAR]; i ++) {
	for (ff = Mod->var[i].ff; ff != NULL; ff = ff->next) {
	    if (! strcmp(ff->tag, "n")) {
		new = PSF_NMALLOC(char, strlen(ff->info) + 1);
		sprintf(new, "!%s!", ff->info);
		ff->info = new;
		break;
	    }
	}
    }
}

static int *consfun = NULL;

static void MarkNonConsFun(aet)
ae_term *aet;
{
    if (aet->ind.table == VAR)
	return;
    consfun[aet->ind.key] = 0;
/*
    for (i = 0; i < aet->a; i ++)
	MarkNonConsFun(&aet->ae_list[i]);
*/
}

static void MarkConsFun()
{
    int i;

    consfun = PSF_NMALLOC(int, Mod->entries_table[FUN] + 1);
    for (i = 1; i <= Mod->entries_table[FUN]; i ++)
	consfun[i] = 1;
    for (i = 1; i <= Mod->entries_table[EQU]; i ++)
	MarkNonConsFun(&Mod->equ[i].aet1);
}

static int ContainsVar(aet)
struct ae_term *aet;
{
    int i;

    if (aet->ind.table == VAR)
	return(1);
    else {
	for (i = 0; i < aet->a; i ++) {
	    if (ContainsVar(&aet->ae_list[i]))
		return(1);
	}
	return(0);
    }
}

static int infix_operator(t, k)
    tabletype t;
    keytype k;
{
    char *s;

    if (t != FUN)
        return (0);
/*
    return field_extract("n", Mod->fun[k].ff, t, k)[0] == '_';
*/
    s = field_extract("n", Mod->fun[k].ff, t, k);
    if (s[0] == '_' || s[strlen(s) - 1] == '_')
	return(1);
    return(0);
}
static void PrintVarTerm(aet)
struct ae_term *aet;
{
    int i;
    int infix;
    char *s;

    if (infix_operator(aet->ind.table, aet->ind.key)) {
        infix = infix_operator(aet->ae_list[0].ind.table,
            aet->ae_list[0].ind.key);
/*
        if (infix)
            printf("(");
        print_ae_term(&aet->ae_list[0]);
*/
	i = 0;
	s = field_extract("n", Mod->fun[aet->ind.key].ff, 
	    aet->ind.table, aet->ind.key);
	if (s[0] == '_') {
            infix = infix_operator(aet->ae_list[i].ind.table,
                aet->ae_list[i].ind.key);
            if (infix)
                printf("(");
	    PrintVarTerm(&aet->ae_list[0]);
	    if (infix)
		printf(")");
	    i ++;
	    printf(" ");
	}
        print_term_name(aet->ind);
	if (s[strlen(s) - 1] == '_') {
	    printf(" ");
            infix = infix_operator(aet->ae_list[i].ind.table,
                aet->ae_list[i].ind.key);
            if (infix)
                printf("(");
	    if (aet->ae_list[i].ind.table == FUN &&
		consfun[aet->ae_list[i].ind.key]) {
		PrintVarTerm(&aet->ae_list[i]);
	    } else if (Option_ExtendActions && ContainsVar(&aet->ae_list[i])) {
		printf("!v%d!", i);
	    } else {
/*
		print_ae_term(&aet->ae_list[i]);
*/
		PrintVarTerm(&aet->ae_list[i]);
	    }
            if (infix)
                printf(")");
        }
    } else {
	print_term_name(aet->ind);
	if (aet->a) {
	    printf("(");
	    for (i = 0; i < aet->a; i ++) {
		if (i)
		    printf(", ");
		if (aet->ae_list[i].ind.table == FUN &&
		    consfun[aet->ae_list[i].ind.key]) {
		    PrintVarTerm(&aet->ae_list[i]);
		} else if (Option_ExtendActions && ContainsVar(&aet->ae_list[i])) {
		    printf("!v%d!", i);
		} else {
/*
		    print_ae_term(&aet->ae_list[i]);
*/
		    PrintVarTerm(&aet->ae_list[i]);
		}
	    }
	    printf(")");
	}
    }
}

static void PrintVarProcessExpr(pe)
process_expr *pe;
{
    switch(pe->fun) {
    case SKP:
	/* not handled here */
	break;
    case DLK:
	printf("delta");
	break;
    case AET:
	PrintVarTerm(&pe->proc_expr.pe2);
	break;
    default:
	/* no */
	break;
    }
}

static void PrintAtomList(al)
atomlist *al;
{
    atomlist *a;

    for (a = al; a != NULL; a = a->next) {
	if (a->atom->fun == SKP) {
	    printf("skip<%d> %d\n", a->atom->proc_expr.nr, a->props.pid->id);
	} else {
	    if (a->props.hide) {
		printf("skip ");
		if (Option_ExtendActions)
		    PrintVarProcessExpr(a->atom);
		else
		    print_process_expr(a->atom);
		printf(" %d\n", a->props.pid->id);
	    } else {
/*
		if (Option_ExtendActions)
*/
		    PrintVarProcessExpr(a->atom);
/*
		else
		    print_process_expr(a->atom);
*/
		if (Option_NoIO) {
		    printf(" %d\n", a->props.pid->id);
		} else {
		    if (a->props.sum)
			printf(" I  -> %d\n", a->props.pid->id);
		    else
			printf(" %d  -> O\n", a->props.pid->id);
		}
	    }
	}
    }
}

static void PrintCommList(cl)
commlist *cl;
{
    commlist *c;

    for (c = cl; c != NULL; c = c->next) {
	NormalizeComm(c);
	if (c->props.hide)
	    printf("skip ");
/*
	if (Option_ExtendActions)
	if (1)
*/
	    PrintVarTerm(c->comm);
/*
	else
	    print_ae_term(c->comm);
*/
	printf(" %d ", c->p1->id);
	switch (c->props.direction) {
	case COMM_SYNC:
	    printf(" - ");
	    break;
	case COMM_TO:
	    printf(" ->");
	    break;
	case COMM_FROM:
	    printf("<- ");
	    break;
	case COMM_BOTH:
	    printf("<->");
	    break;
	}
	printf(" %d\n", c->p2->id);
    }
}

void PrintGraph(pt)
partree *pt;
{
    process_id *pidl;
    int i;
    char *s;

    pidl = GetPidList();
    PropsProcesses(pt, pidl);
    Indent();
    printf("digraph ");
    for (s = get_ff_field("n", Mod->pro[Mod->def[pindex].ae_t.ind.key].ff); *s != '\0'; s ++) {
	if (*s == '-')
	    putchar('_');
	else
	    putchar(*s);
    }
    printf(" {\n");
    indent ++;
    if (Option_GraphDir) {
	Indent();
	printf("rankdir = %s\n", Option_GraphDir);
    }
    Indent();
    printf("node [color=lightblue]\n");
    Indent();
    printf("node [style=filled]\n");
    if (! Option_NoIO) {
	for (i = 1; i <= nrProc; i ++) {
	    if (Proc[i].rank & RANK_MIN) {
		Indent();
		printf("subgraph clusterinput { I [label=\"Input\", color=green]; }\n");
		break;
	    }
	}
    }
    Indent();
    printf("subgraph cluster {\n");
    indent ++;
/*
    PrintProcesses(pidl);
    PrintCommunications(pt->cl);
*/
    PrintClusters(pt->pt);
    indent --;
    Indent();
    printf("}\n");
    if (! Option_NoIO) {
	for (i = 1; i <= nrProc; i ++) {
	    if (Proc[i].rank & RANK_MAX) {
		Indent();
		printf("subgraph clusteroutput { O [label=\"Output\", color=green]; }\n");
		break;
	    }
	}
	for (i = 1; i <= nrProc; i ++) {
	    if (Proc[i].rank & RANK_MIN) {
		Indent();
		printf("I -> n%d [dir=forward, label=\"\"];\n", i);
	    }
	    if (Proc[i].rank & RANK_MAX) {
		Indent();
		printf("n%d -> O [dir=forward, label=\"\"];\n", i);
	    }
	}
    }
    indent --;
    Indent();
    printf("}\n");

    RenameVars();
    MarkConsFun();
    PrintCommList(pt->cl);
    PrintAtomList(pt->al);
}

static void PrintProcessList(pidl)

process_id *pidl;
{
    process_id *pid;

    for (pid = pidl; pid != NULL; pid = pid->next) {
	if (Proc[pid->id].used || Option_Unused) {
	    Indent();
	    printf("n%d ", pid->id);
	    if (pid->aet == NULL)
		printf("_?_");
	    else
		print_ae_term(pid->aet);
	    printf("\n");
	}
    }
}

void PrintTable(pt)
partree *pt;
{
    process_id *pidl;
    int i;
    char *s;

    pidl = GetPidList();
    PropsProcesses(pt, pidl);
    if (! Option_NoIO) {
	for (i = 1; i <= nrProc; i ++) {
	    if (Proc[i].rank & RANK_MIN) {
		printf("I Input\n");
		break;
	    }
	}
    }
    PrintProcessList(pidl);
/*
    PrintProcesses(pidl);
    PrintCommunications(pt->cl);
*/
/*
    PrintClusters(pt->pt);
*/
    if (! Option_NoIO) {
	for (i = 1; i <= nrProc; i ++) {
	    if (Proc[i].rank & RANK_MAX) {
		printf("O Output\n");
		break;
	    }
	}
    }
    RenameVars();
    MarkConsFun();
    PrintCommList(pt->cl);
    PrintAtomList(pt->al);
}
