#include <stdio.h>
#include <string.h>
#include "psf_prototype.h"
#include "psf_malloc.h"
#include "tiltype.h"
#include "ptree.h"
#include "eqm.h"
#include "main.h"
#include "openterm.h"
#include "expandptree.h"
#include "partree.h"
#include "realproc.h"
#include "fieldex.h"
#include "funcptree.h"
#include "prtilparts.h"
#include "dupproc.h"

static commlist *CL = NULL;

static int idcount = 1;
static process_id *pidlist = NULL;

static process_id *NewProcessId(aet)
ae_term *aet;
{
    process_id *pid;

    pid = PSF_MALLOC(process_id);
    pid->id = idcount ++;
    pid->aet = aet;
    pid->next = pidlist;
    pidlist = pid;
/*
printf("id: %d - ", pid->id);
if (aet != NULL)
    print_ae_term(aet);
printf("\n");
*/
    return(pid);
}

process_id *GetPidList()
{
    return(pidlist);
}

int GetMaxProcessId()
{
    return(idcount);
}

static atomlist *CopyAtomList(al)
atomlist *al;
{
    atomlist *a;

    if (al == NULL)
	return(NULL);
    a = AllocAtom();
    *a = *al;
    a->next = CopyAtomList(al->next);
    return(a);
}

static atomlist *AddAtomLists(al1, al2)
atomlist *al1;
atomlist *al2;
{
    atomlist *a;

    if (al1 == NULL)
	return(al2);
    for (a = al1; a->next != NULL; a = a->next);
    a->next = al2;
    return(al1);
}

static commlist *CopyCommList(cl)
commlist *cl;
{
    commlist *c;

    if (cl == NULL)
	return(NULL);
    c = PSF_MALLOC(commlist);
    *c = *cl;
    c->next = CopyCommList(cl->next);
    return(c);
}

static commlist *AddCommLists(cl1, cl2)
commlist *cl1;
commlist *cl2;
{
    commlist *c;

    if (cl1 == NULL)
	return(cl2);
    for (c = cl1; c->next != NULL; c = c->next);
    c->next = cl2;
    return(cl1);
}

static void IdAtomList(al, id)
atomlist *al;
process_id *id;
{
    atomlist *a;

    for (a = al; a != NULL; a = a->next) {
	a->props.pid = id;
/*
	printf("%ld, %d ", a, id->id);
	print_process_expr(a->atom);
	printf("\n");
*/
    }
}

static void IdPtreeEdges(pt, id)
ptree *pt;
process_id *id;
{
    pedge *e;
    ae_term *aet;
    process_id *pid;

    for (e = pt->edge; e != NULL; e = e->next) {
	if (pt->fun == PAR || pt->fun == MRG || pt->fun == INTR
	    || pt->fun == DISR) {
	    aet = NULL;
	    if (e->atom == NULL) {
		if (e->node->id != NULL)
		    aet = e->node->id;
	    }
	    id = NewProcessId(aet);
	    e->node->pid = id;
	}
	e->atom = CopyAtomList(e->atom);
	IdAtomList(e->atom, id);
	IdPtreeEdges(e->node, id);
    }
}

static void IdPtree(pt)
ptree *pt;
{
    process_id *id;

    id = NewProcessId(pt->id);
    pt->pid = id;
    IdPtreeEdges(pt, id);
}

static int VarInTerm(k, t)
keytype k;
ae_term *t;
{
    int i;

    for (i = 0; i < t->a; i ++) {
	if (t->ae_list[i].ind.table == VAR) {
	    if (t->ae_list[i].ind.key == k)
		return(1);
	} else {
	    if (VarInTerm(k, &t->ae_list[i]))
		return(1);
	}
    }
    return(0);
}

static void MarkSumAtoms(k, al)
keytype k;
atomlist *al;
{
    struct ae_term *a;
    int i;

    if (al == NULL) /* nested sum */
	return;
    a = &al->atom->proc_expr.pe2;
    if (VarInTerm(k, a))
	al->props.sum = 1;
/*
printf("sumvar: %d %d\n", k, al->props.sum);
*/
}

static void FindSumAtoms(pt)
ptree *pt;
{
    pedge *e;

    if (pt->edge == NULL)
	return;
    for (e = pt->edge; e != NULL; e = e->next) {
	if (pt->fun == SUM) {
	    MarkSumAtoms(pt->pe->proc_expr.pe1.ind.key, e->atom);
	}
	FindSumAtoms(e->node);
    }
}

struct setlist {
    int type;
    keytype s;
    struct setlist *next;
};

static void MarkEncapsHideAtoms(al, sl)
atomlist *al;
struct setlist *sl;
{
    atomlist *a;
    struct setlist *s;
    int m;

    for (a = al; a != NULL; a = a->next) {
	if (a->atom->fun == SKP)
	    continue;
	for (s = sl; s != NULL; s = s->next) {
	    if ((m = OpentermMemberSet(&a->atom->proc_expr.pe2, s->s)) == 1) {
	        if (s->type == ENC)
		    a->props.encaps = s->s;
		else
		    a->props.hide = s->s;
		break;
	    }
	}
    }
}

static void FindEncapsHideAtoms(pt, sl)
ptree *pt;
struct setlist *sl;
{
    pedge *e;
    struct setlist *set;

    if (pt->edge == NULL)
	return;
    if (pt->fun == ENC || pt->fun == HID) {
	set = PSF_MALLOC(struct setlist);
	set->type = pt->fun;
	set->s = pt->pe->proc_expr.pe1.ind.key;
	set->next = sl;
	sl = set;
    }
    for (e = pt->edge; e != NULL; e = e->next) {
	MarkEncapsHideAtoms(e->atom, sl);
	FindEncapsHideAtoms(e->node, sl);
    }
    if (pt->fun == ENC || pt->fun == HID) {
	set = sl;
	sl = sl->next;
	PSF_FREE(set);
    }
}

static void EncapsHideAtoms(pt)
ptree *pt;
{
    FindEncapsHideAtoms(pt, NULL);
}

static void MarkEncapsHideComms(cl, sl)
commlist *cl;
struct setlist *sl;
{
    commlist *c;
    struct setlist *s;

    for (c = cl; c != NULL; c = c->next) {
	for (s = sl; s != NULL; s = s->next) {
	    if (OpentermMemberSet(c->comm, s->s) == 1) {
	        if (s->type == ENC)
		    c->props.encaps = s->s;
		else
		    c->props.hide = s->s;
		break;
	    }
	}
    }
}

static void FindEncapsHideComms(pt, sl)
ptree *pt;
struct setlist *sl;
{
    pedge *e;
    struct setlist *set;

    if (pt->edge == NULL)
	return;
    if (pt->fun == ENC || pt->fun == HID) {
	set = PSF_MALLOC(struct setlist);
	set->type = pt->fun;
	set->s = pt->pe->proc_expr.pe1.ind.key;
	set->next = sl;
	sl = set;
    }
    MarkEncapsHideComms(pt->comm, sl);
    for (e = pt->edge; e != NULL; e = e->next) {
	FindEncapsHideComms(e->node, sl);
    }
    if (pt->fun == ENC || pt->fun == HID) {
	set = sl;
	sl = sl->next;
	PSF_FREE(set);
    }
}

static void EncapsHideComms(pt)
ptree *pt;
{
    FindEncapsHideComms(pt, NULL);
}

static atomlist *RemoveEncapsAtoms(al, key)
atomlist *al;
keytype key;
{
    atomlist *a, *ah, *fa;

    for (a = al, ah = NULL; a != NULL; ) {
	if (a->props.encaps == key) {
	    if (! a->props.comm) {
		fprintf(stderr, "Warning: ");
		set_print_output_file(stderr);
		print_process_expr(a->atom);
		set_print_output_file(stdout);
		fprintf(stderr, " is encapsulated but does not communicate.\n");
	    }
	    if (ah == NULL) {
		fa = a;
		a = a -> next;
		FreeAtom(fa);
		al = a;
	    } else {
		fa = a;
		a = a->next;
		ah->next = a;
		FreeAtom(fa);
	    }
	} else {
	    ah = a;
	    a = a->next;
	}
    }
    return(al);
}

static atomlist *RemoveHideAtoms(al, key)
atomlist *al;
keytype key;
{
    return(al);
}

static int IsSendReceive(sl, sr)
char *sl, *sr;
{
    if ((strcmp("snd", sl) == 0) && (strcmp("rec", sr) == 0))
	return 1;
    if ((strncmp("snd-", sl, 4) == 0) && (strncmp("rec-", sr, 4) == 0))
	return 1;
    if ((strcmp("-snd", sl + strlen(sl) - 4) == 0) && (strcmp("-rec", sr + strlen(sr) - 4) == 0))
	return 1;
    if ((strstr(sl, "-snd-") != NULL) && (strstr(sr, "-rec-") != NULL))
	return 1;
    if ((strcmp("send", sl) == 0) && (strcmp("receive", sl) == 0))
	return 1;
    if ((strstr(sl, "-snd-") != NULL) && (strstr(sr, "-rec") != NULL))
	return 1;
    if ((strstr(sl, "-snd") != NULL) && (strstr(sr, "-rec-") != NULL))
	return 1;
    /* mixed */
    if ((strcmp("snd", sl) == 0) && (strncmp("rec-", sr, 4) == 0))
	return 1;
    if ((strcmp("snd", sl) == 0) && (strstr(sr, "-rec") != NULL))
	return 1;
    if ((strncmp("snd-", sl, 4) == 0) && (strcmp("rec", sr) == 0))
	return 1;
    if ((strstr(sl, "-snd") != NULL) && (strcmp("rec", sr) == 0))
	return 1;
    return 0;
}

static int HeuristicDirection(a1, a2)
keytype a1, a2;
{
    char *n1, *n2;

    if (Option_Heuristic) {
	n1 = get_ff_field("n", Mod->atm[a1].ff);
	n2 = get_ff_field("n", Mod->atm[a2].ff);
	if (IsSendReceive(n1, n2))
	    return COMM_TO;
	if (IsSendReceive(n2, n1))
	    return COMM_FROM;
    }
    return COMM_SYNC;
}

static commlist *FindCommPartner(a1, al2, ic, com, sub, eqm, cl)
atomlist *a1;
atomlist *al2;
int ic;
struct com_tuple *com;
subst_t *sub;
eqm_t *eqm;
commlist *cl;
{
    atomlist *a2;
    struct ae_term *aet, *aeth;
    subst_t *rsub;
    commlist *c;

    for (a2 = al2; a2 != NULL; a2 = a2-> next) {
	if (a2->props.hide)
	    continue;
	if (a2->atom->proc_expr.pe2.ind.key == com->aet[1 - ic].ind.key) {
/*
	    aeth = OpentermInstantiate(&com->aet[1 - ic], sub, eqm);
	    rsub = OpentermMatch(aeth, &a2->atom->proc_expr.pe2);
*/
	    rsub = OpentermMatchSub(&com->aet[1-ic], &a2->atom->proc_expr.pe2, sub);
/*
	    if (! rsub)
		rsub = OpentermMatch(&a2->atom->proc_expr.pe2, aeth);
	    ae_term_free(aeth);
*/
	    if (rsub) {
/*
		aeth = OpentermInstantiate(&com->aet[2], sub, eqm);
		aet = OpentermInstantiate(aeth, rsub, eqm);
		ae_term_free(aeth);
*/
		aet = OpentermInstantiate(&com->aet[2], rsub, eqm);
		c = PSF_MALLOC(commlist);
		c->comm = aet;
		c->p1 = a1->props.pid;
		c->p2 = a2->props.pid;
		c->props.encaps = 0;
		c->props.hide = 0;
		if (a1->props.sum) {
		    if (a2->props.sum)
			c->props.direction = COMM_BOTH;
		    else
			c->props.direction = COMM_FROM;
		} else {
		    if (a2->props.sum)
			c->props.direction = COMM_TO;
		    else
/*
			c->props.direction = COMM_SYNC;
*/
			c->props.direction = HeuristicDirection(a1->atom->proc_expr.pe2.ind.key, a2->atom->proc_expr.pe2.ind.key);
		}
		a1->props.comm ++;
		a2->props.comm ++;
/*
printf("dir: %d %d  %d\n", a1->props.sum, a2->props.sum, c->props.direction);
*/
		c ->next = cl;
		cl = c;
		subst_free(rsub);
	    }
/*
if (rsub) {
printf("!!! %d ", ic);
print_ae_term(&a1->atom->proc_expr.pe2);
printf(" - ");
print_ae_term(&a2->atom->proc_expr.pe2);
printf(" !!!\n");
} else {
printf("*** %d ", ic);
print_ae_term(&a1->atom->proc_expr.pe2);
printf(" - ");
print_ae_term(&a2->atom->proc_expr.pe2);
printf(" ***\n");
}
*/
	}
    }
    return(cl);
}

static commlist *CalcCommunications(al1, al2)
atomlist *al1;
atomlist *al2;
{
    commlist *cl;
    int i;
    atomlist *a1;
    subst_t *sub;

    cl = NULL;
    for (a1 = al1; a1 != NULL; a1 = a1->next) {
	if (a1->props.hide)
	    continue;
	if (a1->atom->fun == SKP) {
	    continue;
	}
	for (i = 1; i <= Mod->entries_table[COM]; i++) {
	    if (a1->atom->proc_expr.pe2.ind.key == Mod->com[i].aet[0].ind.key) {
/* Match separately all argument in two directions and combine subs !!!! */
/* new function OpentermMatchX should do this */
		if ((sub = OpentermMatch(&Mod->com[i].aet[0],
		    &a1->atom->proc_expr.pe2)) != NULL) {
		    cl = FindCommPartner(a1, al2, 0, &Mod->com[i], sub, Eqm,
			cl);
		}
	    }
	    if (a1->atom->proc_expr.pe2.ind.key == Mod->com[i].aet[1].ind.key) {
		if ((sub = OpentermMatch(&Mod->com[i].aet[1],
		    &a1->atom->proc_expr.pe2)) != NULL) {
		    cl = FindCommPartner(a1, al2, 1, &Mod->com[i], sub, Eqm,
			cl);
		}
	    }
	}
    }
    return(cl);
}

static int Communications(pt)
ptree *pt;
{
    pedge *e;

    if (pt->comm)
	return(1);
    for (e = pt->edge; e != NULL; e = e->next) {
	if (Communications(e->node))
	    return(1);
    }
    return(0);
}

static atomlist *FindCommunications(pt)
ptree *pt;
{
    pedge *e;
    atomlist *al, *tal, *a;
    commlist *cl, *tcl;

    if (pt->edge == NULL)
	return(NULL);
    al = NULL;
    cl = NULL;
/*
if (pt->id != NULL) {
    print_ae_term(pt->id);
    printf("\n");
} else {
    PrintProcessFunction(pt->fun);
    printf("\n");
}
*/
    for (e = pt->edge; e != NULL; e = e->next) {
	tal = FindCommunications(e->node);
	switch(pt->fun) {
	case ENC:
	    tal = AddAtomLists(tal, CopyAtomList(e->atom));
	    tal = RemoveEncapsAtoms(tal, pt->pe->proc_expr.pe1.ind.key);
	    al = AddAtomLists(al, tal);
	    break;
	case HID:
	    tal = AddAtomLists(tal, CopyAtomList(e->atom));
/*
	    tal = RemoveHideAtoms(tal, pt->pe->proc_expr.pe1.ind.key);
*/
	    al = AddAtomLists(al, tal);
	    break;
	case PAR:
	case MRG:
	    tal = AddAtomLists(tal, CopyAtomList(e->atom));
	    tcl = CalcCommunications(al, tal);
/*
printf("************* ");
PrintCommList(tcl);
*/
	    cl = AddCommLists(cl, tcl);
	    al = AddAtomLists(al, tal);
	    break;
	default:
	    tal = AddAtomLists(tal, CopyAtomList(e->atom));
	    al = AddAtomLists(al, tal);
	    break;
	}
    }
/*
if (pt->fun == PAR) {
PrintCommList(cl);
}
*/
    pt->comm = cl;
    if (Option_Combine) {
	if (pt->pid && ((pt->pid->aet != NULL) && (cl == NULL))) {
	    if (! Communications(pt)) {
		for (a = al; a != NULL; a = a->next) {
		    a->props.pid = pt->pid;
		}
	    }
	}
    }
    return(al);
}

static commlist *CollectComms(pt)
ptree *pt;
{
    pedge *e;
    commlist *cl;

    if (pt->edge == NULL)
	return(NULL);
    cl = NULL;
    for (e = pt->edge; e != NULL; e = e->next) {
	cl = AddCommLists(cl, CollectComms(e->node));
    }
    cl = AddCommLists(cl, CopyCommList(pt->comm));
    return(cl);
}

static void PrintParPtree(g)
ptree *g;
{
/* printf ("xxx\n"); */
    PrintEdgePtree(g);
}

static void PrintProcesses(pidl)
process_id *pidl;
{
    process_id *pid;

    for (pid = pidl; pid != NULL; pid = pid->next) {
	printf("%d ", pid->id);
	if (pid->aet != NULL)
	    print_ae_term(pid->aet);
	printf("\n");
    }
}

static void PrintComm(cl)
commlist *cl;
{
    commlist *c;

    for (c= cl; c != NULL; c = c->next) {
	if (c->props.hide)
	    printf("skip ");
	print_ae_term(c->comm);
	printf(" ");
	if (c->p1->aet == NULL)
	    printf("P_%d", c->p1->id);
	else {
	    printf("%d-", c->p1->id);
	    print_ae_term(c->p1->aet);
	}
	printf(" ");
	if (c->props.direction & COMM_FROM)
	    printf("<");
	else
	    printf(" ");
	printf("-");
	if (c->props.direction & COMM_TO)
	    printf(">");
	else
	    printf(" ");
	printf(" ");
	if (c->p2->aet == NULL)
	    printf("P_%d", c->p2->id);
	else {
	    printf("%d-", c->p2->id);
	    print_ae_term(c->p2->aet);
	}
	printf("\n");
    }
}

static void PrintAtom(al)
atomlist *al;
{
    atomlist *a;

    for (a = al; a != NULL; a = a->next) {
	if (a->props.sum)
	    printf("sum:");
	if (a->props.hide)
	    printf("skip ");
	print_process_expr(a->atom);
	printf (" ");
	if (a->props.pid->aet == NULL)
	    printf("P_%d", a->props.pid->id);
	else {
	    printf("%d-", a->props.pid->id);
	    print_ae_term(a->props.pid->aet);
	}
	printf("\n");
    }
}

partree *BuildParPtree(pd)
int pd;
{
    ptree *t;
    atomlist *al;
    commlist *cl;
    partree *pt;

    t = CopyPtree(PT[pd]);
    t = ExpandPtree(t);
    IdPtree(t);
    FindSumAtoms(t);
    InitOpenterm();
    EncapsHideAtoms(t);
/*
    PrintParPtree(t);
*/
    al = FindCommunications(t);
    EncapsHideComms(t);
    cl = CollectComms(t);

    if (Option_Debug) {
	PrintProcesses(GetPidList());
	PrintParPtree(t);
	PrintAtom(al);
	PrintComm(cl);
    }

    pt = PSF_MALLOC(partree);
    pt->pt = t;
    pt->al = al;
    pt->cl = cl;
/*
    PrintAccountPlist();
*/
    if (Option_Sub) {
	RealProcess(pt, idcount, pidlist);
	if (Option_Debug)
	    PrintRealProcess();
    }
    if (Option_RemoveDuplicates) {
	DuplicateProcesses(pt);
    }
    return(pt);
}
