#include <stdio.h>
#include "psf_prototype.h"
#include "tiltype.h"
#include "psf_malloc.h"
#include "ptree.h"
#include "eqm.h"
#include "main.h"

/*
 * Test sets on the possibility to check if an atom with a
 * variable as its last argument is element of the set.
 */
static int **set_cond = NULL;
static int nr_atoms;

static int s_term_condition_test(st, akey)
struct s_term *st;
int akey;
{
    /*
     * If atom akey can be found in the set, and not all the
     * arguments of atom akey are variables, 0 is returned.
     * Otherwise 1 is returned, which indicates that it is
     * decidable that atom akey is elemnt of the set.
     */
    int i, j;
    
    switch(st->fun) {
    case UNI:
    case INT:
    case DIF:
	for (j = 0; j < st->a; j ++) {
	    if (st->u_tag[j]) {
		if (!s_term_condition_test(st->arr[j].s_t, akey))
		    return(0);
	    } else if (st->arr[j].ae_t->ind.table == SOR)
		continue; /* atoms */
	    else { /* SET */
		if (!s_term_condition_test(
		    &Mod->set[st->arr[j].ae_t->ind.key].construct.set_term,
		    akey))
		    return(0);
	    }
	}
	return(1);
    case ENU:
	for (j = 0; j < st->a; j ++) {
	    if (st->arr[j].ae_t->ind.key != akey)
		continue;
	    for (i = st->arr[j].ae_t->a - 1; i >= 0; i --) {
		if (st->arr[j].ae_t->ae_list[i].ind.table != VAR) {
		    return(0);
		}
	    }
	}
	return(1);
    }
    return(0); /* But we are never here. */
}

static void set_condition_test()
{
    struct set_tuple *s;
    int i, j;

    if (set_cond != NULL) {
	for (i = 1; i <= nr_atoms; i ++)
	    PSF_FREE(set_cond[i]);
	PSF_FREE(set_cond);
    }
    nr_atoms = Mod->entries_table[ATM];
    set_cond = PSF_NMALLOC(int *, nr_atoms + 1);
    for (i = 1; i <= nr_atoms; i ++) {
	set_cond[i] = PSF_NMALLOC(int, Mod->entries_table[SET] + 1);
	for (j = 1, s = &Mod->set[1]; j <= Mod->entries_table[SET]; j ++, s ++)
	    {
	    if (Mod->atm[i].sor_indlist.a == 0 || s->u_tag == 0) {
		set_cond[i][j] = 1;
		continue;
	    }
	    set_cond[i][j] = s_term_condition_test(&s->construct.set_term, i);
	    if (set_cond[i][j] == -1)
		set_cond[i][j] = Mod->atm[i].sor_indlist.a;
	}
    }
/*
    for (i = 1; i <= nr_atoms; i ++) {
	fprintf(stderr, "atom: %d ", i);
	for (j = 1; j <= Mod->entries_table[SET]; j ++)
	    fprintf(stderr, " %d", set_cond[i][j]);
	fprintf(stderr, "\n");
    }
*/
}

/*
 * Test communications on the possibility to act on a sumport.
 */
static int **com_cond = NULL;
static int nr_coms;

static int var_appears_in(aet, key)
struct ae_term *aet;
keytype key;
{
    int i;

    if (aet->ind.table == VAR) {
	if (aet->ind.key == key)
	    return(1);
	else
	    return(0);
    }
    for (i = 0; i < aet->a; i ++) {
	if (var_appears_in(&aet->ae_list[i], key))
	    return(1);
    }
    return(0);
}

static void com_condition_test()
{
    struct com_tuple *c;
    int i, j, k, l;
    int nr_partners;

    if (com_cond != NULL) {
	for (i = 1; i <= nr_coms; i++)
	    PSF_FREE(com_cond[i]);
	PSF_FREE(com_cond);
    }
    nr_coms = Mod->entries_table[COM];
    com_cond = PSF_NMALLOC(int *, nr_coms + 1);
    for (i = 1, c = &Mod->com[1]; i <= nr_coms; i ++, c ++) {
	nr_partners = 2; /* in future, get it from c->... */
	com_cond[i] = PSF_NMALLOC(int, nr_partners);
	com_cond[i][0] = com_cond[i][1] = 0;
	for (j = nr_partners - 1; j >= 0; j --) {
	    for (k = c->aet[j].a - 1; k >= 0; k --) {
		if (c->aet[j].ae_list[k].ind.table != VAR)
		    break;
		for (l = nr_partners - 1; l >= 0; l --) {
		    if (l == j)
			continue;
		    if (var_appears_in(&c->aet[l],
			c->aet[j].ae_list[k].ind.key))
			break;
		}
		if (l < 0)
		    break;
	    }
	    com_cond[i][j] = c->aet[j].a - 1 - k;
	}
    }
/*
    for (i = 1; i <= nr_coms; i ++) {
	fprintf(stderr, "com: %d ", i);
	for (j = 0; j < nr_partners; j ++)
	    fprintf(stderr, " %d", com_cond[i][j]);
	fprintf(stderr, "\n");
    }
*/
}

void InitOpenterm()
{
    set_condition_test();
    com_condition_test();
}

/*
 * The portvar must be of type setvar.
 */
static int vartypes_match(setvar, portarg)
keytype setvar;
indextype *portarg;
{
    indextype *setind, *portind;

    setind = &Mod->var[setvar].ind;
    if (portarg->table == FUN)
	portind = &Mod->fun[portarg->key].return_list.indlist[0];
    else
	portind = &Mod->var[portarg->key].ind;
    if (portind->table == setind->table &&
	portind->key == setind->key)
	return(1);
    while (portind->table == SET) {
	portind = &Mod->set[portind->key].ind;
	if (portind->table == setind->table &&
	    portind->key == setind->key)
	    return(1);
    }
    return(0);
}

/*
 * Find out if the atom of the port is in the set.
 */
static int sumport_in_set(aet, st)
struct ae_term *aet;
struct s_term *st;
{
    int j;
    int member;
    int i;

    for (j = 0; j < st->a; j ++) {
	if (st->u_tag[j])
	    member = sumport_in_set(aet, st->arr[j].s_t);
	else if (st->arr[j].ae_t->ind.table == SOR)
	    member = 1; /* atoms */
	else if (st->arr[j].ae_t->ind.table == SET) {
	    member = sumport_in_set(aet,
		&Mod->set[st->arr[j].ae_t->ind.key].construct.set_term);
	} else {
	    if (st->arr[j].ae_t->ind.key == aet->ind.key) {
		member = 1;
		for (i = aet->a - 1; i >= 0; i --) {
		    if (! (member = vartypes_match(st->arr[j].ae_t->
			ae_list[i].ind.key, &aet->ae_list[i].ind))) {
			member = 0;
			break;
		    }
		}
	    } else
		member = 0;
	}
	switch(st->fun) {
	case UNI:
	    if (member)
		return(1);
	    break;
	case INT:
	    if (!member)
		return(0);
	    break;
	case DIF:
	    if (j) {
		if (member)
		    return(0);
		else
		    member = 1;
	    } else {
		if (!member)
		    return(0);
	    }
	    break;
	case ENU:
	    if (member)
		return(1);
	    break;
	}
    }
    return(member);
}

/*
 * Test if an atom can be matched in the set.
 */
int OpentermMemberSet(aet, key)
struct ae_term *aet;
keytype key;
{

    if (set_cond[aet->ind.key][key]) {
	if (Mod->set[key].u_tag)
	    return(sumport_in_set(aet, &Mod->set[key].construct.set_term));
	else {
	    if (Mod->set[key].construct.sort.table == SOR)
		return(1); /* atoms */
	    else
		return(OpentermMemberSet(aet, Mod->set[key].construct.sort.key));
	}
    } else
	return(-1);
}

struct ae_term *OpentermInstantiate(aet, sub, eqm)
struct ae_term *aet;
subst_t *sub;
eqm_t *eqm;
{
    struct ae_term *a;

    a = term_instantiate(aet, sub, eqm);
    return(a);
}

/*
subst_t *OpentermMatch(pattern, term)
struct ae_term *pattern;
struct ae_term *term;
{
    subst_t *sub;

    sub = term_match(pattern, term);
    return(sub);
}
*/
subst_t *OpentermMatch(pattern, term)
struct ae_term *pattern;
struct ae_term *term;
{
    subst_t *sub, *rsub;
    int i;

    if (pattern->ind.key != term->ind.key)
	return(NULL);
    sub = get_sub();
    sub->sb_elems = NULL;
    for (i = 0; i < pattern->a; i ++) {
	if (term->ae_list[i].ind.table == VAR)
	    continue;
	rsub = term_match_sub(&pattern->ae_list[i], &term->ae_list[i], sub);
	if (rsub == NULL)
	    return(NULL);
	sub = rsub;
    }
    return(sub);
}

static int TermsMatch(t1, t2)
term_t *t1;
term_t *t2;
{
    int i;

    if (t1->ind.table != t2->ind.table)
	return(0);
    if (t1->ind.table == VAR)
	return(1);
    if (t1->ind.key != t2->ind.key)
	return(0);
    for (i = t1->nsons; i-- > 0;) {
	if (! TermsMatch(t1->sons[i], t2->sons[i]))
	    return(0);
    }
    return(1);
}

subst_t *OpentermMatchSub(pattern, term, sub)
struct ae_term *pattern;
struct ae_term *term;
subst_t *sub;
{
    subst_t *rsub, *nsub;
    subst_elem_t *e, *re;

    rsub = OpentermMatch(pattern, term);
    if (rsub == NULL)
	return(NULL);

    for (re = rsub->sb_elems; re != NULL; re = re->next_se) {
	for (e = sub->sb_elems; e != NULL; e = e->next_se) {
	    if (e->var.key != re->var.key)
		continue;
/*
printf("var equal: %d\n", e->var.key);
*/
	    if (! TermsMatch(e->value, re->value))
		return(NULL);
	}
    }
    nsub = copy_add_sub_to_sub(sub, rsub);
    subst_free(rsub);
    return(nsub);
}
